/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function MemoryContentStorage()
{
    var memURL = {};
    var memRaw = {};
    var stringTables = {};

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return absolute url of content file
    //
    this.getURL = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[Function]*/ inCallback)
    {
        throwInvalid(inCallback);

        var ret = null;

        if (isValidProperty(memURL[inWorkflowID]))
        {
            ret = memURL[inWorkflowID][inContentID];
        }

        inCallback(ret);
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return absolute url of content file
    //
    this.setURL = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[String]*/ inURL)
    {
        if (!isValidProperty(memURL[inWorkflowID]))
        {
            memURL[inWorkflowID] = {};
        }

        memURL[inWorkflowID][inContentID] = inURL;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return content as it is (e.g. raw text is returned as raw text, html is returned as html, etc.)
    //
    this.getRaw = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[Function]*/ inCallback)
    {
        throwInvalid(inCallback);

        var ret = null;

        if (isValidProperty(memRaw[inWorkflowID]))
        {
            ret = memRaw[inWorkflowID][inContentID];
        }

        inCallback(ret);
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return content as it is (e.g. raw text is returned as raw text, html is returned as html, etc.)
    //
    this.setRaw = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[String]*/ inRaw)
    {
        if (!isValidProperty(memRaw[inWorkflowID]))
        {
            memRaw[inWorkflowID] = {};
        }

        memRaw[inWorkflowID][inContentID] = inRaw;
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Return content from string table
    //
    this.getString = function(/*[string]*/ inWorkflowID, /*[string]*/ inContentID, /*[Function]*/ inCallback)
    {
        throwInvalid(inCallback);

        var ret = '';

        if (isValidProperty(stringTables[inWorkflowID]))
        {
            ret = stringTables[inWorkflowID].getString(inContentID);
        }

        if (!isValidProperty(ret))
        {
            ret = '';
        }

        inCallback(ret);
    }

    //////////////////////////////////////////////////////////////////////////////
    //
    // Set a stringtable
    //
    this.setStringtable = function(/*[String]*/ inWorkflowID, /*[Stringtable]*/ inStringtable)
    {
        stringTables[inWorkflowID] = inStringtable;
    }
}
