/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function StringTable(/*[String]*/ inTableFile)
{
	var tablefile = inTableFile;
	var strings = {};
	var loaded = false;
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// String for id exists?
	//
	this.exists = function(/*[String]*/ inID)
	{
		return isValidProperty(this.getString(inID));
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Get localized string for inID
	//
	this.getString = function(/*[String]*/ inID)
	{
		if (!loaded)
		{
			load();
			loaded = true;
		}
		
		return strings[inID];
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Set string data
	//
	this.setData = function(/*[String]*/ inData)
	{
		parse(inData);
		loaded = true;
	}

	// private ///////////////////////////////////////////////////////////////////
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Load and parse string table file
	//
	function load()
	{	
		var result = cep.fs.readFile(tablefile);
	
		if (isValidProperty(result) && result.err == cep.fs.NO_ERROR)
		{
			parse(result.data);
		}
	}	
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Parse string table content
	//
	function parse(/*[String]*/ inData)
	{
		if (isValidProperty(inData))
		{
			var lines = inData.split('\n');
		
			forEach(lines, function(str)
			{
				str = removeQuotes(str);
				var entry = str.split('=');
				
				if (entry.length > 2)
				{
					var concated = '';
					
					for (var i=1; i<entry.length; i++)
					{
						concated += entry[i];
					}
					
					entry = [entry[0], concated];
				}
				
				if (entry.length > 1)
				{
					strings[entry[0]] = replaceSymbols(entry[1]);
				}
			});
		}
	}
	
	function removeQuotes(/*[String]*/ inLine)
	{
		var line = inLine.trim();
		
		if (line.indexOf('"') == 0 && line.lastIndexOf('"') == line.length-1)
		{
			line = line.substring(1, line.length-1);
		}
		
		return line;
	}
	
	function replaceSymbols(/*[String]*/ inText)
	{
		var kSymbols = 	[	{ symbol : '\\^Q'	, replacement : '"'},
							{ symbol : '\\^n'	, replacement : '\n'} ];
							
		var text = inText;
		
		forEach(kSymbols, function(symbol)
		{
			var regex = new RegExp(symbol.symbol, 'g');
			text = text.replace(regex, symbol.replacement);
		});
		
		return text;
	}
}

StringTable.FILENAME = 'stringtable.txt';