/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function PanelSurface()
{
	var surfaces = {};
	var contentStorage = new LocalContentStorage(getSurfaceFolder());
	var current = '';
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Display named surface
	//
	this.displaySurface = function(/*[String]*/ inName)
	{
		current = inName;
		var content = this.getSurface(inName);
		var body = document.getElementsByTagName("body");

		if (isValidProperty(body))
		{
			body = body[0];
			body.innerHTML = content;
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Is given surface name the current surface
	//
	this.isCurrent = function(/*[String]*/ inName)
	{
		return (inName = current);
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Display inContent as the inner content of the element with inID
	//
	this.displayByID = function(/*[String]*/ inID, /*[String]*/ inContent)
	{
		var element = document.getElementById(inID);
		
		if (isValidProperty(element))
		{
			element.innerHTML = inContent;

			// evaluate any scripts embeded
			//
			var scripts = element.getElementsByTagName('script');

			for (var s=0; s<scripts.length; s++)
			{
				var src = scripts[s].innerHTML;

				if (isValidProperty(src))
				{
					try
					{
						globalEval(src);
					}
					catch(exc)
					{
						exclog(exc);
					}
				}
			}
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Get surface source
	//
	this.getSurface = function(/*[String]*/ inName)
	{
		if (!isValidProperty(surfaces[inName]))
		{
			getSurfaceContent(inName, function(content)
			{
				surfaces[inName] = content;
			});
		}
		
		return surfaces[inName];
	}
	
	// private ///////////////////////////////////////////////////////////////////
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Read surface file and return surface content
	//
	function getSurfaceContent(/*[String]*/ inName, /*[Function]*/ inCallback)
	{
		var ret = '';
		var callback = inCallback;
		var filename = getSurfaceFolder() + inName + '.html';
		var result = cep.fs.readFile(filename);
		
		if (isValidProperty(result) && result.err == cep.fs.NO_ERROR)
		{
			var parser = new DOMParser();
			var doc = parser.parseFromString(result.data, "text/html");
			
			if (isValidProperty(doc))
			{
				var body = doc.getElementsByTagName("body");
		
				if (isValidProperty(body))
				{
					ret = body[0].innerHTML;
				}
			}
		}
		
		if (ret.length)
		{
			replaceStringSymbols(ret, contentStorage, function(content)
			{
				replaceURLSymbols(content, contentStorage, function(content)
				{
					callback(content);
				});
			});
		}
		else
		{
			callback(ret);
		}
	}
}
