/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2016 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/

/**
    This module exports an utility function to get the path of the IMSLib native library.
**/

'use strict';

var path = require('path');
var fs = require('fs');

var TARGET_ARCH = process.env.TARGET_ARCH || process.arch;
var TARGET_PLATFORM = process.platform;

var PLATFORM_NAME = {
    darwin: 'osx10',
    win32: { x64: 'win64', ia32: 'win32' }[TARGET_ARCH]
}[TARGET_PLATFORM];

var PLATFORM_EXTENSION = {
    darwin: '.dylib',
    win32: '.dll'
}[TARGET_PLATFORM];

var PLATFORM_COMMON_LOCATION = {
    darwin: '/Applications/Utilities/Adobe Application Manager/P7/IMSLib.dylib',
    win32: {
        x64: (process.env['ProgramFiles(x86)'] || process.env.PROGRAMFILES) + '\\Common Files\\Adobe\\OOBE\\PDApp\\P7\\x64\\IMSLib.dll',
        ia32: (process.env['ProgramFiles(x86)'] || process.env.PROGRAMFILES) + '\\Common Files\\Adobe\\OOBE\\PDApp\\P7\\IMSLib.dll'
    }[TARGET_ARCH]
}[TARGET_PLATFORM];

var NGL_LOCATION = {
    darwin: '/Library/Application Support/Adobe/Adobe Desktop Common/LCC/IMSLib.dylib',
    win32: {
        x64: (process.env['ProgramFiles(x86)'] || process.env.PROGRAMFILES) + '\\Common Files\\Adobe\\Adobe Desktop Common\\LCC\\x64\\IMSLib.dll',
        ia32: (process.env['ProgramFiles(x86)'] || process.env.PROGRAMFILES) + '\\Common Files\\Adobe\\Adobe Desktop Common\\LCC\\IMSLib.dll'
    }[TARGET_ARCH]
}[TARGET_PLATFORM];

function getIMSLibPath() {
    if (!PLATFORM_NAME || !PLATFORM_EXTENSION) {
        throw new Error('[IMSLib] Unsupported platform or arch: ' + TARGET_PLATFORM + ' ' + TARGET_ARCH);
    }

    // Look in the common location first - only fall back to the bundled lib if the common location isn't there
    // First the NGL location
    if (fs.existsSync(NGL_LOCATION)) {
        return NGL_LOCATION;
    }

    // Old Location
    if (fs.existsSync(PLATFORM_COMMON_LOCATION)) {
        return PLATFORM_COMMON_LOCATION;
    }

    // FIXME: Add debug support.
    return path.join(__dirname, '..', 'IMSLib', 'libraries', PLATFORM_NAME, 'Release', 'IMSLib' + PLATFORM_EXTENSION);
}

module.exports = getIMSLibPath;
