<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />
    
<xsl:param name="ImagePageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
<script language="JavaScript1.1">
		var playing = 0
		var timeoutID = 0
		var slideShowNextLink = "<xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix"/><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/NextSlideshowImagePagePath"/>"
		var slideShowDelay = <xsl:value-of select="/Doc/SlideshowDelay"/>

		// Browser detection	
		var agt = navigator.userAgent.toLowerCase();
		var is_ie = (agt.indexOf("msie") != -1);

		if (location.href.indexOf("?") != -1) {
			urlQuery = location.href.split("?")
			playing = parseInt(urlQuery[1])
		}
		
		if (playing == 1) {
			startSlideShow()
		}
	
		function slideShow() {
			window.location.href = slideShowNextLink + "?" + "1"
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function startSlideShow() {
			clearTimeout(timeoutID)
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function stopSlideShow() {
			clearTimeout(timeoutID)
			if (is_ie) {
				fakeTimeoutID = setInterval("redirectDelay()", 0);
			}
			else {
				redirectDelay();
			}
		}
		
		function redirectDelay() {
			tempArray = window.location.href.split("?")
			window.location.href = tempArray[0]
		}
</script>
</head>
<body>
<table width="100%"  border="0" cellspacing="0" cellpadding="0">
<tr>
<td align="center" valign="middle">
<table width="760" border="0" cellspacing="0" cellpadding="0">
<tr>
<td align="center" valign="middle">
<div id="wrapper">

<xsl:if test="/Doc/IncludeHeader = 1">
<xsl:if test="/Doc/Header/UseImage = 1">
<div id="logohead" class="left">
	<div class="infor">
		<div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
			<div class="xboxcontent"><p><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/Header/ImagePath}"/></p></div>
			<b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
  	</div>
	</div>
</div>
</xsl:if>

<xsl:if test="/Doc/Header/UseInfo = 1">
<div id="pagehead" class="right">
	<div class="infor">
  	<div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
    	<div class="xboxcontent">
				<xsl:if test="/Doc/Header/Text[string(.)]">
      		<p><strong><xsl:value-of select="Doc/Header/Text"/></strong></p>
      	</xsl:if>
       	<xsl:if test="/Doc/Header/Author[string(.)]">
	    		<p><xsl:value-of select="Doc/Header/Author"/></p>
	    	</xsl:if>
	    	<xsl:if test="/Doc/Header/Date[string(.)]">
	    		<p><xsl:value-of select="Doc/Header/Date"/></p>
	    	</xsl:if>
				<xsl:if test="/Doc/Header/Email[string(.)]">
	    		<p><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></p>
	    	</xsl:if>
      </div>
      <b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
		</div>
	</div>
</div>
</xsl:if>
</xsl:if>

  <div class="clearer">&nbsp;</div>
  
  <div class="infor">
    <div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
    <div class="xboxcontent">
			<div class="imagenav">
				<div class="left">
					<table>
						<tr>
							<td valign="center">
							<strong><xsl:value-of select="/Doc/Translations/Slideshow"/>:</strong>&nbsp;
							</td>
							<td valign="center">
							<a href="javascript:void(0)" name="slideShowControl" onclick="startSlideShow()"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_slide_start.gif" width="20" height="19" border="0"/></a>
							</td>
							<td valign="center">
							<a href="javascript:void(0)" name="slideShowControl" onclick="stopSlideShow()"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_slide_stop.gif" width="20" height="19" border="0"/></a>
							</td>
						</tr>
					</table>
				</div>
				<div class="right">
					<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[string(.)]">
		 				<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath}"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_prev.gif" width="19" height="19" border="0"/></a>&nbsp;
		 			</xsl:if>
		 			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[.='']">
		 				<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_prev_grey.gif" width="19" height="19" border="0"/>&nbsp;
		 			</xsl:if>
					<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/HomeFileName}"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_home.gif" width="19" height="19" border="0" /></a>&nbsp;
					<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[string(.)]">
		 				<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath}"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_next.gif" width="19" height="19" border="0"/></a>
		 			</xsl:if>
		 			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[.='']">
		 				<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/btn_next_grey.gif" width="19" height="19" border="0"/>
		 			</xsl:if>
				</div>
				<div class="clearer">&nbsp;</div>
			</div>
		<div id="mainimage">
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[string(.)]">
	  		<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath}"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/></a>
	  	</xsl:if>
	  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[.='']">
	  		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/>
	  	</xsl:if>
			
			<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
			<div class="metabox">
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)]">
					<h2 class="metatitle1"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value"/>&nbsp;&nbsp;</h2>
				</xsl:if>
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
					<span class="metatitle2"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value"/></span>
				</xsl:if>
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
				  <xsl:choose>
					  <xsl:when test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
					  <span class="metatitle3">
					  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
			      	</xsl:if>
				  	</span>
				  	</xsl:when>
				  	<xsl:otherwise>
					  <span class="metatitle4">
					  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
			      	</xsl:if>
			      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
			      		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
			      	</xsl:if>
				  	</span>
				  	</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
					<br/><br/>
				</xsl:if>
				<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag and /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag/Value[string(.)]">
					<table>
				  	<xsl:for-each select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
				  		<xsl:if test="Value[string(.)]">
				  			<tr><td width="65%"><div class="metaitem"><strong><xsl:value-of select="Name"/></strong></div></td><td><div class="metaitem"><xsl:value-of select="Value"/></div></td></tr>
				  		</xsl:if>
						</xsl:for-each>
					</table>
				</xsl:if>
			</div>
			</xsl:if>
		</div>
		</div>
    <b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
    </div>
	</div>
  
  <xsl:if test="/Doc/IncludeFooter = 1">
	<xsl:if test="/Doc/Footer/UseInfo = 1">
	  <div id="pagefoot">
	    <div class="infor">
	      <div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
	        <div class="xboxcontent">
	          <table width="100%"  border="0" cellspacing="0" cellpadding="0">
	            <tr>
	              <td>
	              	<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
	              		<p>
	              			<xsl:if test="/Doc/Footer/Text[string(.)]">
	              				<strong><xsl:value-of select="/Doc/Footer/Text"/></strong>
	              				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
	              				&nbsp;&raquo;&nbsp;
	              				</xsl:if>
	              			</xsl:if>
	              			<xsl:if test="/Doc/Footer/Author[string(.)]">
	              				<xsl:value-of select="/Doc/Footer/Author"/>
	              				<xsl:if test="/Doc/Footer/Date[string(.)]">
	              				&nbsp;&raquo;&nbsp;
	              				</xsl:if>
	              			</xsl:if>
	              			<xsl:if test="/Doc/Footer/Date[string(.)]">
	              				<xsl:value-of select="/Doc/Footer/Date"/>
	              			</xsl:if>
	              		</p>
	              	</xsl:if>
	             	</td>
	              <td align="right"><xsl:if test="/Doc/Footer/Email[string(.)]"><p><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="/Doc/Footer/Email"/></a></p></xsl:if></td>
	            </tr>
	          </table>
	          <div class="clearer">&nbsp;</div>
	        </div>
	      	<b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
	    	</div>
	    </div>
	  </div>
	</xsl:if>
	  
	<xsl:if test="/Doc/Footer/UseImage = 1">
		<div id="logofooter" class="center"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/Footer/ImagePath}"/></div>
	</xsl:if>
	</xsl:if>
</div>
</td>
      </tr>
    </table></td>
  </tr>
</table>
</body>
</html>

</xsl:template>
</xsl:stylesheet>