<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	color: #000000;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	padding: 0;
	margin: 0 auto;
	text-align: center;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	text-align: center;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	text-align: center;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Helvetica, sans-serif;
}

#pagehead a {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
}

#pagehead p {
	line-height: 13pt;
}

#subhead {
	margin: 0 0 10px 0;
}

#pageband {
	background: transparent url(../resources/graf_bg_shade.jpg) repeat-x top;
	color: #000000;
	position: absolute;
	left: 0;
	width: 100%;
	height: 60px;
}

#pagefoot {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	background: transparent;
	margin-bottom: 10px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Helvetica, sans-serif;
}

#pagefoot a {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
}

#mainimage {
	margin: 0;
	padding: 10px;
	text-align: center;
}

#mainimage img {
	margin-bottom: 10px;
}

#altmainimage {
	padding: 10px 0 10px 0;
	margin: 0 0 10px 0;
	width: 740px;
	overflow: auto;
	text-align: center;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.smalltext {
	font-size: 8pt;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
	background: transparent;
}

.right {
	float: right;
	background: transparent;
}

.center {
	text-align: center;
	margin: 0 auto;
}

.sep {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #a2c0df;
	color: #a2c0df;
	margin: 0;
	padding: 0;
}

.seppad {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #a2c0df;
	color: #a2c0df;
	margin: 10px 0 10px 0;
	padding: 0;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: <xsl:value-of select="Doc/Fonts/FilenameFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/FilenameFont/ColorValue"/>;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FilenameFont/Family"/>&quot;, Helvetica, sans-serif;
	float: left;
	margin-right: 8px;
}

.metatitle1 a {
	text-decoration: none;
}

.metatitle1 a:hover {
	color: #7ba9c4;
}

.metatitle2 {
	font-style: italic;
	margin-left: 2px;
	float: left;
}

.metatitle3 {
	float: right;
}

.metatitle4 {
	float: left;
}

.metaitem {
	margin-bottom: 4px;
}

.thumbcontainer {
	text-align: center;
	display: table-cell;
	margin: 10px;
}

.thumbcontainer img {
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	padding: 7px;
	margin-bottom: 5px;
}

.metabox {
	background: #<xsl:value-of select="Doc/Colors/ImageColor/ColorValue"/>;
	padding: 5px;
	text-align: left;
	font-size: <xsl:value-of select="Doc/Fonts/ImageFont/Size"/>pt;
	line-height: 12pt;
	margin: 0 auto;
	height: 1px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;
	color: #<xsl:value-of select="Doc/Fonts/ImageFont/ColorValue"/>;
}

html > body .metabox {
	height: auto;
}

.foo {
	vertical-align: middle;
}

.thumbcontainer .metabox {
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	padding: 7px;
	text-align: left;
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
	line-height: 11pt;
	height: auto;
	width: auto;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
}

.thumbcontainer .metabox img {
	background: transparent;
	padding: 0;
	line-height: normal;
}

.thumbcontainer .metabox p {
	margin: 0 !important;
}

.paginate {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/PaginationFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	padding-top: 10px;
	padding-bottom: 10px;
	margin: 0px;
	text-align: center;
}

.paginate a {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	padding: 2px 6px;
	border: solid 1px #<xsl:value-of select="Doc/Colors/PaginateBorderColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	text-decoration: none;
}

.paginate .this-page {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	padding: 2px 6px;
	border-color: #999999;
	font-weight: bold;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	vertical-align: top;
	background: #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>;
}

.paginate a:hover {
	color: #<xsl:value-of select="Doc/Colors/PaginateHoverTextColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/PaginateBackgroundColor/ColorValue"/>;
	border-color: #<xsl:value-of select="Doc/Colors/PaginateHoverBorderColor/ColorValue"/>;
	text-decoration: none;
}

.imagenav {
	padding: 5px 10px 5px 10px;
	margin: 0 auto;
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;
}

.framediv {
	margin-bottom: 5px;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
	font-weight: bolder;
	margin: 10px 0 10px 0;
	padding: 5px 0 5px 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Helvetica, sans-serif;
	text-align: center;
}

#subhead h1 {
	margin: 10px 0 0 0;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

table{
	margin: 0;
	padding: 0;
	text-align: left;
	border: 0;
}

td {
	padding: 0;
	margin: 0;
}

td.thumbtable {
	padding: 5px;
	text-align: center;
}

.infor {
	text-align: left;
	padding: 0;
}

#logohead .infor {
	text-align: center;
	width: 250px;
}

#pagehead .infor {
	width: 500px;
}

.xsnazzy h1, .xsnazzy p {
	margin: 0 10px;
}

.xsnazzy h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Helvetica, sans-serif;
	text-align: left;
	height: 14pt; /* IE dissapearing act fix */
}

#pagehead .xsnazzy p {
	line-height: 15pt;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>px;
	background: transparent;
}

#pagefoot .xsnazzy p {
	line-height: 15pt;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>px;
	background: transparent;
}

.xsnazzy {
	background: transparent;
	margin-top: 10px;
}

.xtop, .xbottom {
	display: block;
	background: transparent;
	font-size: 1px;
}

.xb1, .xb2, .xb3, .xb4 {
	display: block;
	overflow: hidden;
}

.xb1, .xb2, .xb3 {
	height: 1px;
}

.xb2, .xb3, .xb4 {
	background: #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>; /* main Bg Colour mainbox */
	border-left: 1px solid #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>;
	border-right: 1px solid #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>;
}

#logohead .xb2, #logohead .xb3, #logohead .xb4 {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	border-left: 1px solid #<xsl:value-of select="Doc/Colors/HeaderLogoBorderColor/ColorValue"/>;
	border-right: 1px solid #<xsl:value-of select="Doc/Colors/HeaderLogoBorderColor/ColorValue"/>;
}

#pagehead .xb2, #pagehead .xb3, #pagehead .xb4 {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	border-left: 1px solid #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	border-right: 1px solid #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
}

#pagefoot .xb2, #pagefoot .xb3, #pagefoot .xb4 {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	border-left: 1px solid #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	border-right: 1px solid #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
}

.xb1 {
	margin: 0 5px;
	background: #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>;
}

#logohead .xb1 {
	margin: 0 5px;
	background: #<xsl:value-of select="Doc/Colors/HeaderLogoBorderColor/ColorValue"/>;
}

#pagehead .xb1 {
	margin: 0 5px;
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
}

#pagefoot .xb1 {
	margin: 0 5px;
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
}

.xb2 {
	margin: 0 3px;
	border-width: 0 2px;
}

.xb3 {
	margin: 0 2px;
}

.xb4 {
	height: 2px;
	margin: 0 1px;
}

.xboxcontent {
	display: block;
	background: #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>;
	border: 0 solid #<xsl:value-of select="Doc/Colors/ContentBackgroundColor/ColorValue"/>;
	border-width: 0 1px;
}

#logohead .xboxcontent {
	display: block;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	border: 0 solid #<xsl:value-of select="Doc/Colors/HeaderLogoBorderColor/ColorValue"/>;
	border-width: 0 1px;
}

#pagehead .xboxcontent, #logohead .xboxcontent {
	height: 90px;
}

#pagehead .xboxcontent {
	display: block;
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	border: 0 solid #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	border-width: 0 1px;
}

#pagefoot .xboxcontent {
	display: block;
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	border: 0 solid #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	border-width: 0 1px;
}

#pagefoot .xboxcontent p.left {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
}

</xsl:template>
</xsl:stylesheet>