<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	width: 100%;
	padding: 0;
	margin: 0 auto;
	text-align: center;
}

#content {
	background: transparent url(../resources/graf_bg_shade.jpg) repeat-x top;
	text-align: left;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
	margin-top: 10px;
	text-align: center;
}

#logofoot {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
	margin-top: 10px;
	text-align: center;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	padding: 5px;
	margin-bottom: 10px;
	text-align: center;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>pt;
}

#pagehead p {
	line-height: 13pt;
}

#pagehead a {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
}

#subhead {
	margin: 0 0 10px 0;
}

#pageband {
	background: transparent url(../resources/graf_bg_shade.jpg) repeat-x top;
	color: #000000;
	position: absolute;
	left: 0;
	width: 100%;
	height: 60px;
}

#pagefoot {
	background: transparent url(../resources/graf_bg_shade.jpg) repeat-x top;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	height: 50px;
	padding: 5px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>pt;
	font-weight: bold;
	margin: 10px 0 10px 0;
	text-align: center;
}

#pagefoot a {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
}

#mainimage {
	margin: 0;
	padding: 0;
	text-align: center;
}

#mainimage img {
	margin-bottom: 10px;
}

#altmainimage {
	padding: 10px 0 10px 0;
	margin: 0 0 10px 0;
	width: 740px;
	overflow: auto;
	text-align: center;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.foo {
	vertical-align: middle;
}

.smalltext {
	font-size: 8pt;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
}

.right {
	float: right;
}

.center {
	text-align: center;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 a {
	text-decoration: none;
}

.metatitle1 a:hover {
	color: #7ba9c4;
}

.metatitle2 {
	font-size: 70%;
	font-style: italic;
	margin-left: 10px;
	margin-top: 0.5em;
	float: left;
}

.metatitle3 {
	float: right;
}

.imagemetatitle1 {
	float: left;
	margin-right: 8px;
}

.imagemetatitle2 {
	font-style: italic;
	float: left;
	margin-left: 2px;
}

.imagemetatitle3 {
	float: right;
}

.imagemetatitle4 {
	float: left;
}

.metabox {
	background: #<xsl:value-of select="Doc/Colors/ImageColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/ImageFont/ColorValue"/>;
	padding: 5px;
	border: 1px solid #<xsl:value-of select="Doc/Colors/ImageMetadataBorder/ColorValue"/>;
	text-align: left;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ImageFont/Size"/>pt;
	width: 760px;
	margin: 0 auto;
}

.metaitem {
	margin-bottom: 3px;
}

.thumbcontainer {
	padding: 5px;
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	height: auto;
	display: table-cell;
	border: 1px solid #<xsl:value-of select="Doc/Colors/ThumbnailBorderColor/ColorValue"/>;
}

.thumbmeta {
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
	margin-top: 5px;
	text-align: left;
}

.imagenav {
	width: 760px;
	padding: 5px;
	margin: 0 auto;
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;
}

.imagenav a {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
}

.framediv {
	margin-bottom: 5px;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
	font-weight: bolder;
	margin: 10px 0 10px 0;
	padding: 5px 0 5px 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Helvetica, sans-serif;
	text-align: center;
}

#subhead h1 {
	margin: 10px 0 0 0;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

td.thumbtable {
	padding: 5px;
}

</xsl:template>
</xsl:stylesheet>