<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	color: #000000;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
	background: url(../resources/graf_bg_shade2.gif) #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/> repeat-y top left;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	padding: 0;
	margin: 0;
	width: 760px;
}

#content {
	width: 740px;
	padding: 10px;
	text-align: left;
	background: transparent;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
}

#logofooter {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	padding: 5px;
	margin-bottom: 10px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>pt;
	border: 1px solid #<xsl:value-of select="Doc/Colors/HeaderBorderColor/ColorValue"/>;
	border-left: 8px solid #<xsl:value-of select="Doc/Colors/HeaderBorderColor/ColorValue"/>;
}

#pagehead p {
	line-height: 13pt;
}

#pagehead a {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
}

#subhead {
	margin: 0 0 10px 0;
	color: #<xsl:value-of select="Doc/Fonts/PageFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;
}

#pageband {
	background: url(../resources/graf_head_shade.png) <xsl:value-of select="Doc/Color/BackgroundColor/ColorValue"/> repeat-x top left;
	color: #000000;
	padding: 5px;
	font-size: 8pt;
	font-weight: bold;
}

#pagefoot {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	padding: 5px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>pt;
	font-weight: bold;
	margin: 10px 0 10px 0;
	border-top: 2px solid #<xsl:value-of select="Doc/Colors/FooterBorder/ColorValue"/>;
	border-bottom: 2px solid #<xsl:value-of select="Doc/Colors/FooterBorder/ColorValue"/>;
}

#pagefoot a {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
}

#mainimage {
	margin: 0 0 10px 0;
	width: 740px;
	text-align: center;
	overflow: auto;
}

#title {
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.smalltext {
	color: #<xsl:value-of select="Doc/Fonts/ImageDateFont/ColorValue"/>;
	font-size: <xsl:value-of select="Doc/Fonts/ImageDateFont/Size"/>pt;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageDateFont/Family"/>&quot;, Helvetica, sans-serif;	
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
}

.right {
	float: right;
}

.center {
	text-align: center;
}

.fluidleft {
	float: left;
	width: 250px;
	clear: right;
}

.fluidcenter {
	float:left;
	width: 230px;
	text-align: center;
}

.fluidright {
	float: left;
	width: 250px;
	text-align: right;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: 11pt;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: Arial, Helvetica, sans-serif;
	float: left;
}

.metatitle1 a {
	text-decoration: none;
}

.metatitle1 a:hover {
	color: #7ba9c4;
}

.metatitle2 {
	font-size: 70%;
	font-style: italic;
	margin-left: 10px;
	margin-top: 0.5em;
	float: left;
}

.metatitle3 {
	float: right;
}

.metabox {
	color: #<xsl:value-of select="Doc/Fonts/ImageFont/ColorValue"/>;
	padding: 5px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ImageFont/Size"/>pt;
	background: #<xsl:value-of select="Doc/Colors/ImageColor/ColorValue"/>;
	padding: 5px;
	border: 1px solid #<xsl:value-of select="Doc/Colors/ImageMetadataBorder/ColorValue"/>;
}

.metaitem {
	margin-bottom: 4px;
}

.thumbcontainer {
	padding: 5px;
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	height: auto;
	display: table-cell;
}

.thumbmeta {
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
	padding: 5px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
	margin-top: 5px;
	text-align: left;
	line-height: 12pt;
}

.paginate {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/PaginationFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	padding-top: 10px;
	padding-bottom: 10px;
	margin: 0px;
	text-align: center;
}

.paginate a {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	padding: 2px 6px;
	border: solid 1px #<xsl:value-of select="Doc/Colors/PaginateBorderColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	text-decoration: none;
}

.paginate .this-page {
	padding: 2px 6px;
	border-color: #999999;
	font-weight: bold;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	vertical-align: top;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
}

.paginate a:hover {
	color: #<xsl:value-of select="Doc/Colors/PaginateHoverTextColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/PaginateBackgroundColor/ColorValue"/>;
	border-color: #<xsl:value-of select="Doc/Colors/PaginateHoverBorderColor/ColorValue"/>;
	text-decoration: none;
}

.imagenav {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;
	padding: 5px;
	margin: 10px 0 10px 0;
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
}

.imagenav a {
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	font-weight: bolder;
	margin: 10px 0 10px 0;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Helvetica, sans-serif;	
}

#subhead h1 {
	margin: 10px 0 0 0;
	font-size: <xsl:value-of select="Doc/Fonts/ImageFileNameFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/ImageFileNameFont/ColorValue"/>;
	font-weight: bolder;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFileNameFont/Family"/>&quot;, Helvetica, sans-serif;	
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

</xsl:template>
</xsl:stylesheet>