<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	color: #000000;
	text-align: center;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
}

a:hover {
	text-decoration: none;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	width: 760px;
	padding: 0;
	margin: 0 auto;
	text-align: left;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
	padding-top: 7px;
}

#logofooter {
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	padding-bottom: 5px;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	padding: 5px;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>pt;
	font-weight: bold;
	border-bottom: 1px solid #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Helvetica, sans-serif;
}

#pagehead a{
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
}

#pagehead a:hover{
	text-decoration: none;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
}

#pagefoot {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	padding: 5px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>pt;
	font-weight: bold;
	margin: 10px 0 10px 0;
}

#pagefoot a{
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
}

#pagefoot a:hover{
	text-decoration: none;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
}

#mainimage {
	margin: 0 0 10px 0;
	width: 760px;
	text-align: center;
	overflow: auto;
}

#title {
	color: #<xsl:value-of select="Doc/Fonts/TitleFont/ColorValue"/>;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
}

.right {
	float: right;
}

.center {
	text-align: center;
}

.sep {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #<xsl:value-of select="Doc/Colors/HorizontalLineColor/ColorValue"/>;
	color: #a2c0df;
	margin: 0;
	padding: 0;
}

.seppad {
	line-height: 0px;
	height: 1px;
	border: none;
	background: #<xsl:value-of select="Doc/Colors/HorizontalLineColor/ColorValue"/>;
	color: #a2c0df;
	margin: 10px 0 10px 0;
	padding: 0;
}

.metatitle {
	margin-bottom: 10px;
}

.thumbmetatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: <xsl:value-of select="Doc/Fonts/FilenameFont/Size"/>pt;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FilenameFont/Family"/>&quot;, Helvetica, sans-serif;
	float: left;
	margin-right: 8px;
	color: #<xsl:value-of select="Doc/Fonts/FilenameFont/ColorValue"/>;
}

.metatitle1 a {
	color: #<xsl:value-of select="Doc/Fonts/FilenameFont/ColorValue"/>;
	text-decoration: none;
}

.metatitle1 a:hover {
	color: #<xsl:value-of select="Doc/Colors/HoverColor/ColorValue"/>;
}

.metatitle2 {
	font-family: &quot;<xsl:value-of select="Doc/Fonts/DateFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/DateFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/DateFont/ColorValue"/>;
	font-style: italic;
	margin-left: 2px;
	margin-top: 0.5em;
	float: left;
}

.imagemetatitle2 {
	font-family: &quot;<xsl:value-of select="Doc/Fonts/DateFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/DateFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/DateFont/ColorValue"/>;
	font-style: italic;
	margin-left: 2px;
	margin-top: 0.5em;
	float: left;
}

.metatitle3 {
	float: right;
}

.metatitle4 {
	float: left;
}

.thumbmetabox {
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	padding: 5px;
	border: 1px solid #<xsl:value-of select="Doc/Colors/BordersColor/ColorValue"/>;
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
}

.metabox {
	color: #<xsl:value-of select="Doc/Fonts/ImageFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ImageFont/Family"/>&quot;, Helvetica, sans-serif;
	background: #<xsl:value-of select="Doc/Colors/ImageColor/ColorValue"/>;
	padding: 5px;
	border: 1px solid #<xsl:value-of select="Doc/Colors/BordersColor/ColorValue"/>;
	font-size: <xsl:value-of select="Doc/Fonts/ImageFont/Size"/>pt;
}

.metaitem {
	margin-bottom: 4px;
}

.paginate {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/PaginationFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	padding-top: 10px;
	padding-bottom: 10px;
	margin: 0px;
	text-align: center;
}

.paginate a {
	color: #<xsl:value-of select="Doc/Fonts/PaginationFont/ColorValue"/>;
	padding: 2px 6px;
	border: solid 1px #<xsl:value-of select="Doc/Colors/PaginateBorderColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
	text-decoration: none;
}

.paginate .this-page {
	padding: 2px 6px;
	border-color: #999999;
	font-weight: bold;
	font-size: <xsl:value-of select="Doc/Fonts/PaginationFont/Size"/>pt;
	vertical-align: top;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
}

.paginate a:hover {
	color: #<xsl:value-of select="Doc/Colors/PaginateHoverTextColor/ColorValue"/>;
	background: #<xsl:value-of select="Doc/Colors/PaginateBackgroundColor/ColorValue"/>;
	border-color: #<xsl:value-of select="Doc/Colors/PaginateHoverBorderColor/ColorValue"/>;
	text-decoration: none;
}

.imagenav {
	padding: 5px;
	margin: 10px 0 10px 0;
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;
}

.imagenav a {
	font-size: <xsl:value-of select="Doc/Fonts/NavigationFont/Size"/>pt;
	color: #<xsl:value-of select="Doc/Fonts/NavigationFont/ColorValue"/>;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/NavigationFont/Family"/>&quot;, Helvetica, sans-serif;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: <xsl:value-of select="Doc/Fonts/TitleFont/Size"/>pt;
	font-weight: bolder;
	margin: 5px 0;
	padding: 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/TitleFont/Family"/>&quot;, Helvetica, sans-serif;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

table{
	width: 100%;
	margin: 0;
	padding: 0;
	text-align: left;
	border: 0;
}

td {
	padding: 0;
	margin: 0;
}

td.thumbtable {
	padding: 5px;
}

</xsl:template>
</xsl:stylesheet>