import QtQuick 2.0
import QtMultimedia 5.6
import com.autodesk.toolclips.qml 1.0
import "../Scripts/TCUtils.js" as TCUtils

/** \file MediaView.qml
	
Defines the media stack view of the Level 2 & 3 interface. It contains a
video & image component if a video or image is specified in the ToolClip XML.


*/ 

Rectangle {
    id: media_stack_root
	property variant source : 0
    property int videoState
    property variant media_stack : media_stack
    color: "transparent"


	VisualItemModel {
		id : resourceModel

		Rectangle {
			id : nullResource
			property int index : VisualItemModel.index
            height : TCUtils.dpiScale(70)
            color : "red"
		}
        VideoPlayer {
            id: video2Resource
            property int index : VisualItemModel.index
            width : TCUtils.dpiScale(304)
            height: video2Resource.video_frame.resolution.height * (TCUtils.dpiScale(304) / video2Resource.video_frame.resolution.width)

            onHasVideoChanged:
            {
                // Make the video player / media stack visible again if the video could be properly loaded.
                if ( hasVideo && visible === false )
                {
                    media_stack.visible = true
                }
            }

            onErrorChanged:
            {
                // If the codec is not supported or the resource could not be read,
                // we hide the video player / media stack completely so that no space is wasted.
                if ( error === MediaPlayer.ResourceError || error === MediaPlayer.FormatError )
                {
                    media_stack.visible = false
                }
            }
        }
		Image {
			id : imageResource
			property int index : VisualItemModel.index
            fillMode: Image.PreserveAspectFit
            width : TCUtils.dpiScale(304)
            height: sourceSize.height * (TCUtils.dpiScale(304) / sourceSize.width)
		}
	}

	Stack {
		id : media_stack
		itemModel : resourceModel
        anchors.horizontalCenter: parent.horizontalCenter
	}

	onSourceChanged : {
        //console.log("onSourceChanged", source)
		if ( source ) { 
			// we've been assigned a new resource
            // show the appropriate stack item and assign it's source
			var tagname = source.tagName;
            if ( tagname == "video" ) {

                media_stack.activateItem( 1 )

                var videoLocation = Qt.resolvedUrl( toolClipView.findResource( source.attribute("location") ) )
                if ( media_stack.current.source == videoLocation )
                {
                    // If we already have the same video loaded we make the player visible
                    // since we don't get any other onHasVideoChanged notification.
                    media_stack.visible = video2Resource.hasVideo
                }
                else
                {
                    media_stack.visible = false
                }

                media_stack.current.source = videoLocation
            }
            else if ( tagname == "image" ) {
                media_stack.visible = true
				media_stack.activateItem( 2 )
				media_stack.current.source = source.attribute("location")
			} else {	
                media_stack.visible = false // don't show invalid media stack
				media_stack.activateItem( 0 )
			}
		} else {
            media_stack.visible = false // don't show invalid media stack
			media_stack.activateItem( 0 )
		}
	}
}
