import QtQuick 2.0
import com.autodesk.toolclips.qml 1.0
import "../Scripts/TCUtils.js" as TCUtils

/** \file LinkButton.qml

A simple button with an iconic image to the left and a short text description to the right.
Clients should implement onClicked() to react to a user button click.

*/

Rectangle {
    id : link_button
    property url icon_source : ""
    property url icon_hover_source : icon_source
	property alias text : text.text
	height : Math.max( icon.height, text.height )
	width : icon.width + text.width + TCUtils.dpiScale(3)
	color: "transparent"
	signal clicked

    Image { 
        id: icon
        anchors.left : parent.left
        anchors.verticalCenter: text.verticalCenter 
        width: TCUtils.dpiScale(12)
        height: TCUtils.dpiScale(12)
		fillMode: Image.PreserveAspectFit
		smooth: true
        source : ma.containsMouse ? icon_hover_source : icon_source
        Component.onCompleted:
        {
            toolClipView.setItemCursor(icon, "PointingHandCursor", "more text");
        }
        
    }  
    Text {
        id: text
        anchors.left : icon.right
        anchors.verticalCenter : parent.verticalCenter
        anchors.leftMargin : TCUtils.dpiScale(3)
        font.bold: true
		font.pixelSize: TCUtils.dpiScale(11)
        color : ma.containsMouse ? hoverPal.toolTipText : root.textColor
        Component.onCompleted:
        {
            toolClipView.setItemCursor(text, "PointingHandCursor", "more text");
        }
        
    }        
    
    MouseArea {
        id : ma
        hoverEnabled : true
        anchors.fill : parent
        onClicked : link_button.clicked()
        Component.onCompleted:
        {
            toolClipView.setItemCursor(ma, "PointingHandCursor", "more_ma");
        }                        
    }         

}
