import QtQuick 2.0
import com.autodesk.toolclips.qml 1.0
import "../Scripts/TCUtils.js" as TCUtils

/** \file DescriptionText.qml

This is simply the ToolClip level 2 & 3 description text contained
in toolclip/text:
	
	<toolclip>
		<text>A short description of the Tool</text>
		...
	</toolclip>

*/

Text {
    id: content
    font.pixelSize: TCUtils.dpiScale(11)
    wrapMode: Text.WordWrap
    property alias text : content.text
    property alias textColor : content.color
    visible:  (text == "") ? false : true
    textFormat: { toolClipView.mightBeRichText( text ) ? Text.RichText : Text.PlainText }
}
