-- Generic radius manipulator
-- Written by Scott Morrison

-- This manipulator sets the radius on any object or modifier with
-- a parameter named "radius".  It creates a circle gizmo of the appropriate
-- radius centered at the origin in the XY plane.

plugin simpleManipulator radiusManip
    name:"RadiusManip"
    invisible:true
(
    -- Create the green and red colors for the gizmo
    local greenColor =  colorMan.getColor #manipulatorsActive
    local redColor =    colorMan.getColor #manipulatorsSelected
	local offsetLength = 0.0  -- AF (3/23/01) Used for mouse tracking

    -- This manipulator manipulates any node with a "radius" property
    on canManipulate target return (findItem (getPropNames target) #radius) != 0

    -- Create the manipulator gizmo.
    -- This is called initially and whenever the manipulator target changes
    on updateGizmos do
    (
        -- Clear the current gizmo cache
        this.clearGizmos()
        
        -- Set the radius of circle gizmo a little bigger than the target radius
        giz = manip.makeCircle [0,0,0] (target.radius * 1.01) 28

        -- Add the circle to the manipulator
        this.addGizmoShape giz 0 greenColor redColor  

        -- return the ToolTip string
        return node.name + " radius = " + target.radius as string 
    )

    -- mouseMove is called on every mouse move when dragging the manip
    -- It needs to convert the mouse position 'm' into a new value for the radius
    on mouseMove m which do
    (
        -- Create the XY plane.   
        -- manip.makePlaneFromNormal takes a normal vector and a point
        -- and creates a plane passing through the point with the given normal
        local pl = manip.makePlaneFromNormal z_axis [0, 0, 0],
        projectedPoint = [0,0,0]
		
        -- Compute the hit-ray in local coordinates
        viewRay = this.getLocalViewRay m

        -- Intersect the plane with the view ray
        res = pl.intersect viewRay &projectedPoint
    
        -- If the intersection worked, set the radius
        if (res) then
		(
			target.radius = (length projectedPoint) / 1.01
			offsetLength = 0.0
			return true
		)
		-- AF (3/23/01) Plan B : the point wasn't on the plane because the plane 
		-- was parallel to view or close to it.  Use the plane perpendicular to the view instead
		pl = manip.makePlaneFromNormal viewRay.dir [0, 0, 0]
		projectedPoint = [0,0,0]
		res = pl.intersect viewRay &projectedPoint
		if (res) then 
		(  
			 -- (length projectedPoint) is equal to distance traveled
			 -- radius = distance traveled + the offset from the original mouse down point    
			if offsetLength == 0.0 then 
				offsetLength = target.radius - (length projectedPoint)
			target.radius = ((length projectedPoint) + offsetLength) / 1.01
		)
    )
	
	on MouseDown m which do
	(
		offsetLength = 0.0
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCsOKzi86k6S/7/Stxf/uwRCCbIErnIZ5g6
-- j5RxS6aKtLj+evSQXw8WRIL2rCTFlsba0d64vN042BjYSoZdOkc/ajEfLEprz8k9
-- GCX2mc4KS2NBpRULPq1G2XL2RMypyF7xn7GAf+NwLRW0ewN+0ZNCnbwuV6R+UUjI
-- /xjqx+bwHSWbG6QL+x/V/Wib4Ce5klIZwF/EEVjTjR1y2OErni+D8cadCrrHUb/m
-- haJTFfabCmxbQBrqi2KhD2obgpWRtaCv6KlBX0dzplgqPl+MRT1oaIn466wFKBgH
-- 4iltSRdneQAfsA7lvbTLz36/UXDFoDNzZmL03VEhJnLeAY++YFoE
-- -----END-SIGNATURE-----