/*
UVW Unwrap functions and dialog

Version: 3dsmax 6

Revision History:
		
	24 April 2004 added the pen tool and the loop selection tool
	12 dec 2003, Pierre-Felix Breton, 
		moved functions and dialog definition into the /stdplug/stdscripts/modifier_uvwunwrap_dialog.ms from the Macro_UnwrapUI.mcr

*/

Global unwrapUIdialog
rollout unwrapUIdialog ~UNWRAPUIDIALOG_CAPTION~ width:604 height:158
(
	GroupBox grp3 ~GRP3_CAPTION~ pos:[4,0] width:258 height:76
	checkbox dash_SoftSel ~DASH_SOFTSEL_CAPTION~ pos:[12,20] width:44 height:16 checked:false
	spinner dash_SoftFalloff ~DASH_SOFTFALLOFF_CAPTION~ pos:[170,19] width:80 height:16 enabled:false range:[0,100,0.2] scale:0.01 fieldwidth:40
	radiobuttons dash_UVSpace "" pos:[64,20] width:~DASH_UVSPACE_WIDTH~ height:16 enabled:true labels:#("XY", "UV") columns:2
	checkbutton dash_FalloffLin "" pos:[180,42] width:24 height:24 iconName:"UVWUnwrapDialog/LinearFalloff" toolTip:~DASH_FALLOFFLIN_TOOLTIP~
	checkbutton dash_FalloffSin "" pos:[154,42] width:24 height:24 iconName:"UVWUnwrapDialog/SmoothFalloff"  toolTip:~DASH_FALLOFFSIN_TOOLTIP~
	checkbutton dash_FalloffIn "" pos:[206,42] width:24 height:24 iconName:"UVWUnwrapDialog/SlowOutFalloff"  toolTip:~DASH_FALLOFFIN_TOOLTIP~
	checkbutton dash_FalloffOut "" pos:[232,42] width:24 height:24 iconName:"UVWUnwrapDialog/FastOutFalloff"  toolTip:~DASH_FALLOFFOUT_TOOLTIP~
	spinner dash_EdgeDistAmount "" pos:[108,44] width:42 height:16 enabled:true range:[0,50,4] type:#integer scale:0.1 fieldwidth:25
	checkbox dash_edgeDist ~DASH_EDGEDIST_CAPTION~ pos:[12,44] width:~DASH_EDGEDIST_WIDTH~ height:16 checked:false
	
	GroupBox grp5 ~GRP5_CAPTION~ pos:[264,0] width:236 height:76
	checkbutton dash_VertexMode "" pos:[300-22-8,15] width:27 height:27 iconName:"UVWUnwrapDialog/VertexSubObjectMode"  highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) toolTip:~DASH_VERTEXMODE_TOOLTIP~
	checkbutton dash_EdgeMode "" pos:[332-22-8,15] width:27 height:27 iconName:"UVWUnwrapDialog/EdgeSubObjectMode"  highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) toolTip:~DASH_EDGEMODE_TOOLTIP~
	checkbutton dash_FaceMode "" pos:[364-22-8,15] width:27 height:27 iconName:"UVWUnwrapDialog/FaceSubObjectMode" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) toolTip:~DASH_FACEMODE_TOOLTIP~

	checkbox dash_element ~DASH_ELEMENT_CAPTION~ pos:[280-8,48] width:~DASH_ELEMENT_WIDTH~ height:16 checked:false

	button dash_grow "+" pos:[416-41-6,16] width:27 height:24 toolTip:~DASH_GROW_TOOLTIP~
	button dash_shrink "-" pos:[444-39-6,16] width:27 height:24 toolTip:~DASH_SHRINK_TOOLTIP~
	
	checkbutton dash_PaintMode "" pos:[416-41-6,16+26] width:27 height:28 iconName:"UVWUnwrapDialog/PaintSelectMode" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) toolTip:~DASH_PAINTMODE_TOOLTIP~

	button dash_PaintModeInc "+" pos:[444-39-6,16+26] width:14 height:14  toolTip:~DASH_PAINTMODEINC_TOOLTIP~

	button dash_PaintModeDec "-" pos:[444-39-6,30+26] width:14 height:14  toolTip:~DASH_PAINTMODEDEC_TOOLTIP~

	button dash_EdgeLoop ~DASH_EDGELOOP_CAPTION~ pos:[438-6,14-1] width:46 height:28  toolTip:~DASH_EDGELOOP_TOOLTIP~

	button dash_EdgeLoopInc "+" pos:[438+58-18,14-1] width:14 height:14  toolTip:~DASH_EDGELOOPINC_TOOLTIP~
	button dash_EdgeLoopDec "-" pos:[438+58-18,14+14-1] width:14 height:14  toolTip:~DASH_EDGELOOPDEC_TOOLTIP~

	button dash_EdgeRing ~DASH_EDGERING_CAPTION~ pos:[438-6,14+32-1] width:46 height:28  toolTip:~DASH_EDGERING_TOOLTIP~
	button dash_EdgeRingInc "+" pos:[438+58-18,14+32-1] width:14 height:14  toolTip:~DASH_EDGERINGINC_TOOLTIP~
	button dash_EdgeRingDec "-" pos:[438+58-18,14+32+14-1] width:14 height:14  toolTip:~DASH_EDGERINGDEC_TOOLTIP~
	
--	checkbox dash_sync ~DASH_SYNC_CAPTION~ pos:[378,48] width:98 height:16 checked:false
	
	button dash_RotateCW "+90" pos:[488+15,4] width:24 height:24 toolTip:~DASH_ROTATECW_CAPTION~ iconName:"UVWUnwrapDialog/Rotate90" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) 
	button dash_RotateCCW "-90" pos:[488+15+24,4] width:24 height:24 toolTip:~DASH_ROTATECCW_TOOLTIP~ iconName:"UVWUnwrapDialog/Rotate-90" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) 
	
	button dash_AlignH "--" pos:[488+15+48+2,4] width:24 height:24 toolTip:~DASH_ALIGNH_TOOLTIP~ iconName:"UVWUnwrapDialog/AlignHorizontal" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) 
	button dash_AlignV "||" pos:[488+15+48+24+2,4] width:24 height:24 toolTip:~DASH_ALIGNV_TOOLTIP~ iconName:"UVWUnwrapDialog/AlignVertical" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255))
	
	button dash_SpaceH "|--|" pos:[488+15+48+2,6+24] width:24 height:24 toolTip:~DASH_SPACEH_CAPTION~  iconName:"UVWUnwrapDialog/SpaceHorizontal" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) 
	button dash_SpaceV "=" pos:[488+15+48+24+2,6+24] width:24 height:24 toolTip:~DASH_SPACEV_CAPTION~  iconName:"UVWUnwrapDialog/" highlightColor:(color ((colorman.getcolor #activecommand).x *255) ((colorman.getcolor #activecommand).y *255)((colorman.getcolor #activecommand).z *255)) 
	
	button dash_Stitch ~DASH_STITCH_CAPTION~ pos:[488+15+~DASH_STITCH_SIX_OR_EIGHT~,6+24] width:~DASH_STITCH_WIDTH~ height:24 toolTip:~DASH_STITCH_TOOLTIP~
	button dash_Stitch0 "<" pos:[488+15,6+24] width:8 height:24 toolTip:~DASH_STITCH0_TOOLTIP~
	button dash_Stitch1 ">" pos:[488+15+~DASH_STITCH1_FORTY_OR_FORTY_ONE~,6+24] width:8 height:24 toolTip:~DASH_STITCH1_TOOLTIP~
	
	checkbutton dash_options ~DASH_OPTIONS_CAPTION~ pos:[488+15,56] width:98 height:18
	
	GroupBox grp10 ~GRP10_CAPTION~ pos:~GRP10_POSITION~ width:~GRP10_WIDTH~ height:78
	spinner dash_picwidth ~DASH_PICWIDTH_CAPTION~ pos:~DASH_PICWIDTH_POSITION~ width:76 height:16 range:[2,2048,256] type:#integer fieldwidth:40
	spinner dash_picheight ~DASH_PICHEIGHT_CAPTION~ pos:~DASH_PICHEIGHT_POSITION~ width:76 height:16 range:[2,2048,256] type:#integer  fieldwidth:40
	checkbox dash_custombitmapsize ~DASH_CUSTOMBITMAPSIZE_CAPTION~ pos:~DASH_CUSTOMBITMAPSIZE_POSITION~ width:~DASH_CUSTOMBITMAPSIZE_WIDTH~ height:16	
	checkbox dash_TileOn ~DASH_TILEON_CAPTION~ pos:~DASH_TILEON_POSITION~ width:~DASH_TILEON_WIDTH~ height:16
	spinner dash_Tileamount ~DASH_TILEAMOUNT_CAPTION~ pos:~DASH_TILEAMOUNT_POSITION~ width:64 height:16 range:[0,50,1] type:#integer fieldwidth:40
	spinner dash_brightness ~DASH_BRIGHTNESS_CAPTION~ pos:~DASH_BRIGHTNESS_POSITION~ width:88 height:16 range:[0,1,.5] scale:.1 type:#float fieldwidth:40	
	
	GroupBox grp20 ~GRP20_CAPTION~ pos:~GRP20_POSITION~ width:~GRP20_WIDTH~ height:78
	checkbox dash_ConstantUpdate ~DASH_CONSTANTUPDATE_CAPTION~ pos:~DASH_CONSTANTUPDATE_POSITION~ width:104 height:14 
--	checkbox dash_highlightverts ~DASH_HIGHLIGHTVERTS_CAPTION~ pos:[264,119] width:140 height:14 
	
	GroupBox grp21 ~GRP21_CAPTION~ pos:~GRP21_POSITION~ width:~GRP21_WIDTH~ height:78
	checkbox dash_showhiddenedges ~DASH_SHOWHIDDENEDGES_CAPTION~ pos:~DASH_SHOWHIDDENEDGES_POSITION~ width:~DASH_SHOWHIDDENEDGES_WIDTH~ height:14

	spinner dash_WeldThresh ~DASH_WELDTHRESH_CAPTION~ pos:[464,132] width:120 height:16 range:[0,100,0.2] scale:0.01 fieldwidth:40
	checkbox dash_MidPixelSnap ~DASH_MIDPIXELSNAP_CAPTION~ pos:~DASH_MIDPIXELSNAP_POSITION~ width:~DASH_MIDPIXELSNAP_WIDTH~ height:16
	
	fn UpdateUI = 
	(
		 if unwrapUIdialog.open do 
		 (
			unwrapMod = modpanel.getcurrentobject()
		
			-- Get all selection Modes and set the UI correctly
			dash_SoftSel.checked = unwrapMod.getEnableSoftSelection() 
	
			dash_SoftFalloff.value = unwrapMod.getFalloffDist() 
			if 	unwrapMod.getEnableSoftSelection() == true do dash_SoftFalloff.enabled = true
			if 	unwrapMod.getEnableSoftSelection() == false do dash_SoftFalloff.enabled = false
	
			dash_FalloffLin.state = false 
			dash_FalloffSin.state = false
			dash_FalloffIn.state = false
			dash_FalloffOut.state = false
			
			dash_VertexMode.checked = false
			dash_EdgeMode.checked = false
			dash_FaceMode.checked = false
	
			dash_UVSpace.state = unwrapMod.getFalloffSpace()
			if unwrapMod.getFalloffType() == 1 do dash_FalloffLin.state = true 
			if unwrapMod.getFalloffType() == 2 do dash_FalloffSin.state = true
			if unwrapMod.getFalloffType() == 3 do dash_FalloffIn.state = true
			if unwrapMod.getFalloffType() == 4 do dash_FalloffOut.state = true
			dash_EdgeDistAmount.value  = unwrapMod.getLimitSoftSelRange()
			dash_edgeDist.state =  unwrapMod.getLimitSoftSel()
			
			if unwrapMod.getTVSubObjectMode() == 1 do dash_VertexMode.checked = true
			if unwrapMod.getTVSubObjectMode() == 2 do dash_EdgeMode.checked = true
			if unwrapMod.getTVSubObjectMode() == 3 do dash_FaceMode.checked = true
			
			dash_EdgeLoop.enabled = true
			dash_AlignH.enabled = true
			dash_AlignV.enabled = true

			dash_SpaceH.enabled = true
			dash_SpaceV.enabled = true


			dash_EdgeRingDec.enabled = false
			if unwrapMod.getTVSubObjectMode() == 2 do 			
			(
				dash_EdgeRingDec.enabled = true
			)
			

			if unwrapMod.getTVSubObjectMode() == 3 do 
			(
				dash_AlignH.enabled= false
				dash_AlignV.enabled= false
				dash_SpaceH.enabled= false
				dash_SpaceV.enabled= false
			)
			
			dash_element.checked = unwrapMod.getTVElementMode()
	--		dash_sync.checked = unwrapMod.getSyncSelectionMode()
			dash_picwidth.value = unwrapMod.getRenderWidth()
			dash_picheight.value = unwrapMod.getRenderHeight()
			
			dash_custombitmapsize.checked = not unwrapMod.getUseBitmapRes()
			dash_TileOn.checked = unwrapMod.getTileMap()
			dash_Tileamount.value = unwrapMod.getTileMapLimit() 
			dash_brightness.value = unwrapMod.getTileMapBrightness() 
			dash_ConstantUpdate.checked = unwrapMod.getConstantUpdate() 
	--		dash_highlightverts.checked = unwrapMod.getShowSelectedVertices() 
			
			dash_showhiddenedges.checked = unwrapMod.getDisplayHiddenEdges() 
			if (unwrapMod.IsMesh()==false) then dash_showhiddenedges.Enabled = false
			dash_WeldThresh.value = unwrapMod.getWeldThreshold() 
			dash_MidPixelSnap.checked = unwrapMod.getMidPixelSnap() 
			
			dash_PaintMode.checked = unwrapMod.unwrap2.getPaintSelectMode()
		)
	)

	on unwrapUIdialog open do 
	(
	  	unwrapModPKW = modpanel.getcurrentobject()
	  	h =  unwrapModPKW.GetWindowH()	
		if (h==0) then
		unwrapUIdialog.height = 0		
		else unwrapUIdialog.height = 78
		
		unwrapModPKW .unwrap5.setWindowYOffset (78+10)		
		
		-- Get all selection Modes and set the UI correctly
		UpdateUI()
	)
	
	on dash_EdgeLoop pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.uvLoop 0
	)
	
	on dash_EdgeLoopInc pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.uvLoop 1
	)	
	
	on dash_EdgeLoopDec pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.uvLoop -1
	)	
	
	on dash_EdgeRing pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.uvRing 0
	)	
	
	on dash_EdgeRingInc pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.uvRing 1
	)
        
        on dash_EdgeRingDec pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.uvRing -1
	)
	
	on dash_Stitch pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		if (keyboard.shiftpressed) then unwrapMod.stitchVerts false 1.0 
		else unwrapMod.stitchVerts false 0.5 
	)
	
	on dash_Stitch0 pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.stitchVerts false 0.0 
	)
	
	on dash_Stitch1 pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.stitchVerts false 1.0 
		
	)
	
	on dash_AlignH pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		if (keyboard.shiftpressed and (unwrapMod.getTVSubObjectMode() == 2)) then unwrapMod.uvLoop 0
		unwrapMod.align true
	)
	
	on dash_AlignV pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		if (keyboard.shiftpressed and (unwrapMod.getTVSubObjectMode() == 2)) then unwrapMod.uvLoop 0
		unwrapMod.align false
	)	
	
	on dash_SpaceH pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		if (keyboard.shiftpressed and (unwrapMod.getTVSubObjectMode() == 2)) then unwrapMod.uvLoop 0
		unwrapMod.space true
	)		
	
	on dash_SpaceV pressed do
	(
		unwrapMod = modpanel.getcurrentobject()
		if (keyboard.shiftpressed and (unwrapMod.getTVSubObjectMode() == 2)) then unwrapMod.uvLoop 0
		unwrapMod.space false
	)		
	
	on dash_PaintMode changed state do
	(
		unwrapMod = modpanel.getcurrentobject()
		if state == false do 
		(
			unwrapMod.setPaintSelectMode false
		)
		if state == true do 
		(
			unwrapMod.setPaintSelectMode true		
		)

	)
	on dash_PaintModeInc pressed do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.PaintSelectIncSize()
	)
	on dash_PaintModeDec pressed do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.PaintSelectDecSize()
	)
	
	-- Soft Selection UI items
	on dash_SoftSel changed state do
	(
		unwrapMod = modpanel.getcurrentobject()
		if state == false do 
		(
--			unwrapMod.SetFalloffDist 0
			unwrapMod.setEnableSoftSelection false
			dash_SoftFalloff.enabled = false
		)
		if state == true do
		(
--			unwrapMod.SetFalloffDist dash_SoftFalloff.value
			unwrapMod.setEnableSoftSelection true
			dash_SoftFalloff.enabled = true
		)
	)
	on dash_FalloffLin changed state do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setFalloffType 1
		dash_FalloffLin.checked = true
		dash_FalloffSin.checked = false
		dash_FalloffIn.checked = false
		dash_FalloffOut.checked = false

	)
	on dash_FalloffSin changed state do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setFalloffType 2
		dash_FalloffLin.checked = false
		dash_FalloffSin.checked = true
		dash_FalloffIn.checked = false
		dash_FalloffOut.checked = false
		
	)
	on dash_FalloffIn changed state do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setFalloffType 3
		dash_FalloffLin.checked = false
		dash_FalloffSin.checked = false
		dash_FalloffIn.checked = true
		dash_FalloffOut.checked = false
		
	)
	on dash_FalloffOut changed state do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setFalloffType 4
		dash_FalloffLin.checked = false
		dash_FalloffSin.checked = false
		dash_FalloffIn.checked = false
		dash_FalloffOut.checked = true		
	)
	
	on dash_SoftFalloff changed val do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.SetFalloffDist val
	)
	on dash_UVSpace changed stat do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.SetFalloffSpace stat
	)
	on dash_EdgeDistAmount changed val do 
	(
   		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setLimitSoftSelRange val
	)
	on dash_edgeDist changed state do
	(
		unwrapMod = modpanel.getcurrentobject()	
		if state == false do 
		(
			unwrapMod.setLimitSoftSel false
		)
		if state == true do
		(
			unwrapMod.setLimitSoftSel true
		)
	)
	
	-- Selection Modes and UI Items
	on dash_VertexMode changed state do
	(
		unwrapMod = modpanel.getcurrentobject()
		if state == true do 
		(
			dash_VertexMode.checked = true
			dash_EdgeMode.checked = false
			dash_FaceMode.checked = false
			dash_EdgeLoop.enabled = false	
			dash_EdgeRingDec.enabled = false			
		)
		if state == false do 
		(
			dash_VertexMode.checked = true
			dash_EdgeMode.checked = false
			dash_FaceMode.checked = false
		)
		unwrapMod.setTVSubObjectMode 1
	)
	on dash_EdgeMode changed state do
	(
		unwrapMod = modpanel.getcurrentobject()	
		if state == true do 
		(
			dash_VertexMode.checked = false
			dash_EdgeMode.checked = true
			dash_FaceMode.checked = false
			dash_EdgeLoop.enabled = true
			dash_EdgeRingDec.enabled = true
		)
		if state == false do 
		(
			dash_VertexMode.checked = false
			dash_EdgeMode.checked = true
			dash_FaceMode.checked = false
		)
		unwrapMod.setTVSubObjectMode 2
	)
	on dash_FaceMode changed state do
	(
		unwrapMod = modpanel.getcurrentobject()
		if state == true do 
		(
			dash_VertexMode.checked = false
			dash_EdgeMode.checked = false
			dash_FaceMode.checked = true
			dash_EdgeLoop.enabled = false
			dash_EdgeRingDec.enabled = false
		)
		if state == false do 
		(
			dash_VertexMode.checked = false
			dash_EdgeMode.checked = false
			dash_FaceMode.checked =true
		)
		unwrapMod.setTVSubObjectMode 3
	)
	on dash_element changed state do
	(
		unwrapMod = modpanel.getcurrentobject()	
		if state == false do 
		(
			unwrapMod.setTVElementMode false
		)
		if state == true do
		(
			unwrapMod.setTVElementMode true
		)
	)
/*	on dash_sync changed state do
	(
		unwrapMod = modpanel.getcurrentobject()	
		if state == false do 
		(
			unwrapMod.setSyncSelectionMode false
		)
		if state == true do
		(
			unwrapMod.setSyncSelectionMode true
		)
	)
*/
	on dash_grow pressed do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.expandSelection()
	)
	on dash_shrink pressed do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.contractSelection()
	)
	
	-- Tools and Misc
	on dash_RotateCW pressed do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.RotateSelectedCenter -1.5708
	)
	on dash_RotateCCW pressed do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.RotateSelectedCenter 1.5708
	)
	
		
	-- Options Panel UI elements
	on dash_options changed state do
	(
		unwrapMod = modpanel.getcurrentobject()
		if state == true do 
		(
			unwrapUIdialog.height = 163
			unwrapMod.unwrap5.setWindowYOffset (163+10)
		)
		if state == false do 
		(
			unwrapUIdialog.height = 78
			unwrapMod.unwrap5.setWindowYOffset (78+10)
		)
	)
	on dash_custombitmapsize changed state do
	(	
		unwrapMod = modpanel.getcurrentobject()
		if state == true do  unwrapMod.setUseBitmapRes false
		if state == false do  unwrapMod.setUseBitmapRes true
	)
	on dash_picwidth changed val do 
	(
		unwrapMod = modpanel.getcurrentobject()	
		unwrapMod.setRenderWidth val
	)
	on dash_picheight changed val do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setRenderHeight val	
	)
	on dash_TileOn changed state do	
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setTileMap state
	)
	on dash_TileAmount changed val do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setTileMapLimit val
	)
	on dash_brightness changed val do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setTileMapbrightness val
	)
	on dash_constantUpdate changed state do	
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setConstantUpdate state
	)
/*
	on dash_highlightVerts changed state do	
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setShowSelectedVertices state
	)
*/
	on dash_showHiddenEdges changed state do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setDisplayHiddenEdges state
	)
	on dash_MidPixelSnap changed state do 
	(
		unwrapMod = modpanel.getcurrentobject()	
		unwrapMod.setMidPixelSnap state
	)
	on dash_weldThresh changed val do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.setWeldThreshold val
	)
	
	on unwrapUIdialog  lbuttonup p do 
	(
		unwrapMod = modpanel.getcurrentobject()
		unwrapMod.Edit()
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBMhvJU8J0iKw0fEG+NZ12zOxYTuEO2XxU4
-- NwgIRTruL15Ezkf6xPSJUYmWwPtAGQn1oP8i4kDT8SslQoSQbm2bkx0bRhXSm9hm
-- uEZ0ZCF6fqsCKpEqk+2IbG2sL65B7kJ8nur4pdzJSkjcvWFDHAQLPZe+hNSKJGOQ
-- jH9J+uPJT7/igpQnXGGCZ/5sJ3/jDs5E3kuIPTPVswQU+rx1JKFNEuQULZnIRkNE
-- g04Q/CHD51yCWhgxKWz80FKgEX4PgR+NW7uIP8IV8QrB01mgr8oirvUhIWttZ5xa
-- GXtyiCAEOJqYVTm7XsaZqwY7BoFmHMlSe6hdryMxVvfz65jjDbN2
-- -----END-SIGNATURE-----