-- Medit Functions Script
-- meditUtilities Structure
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Feb  2005 -  split the functions from the MeditUtilities into this script to make them re-usable
June 2006 -  added functions for the mrArchMtl templates 

NOTE TO LOCALIZATION

Nothing should be localized in this script

*/

struct meditUtilities (


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultsFile =
(
	defaultsFolder = getDir #defaults
	defaultsFile = defaultsFolder + #'\\CurrentDefaults.INI' as string
	if (getFiles defaultsFile).count == 0 do
		defaultsFile = defaultsFolder + #'\\FactoryDefaults\\CurrentDefaults.INI' as string
	if (getFiles defaultsFile).count == 0 then 
		undefined 
	else 
		defaultsFile
),
-- end getDefaultsFile
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultLibraryFile =
(
	defaultsFolder = getDir #defaults
	defaultLibFile = defaultsFolder + #'\\medit.mat' as string
	if (getFiles defaultLibFile).count == 0 do
		defaultLibFile = defaultsFolder + #'\\FactoryDefaults\\medit.mat' as string
	if (getFiles defaultLibFile).count == 0 then 
		undefined 
	else 
		defaultLibFile
),
-- end getDefaultLibraryFile
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultMaterial defaultsFileStr =
(
-- this is obsolete: still maybe used.
-- return material created from the class of the first element in the default library
-- parameter is not uded.
	defaultMtl = StandardMaterial

	defaultMtlLibFile = meditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile
		if defaultMtlLib.count >= 1 do
			defaultMtl = (classof defaultMtlLib[1])()
	)

	defaultMtl
),
-- end getDefaultMaterial
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn isMaterialInUse mtl =
(
	local foundSceneRef = false
	if superClassof mtl == material or superClassof mtl == textureMap do
	(
		local deps = refs.dependents mtl
		for i in deps while not foundSceneRef do
		(
			local c = classof i
			local sc = superclassof i
			local sid = i.superclassid
			-- exclude scene root, scene mtl lib, medit, materials, texturemaps, and texture map containers (used by std mtl to hold texmaps)
			foundSceneRef = c != Scene and c != MtlBaseLib and c != Material_Editor and sc != Material and sc != TextureMap and sid != 4224
		)
	)
	foundSceneRef 	
),
-- end isMaterialInUse
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib
-- Get a Material Name and loads each properties into the global mrArchTemplate_ActiveMaterial
-- Used by the mrArchMaterial templates drop down
-- material name defined in the /plugcfg/mrArchMaterial.ini file


fn Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib mrArchTemplate_ActiveMaterial strMtlName =
(
	local matFromLib	
	matFromLib = (loadTempMaterialLibrary ((getdir #maxroot) + "\\materiallibraries\\mrArch_DesignTemplates.mat"))[strMtlName]

	undo on
	(
		for i in getPropNames(matFromLib) do
		(
			local j = (getProperty matFromLib i)
			try (
				SetProperty mrArchTemplate_ActiveMaterial i j
			)
			catch (
				-- Do nothing, normal for a read-only property
			)
		)
	)
	
),
--end Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib
-- Get a Material Name and loads each properties into the passed material
-- Used by the Physical Material templates drop down
-- material name defined in the /plugcfg/PhysicalMaterial.ini file

fn Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib mtl strMtlName =
(
	local matFromLib	
	matFromLib = (loadTempMaterialLibrary ((getdir #maxroot) + "\\materiallibraries\\PhysicalMaterialTemplates.mat"))[strMtlName]

	undo on
	(
		for i in getPropNames(matFromLib) do
		(
			local j = (getProperty matFromLib i)
			try (
				SetProperty mtl i j
			)
			catch (
				-- Do nothing, normal for a read-only property
			)
		)
	)
	
)--end Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||




) -- end struct

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCMOv+3ELTxemo1siLXFp1tFsmXgrOjhyHG
-- 4CB3f4+i6bqBvZJGgut/c9ktNOcRKfN6xxozyr4lO9ahMtGu0Mhptk2ZY0toFST1
-- yUor73LtUzXawwvWlrbs2neXcsPijMWqq7dVvTX8f4yT+d33JlUN0habA6JYYkbk
-- JLMiyoyJqmxTdU7rTS4PGSJ25aXOkHUs48GqVVQPZtyIMyaiQkEDSZrrifBFfopm
-- 1X93L3gET1z4e14cH4KiGF6kfY+BzY7im05Q+5dmNIPO6uanQpAs027siyv/UrAs
-- 0Ur3VwnVCXjRngBemLv1iM3Uz0MQgouPbnBckp3nQ7HCdozYfLgM
-- -----END-SIGNATURE-----