/*
/////////////////////////////////////////////////////////////////////////
Scripted Manipulator 

Created: April 7 2002 - Pierre-Felix Breton
Version: 0.1 (scripted plugin)

Purpose:

This manipulator is intended to provide quick and fast roll angle access features for targeted lights
that are within luminaires or not.

Abstract:

a)A gizmo is drawn between a light object and it's target.

b)The Gizmo is made of one circle and 2 lines displaying the local
  x and y axis of the light.

c)As the mouse is clicked and dragged on the circle, we allow free rotation of the light (roll angle)

d)if the user click on an axis line or a dot, the light flip by +/- 90 degrees.
  This is for fast flipping.
  
e) The Gizmo calculates its size based on the viewport zoom factor (resizes itself only when redrawn)
 
 
Revision history:

August 22 2002: Initial implementation.

June 16 2003: Fixed script failure when a user cancles the light creation


/////////////////////////////////////////////////////////////////////////
*/

plugin simpleManipulator Light_RollAngle_Manipulator
name:~LIGHT_ROLL_ANGLE_MANIPULATOR_CAPTION~
invisible:true

(--plugin begin
	-- Create the green and red colors for the gizmo 

	--******************************************************************************************
	--Variable definitions
	--******************************************************************************************

	-- gizmo shape related
	local clrGizmoBaseClr = [0.8,0.8,0]
	local clrGizmoActiveClr = [1,1,0]
	local clrGizmoRed = [1,0,0]
	local clrGizmoGreen = [0,1,0]
	local clrGizmoBlue = [0,0,1]
	local fltNonScalingObjectsSize = gw.NonScalingObjectSize() --counter weight the zoom factor of the screen, user preference
	
	
	--rotation related
	local MouseDownRollAngle = 0
	local MouseDownIntersectionPoint = [0,0,0]
	local MouseDownVportCoords = [0,0]
	local nodeRoll = 0
	
	 
	--******************************************************************************************
	--Functions
	--******************************************************************************************
	
	-- Sends a roll angle in degrees and rescales it back to
	--be within a 0-360 range
	fn NormalizeRollAngle angle =
	(
		angle = mod angle 360

	)
	
	
	--******************************************************************************************
	--Events
	--******************************************************************************************

	-- Filter
	
	on canManipulateNode n do((Superclassof n == Light) and (n.target != undefined) and (hasProperty n.controller #roll_angle))	
	
	-- Create the manipulator gizmo. 
	-- This is called initially and whenever the manipulator target changes 
	on updateGizmos do 
	( 
	
		local giz
		local gizpos = [0,0,0]
		local TM = (matrix3 [25,0,0] [0,25,0] [0,0,1] [0,0,0])
		local fltDistanceFromTarget = 0 --distance between target and gizmo
		local wrldGizDiam = 10 --gizmo diameter variable
		local lblToolTip = ""
		
		-- Clear the current gizmo cache 
		this.clearGizmos() 
		
		if node.target != undefined do --pfb; 16 juin 2003: fixes cases wher a light can be set to targeted/non-targeted
		(		
			-- defines gizmo distance to position it on the line between the light and the target
			--due to Maxscript inconsistencies, the target_distance property is not always valid
			if node.targetdistance == undefined 
				then fltDistanceFromTarget = node.target_distance
				else fltDistanceFromTarget = distance node node.target --pfb;June 16 2003
	
			gizpos = [0,0,-fltDistanceFromTarget/2] --positions the gizmo between the target and the node (-z coord)
			wrldGizDiam = (getscreenscalefactor gizpos) * fltNonScalingObjectsSize /10  --defines the gizmo diameter based on the screen scale factor.
			
			--///////////////////////////////////////
			--Gizmo 0 : circle
			--///////////////////////////////////////
			giz = manip.makeCircle [0,0,gizpos.z] (wrldGizDiam/1.25) 18
			this.addGizmoShape giz gizmoActiveViewportOnly clrGizmoBlue clrGizmoActiveClr	
	
	
			--///////////////////////////////////////
			--Gizmo 1 : green axis (y)
			--///////////////////////////////////////
			-- defines the flipping dots and axis lines
			giz = manip.makeGizmoShape()
			giz.addpoint [0,0,gizpos.z]
			giz.addpoint [0,wrldGizDiam,gizpos.z]
			this.addGizmoShape giz gizmoActiveViewportOnly clrGizmoGreen clrGizmoActiveClr	
			
			--///////////////////////////////////////
			--Gizmo 2: red axis (x)
			--///////////////////////////////////////
			giz = manip.makeGizmoShape()
			giz.addpoint [0,0,gizpos.z]
			giz.addpoint [wrldGizDiam,0,gizpos.z]
		    this.addGizmoShape giz gizmoActiveViewportOnly clrGizmoRed clrGizmoActiveClr	
			
			--///////////////////////////////////////
			--Gizmo 3
			--///////////////////////////////////////
			this.addGizmoMarker #diamond [0,wrldGizDiam,gizpos.z] gizmoActiveViewportOnly clrGizmoGreen clrGizmoActiveClr
			--///////////////////////////////////////
			--Gizmo 4
			--///////////////////////////////////////
			this.addGizmoMarker #diamond [wrldGizDiam,0,gizpos.z] gizmoActiveViewportOnly clrGizmoRed clrGizmoActiveClr
	
			--///////////////////////////////////////
			--Gizmo 5
			--///////////////////////////////////////
			--adds a small circle in the insertion point of the gizmo
			this.addGizmoMarker #smallcircle gizpos gizmoActiveViewportOnly clrGizmoBlue clrGizmoActiveClr
			
			-- return the ToolTip string
			lblToolTip = (~LBLTOOLTIP_ROLL_ANGLE_CAPTION~ + (node.controller.roll_angle as string)) --end update gizmos
			
		)--end if node.target != undefined 
		
	)--end updateGizmos

	--Mouse down event
	--Stores the current rotation and projected point to calculate the rotation
	-- during dragging (mouse move)
	on mouseDown m wich do
	(
		MouseDownVportCoords = (m) 
		MouseDownRollAngle = NormalizeRollAngle (node.controller.roll_angle) -- cache the current roll angle of the light	
		node.controller.roll_angle  = MouseDownRollAngle 
		
		-- the circle and arrows
		if wich == 0 then
		(
		)
		
		-- the Y+ line
		else if wich == 1 then
		(
			node.controller.roll_angle += 90
		)
		
		--the x+ line
		else if wich == 2 then
		(
			node.controller.roll_angle -= 90
		)
		
		-- the Y+ dot
		else if wich == 3 then
		(
			node.controller.roll_angle += 90
		)
		
		--the x+ dot
		else if wich == 4 then
		(
			node.controller.roll_angle -= 90
		)
		
		--the small circle
		else if wich == 5 then
		(
			
		)
	
	)--end mouse down


	-- Mouse move event
	on mouseMove m which do 
	(  
		--ony if the circle and arrows are dragged
		--rotates the light through it's roll angle
		if (which == 0 or which == 5) do
		(
			--calculates the mouse movement in Y screen coords 
			local DeltaRoll = (MouseDownVportCoords.y - m.y) 
				
			--updates the node roll angle
			node.controller.roll_angle = (DeltaRoll + MouseDownRollAngle)
		)
	) --end on mouse move


	-- Mouse Up event
	on mouseUp m wich do
	(
		node.controller.roll_angle =  NormalizeRollAngle (node.controller.roll_angle)
	)--end mouse up

	
) --end plugin
-------------------------------------------------------------------- 


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB8SVNAZfoqIE8fbUDKE7myj8gKIoNqlyyJ
-- KnkBjBmBQbX4F5z0PPHS3bCmpA3dyxR+R2BXj+8h1vfi0IeR5K3flBNduxDA5/Hx
-- sKjXg8MufPlpIhCKwPR/j7timOkHyg6YtD7uXS+px7v1ZQGyFw7gKeO/JTqLd7dd
-- S5ZcAOIlA8BqFOVmAgeBHO9+2BE3Ke86RLWvAcDp8QPKYvKyYNDw2bU9sfWoK8zr
-- xiA7Lxt0DoBStOdBwdzhQ3XPBLhYq1BTNZfbItirn2ip/cfA1/mlTsqT/Jj+F2c1
-- s4NnMjD9v9tNsrKxnXmBJaRyri5BObqF7u9EK+g+5bUaQytnBL3P
-- -----END-SIGNATURE-----