-- LightCreationTool Script
-- Created:       Jan 18 2005
-- Last Modified: Mar 18 2005
-- Version: VIZ 2006
-- Author: Alexander Esppeschit Bicalho, Discreet
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/*

This file is intended to use with the creation tools available in the tool palette.

Usage is inside a macroscript. The macro will have to create a light and hand it to the tool for positioning.

Example Macros:

macroScript Free_40W_Bulb_ZBased
            category:~FREE_40W_BULB_ZBASED_LIGHTS_CAMERA_CAPTION~
            internalcategory:"Lights and Cameras"
			ButtonText:~40W_BULB_ZBASED_BUTTON_CAPTION~
            tooltip:~40W_BULB_ZBASED_TOOLTIP~ 
            icon:#("PhotometricLights",3)
            --palettehint: Incandescent --used for publishing to palettes
(
	-- sets properties of newly created linear lights based on the newNodeCallback callback
	 fn setprops n =
	 (
	 	if isKindof n Light do -- pfb march 4 2003: make sure it only happens on lights.  the callback can also pass the target if the user click "targeted" while creating the light
		(
		 	n.useKelvin = off --forces to use the color dropdown
		 	n.rgb = color 255 244.214 214.62  --sets the 'incandescent' color
			n.distribution = 0 -- sets to a isotropic distribution
			n.intensityType = 1 --sets to be in cd
			n.Intensity = 38
			n.useMultiplier = on
		)

	 )
     on execute do 
	 (
	 	LightHeight = 20
		SetCommandPanelTaskMode #create
		LightCreationTool.isCreatingLight = #Free_40W_Bulb_ZBased
		LightCreationZHeight free_point LightHeight setProps lightName:#Free_40W_Bulb
	 )
     on isChecked return LightCreationTool.isCreatingLight == #Free_40W_Bulb_ZBased
)

macroScript Target_40W_Bulb
            category:~CATEGORY_LIGHTS_CAMERAS_CAPTION~
            internalcategory:"Lights and Cameras"
			ButtonText:~BUTTON_40W_BULB_TARGETED_CAPTION~
            tooltip:~40W_BULB_TARGETED_TOOLTIP~ 
            icon:#("PhotometricLights",3)
            --palettehint: Incandescent --used for publishing to palettes
(
	-- sets properties of newly created linear lights based on the newNodeCallback callback
	 fn setprops n =
	 (
	 	if isKindof n Light do -- pfb march 4 2003: make sure it only happens on lights.  the callback can also pass the target if the user click "targeted" while creating the light
		(
		 	n.useKelvin = off --forces to use the color dropdown
		 	n.rgb = color 255 244.214 214.62  --sets the 'incandescent' color
			n.distribution = 0 -- sets to a isotropic distribution
			n.intensityType = 1 --sets to be in cd
			n.Intensity = 38
			n.useMultiplier = on
		)

	 )
     on execute do 
	 (
	 	LightHeight = 20
		SetCommandPanelTaskMode #create
		LightCreationTool.isCreatingLight = #Target_40W_Bulb
		LightCreationZHeight target_point LightHeight setProps isTargeted:true LightName:#Target_40W_Bulb
	 )
     on isChecked return LightCreationTool.isCreatingLight == #Target_40W_Bulb
)

*/



struct lightCreationToolStr (lightObj, 
							lightHeight, 
							lightClass,
							lightPropfn,
							isTargeted = false,
							isCreatingLight = false)

global LightCreationTool = lightCreationToolStr()

fn LightCreationZHeight lightClass lightHeight lightPropfn isTargeted:false LightName:undefined =
(

-- Setup parameters in the Struct
-- The Tool cannot take local parameters, it needs to grab them from the struct

	lightCreationTool.lightClass = lightClass
	lightCreationTool.lightPropfn = lightPropfn
	lightCreationTool.isTargeted = isTargeted
	LightCreationTool.lightHeight = if lightHeight == undefined then 0 else lightHeight

	tool LiftedLightTool
	(
		on mousePoint clickNo do 
		(
			if clickNo == 1 do -- 1st Click position the light
			(
				local pt = gridPoint
				if lightCreationTool.isTargeted == false then -- Free light
				(
					if snapmode.active == true and snapMode.type == #3D then -- Snap ON
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass pos:pt
					else -- Snap Off, lift Z
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass pos:[pt.x, pt.y, lightCreationTool.Lightheight]
				)
				else -- Target Light
				(
					if snapmode.active == true and snapMode.type == #3D then -- Snap ON
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass pos:pt \
							target:(targetObject())
					else -- Snap off, lift Z
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass \
							pos:[pt.x, pt.y, lightCreationTool.Lightheight] target:(targetObject())
				)
				if classof lightCreationTool.lightPropfn == MAXScriptFunction do  -- Apply Properties
					lightCreationTool.lightPropfn lightCreationTool.lightObj
				if isValidNode lightCreationTool.lightObj do
					select lightCreationTool.lightObj
			)
			if clickNo == 2 then -- Release mouse = stop
			(
				#stop
			)
		)--end mousepoint

		on MouseMove clickNo do 
		(
			if (clickNo == 2) do -- Dragging the mouse moves the light (when free) or target (when targeted)
			(
				if isValidNode lightCreationTool.lightObj then
				(
					local st = gridPoint
					if lightCreationTool.isTargeted == false then -- Free Light
					(
						if snapmode.active == true and snapMode.type == #3D then -- Snap On
							in coordsys grid lightCreationTool.lightObj.pos = st
						else -- Snap Off (keep Z up)
							in coordsys grid lightCreationTool.lightObj.pos = [st.x, st.y, lightCreationTool.Lightheight]
					)
					else -- Target Light
					( -- No Snap considerations - it doesn't matter for the target
						in coordsys grid lightCreationTool.lightObj.target.pos = st
					)
				)
				else #abort
			)
		)--end mouse move
	)-- end tool

	-- Start the creation
	local status
	
	if lightClass != undefined and lightClass.creatable do -- if it cannot be created or doesn't exist, bail out
	(
	  local undoName = if lightName == undefined then lightClass.localizedName else lightName as string
	  undo label:undoName on
	  (
		status = starttool LiftedLightTool
		
		-- If it user aborted, delete the light
		if status == #abort then 
			if isValidNode lightCreationTool.lightObj do delete lightCreationTool.lightObj
		else -- ok, user created it, so let's apply the final touch - modify panel, naming, etc
		(
			if isValidNode lightCreationTool.lightObj do
			(
				if lightName != undefined do -- Name the Light based on the name passed to the function
				(
					lightCreationTool.lightObj.name = uniqueName (lightName as string)
					if isTargeted == true do -- if Target Light, name the target too
						lightCreationTool.lightObj.target.name = lightCreationTool.lightObj.name + "." + \
							Targetobject.localizedName
				)
				-- Set Command Panel and select the object
				SetCommandPanelTaskMode #modify
			)
		)
	  ) -- end Undo
	)
	
	--resets the variables and updates the UI
	lightCreationTool.lightObj = undefined
	lightCreationTool.isCreatingLight = false
	updateToolbarButtons()
	
) -- end zHeightLightTool

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBdMnC3peRf/RQxkUZmdhgYMjKQ5PyEiCKF
-- 3UwFqInmUxAtklFziViWo2oM2UF5zH4ml9Z45KQ4YoPHhBOQkgtnOvJv+k965nxZ
-- a0b94RlJSYVO3RJ4BHwwXrz23KYDzbcuZTwHNQkMmJIbgfKgmA4kwJQxL+IG2YP8
-- rX8mk3hWdkojP6uaO43dot3Bf4DtMN79C5FM7NC81GeKx3WIU6oXZDT+ThvdbgG0
-- WR/sRyVPgLbxAY4iz8DK6aaENZqehdByRBBLOJcKMB00czBU6whwCk1QOytQTXUy
-- M4De9+ZF5Z5S3p81tjAY2DvMQNCkGhehWpQtmGTiI9DKePrdUBMD
-- -----END-SIGNATURE-----