/*

-- Edit Functions Script File
--
-- Created:  		May 17 2000
--
-- Version:  3D Studio Max Version 6.0
--
-- 

Revision History

	Mai 26th 2003, pfb
               added in 3ds MAX 6
        Jan 30th 2003, pfb
		added product id check for VIZR:  hardcoded to meters
		
	Sept 4th 2001, pfb
	Added InchesToSystemScale function

	main usage: 
		allowing creation of objects based on the current system units, in order to always be in 'normal world' scale
		for example, a fluorescent panel is usually 4ft long, no matter if the system units are in cm, miles or inches.
*/

 
-- Filter and Operation Functions for conext sensitve menus.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 


fn ApplyOperation ctype oper =
(
	If (Modpanel.getcurrentObject () == $.baseobject) then oper $
	If Classof (Modpanel.getcurrentObject ()) == ctype then (oper $.modifiers[modPanel.getModifierIndex $ (Modpanel.getcurrentObject ())])	
)

-------------------------------------------------------------------------------------
-- Sept 4th 2001, pfb
-- Added Functions for VIZ R4
-------------------------------------------------------------------------------------


-- pass an inch value and returns corresponding value based on the system units
-- it is called by the 'Preset Lights' macros in the Macro_ObjectsLights.mcr file and by the mentalray scripted lights

fn InchesToSystemScale val=
(		
	case units.systemtype of
	(
		#inches:val = val
		#feet:val = 0.08333333333333333 * val
		#miles:val = 0.000015782828282828283 * val
		
		#millimeters:val = 25.4 * val
		#centimeters:val = 2.54 * val
		#meters:val = 0.0254 * val
		#kilometers:val = 0.000025399999999999997 * val
	)

	val
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBjNlQEnari2JvRqHfN+vbSrCnHXzgEXNGy
-- fft5NkVUmadg/2Bn0Vdyqt4VP6xjWgYUBGmAnnn6RmUkp25SbvXSGHGtI7qjkFNb
-- +B5eSLRWXtbynkw2pFe4T0pdezgiZs3DTdYnFzSawM3gb/pK6hfLKbMu0fnIZdJT
-- EolvZUTBiKfNpAbqbvpfsBjULQFpBMau9Tyc4WHm7HDdgbjwHESImNMZk9mEZbfJ
-- jFlZqYmS3M5obflqo3agwVBZKRD91DpZD52d4i6Lm28mtcWs1AYwTUtPtP2s2cBb
-- ea2WPAKfJGaFyAqrPshHmXJlApFXW7bBH70ceVbQyEOb4lR9NC8C
-- -----END-SIGNATURE-----