﻿/*
Functions for loading a UI Scheme, saving, loading quads colors etc...

Theses functions are accessed by the Load Custom UI scheme script and the CUI/Defaults switcher.


Revision history:

Oct 25 2001: Fred Ruff, Frank Delise
	max 4.5 implementation

August 13 2003: Pierre-Felix Breton
	max 6 implementation:  
		
		pulled out of the Macro_IUScheme.mcr to allow the same function being accessed by more than one macro
		consolidated the quadsxolors functions into the same file
		
		added localization comments

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
*/


/*
---------------------------------------------------------------------------------------
SaveQuadClr
 
It's main function is to store the Quad colors from the "Advanced Options" in the 
"Customize User Interface" dialog box.  It's secondary usage is for the Custom UI Schemes.  

That script uses this function to save out the current quad colors into the scripts 
startup directory so they will load when MAX starts.  

It also saves the quad colors 
into a .qop file to be loaded with each custom scheme.
-----------------------------------------------------------------------------------------
*/


function SaveQuadClr ColorFilePath ColorFileName Extention Remarks =
(
	try (
		local OpenColorFile = CreateFile (ColorFilePath + "\\" + ColorFileName + Extention) 

		local QMS = QuadMenuSettings
		format "-- Quad Color File\n" to:OpenColorFile --LOC_NOTES: do not localize this
		format "-- Created automatically by % \n" Remarks to:OpenColorFile --LOC_NOTES: do not localize this
		format "-- To restore Quad Menu to these settings, simply run this script.\n" to:OpenColorFile --LOC_NOTES: do not localize this

		for Quadnum = 1 to 4 do
		(
			format "\n-- Quad number % colors \n" QuadNum to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetTitleBarBackgroundColor % %\n" QuadNum (QMS.GetTitleBarBackgroundColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetTitleBarTextColor % %\n" QuadNum (QMS.GetTitleBarTextColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this				
			format "QuadMenuSettings.SetItemBackgroundColor % %\n" QuadNum (QMS.GetItemBackgroundColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetItemTextColor % %\n" QuadNum (QMS.GetItemTextColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetLastExecutedItemTextColor % %\n" QuadNum (QMS.GetLastExecutedItemTextColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this					
			format "QuadMenuSettings.SetHighlightedItemBackgroundColor % %\n" QuadNum (QMS.GetHighlightedItemBackgroundColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetHighlightedItemTextColor % %\n" QuadNum (QMS.GetHighlightedItemTextColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetBorderColor % %\n" QuadNum (QMS.GetBorderColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this
			format "QuadMenuSettings.SetDisabledShadowColor % %\n" QuadNum (QMS.GetDisabledShadowColor QuadNum) to:OpenColorFile	 --LOC_NOTES: do not localize this	
			format "QuadMenuSettings.SetDisabledHighlightColor % %\n" QuadNum (QMS.GetDisabledHighlightColor QuadNum) to:OpenColorFile --LOC_NOTES: do not localize this		
		)--end for Quadnum = 1 to 4 do
		
		format "\n-- Interaction Settings\n" to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetUseLastExecutedItem %\n" (QMS.GetUseLastExecutedItem()) to:OpenColorFile --LOC_NOTES: do not localize this
	
		format "\n-- Animation Settings\n" to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetDisplayMethod %\n" (QMS.GetDisplayMethod()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetAnimatedStepTime %\n" (QMS.GetAnimatedStepTime()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetAnimatedSteps %\n" (QMS.GetAnimatedSteps()) to:OpenColorFile --LOC_NOTES: do not localize this
	
		format "\n-- Display Settings\n" to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetSubMenuPauseTime %\n" (QMS.GetSubMenuPauseTime()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetOpacity %\n" (QMS.GetOpacity()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetRemoveRedundantSeparators %\n" (QMS.GetRemoveRedundantSeparators()) to:OpenColorFile --LOC_NOTES: do not localize this
	
		format "\n-- PositionSettings\n" to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetInitialCursorLocInBox_0to1 % %\n" (QMS.GetInitialCursorLocXInBox_0to1()) (QMS.GetInitialCursorLocYInBox_0to1()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetFirstQuadDisplayed %\n" (QMS.GetFirstQuadDisplayed()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetMirrorQuad %\n" (QMS.GetMirrorQuad()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetRepositionWhenClipped %\n" (QMS.GetRepositionWhenClipped()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetMoveCursorOnReposition %\n" (QMS.GetMoveCursorOnReposition()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetReturnCursorAfterReposition %\n" (QMS.GetReturnCursorAfterReposition()) to:OpenColorFile --LOC_NOTES: do not localize this
		
		format "\n-- Size Settings\n" to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetBorderSize %\n" (QMS.GetBorderSize()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetUseUniformQuadWidth %\n" (QMS.GetUseUniformQuadWidth()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetUseUniformItemHeight %\n" (QMS.GetUseUniformItemHeight()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetHorizontalMarginInPoints %\n" (QMS.GetHorizontalMarginInPoints()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetVerticalMarginInPoints %\n" (QMS.GetVerticalMarginInPoints()) to:OpenColorFile --LOC_NOTES: do not localize this
	
		format "\n-- Font Settings\n" to:OpenColorFile
		format "QuadMenuSettings.SetItemFontFace \"%\"\n" (QMS.GetItemFontFace()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetItemFontSize %\n" (QMS.GetItemFontSize()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetTitleFontFace \"%\"\n" (QMS.GetTitleFontFace()) to:OpenColorFile --LOC_NOTES: do not localize this
		format "QuadMenuSettings.SetTitleFontSize %\n" (QMS.GetTitleFontSize()) to:OpenColorFile --LOC_NOTES: do not localize this
		
		close OpenColorFile
		)--end try
		Catch
		(
			local str = ~ERROR_SAVING~ + ColorFilePath + "\\" + ColorFileName + Extention + ~ERROR_SAVING_ADV_QUAD_OPTIONS_NOT_SAVED~ --LOC_NOTES: localize this
			messagebox str title:~MSGBOX_STR_TITLE~ --LOC_NOTES: localize this
		)--end catch
)--function SaveQuadClr ColorFilePath ColorFileName Extention Remarks


/*
--------------------------------------------------------------------------------------------------------
Function to load a set of CUI files

It's main function is to load the set of CUI files contained in *.cuix, *.qop, *.clrx, *.kbdx and *.mnux
Is accessed by the Load Custom UI scheme macro and CUI/DefaultUI switcher macro
------------------------------------------------------------------------------------------------------
*/


function loadCUIScheme UIScheme_Filename = 
(

	local UIScheme_Icon_Folder, UIScheme_Icon_Type, UIScheme_Icon_Display, UIScheme_Filename, UIScheme_Icon_Setup, LoadSchemename, UIScheme_Root, UIScheme_Directories	
	local UIScheme_LoadDialog, UIScheme_IconDialog
	
	global UIScheme_Bitmap_Init
	
	If UIScheme_Filename != undefined do
	(

		-------------------------------------------------------------------------------------------------------
		-- Post a note and do nothing if the user has browsed to a new location for the .ui file.
		-- Only UI files from the getdir #ui folder may be loaded.  (current max limitation)
		-------------------------------------------------------------------------------------------------------
		
		local UIScheme_path = GetFileNamepath UIScheme_Filename

		--		local UIDir = getdir #ui
		--   	DC - May 10, 2006 - removing restriction that UI scheme can only be loaded from 
		--							root install directory
		--		if ((stricmp (GetFileNamepath UIScheme_Filename) UIDir ) != 0) do -- root path of target file does not match UI folder
		--		(
		--				msgtext = ~MSGTEXT_NOTE_CUSTOM_UI_LOADED_FROM_DEFAULT_UI_FOLDER~ + UIDir + ")\n\n" --LOC_NOTES: localize this
        --				msgtext += ~MSGTEXT_PLEASE_COPY~ + (getfilenamefile UIScheme_Filename) + ~MSGTEXT_UI_AND_ASSOCIATED_UI_CUSTOMIZATION_FILES~ + (getdir #ui) + ~MSGTEXT_AND_RETRY~ --LOC_NOTES: localize this
        --				messagebox msgtext title:~MSGBOX_MSGTEXT_ERROR_TITLE~ --LOC_NOTES: localize this
        --				return()
        --		)
	
	
		-------------------------------------------------------------------------------------------------------
		-- Create Loading dialog
		-------------------------------------------------------------------------------------------------------
		Rollout UIScheme_LoadDialog ~UISCHEME_LOADDIALOG_CUSTOM_SCHEME_CAPTION~ Width:200 Height:100 --LOC_NOTES: localize this
		(
			label lbl2 ~LBL2_CAPTION~  offset:[0,30] --LOC_NOTES: localize this
			label lbl3 ~LBL3_PLEASE_WAIT_CAPTION~   --LOC_NOTES: localize this
		)
		
		CreateDialog UIScheme_LoadDialog width:200 height:100
	
		-------------------------------------------------------------------------------------------------------
		-- Load set of CUI files
		-------------------------------------------------------------------------------------------------------
	
			LoadSchemeName = (UIScheme_path + (GetFileNameFile UIScheme_Filename))
	
			-- reads the pull down menus and quads definition file
			if (doesFileExist (LoadSchemeName +".mnux" )) == true do 
			(
				MenuMan.LoadMenuFile (LoadSchemeName +".mnux" )
				--print ((LoadSchemeName +".mnux") + " loaded.")
			)
			
			-- reads the ui color definition file
			if (doesFileExist (LoadSchemeName +".clrx" )) == true do
			(	
				ColorMan.LoadColorFile (LoadSchemeName +".clrx" )
				--print ((LoadSchemeName +".clrx") + " loaded.")
			)
			
			-- reads the keyboard shortcuts definition file
			if (doesFileExist (LoadSchemeName +".kbdx" )) == true do 
			(
				ActionMan.LoadKeyboardFile (LoadSchemeName +".kbdx" )
				--print ((LoadSchemeName +".kbdx") + " loaded.")
			)
			
			-- reads the toolbars definition file
			if (doesFileExist (LoadSchemeName +".cuix" )) == true do 
			(
				cui.loadConfig (LoadSchemeName +".cuix" )
				--print ((LoadSchemeName +".cuix") + " loaded.")				
			)
	
			--reads the quads colors (really, qop files contains MXS code that is evaluated)
			if (doesFileExist (LoadSchemeName +".qop" )) == true do 
			(
				filein (LoadSchemeName +".qop")
			)

			-- reads the brush presets definition file
			if (doesFileExist (LoadSchemeName +".bpr" )) == true do 
			(
				local Bpr = BrushPresetMgr
				if Bpr != undefined do Bpr.LoadPresetFile (LoadSchemeName +".bpr" )
				--print ((LoadSchemeName +".bpr") + " loaded.")				
			)			

	
		-------------------------------------------------------------------------------------------------------
			-- Save Quad colors as startup
		-------------------------------------------------------------------------------------------------------
			local userScriptsFolder = GetDir #userStartupScripts
		
			SaveQuadClr userScriptsFolder "QuadColor_Startup" ".ms" (LoadSchemeName + " Scheme") --LOC_NOTES: do not localize this
			--	Print UIScheme_Filename
		-------------------------------------------------------------------------------------------------------
			-- Save CUI file as startup so your changes are loaded when restarting MAX
		-------------------------------------------------------------------------------------------------------
		
			local cuiFilename = pathconfig.appendPath (GetDir #ui) "MaxStartUI.cuix"  --LOC_NOTES: do not localize this
					
			cui.saveConfigAs cuiFilename 
			
		-------------------------------------------------------------------------------------------------------
			-- If an Icon .ui file exists, Use it when loading Scheme
		-------------------------------------------------------------------------------------------------------
			
			DestroyDialog (UIScheme_LoadDialog)

			
	-- reads the toolbars definition file
	if (doesFileExist (LoadSchemeName +".ui" )) == true do 
	(
			
			-- looks for the bitmap thumbnail to display in the Icons loader dialog
			UIScheme_Icon_Folder = OpenFile (LoadSchemeName + ".ui")
			If UIScheme_Icon_Folder != undefined do 
			(
				UIScheme_Icon_Type = (ReadLine UIScheme_Icon_Folder)
				
				local resolvedIconDirectory = pathconfig.appendPath (getdir #ui_ln) UIScheme_Icon_Type
				if((doesFileExist resolvedIconDirectory) OR colorman.resolveIconFolder UIScheme_Icon_Type &resolvedIconDirectory)
				then
				(
					-- print "folder resolved"
					-- print resolvedIconDirectory
					UIScheme_Bitmap_Init  = pathconfig.appendPath resolvedIconDirectory "AnimatePanel_16i.bmp"
				)
				else 
				(
					resolvedIconDirectory = undefined
					-- print "folder not resolved"
					-- check the install root for the null bitmap
					UIScheme_Root = GetDir #ui_ln
					
					-- TODO: select icons folder based on theme setting
					if (doesFileExist (UIScheme_Root + "Icons" + "\\Null_24i.bmp")) == true do
					(
						UIScheme_Bitmap_Init = pathconfig.AppendPath UIScheme_Root "Icons" 
						UIScheme_Bitmap_Init = pathconfig.AppendPath UIScheme_Bitmap_Init "Null_24i.bmp"
					)--end if
				)--end if
		
			)--end if UIScheme_Icon_Folder != undefined
				
		
		
		
		-------------------------------------------------------------------------------------------------------
			-- Loading Icons Dialog
		-------------------------------------------------------------------------------------------------------		



			Rollout UIScheme_IconDialog ~UISCHEME_ICONDIALOG_CUSTOM_SCHEME_CAPTION~ Width:200 Height:200
			(
				Bitmap UIScheme_Icon_Display "" filename:UIScheme_Bitmap_Init
				label lbl2 ~LBL2_LOADING_ICONS_CAPTION~  offset:[0,5]
				label lbl3 ~LBL3_PLEASE_WAIT2_CAPTION~  
				/*
				On UIScheme_IconDialog Open do
				(
					if (UIScheme_Bitmap_Init != undefined) do UIScheme_Icon_Display.filename = UIScheme_Bitmap_Init		
				)--end On UIScheme_IconDialog Open
				*/				
			)--end rollout
			
			CreateDialog UIScheme_IconDialog width:200 height:100
	
		-------------------------------------------------------------------------------------------------------
				-- Load Icons
		-------------------------------------------------------------------------------------------------------
	
				if(resolvedIconDirectory == undefined) then
				(
					-- print "undefined"
					resolvedIconDirectory = UIScheme_Icon_Type
				)
					
				ColorMan.SetIconFolder resolvedIconDirectory
				Close UIScheme_Icon_Folder
				UIScheme_Bitmap_Init = undefined	
				
				DestroyDialog UIScheme_IconDialog
				forceCompleteRedraw()	
	
	)--end if (doesFileExist (LoadSchemeName +".ui" )) == true
	)--end if UIScheme_Filename != undefined do

)--end function loadCUIScheme UIScheme_Filename


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBWhMcvZvpnjtWgvNNVmrZQQinZWkk7arqi
-- qYP8WJIm0zm645Z/wdR3J1LbtshcIF626NzjCVVrNgGTpQo1Pk5ymJholKNo1Zpr
-- REPxBr8IC7ZEWEgm9nvWJI0Yr+Hm8coDw8eo/C3WuMkwdhAitOFw/74kdLjjOict
-- f/RooWf80qTu44NX6/x6R+y1bpyBBHVLMNqErp7IFz+cisMBwc+mekkJWl8GqtZ+
-- lzFsOsYiTDqpy09mZfex6FQOT2YwI3dRMbqxRL+od2gyJb3ZdPFSU9Oz3lnhP1NY
-- /OT5PyAUUkRnVpC1pcjIvOA5nn7hI660Ry/jab0mfyciak7OQcBj
-- -----END-SIGNATURE-----