-- Custom Attributes MacroScript Struct Definition File
--
-- Created:  		Nov 7 2000
-- Last Updated: 	March 30, 2004 - Larry Minton 
--
-- Author :   Frank DeLise / Installed into stdplugs\stdscrpts by jbw 11.7.00
-- Version:  3D Studio Max Version 7.0
--
-- 
-- Custom Attributes Macroscript Struct Definition file.
--
--    Must reside in stdplugs\stdscripts for Custom Attribute dialogs to work.
--
-- Revision History:
--	March 30, 2004 - Larry Minton,
--		added Array and Alpha to CAT_UIItem
--  August 08, 2014 - Xiaoyue Wu,
--      added CAT_UIItem2 which uses absolute layout
--
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--

----------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Paramblock Definition
----------------------------------------------------------------------------------------------------------------------------------------------------------------

Struct CAT_ParamBlock
(
	Name,	-- the name of the parameter
	Type,	-- the type of the parameter
	UI,		-- the name of the rollout ui item
	Default = "", -- the default value for the parameter
	OrigName -- the original name of the parameter. Used when editting attributes
)

----------------------------------------------------------------------------------------------------------------------------------------------------------------
-- UI Items Definition
----------------------------------------------------------------------------------------------------------------------------------------------------------------
Struct CAT_UIItem
(
	UI, 								-- ui item type
	Name,								-- ui item name
	String,								-- ui item caption
	Type,								-- value type
	Range = "[0,100,0]",				-- spinner, slider
	Default = "1",						-- default value
	Width = "70",						-- ui item width
	Height = "25",						-- ui item height
	Enabled = "True",					-- not used
	Orient = "Horizontal",				-- slider
	Checked = "False",					-- not used
	Color = "(color 0 0 0)",			-- colorswatch default color
	HighLightColor = "(color 0 255 0)",	-- checkbutton
	Align = "Left",						-- alignment
	Items = "#()",						-- typically contains var name pointing at array
	Ticks = "10",						-- slider
	Array = #(),						-- array of strings
	Alpha = "False",					-- colorpicker - true if frgba
	Offset = "[0,0]",					-- UI control offset
	LabelOnTop = "False"				-- Label on top for edittext
)

----------------------------------------------------------------------------------------------------------------------------------------------------------------
-- UI Items Definition: Version 2, use absolute layout
----------------------------------------------------------------------------------------------------------------------------------------------------------------
Struct CAT_UIItem2
(
	UI, 								-- ui item type
	Name,								-- ui item name
	String,								-- ui item caption
	Type,								-- value type
	Align = "Left",						-- alignment, not used here, just for compatiblity
	Offset = "[0,0]",					-- UI control offset, not used here, just for compatiblity
	Range = "[0,100,0]",				-- spinner, slider
	Default = "1",						-- default value
	Width = "70",						-- ui item width
	Height = "25",						-- ui item height
	Enabled = "True",					-- not used
	Orient = "Horizontal",				-- slider
	Checked = "False",					-- not used
	Color = "(color 0 0 0)",			-- colorswatch default color
	HighLightColor = "(color 0 255 0)",	-- checkbutton
	Items = "#()",						-- typically contains var name pointing at array
	Ticks = "10",						-- slider
	Array = #(),						-- array of strings
	Alpha = "False",					-- colorpicker - true if frgba
	Pos = "[0,0]",						-- absolute position of ui item
	LabelOnTop = "False"				-- Label on top for edittext
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA7Usqi9Vu1iG6xwIIGZc74u9JEtu3wsyxT
-- 8AdUEX8JQc5B/SLMr5Uu6mnO73qUujJVbY+fEkpK22pU/RGX8QyA9uSJsA5JUqTA
-- govmt9/Cg3pCH+Z2C0QL8RMclLkQAm0Qz+3TA5vatrGrunqkbCaMxcfsQD3pcBar
-- KrDNdBNTgE3un6lz5lUAYYO/GWljhjF2Amyq0Gi4oqfbj7g6oNJRbTQ6ZOqBMCWd
-- j1mTAMNXxur7eZoMdbwbJMzZMNOhRkSQTb7zzIy5KQr7yW/3FqzZBPu9zLfnkoAg
-- 66zJwd82vi/PmEObtaYr5E9RLYcli7rgnjKve4h84Y4T4jSy03yd
-- -----END-SIGNATURE-----