-- Functions for Controller Access, MacroScript File
--
-- Created:  		May 17 2000
-- Last Updated: 	Jan 20 2006
--
-- Author :   Frank DeLise
-- Version:  3D Studio Max Version 4.0
--
--  Michael Zyracki updated on Jan 20th 2006 to add support for Layer Controllers.
-- Functions for accessing Controllers
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- Removed IsPosXYZ() filters, moved them into FilterFunctions.ms
-- Removed Prompting to the listner window Aug 15, 2000 -FD
-- Updated Target additions for the new constraint function publishing October 6 2000
-- Jan 4 Added support for HI and HD IK
fn IsLayerControl ctrl = 
(
	local result = false
	if classof ctrl == Position_Layer do
		result = true
	if classof ctrl == Rotation_Layer do
		result = true
	if classof ctrl == Point3_Layer do
		result = true
	if classof ctrl == Point4_Layer do
		result = true
	if classof ctrl == Scale_Layer do
		result = true
	if classof ctrl == Float_Layer do
		result = true

	result
)

fn AddListController OBJ Trans ListType = 
(
	Try
	(
		local xformC
		-------------------------------------------------------------------------------------------
		-- If object has IK assigned apply to subController, if it's an IK goal apply to Ik goal  if not, apply to controller
		-------------------------------------------------------------------------------------------
		if classof OBJ.controller == IKControl then  xformC = OBJ.controller.fk_sub_control.controller
			else if classof OBJ.controller == IKChainControl then  xformC = OBJ.controller.IK_goal.controller
				else xformC = OBJ.controller
		
		if classof xformC == IK_ControllerMatrix3Controller do
		(	if (substring (Trans as string) 1 3) as name == #pos then Trans = getsubanimname xformC 1
			else if (substring (Trans as string) 1 3) as name == #rot then Trans = getsubanimname xformC 2
		)

		if classof xformC == Link_Constraint do xformC = xformC.link_params
		if classof xformC == Link_Transform do xformC = xformC.Scene_Transform

		local oldC = getPropertyController xformC trans
		if classof oldC != ListType then
		(	local newC = execute (ListType as string + "()")
			if(IsLayerControl oldC) then
			(
				oldC[oldC.active].controller = newC
			 
			)else
			(
			  if (setPropertyController xformC trans newC) == undefined do throw 0
			)
			newC
		)
		else
			oldC
	)
	Catch (MessageBox ~MSGBOX_LIST_CONTROLLER_ERROR~ Title:~CONTROLLER_FUNCTIONS_TITLE~;throw())
) 

fn AddConstraint OBJ Trans Constraint List =
(
	Try
	(	
		local xformC
		-------------------------------------------------------------------------------------------
		-- If object has IK assigned apply to subController, if not, apply to controller
		-------------------------------------------------------------------------------------------
		if classof OBJ.controller == IKControl then xformC = OBJ.controller.fk_sub_control.controller
			else if classof OBJ.controller == IKChainControl then xformC = OBJ.controller.IK_goal.controller
				else xformC = OBJ.controller
		
		if classof xformC == IK_ControllerMatrix3Controller do
		(	if (substring (Trans as string) 1 3) as name == #pos then Trans = getsubanimname xformC 1
			else if (substring (Trans as string) 1 3) as name == #rot then Trans = getsubanimname xformC 2
		)

		if classof xformC == Link_Constraint do xformC = xformC.link_params
		if classof xformC == Link_Transform do xformC = xformC.Scene_Transform
		
		local newC = execute (constraint as string + "()")
		If List == True then
		(	local oldC = getPropertyController xformC  trans
			if classof oldC != ListType then
			(
				if(IsLayerControl oldC) then
				(
					oldc = oldC[oldC.active].controller 
			 
				)
			)
			oldC.available.controller = newC
		)
		Else 
			if (setPropertyController xformC trans newC) == undefined do throw 0
		newC
	)
	Catch (MessageBox ~MSGBOX_CONSTRAINT_ERROR~ Title:~MSGBOX_CONTROLLER_FUNCTIONS_TITLE~;throw())
)

fn SetActiveController Controller subController =
(
	Try
	(	local index
		for i = 1 to (Controller.numsubs-1) do
			if controller[i].controller == subController do index = i
		if index != undefined do
		(	listCtrl.setActive controller index
			format ~FORMAT_SETTING_AS_ACTIVE_CONTROLLER~ (listCtrl.getName controller index)
		)
	)
	Catch ( MessageBox ~MSGBOX_SET_ACTIVE_CONTROLLER_ERROR~ Title:~MSGBOX_SET_ACTIVE_CONTROLLER_TITLE~)
)


-------------------------------------------------------------------------------------------
-- ShapeFilterFn
-- This function used in PickObject for path validates that the node is a shape
-- and that it's not dependent on the selection
-------------------------------------------------------------------------------------------
fn ShapeFilterFn obj = 
(
	valid = true
	if superClassOf obj != Shape then
		valid = false
	else
	(
		valid = false
		for node in selection while not valid DO
		(
			if (refs.DependencyLoopTest obj node.controller) != true then
			(
				valid = true
			)
		)
	)
	valid
)
		
-------------------------------------------------------------------------------------------
-- SurfaceFilterFn
-- This function used in PickObject for Surface constraint validates that the node is 
-- a surface and is not dependent on the selection
-------------------------------------------------------------------------------------------
fn SurfaceFilterFn obj = 
(
	valid = true
	objClass = ClassOf obj
	if (objClass != NURBSSurf and
	    objClass != Editable_Patch and
	    objClass != Sphere and
	    objClass != Cone and
	    objClass != Cylinder and
	    objClass != Torus and
	    objClass != Loft) then
		valid = false
	else
	(
		valid = false
		for node in selection while not valid DO
		(
			if (refs.DependencyLoopTest obj node.controller) != true then
			(
				valid = true
			)
		)
	)
	valid
)
				
-------------------------------------------------------------------------------------------
-- GeomFilterFn
-- This function used in PickObject for Attachment constraint validates that the node is 
-- a geometry and is not dependent on the selection
-------------------------------------------------------------------------------------------
fn GeomFilterFn obj = 
(
	valid = true
	if superClassOf obj != GeometryClass then
		valid = false
	else
	(
		valid = false
		for node in selection while not valid DO
		(
			if (refs.DependencyLoopTest obj node.controller) != true then
			(
				valid = true
			)
		)
	)
	valid
)
			
-------------------------------------------------------------------------------------------
-- ConstrFilterFn
-- This function used in PickObject for some constraints validates that the node is not
-- dependent on the selection
-------------------------------------------------------------------------------------------
fn ConstrFilterFn obj = 
(
	valid = false
	for node in selection while not valid DO
	(
		if (refs.DependencyLoopTest obj node.controller) != true then
		(
			valid = true
		)
	)
	valid
)
	
			
--------------------------------------------------------------------------------
--  IsValidControllerSelection 

-- function returning true if there is at least one node selected that can be 
-- assigned a controller, i.e. not a biped slave, not an xref controller or 
-- not a Matrix3 controller.  If more than 200 nodes are selected, then
-- in order to accelerate the validation it is assumed that the selection is 
-- valid.
--------------------------------------------------------------------------------
fn IsValidControllerSelection = 
(
	local isValid = false;
	if selection.count > 200 then isValid = true
	else
	(
		for node in selection while not isValid do
		(
			local controllerClass = classof node.controller
			if (controllerClass != BipSlave_Control and \
				controllerClass != XRef_Controller and \
			    (controllerClass != IK_ControllerMatrix3Controller or \
				 node.controller[1].controller != undefined)) then isValid = true
		)
	)
	isValid
)


--------------------------------------------------------------------------------
--  AssignControllerSelection 

-- function assigning a controller to all selected nodes
--------------------------------------------------------------------------------
fn AssignControllerSelection CONTROLLER_TYPE Trans ListType MsgBoxBody = 
(
	Try
	(
		-------------------------------------------------------------------------------------------
		-- Switch to Motion Panel
		-------------------------------------------------------------------------------------------
	
		IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
		
		for node in selection do
		(
			local controllerClass = classof node.controller
			if not (controllerClass == BipSlave_Control or
				    controllerClass == XRef_Controller or
				    (controllerClass == IK_ControllerMatrix3Controller and 
				     node.controller[1].controller == undefined)) then
			(
				-------------------------------------------------------------------------------------------
				-- Skip group members, only apply to head
				-------------------------------------------------------------------------------------------
				local h = node.parent 
				if not (h != undefined and h.isSelected and isGroupHead h) then
				(
					-------------------------------------------------------------------------------------------
					-- Add List Controller
					-------------------------------------------------------------------------------------------
					
					local cont = AddListController node Trans ListType 
					
					-------------------------------------------------------------------------------------------
					-- Add Constraint
					---------------------------------------------------------------------------------------
					If classof cont[listCtrl.GetActive cont].object != CONTROLLER_TYPE then 
					(
						controller = AddConstraint node Trans CONTROLLER_TYPE true
					)
					else 
					(
						controller = cont[listCtrl.GetActive cont].object
					)
			
					-------------------------------------------------------------------------------------------
					-- Set Active Controller
					-------------------------------------------------------------------------------------------
							
					SetActiveController cont controller
					
					-- the script used to select the selected node here, but I don't see why, and 
					-- it would now break the loop on selected nodes
				)
			)
		)
			
	)
	Catch (MessageBox MsgBoxBody Title:~MSGBOX_CONTROLLERS_TITLE~)
)


--------------------------------------------------------------------------------
--  AssignConstraintSelection 

-- function assigning a constraint to all selected nodes
--------------------------------------------------------------------------------
fn AssignConstraintSelection CONSTRAINT_TYPE Trans ListType FiltFn PickMsg MsgBoxBody = 
(
	Try
	(
		-------------------------------------------------------------------------------------------
		-- Switch to Motion Panel
		-------------------------------------------------------------------------------------------
	
		IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
		
		-------------------------------------------------------------------------------------------
				
		EC_TargetOBJ = PickObject count:1 filter:FiltFn message:PickMsg Rubberband:selection[1].transform.pos ForceListenerFocus:False
		if EC_TargetOBJ != undefined and EC_TargetOBJ != "None" then
		(
			for node in selection do
			(
				local controllerClass = classof node.controller
				if not (controllerClass == BipSlave_Control or
						controllerClass == XRef_Controller or
						(controllerClass == IK_ControllerMatrix3Controller and 
						 node.controller[1].controller == undefined)) then
				(
					-------------------------------------------------------------------------------------------
					-- Skip group members, only apply to head
					-------------------------------------------------------------------------------------------
					local h = node.parent 
					if not (h != undefined and h.isSelected and isGroupHead h) then
					(
						if (refs.DependencyLoopTest EC_TargetOBJ node.controller != true) then
						(
							-------------------------------------------------------------------------------------------
							-- Add List Controller
							-------------------------------------------------------------------------------------------
							
							local cont = AddListController node Trans ListType 
							
							-------------------------------------------------------------------------------------------
							-- Add Constraint
							---------------------------------------------------------------------------------------
							If classof cont[listCtrl.GetActive cont].object != CONSTRAINT_TYPE then 
							(
								constraint = AddConstraint node Trans CONSTRAINT_TYPE true
							)
							else 
							(
								constraint = cont[listCtrl.GetActive cont].object
							)
					
							-------------------------------------------------------------------------------------------
							-- Add Constraint Objects
							-------------------------------------------------------------------------------------------
									
							if ((constraint.AppendTarget EC_TargetOBJ 50) == true) then
							(
								-------------------------------------------------------------------------------------------
								-- Set Active Controller
								-------------------------------------------------------------------------------------------
										
								SetActiveController cont constraint
											
								--Format "%\n"  (node.name + " is Constrained to " + EC_TargetOBJ.name) to:Listener
							)
							else throw 0
						)
					)
				)
			)
		)			
	)
	Catch (MessageBox MsgBoxBody Title:~MSGBOX_CONSTRAINTS_TITLE~)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBvNe7VRLmbNCv3YIuedEjZ3OIXklofY7G1
-- IpA0jtzdmhhUy6HFsnI1eE45E7wL9/snW0yg8A0V4526A95eokXCdK9YHhd6MVN3
-- H994O1Iip1zvmjvASVrxPphjdyf60G9/yOdclqsxXMWE4OfhZRWRWbz8AO2h9wH1
-- 6N7mIe5gMq2FyLQuO4b9AtYyohzzb8KSnJ3ZA/LaZfiamk+0i0gvOP4xq/uS96QW
-- OPus389evNeNwJvaA6pxnwGbN65uA0MYuWKFsoHC+iHxppCduP+eBn/t4OB9owdq
-- exPZ/2w8rd/MqjmyvjXdnfsGCRhQhrpnIgegLBwXCs+cUGg2cixP
-- -----END-SIGNATURE-----