-------------------------------------------------------------------------------
--   
--  File:		rc2mxs.ms		
--  Description:	Helper struct for generating Maxscript rollouts/dialogs from rc files
--  By:		Ravi Karra [Discreet] 			ravi.karra@discreet.com
--	
-- Version:		1.01
-- Note:		DO NOT LOCALIZE
-------------------------------------------------------------------------------


struct s_rc2mxs 
(
	fltStr, rW, rH, rc, fac, fc=1.5,
	fn dimStr i =
	(
		" pos:[" + fltStr[i] + fac + "," + fltStr[i+1] + fac + "] width:(" + fltStr[i+2] + fac + ") height:(" + fltStr[i+3] + fac + ") "
	),
 	fn isContinuation str =
	(
		(filterString (subString str 1 19) " ").count == 0
		--str[str.count] == ","
	),
	-- fills up "rc", an instance of rolloutCreator
	fn convertRC filename dlgID rTitle:"" = 
	(
		local ln, lbl_count = 0
		fac = "*" + fc as string
		f = openFile filename mode:"r"
		if f != undefined then
		(
			while not (eof f) do
			(
				ln = readLine f
				if (subString ln 1 3) != "IDD" then continue
				
				-- read the dialog properties
				fltStr = filterString ln " ,"
				if fltStr[1] != dlgID then continue
				rc = rolloutCreator fltStr[1] rTitle quote:""
				rc.begin()
					rW =  fltStr[fltStr.count - 1] as integer
					rH = fltStr[fltStr.count] as integer					
					
					-- skip till after BEGIN
					skipToString f "BEGIN"; readLine f
					local str = ""; ln = readLine f; type	
					while true do
					(
						str = readLine f						
						if isContinuation str then
						(
							ln += str					
						)
						else
						(
							--format "ln:%\n" ln
							fltStr = filterString ln " "
							type = fltStr[1]			
							fltStr = filterString (subString ln (findString ln fltStr[2]) ln.count) ","
							
							case type of
							(
								"LTEXT":
								(
									format "ln:%\n" ln
									lbl_count += 1
									rc.addControl #label ("label" + lbl_count as string) fltStr[1] paramStr:(dimStr 3)
								)
								"EDITTEXT":
								(
									rc.addControl #editText fltStr[1] "" paramStr:(dimStr 2)
								)
								"PUSHBUTTON":
								(
									rc.addControl #button fltStr[2] fltStr[1] paramStr:(dimStr 3)
								)
								"LISTBOX":
								(
									local h = ceil (((fltStr[5] as float)*fc)/(gettextextent "T")[2]) as string
									rc.addControl #listbox fltStr[1] "" paramStr:("height:" + h + dimStr 2)
								)
							)							
							if str == "END" then 
							(
								close f
								rc.end()
								return true
							)
							ln = str							
						)						
					)														
			)
			close f
			false
		)
	)
)

rc2mxs = s_rc2mxs()
--rc2mxs.convertRC "F:/devel/3dswin/src/maxsdk/Samples/SdkApWz/SdkApWz.rc" "IDD_CUSTOM2"
--rc2mxs.convertRC "D:/devel/3dswin/src/app/3dswin.rc" "IDD_ABOUT"
--createDialog rc2mxs.rc.def width:(rc2mxs.rW*rc2mxs.fc) height:(rc2mxs.rH*rc2mxs.fc)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAkw6iX5JszjT5olt3YTevWBLxMx5YKU8oV
-- SNRbIvO2nEdevcmcmVKXltlp3vQeCgNE8x05xbHbj54VshWnCbhegVrToFknOr2t
-- T20dViCdfjxs+ur/uI3YceKwwxeA02NOWw4MDC906mUKU4bYQNuROHSdJkGVvo42
-- JrABMlamGIImAgaI5IoXIng+Rl41IndfzQv7JRPaPUxMu0TdbnwwZBj4I5SgEemG
-- ZIR9Is4oDidpq+6GzLfKJun0N26sx4NWYtGcO/Sh2Y0ImGii0AJiByOxXJE62gID
-- /v00u4uYUg6hBT29l9XXjcjhnKVM7syhkQHFP/La/f6aYzTnw+PK
-- -----END-SIGNATURE-----