/*

Utility Script File
Author: Frank DeLise
Utility Script that converts selected Lights into Area Lights
3DStudio MAX Version 6

Revision history:

August 2003; Pierre-Felix Breton
	bug fixes for Max 6

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
*/

global miAreaLight -- defined in stdplugs\stdscripts\Light-mentalray_AreaSpot.ms
global miAreaLightomni -- defined in stdplugs\stdscripts\Light-mentalray_AreaOmni.ms

Utility conv_area_lights ~CONV_AREA_LIGHTS_CAPTION~ --LOC_Notes: localize this
(
	local Alight, Sel_props, Sel_Objs, tg, Sel_converted
----------------------------------------------------------------------------------------
-- Added Jan 30 2001 2 Functions for saving and recalling volume light info
----------------------------------------------------------------------------------------
	fn GetVolumeInfo CurLight=
	(
		local VolList=#()
		if numAtmospherics != 0 do for j = 1 to numAtmospherics do
			(
			TempAtmos = GetAtmospheric j
			for q = 1 to TempAtmos.numgizmos  do 
				(
				PGizLight = getgizmo TempAtmos q
				if PGizLight == curlight do append VolList j
				)
			
			)
		vollist
	)
	
	fn SetVolumeInfo VolList CurLight =
	(
		for i = 1 to VolList.count do
			(
			TempAtmos = GetAtmospheric VolList[i]
			AppendGizmo TempAtmos CurLight
			)
	)
----------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------
	
	Button Area_Convert ~CONVERT_SELECTED_LIGHTS_CAPTION~ --LOC_Notes: localize this
	
	on Area_Convert pressed do
	(
		local isInvalidLightsInSelection = true
		local sel_Objs = Selection as array
		
		if Sel_Objs.count < 1 then messagebox ~MSGBOX_SELECT_LIGHTS_TO_CONVERT_CAPTION~ title:~MSGBOX_SELECT_LIGHTS_TO_CONVERT_TITLE~ --LOC_Notes: localize this
		
		sel_converted = #()

		for i in 1 to Sel_Objs.count do
		(
----------------------------------------------------------------------------------------		
-- This remembers which volume light if any are on the current light.
----------------------------------------------------------------------------------------
		VLNum = GetVolumeInfo Sel_Objs[i]	
		print vlnum
----------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------
			if (SuperClassof Sel_Objs[i]) == light then
				(
					--checks if the light contained in the selection set is valid or not
					case of
					(
						------------------------------------------------------------------------------------------
						--Omnilights
						(classof Sel_Objs[i] == Omnilight):
							(
								ALight = miarealightomni ()
								Alight.transform = Sel_Objs[i].transform
								ALight.omnilight.raytracedshadows = Sel_Objs[i].raytracedshadows
								if Sel_Objs[i].includelist != undefined do 
									ALight.omnilight.includelist = Sel_Objs[i].includelist
								if Sel_Objs[i].excludelist != undefined do 
									ALight.omnilight.excludelist = Sel_Objs[i].excludelist
								if Sel_Objs[i].projectormap != undefined do 
									ALight.omnilight.projectormap = Sel_Objs[i].projectormap
								if Sel_Objs[i].shadowprojectormap != undefined do 
									ALight.omnilight.shadowprojectormap = Sel_Objs[i].shadowprojectormap
								Sel_Props = getpropnames Sel_Objs[i]
								try for j in Sel_Props do
									if j != #includelist and j != excludelist and j != #projectormap and j != #shadowprojectormap and j != #Indirect_Illumination_Params and j != #value and j != #type do
										setproperty ALight.omnilight j (getproperty Sel_Objs[i] j) catch ()
								append sel_converted Sel_Objs[i]
								
							)--end case omnilight
							
						------------------------------------------------------------------------------------------
						--Spotlights
						(classof Sel_Objs[i] == freespot or classof Sel_Objs[i] == targetspot):
							(
								ALight = miarealight ()
								Alight.transform = Sel_Objs[i].transform
									if classof Sel_Objs[i] == targetspot do
										(
										tg = targetobject name:(Alight.name + ".target") --LOC_Notes: do not localize this
										tg.transform = Sel_Objs[i].target.transform
										Alight.target = tg
										)
								ALight.targetspot.raytracedshadows = Sel_Objs[i].raytracedshadows
								if Sel_Objs[i].includelist != undefined do 
									ALight.targetspot.includelist = Sel_Objs[i].includelist
								if Sel_Objs[i].excludelist != undefined do 
									ALight.targetspot.excludelist = Sel_Objs[i].excludelist
								if Sel_Objs[i].projectormap != undefined do 
									ALight.targetspot.projectormap = Sel_Objs[i].projectormap
								if Sel_Objs[i].shadowprojectormap != undefined do 
									ALight.targetspot.shadowprojectormap = Sel_Objs[i].shadowprojectormap
								Sel_Props = getpropnames Sel_Objs[i]
								try for j in Sel_Props do
									if j != #includelist and j != excludelist and j != #projectormap and j != #shadowprojectormap and j != #Indirect_Illumination_Params and j != #value and j != #type do
										setproperty ALight.targetspot j (getproperty Sel_Objs[i] j) catch ()
								append sel_converted Sel_Objs[i]
							)--end if spotlight
							
						------------------------------------------------------------------------------------------
						--Directlights
						(classof Sel_Objs[i] == Directionallight or classof Sel_Objs[i] == TargetDirectionallight):
							(
								ALight = miarealight ()
								Alight.transform = Sel_Objs[i].transform
								if classof Sel_Objs[i] == TargetDirectionallight do
									(
									tg = targetobject name:(Alight.name + ".target") --LOC_Notes: do not localize this
									tg.transform = Sel_Objs[i].target.transform
									Alight.target = tg
									)
								ALight.targetspot.raytracedshadows = Sel_Objs[i].raytracedshadows
								if Sel_Objs[i].includelist != undefined do 
									ALight.targetspot.includelist = Sel_Objs[i].includelist
								if Sel_Objs[i].excludelist != undefined do 
									ALight.targetspot.excludelist = Sel_Objs[i].excludelist
								if Sel_Objs[i].projectormap != undefined do 
									ALight.targetspot.projectormap = Sel_Objs[i].projectormap
								if Sel_Objs[i].shadowprojectormap != undefined do 
									ALight.targetspot.shadowprojectormap = Sel_Objs[i].shadowprojectormap
								Sel_Props = getpropnames Sel_Objs[i]
								try for j in Sel_Props do
									if j != #includelist and j != excludelist and j != #projectormap and j != #shadowprojectormap and j != #Indirect_Illumination_Params and j != #value and j != #type do
										setproperty ALight.targetspot j (getproperty Sel_Objs[i] j) catch ()
								if Alight.targetspot.coneshape == 1 then
									(
									Alight.Area_Type = 2
									Alight.Disc_Radius = Sel_Objs[i].falloff
									)
								  else
								  	(
									Alight.Area_Type = 1
									Alight.Rectangle_Height = Sel_Objs[i].falloff/Sel_Objs[i].aspect*2
									Alight.Rectangle_Width = Sel_Objs[i].falloff*2
									)
								append sel_converted Sel_Objs[i]
							)--end if directlights
						
						------------------------------------------------------------------------------------------
						--Default
						default: messagebox (~DEFAULT_MSGBOX_SEL_LIGHT_CANNOT_BE_MR_AREA_LIGHT_CAPTION~ + (Sel_Objs[i].name) + ~DEF_MSGBOX_WILL_BE_SKIPPED_CAPTION~) title:~CONVERT_SELECTED_LIGHTS_TITLE~ --LOC_Notes: localize this
					)--end case

				)--end if selected object classof light

			if VLnum != OK do SetVolumeInfo VLnum Alight				
		)
		if sel_converted.count > 0 do
		(
			if querybox ~QUERYBOX_DEL_OLD_LIGHTS_CAPTION~ then --LOC_Notes: localize this
			(

					for i in 1 to sel_converted.count do
						(
		
						undo on (Delete sel_converted[i])
				
						)


			)--end then
			Else
			(

					for i in 1 to sel_converted.count do
						(
		
						undo on ( Try(sel_converted[i].on = false)Catch ())
				
						)


			)--end else
		)--end if sel_converted.count > 0 do
	
	)
	

)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCIEd6+xzt49FWfTVOETufGYnQsDz0SCZet
-- WLPTQ5ElaJiV/x2yfpcopfCmHEqcq369Sbea/GX+S9GcmPBHRgan0DcX9wPSHnmb
-- XYV2lBH3hAO8RzQkMrIlKl2AAcHgkTOvd6tsVlNdxafBXCzJvVx/yYjluLWqVOsI
-- v9f7f68wXwu9y740aCCue/fsDMEbcyZGmP13uiUM5WEFTANxywgOml7TJkO/zanj
-- eBzOYte8JjwYhPVog8/OwMhdwPyw6D7yb1z1iGWrfwG0p76CeZM0MBgMUif6Ao7J
-- 0mwJ3tD2xwSSUNO7wm2sn4vfIL6Nm5WzDWx1p3C8W24kViDm9O1s
-- -----END-SIGNATURE-----