-- Scene Converter
-- Setup invalid ClassIDs for Physical Renderers workflow
-- the Render Upgrade Assistant is a tool to convert scenes to Physical Renderers, 
-- it can upgrade some of the Objects/Materials/Maps or remove them if they are unsupported.

-- Modify this file at your own risk !

SceneConverter.ClearInvalidclassIDs()

--Invalid Cameras
	--SceneConverter.AddInvalidClassID #eCamera #(0x1001, 0) --Free Camera ClassID
	--SceneConverter.AddInvalidClassID #eCamera #(0x1002, 0) --Target Camera ClassID

--Invalid Lights
	--SceneConverter.AddInvalidClassID #eLight #(0x1011, 0) --Omni Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1012, 0) --Target Spot Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1013, 0) --Target Directional Light classID
	--SceneConverter.AddInvalidClassID #eLight #(0x1014, 0) --Free Spot Light ClassID
	--SceneConverter.AddInvalidClassID #eLight #(0x1015, 0) --Free Directional Light ClassID
	--SceneConverter.AddInvalidClassID #eLight #(0x7bf61478, 0x522e4705) --Skylight
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		--If the mental ray dll is not present, add its classes as invalid so we can convert or remove them
		SceneConverter.AddInvalidClassID #eLight #(0x0001b669, 0x000875c2) --mental ray Area Spot Light ClassID
		SceneConverter.AddInvalidClassID #eLight #(0x0001b669, 0x000875c1) --mental ray Area Omni Light ClassID
		SceneConverter.AddInvalidClassID #eLight #(0x335c655c, 0x382151b1) --mental ray SkyPortal Light classID
	)

--Invalid Geometries
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eGeometry #(0x2e013bd5, 0x13c00afb) --mental ray Proxy Object ClassID
		SceneConverter.AddInvalidClassID #eGeometry #(0x711f0aad, 0x1c181b09) --mental ray Geometry Object ClassID
		SceneConverter.AddInvalidClassID #eGeometry #(0x64b11409, 0x1e7a186d) --iray Section Planes Object ClassID
	)
	
--Invalid Materials	
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eMaterial #(0x70b05735, 0x4a163654) --mental ray Arch and Design Material ClassID
	)

--Invalid Maps	
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(	
		SceneConverter.AddInvalidClassID #eMap #(0x7773161f, 0x996c7d15L) --mental ray Gamma and Gain	
		SceneConverter.AddInvalidClassID #eMap #(0x628e269e, 0x72386abf) --mental ray Physical sky environment map
	)
	
--Invalid Exposure Control
	if (false == NVIDIARenderersHelper.IsMentalrayDllPresent() ) do
	(
		SceneConverter.AddInvalidClassID #eOther #(0x73317331, 0x49154663) --mental ray Photographic Exposure Control
	)
	
--Other
	--SceneConverter.AddInvalidClassID #eOther #(0x4a1e6deb, 0x31c77d57) --Daylight Assembly
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAb0pMHWlVcVj9/MetSBRWAZ/kPEm3WyEKd
-- L4YOJINAtBvrA4UKFbDUV8HsmPg3F9aDtRUG2gwD+dhef7ZzSwQnAVcB7YCs9n9t
-- msyE2k5p1qVVQyUIwAgebyclGyt3JayjVKJ5g/PTDiBX/p2gRLuc3kctcfKxYFBn
-- B8xwUF+qVRRUILqbWrXQizqftoXqcXezpGuc2p5wA2kXVFZ7ptqGRPxUN45hL4g5
-- yVCvRwZLojBqN0KU5z+6JAZ0U2RZXBTutPaRUIdJWlP4ow86QPOq8hkOTM6EL0DI
-- R8Xb2gBLaAWYbfhpWnvt3jej6Xj7V5IcgMlMsB6O8HS8qSdKobr+
-- -----END-SIGNATURE-----