-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
--	
--	Projection Mod Helper Functions
--
--	Created: April 21, 2004
--
--	Author :  Michael Russo
--
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------

-- MODIFY THIS AT YOUR OWN RISK
 

--
--	GetPModObjectNames
--
--	For a given Projection Modifier, return an array of the name of the Geometry Selections
--
function GetPModObjectNames pmod =
(
	local ObjList = #()
	
	pmodInterface = pmod.ProjectionModOps
	if pmodInterface == undefined do return ObjList
	
	local iObjCount = pmodInterface.NumObjects()
	ObjList.count = iObjCount 
	
	for i = 1 to iObjCount do 
		ObjList[i]= pmodInterface.GetObjectName i
	
	return ObjList
)

--
--	FindPMod
--
function FindPMod nodeSrc =
(
	local pmod = undefined
	theMods = nodeSrc.modifiers
	
	for theMod in theMods while pmod == undefined do (
		if (Classof theMod) == Projection do pmod = theMod
	)
	
	return pmod
)


--
--	AddPModObjects
--
--	nodeList : Array of nodes to apply Projection Modifiers
--	bCreateNewPMods : set to true to always append a new Projection Modifier, else use the highest in stack
--	bDeletaAll : before adding objList (targets), make sure the object list in projection modifier is empty
--	objList : if defined, these objects will be added to projection modifier, else use selectByName dialog
--
--	Array of PMods corresponding to nodeList is returned.
--
function AddPModObjects nodeList bCreateNewPMods bDeleteAll objList:undefined =
(
	local PModList = #()
	
	-- Add PMods
	for nodeSrc in nodeList do (
		local newPMod = undefined
		if bCreateNewPMods == false do (
			newPMod = FindPMod nodeSrc		
		)
		if newPMod == undefined do (
			newPMod = Projection()
			AddModifier nodeSrc newPMod
		)
		append PModList newPMod
	)

	-- Prompt for obj nodes
	if objList == undefined do (
		function selectFilter obj = iskindof obj GeometryClass
		objList = selectByName title:~OBJLIST_TITLE~ buttonText:~OBJLIST_BUTTONTEXT_CAPTION~ filter:selectFilter showhidden:false single:false
	)

	for pmod in PModList do (
		if pmod != undefined do (
			local pmodInterface = pmod.projectionmodops
			if bDeleteAll == true do pmodInterface.deleteAll()
			for objNode in objList do (
				 pmodInterface.AddObjectNode objNode
			)
		)
	)
	
	return PModList
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB4ynHTfF5MivnJb81aDBqCtZubm17d+MNz
-- olB85clO7i4yVjjGlW4pmcY8pAFvytjnIThVtHe8D5IHkeAm8sf7Hi/RTDG1QzSF
-- qCxaTaoYUFZPEGWTZ/8AxKCNnwLjsCzpm7syil6FgDZgR2WLnBHb/X5rHuGFOKP0
-- 83AzRbDqqUphscNaHeyt2x2yjBmf5qXxSZptCe+EBp8PXM3gemevsqYxeeDgGktZ
-- a4ywEh/AtmwpWUC2Ig3zFs2f0WKWc+Gfa24mwAPrZVjyxVi2d9zz4J4XD1+4z+9n
-- kM1Kujy157OJtQMXt0zXy+ALZzcmQbhN0SBO1XbUF+BRpBhpmJcU
-- -----END-SIGNATURE-----