----------------------PolyBoost Functions---------------------
--------Globals-------------------------
global PolyBoost, PBViewCanvas, SymmetryMainModel, PBo_Pickobject
---------DialogWindows---------
global PBo_RCmain, PBo_NMmain, PBo_RDmain, PBo_Simimain, PBo_getmain, PBo_BSmain, PBtexprog
--Ribbon UI values
global PolyToolsUI
--Object Paint globals
global ObjectPaint, ObjectPaintNodeDialog
--Viewport Canvas globals
global VCanvas, VCLayers, VCSetup
--Viewport Canvas Rollouts
global VCMainFloater, VCPaintRoll, VCBrushImageRoll, VCBrushImageSettingsRoll, VCOptionsRoll, VCBehaveRoll, VCRandomizeRoll, VCPressureRoll, VCSettingsRoll
global VCview2D, VCBrushMenu, VCCustomBrushRollout, ColorPaletteRollout, VCMapMenu

struct PolyToolsUIstruct
(
	--Selection
	SimilarV = #(true,true,true,false,false), --#(edgecount, edgelength, facecount, facearea, normal)
	SimilarE = #(true,true,false,false), --#(edgelength, facearea, topology, normal)
	SimilarF = #(true,true,true,false), --#(edgecount, facearea, topology, normal)
	StepLoopLongdist = false,
	DotLoopGap = 1,
	RandomType = 1,
	RandomNumberButton = false,
	RandomPercentButton = true,
	RandomNumber = 20,
	RandomPercent = 25,
	CovexConcave = 1,
	NormalRadio = 1,
	NormalInvert = false,
	PerspectiveValue = 30.0,
	PerspectiveOutline = false,
	HalfAxis = 1,
	HalfInvert = false,
	NumericEdges = 4,
	NumericType = 1,
	LoopModeButton = false,
	RingModeButton = false,
	StepModeButton = false,
	StoreSelButton1 = false,
	StoreSelButton2 = false,
	SurfaceSelectSpinner = 0.0,
	NormalSelectSpinner = 0.0,
	PerspectiveGrowSpinner = 0.0,
	DistanceSelectSpinner = 100.0,
	--Ribbon Splitbutton dropdownlist integer callbacks
	DotLoopType = 1,
	DotLoopTypeEdge = 1,
	DotLoopTypePoly = 1,
	QuadrifyType = 1,
	ConvexConcaveType = 1,
	RandomSelectType = 1,
	SmoothType = 1,
	HardType = 1,
	Smooth30Type = 1,
	--Modeling
	InsertV = 1,
	SetFlowSpeed = 4,
	SetFlowAutoLoop = false,
	FlowConnectAutoLoop = false,
	RandomConnectJitter = 0.3,
	RandomConnectAutoLoop = true,
	MirrorElementClone = false,
	--PolyShift
	PSFullStrength = 20,
	PSFalloff = 200,
	PSStrength = 100,
	PSUseSelected = false,
	PSIgnoreback = false,
	PSFreezeX = false,
	PSFreezeY = false,
	PSFreezeZ = false,
	PSFreezeEX = false,
	PSFreezeEY = false,
	PSFreezeEZ = false,
	PSMirror = false,
	PSMirrorAxis = #X,
	PSUseRelativeOffset = false,
	PSConformAmount = 0.1,
	PSButtons = #(false, false, false),
	PSConformDirection = 1,
	PSBrushAffect = 2,
	fn PolyShiftSettings =
	(
		PolyBPolyShiftSettings PSFullStrength PSFalloff PSStrength PSUseSelected PSIgnoreback PSFreezeX PSFreezeY PSFreezeZ PSFreezeEX PSFreezeEY PSFreezeEZ PSUseRelativeOffset PSConformAmount PSConformDirection PSBrushAffect
	),
	--PolyDraw
	PDDrawtype = 1,
	PDOffset = 0.0,
	PDDistanceType = 1,
	PDDistance = 10.0,
	PDAutoWeld = true,
	PDSetFlow = false,
	PDSurfQuads = true,
	PDBranchTaper = -0.9,
	PDSolveAngle = 35,
	PDSolveQuads = true,
	PDButtons = #(false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false),
	PDPickButton = false,
	fn PolyDrawSettings =
	(
		PolyBPolyDrawUpdateValues PDOffset PDDistanceType PDDistance PDSetFlow PDBranchTaper PDSurfQuads PDAutoWeld
	),
	--PolySculpt (Paint Deform)
	SculptBrushsize = 20.0,
	SculptBrushStrength = 1.0,
	SculptOffset = 4.0,
	SculptCap = false,
	SculptDirection = 1,
	SculptNoiseSeed = 0,
	SculptNoiseScale = 4.0,
	SculptNoiseTurbulence = false,
	SculptNoiseIterations = 3.0,
	SculptHasBuffer = false,
	SculptUseSelectedVerts = false,
	SculptButtons = #(false,false,false,false,false,false,false,false),
	SculptPickButton = false,
	fn PolySculptSettings =
	(
		PolyBSculptSettings SculptOffset SculptCap SculptDirection SculptNoiseSeed SculptNoiseScale SculptNoiseTurbulence SculptNoiseIterations SculptUseSelectedVerts
	),
	---UVWTweak
	UVWTweakChannel = 1,
	UVWTweakFullStrength = 20,
	UVWTweakFalloff = 200,
	UVWTweakStrength = 100,
	UVWTweakKeepBoundries = false,
	UVWTweakButton = false,
	fn UVWTweakSettings =
	(
		PolyBUVWTweakSettings UVWTweakFullStrength UVWTweakFalloff UVWTweakStrength UVWTweakKeepBoundries
	),
	---Active tools
	PDTool = 0, --PolyDraw
	SculptTool = 0, --Paint deform
	PolyShiftActive = false, --PolyShift
	UVWTweakActive = false, --UVW Tweak
	fn ToolReset =
	(
		PDButtons = #(false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false)
		SculptButtons = #(false,false,false,false,false,false,false,false)
		PSButtons = #(false,false,false)
		PolyShiftActive = false
		PDTool = 0
		SculptTool = 0
		UVWTweakActive = false
		UVWTweakButton = false
		updateToolBarButtons()
	)
)
PolyToolsUI = PolyToolsUIstruct()

struct SculptSizeSpinnerCallback
(
	fn OnChanged fValue = 
	(
		thePainterInterface.maxSize = fValue
		PolyToolsUI.SculptBrushsize = fValue
	),
	fn getValue =
	(
		thePainterInterface.maxSize
	)
)

struct SculptStrengthSpinnerCallback
(
	fn OnChanged fValue = 
	(
		thePainterInterface.maxStr = fValue
		PolyToolsUI.SculptBrushStrength = fValue
	),
	fn getValue =
	(
		thePainterInterface.maxStr
	)
)

struct SculptOffsetSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.SculptOffset = fValue
		PolyToolsUI.PolySculptSettings()
	),
	fn getValue =
	(
		PolyToolsUI.SculptOffset
	)
)

struct SculptNoiseSeedSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.SculptNoiseSeed = iValue
		PolyToolsUI.PolySculptSettings()
	),
	fn getValue =
	(
		PolyToolsUI.SculptNoiseSeed
	)
)

struct SculptNoiseScaleSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.SculptNoiseScale = fValue
		PolyToolsUI.PolySculptSettings()
	),
	fn getValue =
	(
		PolyToolsUI.SculptNoiseScale
	)
)

struct SculptNoiseIterationsSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.SculptNoiseIterations = fValue
		PolyToolsUI.PolySculptSettings()
	),
	fn getValue =
	(
		PolyToolsUI.SculptNoiseIterations
	)
)

struct PDOffsetSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.PDOffset = fValue
		PolyToolsUI.PolyDrawSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PDOffset
	)
)

struct PDDistanceSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.PDDistance = fValue
		PolyToolsUI.PolyDrawSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PDDistance
	)
)

struct PDSolveSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.PDSolveAngle = iValue
	),
	fn getValue =
	(
		PolyToolsUI.PDSolveAngle
	)
)

struct PDBranchSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.PDBranchTaper = fValue
		PolyToolsUI.PolyDrawSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PDBranchTaper
	)
)

struct SurfaceSelectSpinnerCallback
(
	fn onButtonDown fValue =
	(
		PolyBoost.SpinnerChange true 1
	),
	fn onButtonUp fValue =
	(
		PolyBoost.SpinnerChange false 1
	),
	fn OnChanged fValue = 
	(
		PolyToolsSelect.ConvexConcave fValue PolyToolsUI.CovexConcave
		PolyToolsUI.SurfaceSelectSpinner = fValue
	),
	fn getValue =
	(
		PolyToolsUI.SurfaceSelectSpinner
	)
)

struct NormalSelectSpinnerCallback
(
	fn onButtonDown fValue =
	(
		PolyBoost.SpinnerChange true 2
	),
	fn onButtonUp fValue =
	(
		PolyBoost.SpinnerChange false 2
	),
	fn OnChanged fValue = 
	(
		PolyToolsSelect.Normal PolyToolsUI.NormalRadio fValue PolyToolsUI.NormalInvert
		PolyToolsUI.NormalSelectSpinner = fValue
	),
	fn getValue =
	(
		PolyToolsUI.NormalSelectSpinner
	)
)

struct DistanceSelectSpinnerCallback
(
	fn onButtonDown fValue =
	(
		PolyBoost.SpinnerChange true 3
	),
	fn onButtonUp fValue =
	(
		PolyBoost.SpinnerChange false 3
	),
	fn OnChanged fValue = 
	(
		PolyToolsSelect.Distance fValue
		PolyToolsUI.DistanceSelectSpinner = fValue
	),
	fn getValue =
	(
		PolyToolsUI.DistanceSelectSpinner
	)
)

struct PerspectiveGrowSpinnerCallback
(
	fn onButtonDown fValue =
	(
		PolyBoost.SpinnerChange true 4
	),
	fn onButtonUp fValue =
	(
		PolyBoost.SpinnerChange false 4
	),
	fn OnChanged fValue = 
	(
		PolyToolsSelect.PerspectiveGrow fValue
		PolyToolsUI.PerspectiveGrowSpinner = fValue
	),
	fn getValue =
	(
		PolyToolsUI.PerspectiveGrowSpinner
	)
)

struct PerspectiveSelectSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.PerspectiveValue = fValue
	),
	fn getValue =
	(
		PolyToolsUI.PerspectiveValue
	)
)

struct UVWTweakSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.UVWTweakChannel = iValue
	),
	fn getValue =
	(
		PolyToolsUI.UVWTweakChannel
	)
)

struct RandomNumberSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.RandomNumber = iValue
	),
	fn getValue =
	(
		PolyToolsUI.RandomNumber
	)
)

struct RandomPercentSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.RandomPercent = fValue
	),
	fn getValue =
	(
		PolyToolsUI.RandomPercent
	)
)

struct NumericSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.NumericEdges = iValue
	),
	fn getValue =
	(
		PolyToolsUI.NumericEdges
	)
)

struct DotLoopSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.DotLoopGap = iValue
	),
	fn getValue =
	(
		PolyToolsUI.DotLoopGap
	)
)

struct InsertVSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.InsertV = iValue
	),
	fn getValue =
	(
		PolyToolsUI.InsertV
	)
)

struct SetFlowSpinnerCallback
(
	fn onButtonDown fValue =
	(
		PolyBoost.FlowSel = PolyBGetSel 2
		PolyBSetFlowSpinner PolyToolsUI.SetFlowAutoLoop 0 0 1
	),
	fn onButtonUp fValue =
	(
		PolyBAdjustUndo PolyBoost.FlowSel
	),
	fn OnChanged fValue = 
	(
		PolyBSetFlowSpinner false fValue PolyToolsUI.SetFlowSpeed 0
	),
	fn getValue =
	(
		0.0
	)
)

struct SetFlowSpeedSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.SetFlowSpeed = iValue
	),
	fn getValue =
	(
		PolyToolsUI.SetFlowSpeed
	)
)

struct RandomConnectSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.RandomConnectJitter = fValue
	),
	fn getValue =
	(
		PolyToolsUI.RandomConnectJitter
	)
)

struct PSFullStrengthSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.PSFullStrength = iValue
		if iValue > PolyToolsUI.PSFalloff do
		(
			PolyToolsUI.PSFalloff = iValue
			updateToolbarButtons()
		)
		PolyToolsUI.PolyShiftSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PSFullStrength
	)
)

struct PSFalloffSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.PSFalloff = iValue
		if iValue < PolyToolsUI.PSFullStrength do
		(
			PolyToolsUI.PSFullStrength = iValue
			updateToolbarButtons()
		)
		PolyToolsUI.PolyShiftSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PSFalloff
	)
)

struct PSStrengthSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.PSStrength = iValue
		PolyToolsUI.PolyShiftSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PSStrength
	)
)

struct PSConformSpinnerCallback
(
	fn OnChanged fValue = 
	(
		PolyToolsUI.PSConformAmount = fValue
		PolyToolsUI.PolyShiftSettings()
	),
	fn getValue =
	(
		PolyToolsUI.PSConformAmount
	)
)

struct UVWTweakFullStrengthSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.UVWTweakFullStrength = iValue
		if iValue > PolyToolsUI.UVWTweakFalloff do
		(
			PolyToolsUI.UVWTweakFalloff = iValue
			updateToolbarButtons()
		)
		PolyToolsUI.UVWTweakSettings()
	),
	fn getValue =
	(
		PolyToolsUI.UVWTweakFullStrength
	)
)

struct UVWTweakFalloffSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.UVWTweakFalloff = iValue
		if iValue < PolyToolsUI.UVWTweakFullStrength do
		(
			PolyToolsUI.UVWTweakFullStrength = iValue
			updateToolbarButtons()
		)
		PolyToolsUI.UVWTweakSettings()
	),
	fn getValue =
	(
		PolyToolsUI.UVWTweakFalloff
	)
)

struct UVWTweakStrengthSpinnerCallback
(
	fn OnChanged iValue = 
	(
		PolyToolsUI.UVWTweakStrength = iValue
		PolyToolsUI.UVWTweakSettings()
	),
	fn getValue =
	(
		PolyToolsUI.UVWTweakStrength
	)
)

struct ObjectPaintOffsetSpinnerCallback
(
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 19 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 19
	)
)

struct ObjectPaintFillCountSpinnerCallback
(
	fn isEnabled =
	(
		(not OBJPaintGetSetting 50)
	),
	fn OnChanged iValue = 
	(
		OBJPaintSetSetting 35 iValue
		if (OBJPaintGetSetting 51) do --if Fill tool is active
		(
			PolyBOBJPaintSetNumFillNodes iValue
			updateToolbarButtons()
		)
	),
	fn getValue =
	(
		OBJPaintGetSetting 35
	)
)

struct ObjectPaintMotionSpinnerCallback
(
	fn OnChanged iValue = 
	(
		OBJPaintSetSetting 36 iValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 36
	)
)

struct ObjectPaintSpacingSpinnerCallback
(
	fn onButtonDown fValue =
	(
		PolyBOBJSpacingChangeStart()
		ObjectPaint.hasStartedSpacingButtonDown = true
	),
	fn onButtonUp fValue =
	(
		PolyBOBJSpacingChangeEnd()
		ObjectPaint.hasStartedSpacingButtonDown = false
	),
	fn OnChanged fValue = 
	(
		if (not ObjectPaint.hasStartedSpacingButtonDown) then --value is typed in manually
		(
			PolyBOBJSpacingChangeStart()
			OBJPaintSetSetting 1 fValue
			PolyBOBJInterActiveUpdate()
			PolyBOBJSpacingChangeEnd()
		)
		else
		(
			OBJPaintSetSetting 1 fValue
			PolyBOBJInterActiveUpdate()
		)
	),
	fn getValue =
	(
		OBJPaintGetSetting 1
	)
)

struct ObjectPaintScatterUSpinnerCallback
(
	fn OnChanged fValue = 
	(
		curScatter = OBJPaintGetSetting 2
		curScatter.x = fValue
		OBJPaintSetSetting 2 curScatter
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		(OBJPaintGetSetting 2).x
	)
)

struct ObjectPaintScatterVSpinnerCallback
(
	fn OnChanged fValue = 
	(
		curScatter = OBJPaintGetSetting 2
		curScatter.y = fValue
		OBJPaintSetSetting 2 curScatter
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		(OBJPaintGetSetting 2).y
	)
)

struct ObjectPaintScatterWSpinnerCallback
(
	fn OnChanged fValue = 
	(
		curScatter = OBJPaintGetSetting 2
		curScatter.z = fValue
		OBJPaintSetSetting 2 curScatter
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		(OBJPaintGetSetting 2).z
	)
)

struct ObjectPaintRotXSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 9)
	),
	fn OnChanged iValue = 
	(
		OBJPaintSetSetting 3 iValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 3
	)
)

struct ObjectPaintRotYSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 10)
	),
	fn OnChanged iValue = 
	(
		OBJPaintSetSetting 4 iValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 4
	)
)

struct ObjectPaintRotZSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 11)
	),
	fn OnChanged iValue = 
	(
		OBJPaintSetSetting 5 iValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 5
	)
)

struct ObjectPaintScaleXSpinnerCallback
(
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 6 fValue
		if (OBJPaintGetSetting 28) do --lock axis is on
		(
			OBJPaintSetSetting 7 fValue
			OBJPaintSetSetting 8 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 6
	)
)

struct ObjectPaintScaleYSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 7 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 7
	)
)

struct ObjectPaintScaleZSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 8 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 8
	)
)

struct ObjectPaintScaleRandomXMinSpinnerCallback
(
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 21 fValue
		if fValue > (OBJPaintGetSetting 24) do
		(
			OBJPaintSetSetting 24 fValue
			if (OBJPaintGetSetting 28) do --lock axis is on
			(
				OBJPaintSetSetting 25 fValue
				OBJPaintSetSetting 26 fValue
			)
		)
		if (OBJPaintGetSetting 28) do --lock axis is on
		(
			OBJPaintSetSetting 22 fValue
			OBJPaintSetSetting 23 fValue
		)
		updateToolbarButtons()
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 21
	)
)

struct ObjectPaintScaleRandomYMinSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 22 fValue
		if fValue > (OBJPaintGetSetting 25) do
		(
			OBJPaintSetSetting 25 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 22
	)
)

struct ObjectPaintScaleRandomZMinSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 23 fValue
		if fValue > (OBJPaintGetSetting 26) do
		(
			OBJPaintSetSetting 26 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 23
	)
)

struct ObjectPaintScaleRandomXMaxSpinnerCallback
(
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 24 fValue
		if fValue < (OBJPaintGetSetting 21) do
		(
			OBJPaintSetSetting 21 fValue
			if (OBJPaintGetSetting 28) do --lock axis is on
			(
				OBJPaintSetSetting 22 fValue
				OBJPaintSetSetting 23 fValue
			)
		)
		if (OBJPaintGetSetting 28) do --lock axis is on
		(
			OBJPaintSetSetting 25 fValue
			OBJPaintSetSetting 26 fValue
		)
		updateToolbarButtons()
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 24
	)
)

struct ObjectPaintScaleRandomYMaxSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 25 fValue
		if fValue < (OBJPaintGetSetting 22) do
		(
			OBJPaintSetSetting 22 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 25
	)
)

struct ObjectPaintScaleRandomZMaxSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 26 fValue
		if fValue < (OBJPaintGetSetting 23) do
		(
			OBJPaintSetSetting 23 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 26
	)
)

struct ObjectPaintScaleRampXStartSpinnerCallback
(
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 29 fValue
		if (OBJPaintGetSetting 28) do --lock axis is on
		(
			OBJPaintSetSetting 30 fValue
			OBJPaintSetSetting 31 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 29
	)
)

struct ObjectPaintScaleRampYStartSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 30 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 30
	)
)

struct ObjectPaintScaleRampZStartSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 31 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 31
	)
)

struct ObjectPaintScaleRampXEndSpinnerCallback
(
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 32 fValue
		if (OBJPaintGetSetting 28) do --lock axis is on
		(
			OBJPaintSetSetting 33 fValue
			OBJPaintSetSetting 34 fValue
			updateToolbarButtons()
		)
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 32
	)
)

struct ObjectPaintScaleRampYEndSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 33 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 33
	)
)

struct ObjectPaintScaleRampZEndSpinnerCallback
(
	fn isEnabled =
	(
		not (OBJPaintGetSetting 28)
	),
	fn OnChanged fValue = 
	(
		OBJPaintSetSetting 34 fValue
		PolyBOBJInterActiveUpdate()
	),
	fn getValue =
	(
		OBJPaintGetSetting 34
	)
)

struct PolyBoostStruct
(
-----Values------------------
	Modetype, ModeSel, ModeRun,
	StepSel, StepLast, SubLevel, StepRun,
	
	SelStorage1, SelStorage2, SelStorage3,
	SelectedObj, FlowSel, TexWrapFile, SurfSelsel, VertexTicks, PolyDrawPicktext = ~PICK~,
	
	PBo_Flowmainpos, PBo_SDmainpos, PBo_transmainpos, PBo_texturemainpos,
	PBo_transmain, PBo_texturemain,
	TransformDialogOpen = false, ViewportCanvasOpen = false, TextureToolsOpen = false,
	
	PaintDeformPicktext = ~PICK_PAINTDEFORM~,
------GeneralFunctions-----------------------------------------

fn validobjfunc =
(
	PolyBValidObject #NoSubobjectCheck #EditablePoly
),
-- for editable poly or edit poly in subobject mode
fn validEPmacro =
(
	PolyBValidObject #SubobjectCheck #None
),
-- for editable poly or edit poly when also in subobjectlevel 0
fn validEPbasemacro =
(
	PolyBValidObject #NoSubobjectCheck #None
),
fn Modetext =
(
	if ($ == undefined) or ($ != SelectedObj) or subobjectLevel != SubLevel then
	(
		deleteAllChangeHandlers id:#Nup
		deleteAllChangeHandlers id:#Stup
		StepRun = 0 ; StepSel = undefined
		PolyToolsUI.LoopModeButton = false
		PolyToolsUI.RingModeButton = false
		PolyToolsUI.StepModeButton = false
		unRegisterRedrawViewsCallback Modetext
		ModeRun = 0
		forcecompleteredraw doDisabled: true
		updateToolbarButtons()
	)
	else
	(
		winx = gw.getWinSizeX()
		pbtext = ""
		if Modetype == 1 then pbtext = ~LOOPMODE_ON~
		else if Modetype == 2 then pbtext = ~RINGMODE_ON~
		else if Modetype == 3 do pbtext = ~STEPMODE_ON~
		local sz = gw.getTextExtent pbtext
		gw.wText [(winx-sz.x)/2,35,0] pbtext color: (color 255 255 255)
		gw.enlargeUpdateRect #whole
		gw.UpdateScreen()
	)
),

------ToolFunctions--------------------------------------------
fn Insloopfunc =
(
	cursel = modpanel.getcurrentobject()
	if classof cursel == Edit_Poly then undo ~INSERT_LOOP~ on
	(
		disablesceneredraw()
		if not keyboard.shiftpressed do
		(
			cursegs = cursel.connectEdgeSegments
			curpinch = cursel.connectEdgePinch
			curslid = cursel.connectEdgeSlide
			cursel.connectEdgePinch = 0
			cursel.connectEdgeSlide = 0
			cursel.connectEdgeSegments = 1
		)
		if (subobjectLevel == 4) or (subobjectLevel == 5) and ((cursel.getSelection 4 as array).count > 1) then
		(
			cursel.ConvertSelection #Face #Edge requireAll:on
			hummu = cursel.getSelection #Edge
			wut = #{}
			for i in hummu where (cursel.GetEdgeFace i 2 node:$) != 0 do wut[i] = true
			subobjectLevel = 2
			cursel.setSelection #Edge #{}
			cursel.Select #Edge wut
			cursel.ButtonOp #SelectEdgeRing
			if (keyboard.shiftpressed) then
			(
				cursel.popupDialog #ConnectEdges
				cursel.ConvertSelection #Edge #Face
			)
			else
			(
				cursel.ButtonOp #ConnectEdges
				subobjectLevel = 4
				cursel.ConvertSelection #Edge #Face
			)
		)
		else if (subobjectLevel == 2) or (subobjectLevel == 3) then
		(
			cursel.ButtonOp #SelectEdgeRing
			if (keyboard.shiftpressed) then (cursel.popupDialog #ConnectEdges)
			else cursel.ButtonOp #ConnectEdges
		)
		else if (subobjectLevel == 1) then
		(
			cursel.ConvertSelection #Vertex #Edge requireAll:true
			subobjectLevel = 2
			cursel.ButtonOp #SelectEdgeRing
			if (keyboard.shiftpressed) then cursel.popupDialog #ConnectEdges
			else
			(
				cursel.ButtonOp #ConnectEdges
				cursel.ConvertSelection #Edge #Vertex
				subobjectLevel = 1
			)
		)
		if not keyboard.shiftpressed do
		(
			cursel.connectEdgeSegments = cursegs
			cursel.connectEdgePinch = curpinch
			cursel.connectEdgeSlide = curslid
		)
		enablesceneredraw()
		redrawviews()
	)
	else if PolyBoost.validobjfunc() do undo ~UNDO_INSERT_LOOP~ on
	(
		selbas = $.baseobject
		disablesceneredraw()
		if not keyboard.shiftpressed do
		(
			cursegs = $.connectEdgeSegments
			curpinch = $.connectEdgePinch
			curslid = $.connectEdgeSlide
			$.connectEdgePinch = 0
			$.connectEdgeSlide = 0
			$.connectEdgeSegments = 1
		)
		if (subobjectLevel == 4) or (subobjectLevel == 5) and ((polyop.getFaceSelection selbas as array).count > 1) then
		(
			mev = polyop.getOpenEdges selbas
			$.EditablePoly.ConvertSelection #Face #Edge requireAll:on
			polyop.setEdgeselection selbas ((polyop.getEdgeselection selbas)-mev)
			$.EditablePoly.SelectEdgeRing ()
			if (keyboard.shiftpressed) then
			(
				subobjectLevel = 2
				$.EditablePoly.popupDialog #ConnectEdges
				$.EditablePoly.ConvertSelection #Edge #Face
			)
			else
			(
				$.EditablePoly.ConnectEdges ()
				$.EditablePoly.ConvertSelection #Edge #Face
			)
		)
		else if (subobjectLevel == 2) or (subobjectLevel == 3) then
		(
			$.EditablePoly.SelectEdgeRing ()
			if (keyboard.shiftpressed) then ($.EditablePoly.popupDialog #ConnectEdges)
			else $.EditablePoly.ConnectEdges ()
		)
		else if (subobjectLevel == 1) then
		(
			$.EditablePoly.ConvertSelection #Vertex #Edge requireAll:true
			$.EditablePoly.SelectEdgeRing ()
			if (keyboard.shiftpressed) then
			(
				subobjectLevel = 2
				$.EditablePoly.popupDialog #ConnectEdges
			)
			else
			(
				$.EditablePoly.ConnectEdges ()
				$.EditablePoly.ConvertSelection #Edge #Vertex
			)
		)
		if not keyboard.shiftpressed do
		(
			$.connectEdgeSegments = cursegs
			$.connectEdgePinch = curpinch
			$.connectEdgeSlide = curslid
		)
		enablesceneredraw()
		redrawviews()
	)
),
fn RandDfunc =
(
	rollout RDmainroll ~RANDOM~
	(
	
		button randbs ~SELECT_BUTTONTEXT~ height: 17 width: ~RANDBS_WIDTH~ tooltip: ~RANDBS_TOOLTIP~
		radiobuttons randradio "" labels:#("%",~NUM~) default: 1 columns: 2
		spinner randspin ~PERCENT~ range:[0,100,50] fieldwidth: 38 pos:[4,50] scale:1
		spinner randnum ~NUMBER~ range:[0,100000000,20] fieldwidth: 38 pos:[4,70] scale:1 type:#integer enabled:false
		
		on randradio changed state do
		(
			if randradio.state == 1 then (randspin.enabled = true ; randnum.enabled = false)
			else (randspin.enabled = false ; randnum.enabled = true)
		)
		on randbs pressed do
		(
			PolyToolsSelect.Random randspin.value randnum.value randradio.state keyboard.shiftpressed
		)
	)
	--PBo_RDmain = undefined
	if PBo_RDmain != undefined then
	(
		if PBo_RDmain.dialogbar do cui.UnRegisterDialogBar PBo_RDmain
		PBrdp = PBo_RDmain.pos
		closerolloutFloater PBo_RDmain
		PBo_RDmain = newrolloutfloater ~RANDOMSELECT~ 112 122 PBrdp[1] PBrdp[2]
		PBo_RDmain.pos = PBrdp
	)
	else (PBo_RDmain = newrolloutfloater ~NEWROLLOUTFLOATER_RANDOMSELECT~ 112 122 157 240)
	addrollout RDmainroll PBo_RDmain
	cui.RegisterDialogBar PBo_RDmain minSize:[28,28] maxSize:[118,127]
),
fn Smoothfunc doSelection =
(
	cursel = modpanel.getcurrentobject()
	if classof cursel == Edit_Poly then undo ~SMOOTH~ on
	(
		subble = subobjectlevel
		subobjectlevel = 4
		ma = cursel.getSelection #Face
		if (not doSelection and not keyboard.shiftpressed) do 
		(
			cursel.setSelection #Face #{}
			cursel.Select #Face #{1..(cursel.getNumFaces node:$)}
		)
		cursel.autoSmoothThreshold = 180
		cursel.ButtonOp #Autosmooth
		cursel.setSelection #Face #{}
		cursel.Select #Face ma
		subobjectlevel = subble
		redrawviews()
	)
	else undo ~ELSE_UNDO_SMOOTH~ on
	(
		if (selection.count == 1) and (classof $.baseobject == Editable_Poly) then
		(
			ma = polyop.getfaceselection $.baseobject
			if not doSelection and not keyboard.shiftpressed do polyop.setfaceselection $.baseobject #all
			$.baseobject.autoSmoothThreshold = 180
			$.baseobject.EditablePoly.autosmooth ()
			polyop.setfaceselection $.baseobject ma
			redrawviews()
		)
	)
),
fn Hardfunc doSelection =
(
	cursel = modpanel.getcurrentobject()
	if classof cursel == Edit_Poly then undo ~HARD~ on
	(
		subble = subobjectlevel
		subobjectlevel = 4
		ma = cursel.getSelection #Face
		if (not doSelection and not keyboard.shiftpressed) do 
		(
			cursel.setSelection #Face #{}
			cursel.Select #Face #{1..(cursel.getNumFaces node:$)}
		)
		cursel.SetOperation #SetSmooth
		cursel.smoothingGroupsToSet = 0
		cursel.smoothingGroupsToClear = -1
		cursel.commit()
		cursel.setSelection #Face #{}
		cursel.Select #Face ma
		subobjectlevel = subble
		redrawviews()
	)
	else undo ~ELSE_UNDO_HARD~ on
	(
		if (selection.count == 1) and (classof $.baseobject == Editable_Poly) then
		(
			if not doSelection and not keyboard.shiftpressed then allf = #{1..(polyop.getNumFaces $.baseobject)}
			else allf = polyop.getFaceSelection $.baseobject
			polyOp.setFaceSmoothGroup $.baseobject allf 0
			redrawviews()
		)
	)
),
fn Thirtyfunc doSelection =
(
	cursel = modpanel.getcurrentobject()
	if classof cursel == Edit_Poly then undo ~SMOOTH_30~ on
	(
		subble = subobjectlevel
		subobjectlevel = 4
		ma = cursel.getSelection #Face
		if (not doSelection and not keyboard.shiftpressed) do 
		(
			cursel.setSelection #Face #{}
			cursel.Select #Face #{1..(cursel.getNumFaces node:$)}
		)
		cursel.autoSmoothThreshold = 30
		cursel.ButtonOp #Autosmooth
		cursel.setSelection #Face #{}
		cursel.Select #Face ma
		subobjectlevel = subble
		redrawviews()
	)
	else undo ~ELSE_UNDO_SMOOTH_30~ on
	(
		if (selection.count == 1) and (classof $.baseobject == Editable_Poly) then
		(
			ma = polyop.getfaceselection $.baseobject
			if not doSelection and not keyboard.shiftpressed do polyop.setfaceselection $.baseobject #all
			$.baseobject.autoSmoothThreshold = 30
			$.baseobject.EditablePoly.autosmooth ()
			polyop.setfaceselection $.baseobject ma
			redrawviews()
		)
	)
),
fn Storefunc =
(
	if (subobjectLevel == 1) then SelStorage3 = PolyBGetSel 1
	else if (subobjectLevel == 2) or (subobjectLevel == 3) then SelStorage3 = PolyBGetSel 2
	else if (subobjectLevel == 4) or (subobjectLevel == 5) do SelStorage3 = PolyBGetSel 3
	if SelStorage3 == undefined do messagebox ~MSGBOX_NO_SELECTION_WAS_STORED~ title: ~STORE_SELECTION_TITLE~
),
fn Pastefunc =
(
	if SelStorage3 != undefined then
	(
		undo ~UNDO_PASTE_SELECTION~ on
		(
			if (subobjectLevel == 1) then
			(
				if keyboard.shiftpressed then PolyBSetSel 1 (SelStorage3 + (PolyBGetSel 1))
				else PolyBSetSel 1 SelStorage3
			)
			else if (subobjectLevel == 2) or (subobjectLevel == 3) then
			(
				if keyboard.shiftpressed then PolyBSetSel 2 (SelStorage3 + (PolyBGetSel 2))
				else PolyBSetSel 2 SelStorage3
			)
			else if (subobjectLevel == 4) or (subobjectLevel == 5) then
			(
				if keyboard.shiftpressed then PolyBSetSel 3 (SelStorage3 + (PolyBGetSel 3))
				else PolyBSetSel 3 SelStorage3
			)
		)
		redrawviews()
	)
	else messagebox ~MSGBOX_THERE_IS_NO_SELECTION_STORED~ beep:false title:~UNDO_PASTE_SELECTION_TITLE~
),
fn Simifunc =
(
	rollout simivertroll ~VERTEX~ rolledup:true
	(
		group ~COMPARE~
		(
			checkbox sedgenum ~EDGECOUNT~ checked: true
			checkbox sedgel ~EDGELENGTH~ checked: true
			checkbox sfacec ~FACECOUNT~ checked: true
			checkbox sfacearea ~FACEAREAS~
			checkbox snormal ~NORMAL_DIR~
			button simiVsel ~SIMIVSEL_SELECT_BUTTONTEXT~ height:17 width:44 tooltip:~SELECT_SIMILAR_VERTICES~
		)
		
		on simivertroll open do (if subobjectlevel == 1 do simivertroll.open = true)
		on simiVsel pressed do
		(
			if (subobjectLevel == 1) do
			(
				PolyToolsSelect.Similar sedgenum.state sedgel.state sfacec.state sfacearea.state false snormal.state
			)
		)
	)
	rollout simiedgeroll ~EDGE~ rolledup:true
	(
		group ~GROUP_COMPARE~
		(
			checkbox sEedgel ~EDGELENGTHS_CAPTION~ checked: true
			checkbox sEfacearea ~FACEAREAS_CAPTION~ checked: true
			checkbox sEtopo ~TOPOLOGY~
			checkbox sEnormal ~NORMAL_DIR_CAPTION~
			button simiEsel ~SIMIESEL_SELECT_BUTTONTEXT~ height: 17 width: 44 tooltip:~SIMIESEL_SELECT_TOOLTIP~
		)
		
		on simiedgeroll open do (if subobjectlevel == 2 do simiedgeroll.open = true)
		on simiEsel pressed do
		(
			if (subobjectLevel == 2) or (subobjectLevel == 3) do
			(
				PolyToolsSelect.Similar false sEedgel.state false sEfacearea.state sEtopo.state sEnormal.state
			)
		)
	)
	rollout simipolyroll ~FACE_CAPTION~ rolledup:true
	(
		group ~SIMIPOLYROLL_GROUP_COMPARE~
		(
			checkbox sPedgenum ~SPEDGENUM_EDGECOUNT~ checked: true
			checkbox sPfacearea ~SPFACEAREA_CAPTION~ checked: true
			checkbox sPtopo ~SPTOPO_TOPOLOGY~ checked: true
			checkbox sPnormal ~SPNORMAL_NORMAL_DIR_CAPTION~
			button simiPsel ~SIMIPSEL_SELECT_BUTTONTEXT~ height: 17 width: 44 tooltip:~SIMIPSEL_SELECT_TOOLTIP~
		)
		
		on simipolyroll open do (if subobjectlevel == 4 or subobjectlevel == 0 do simipolyroll.open = true)
		on simiPsel pressed do
		(
			if (subobjectLevel == 4) or (subobjectLevel == 5) do
			(
				PolyToolsSelect.Similar sPedgenum.state false false sPfacearea.state sPtopo.state sPnormal.state
			)
		)
	)
	--PBo_Simimain = undefined
	if PBo_Simimain != undefined then
	(
		if PBo_Simimain.dialogbar do cui.UnRegisterDialogBar PBo_Simimain
		PBsis = PBo_Simimain.size
		PBsip = PBo_Simimain.pos
		closerolloutFloater PBo_Simimain
		PBo_Simimain = newrolloutfloater ~SIMILAR_CAPTION~ 112 PBsis[2] PBsip[1] PBsip[2]
		PBo_Simimain.pos = PBsip
	)
	else (PBo_Simimain = newrolloutfloater ~PBO_SIMIMAIN_SIMILAR_CAPTION~ 112 228 157 240)
	addrollout simivertroll PBo_Simimain
	addrollout simiedgeroll PBo_Simimain
	addrollout simipolyroll PBo_Simimain
	cui.RegisterDialogBar PBo_Simimain minSize:[28,28] maxSize:[118,510]
),
fn ModeLoopRing type =
(
	cursel = modpanel.getcurrentobject()
	if PolyBoost.validobjfunc() or classof cursel == Edit_Poly do
	(
		if (subobjectlevel != 0) do
		(
			if ModeRun == 1 then
			(
				if Modetype != type then (Modetype = type ; forcecompleteredraw doDisabled: true)
				else
				(
					deleteAllChangeHandlers id:#Nup
					unRegisterRedrawViewsCallback Modetext
					ModeRun = 0
					forcecompleteredraw doDisabled: true
				)
			)
			else
			(
				deleteAllChangeHandlers id:#Stup
				unRegisterRedrawViewsCallback Modetext
				StepRun = 0 ; StepSel = undefined
				
		 		ModeRun = 1
				Modetype = type
				SelectedObj = $
				SubLevel = subobjectLevel
				registerRedrawViewsCallback Modetext
				sellev = 2
				if subobjectLevel == 1 then sellev = 1
				else if subobjectLevel == 4 or subobjectLevel == 5 do sellev = 3
				ModeSel = PolyBGetSel sellev
				when select cursel changes id:#Nup do
				(
					PolyBoost.ActiveLoopRingMode()
				)
				when topology cursel changes id:#Nup do
				(
					PolyBoost.Looptopofunc()
				)
				forcecompleteredraw doDisabled: true
			)
		)
	)
),
fn ActiveLoopRingMode =
(
	ModeSel = PolyBModeLoopRing Modetype ModeSel keyboard.controlpressed keyboard.altpressed
),
fn Looptopofunc = 
(
	sellev = 2
	if subobjectLevel == 1 then sellev = 1
	else if subobjectLevel == 4 or subobjectLevel == 5 do sellev = 3
	ModeSel = PolyBGetSel sellev
),
fn ModeStep =
(
	sellevel = 3
	if subobjectlevel == 1 then sellevel = 1
	else if subobjectlevel == 2 or subobjectlevel == 3 do sellevel = 2
	elsel = PolyBGetSel sellevel
	if not keyboard.controlpressed do StepSel = StepLast = #{}
	if (elsel as array).count != 0 do
	(
		esel = elsel - StepSel
		if (StepLast as array).count == 0 then (StepLast = esel ; StepSel = elsel)
		else
		(
			PolyBSetSel sellevel (esel + StepLast)
			PolyToolsSelect.StepLoop false
			StepSel = (PolyBGetSel sellevel) + StepSel
			PolyBSetSel sellevel StepSel
			StepLast = esel
		)
	)
),
fn Stepfunc =
(
	cursel = modpanel.getcurrentobject()
	stepgogo = 0
	if classof cursel == Edit_Poly then stepgogo = 1
	if PolyBoost.validobjfunc() or stepgogo == 1 do
	(
		if (subobjectLevel == 4) or (subobjectLevel == 1) or (subobjectLevel == 2) do
		(
			if StepRun != 1 then
			(
				deleteAllChangeHandlers id:#Nup
				unRegisterRedrawViewsCallback Modetext

				StepRun = 1
				ModeRun = 0
				SelectedObj = $
				StepLast = #{}
				SubLevel = subobjectLevel
				Modetype = 3
				registerRedrawViewsCallback Modetext
				if selection.count == 1 do
				(
					if subobjectlevel == 1 then sellevel = 1
					else if subobjectlevel == 2 or subobjectlevel == 3 then sellevel = 2
					else if subobjectlevel == 4 or subobjectlevel == 5 do sellevel = 3
					StepSel = PolyBGetSel sellevel
					when select cursel changes id:#Stup do (PolyBoost.ModeStep())
				)
				forcecompleteredraw doDisabled: true
			)
			else
			(
				StepRun = 0
				deleteAllChangeHandlers id:#Stup
				unRegisterRedrawViewsCallback Modetext
				StepSel = undefined
				forcecompleteredraw doDisabled: true
			)
		)
	)
),
fn Randconfunc =
(
	rollout RCmainroll ~RCMAINROLL_PARAMETERS~
	(
		button conct ~CONCT_CONNECT_CAPTION~ tooltip: ~CONCT_CONNECT_TOOLTIP~
		spinner tsh ~TSH_JITTER_CAPTION~ range:[0.0,0.49,0.3] fieldwidth: 38 pos:[20,34]
		checkbox ranconcheck ~RANCONCHECK_AUTOLOOP_CAPTION~ checked:true align:#center
		
		on conct pressed do undo ~CONCT_UNDO_RANDOM_CONNECT_CAPTION~ on
		(
			PolyToolsModeling.RandomConnect tsh.value ranconcheck.state
		)
	)
	--PBo_RCmain = undefined
	if PBo_RCmain != undefined then
	(
		if PBo_RCmain.dialogbar do cui.UnRegisterDialogBar PBo_RCmain
		PBrcp = PBo_RCmain.pos
		closerolloutFloater PBo_RCmain
		PBo_RCmain = newrolloutfloater ~PBO_RCMAIN_RANDOMCONNECT_CAPTION~ 130 106 PBrcp[1] PBrcp[2]
		PBo_RCmain.pos = PBrcp
	)
	else (PBo_RCmain = newrolloutfloater ~PBO_RCMAIN_RANDOMCONNECT_CAPTION2~ 130 106)
	addrollout RCmainroll PBo_RCmain
	cui.RegisterDialogBar PBo_RCmain minSize:[28,28] maxSize:[136,111]
),
fn FlowDfunc =
(
	rollout PBo_Flowmain ~LOOP_TOOLS_CAPTION~
	(
		checkbox autol ~AUTOLOOP_CAPTION~ checked:false
-- 		group ~GROUP_MESHFLOW_CAPTION~
-- 		(
-- 			button Fconnect ~FLOWCONNECT_BUTTONTEXT~ height:17 width:70 tooltip:~INSERT_LOOPS_EDGES_ADJUST_MESHFLOW~ offset:[-10,0]
-- 			button Flowset ~SET_FLOW_BUTTONTEXT~ height:17 width:70 tooltip:~ADJUST_LOOPS_EDGES_TO_MESHFLOW_USE_SPINNER~ offset:[-10,-2]
-- 			spinner Flowspin "" range:[-1000000.0,1000000.0,0] fieldwidth:0 scale:0.1 offset:[4,-21]
-- 			spinner Fspeed ~SPINNER_SPEED_CAPTION~ range:[1,400,4] fieldwidth:32 type:#integer offset:[0,2]
-- 		)
		group ~GROUP_ADJUST_LOOPS~
		(
			bitmap loopbit1 filename:((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\Images\Loops.bmp") offset:[-34,0] width:24
			spinner Tightspin ""  range:[-1000000,1000000,0] fieldwidth:0 offset:[-52,-28]
			bitmap loopbit2 filename:((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\Images\Loops2.bmp") offset:[18,-23] width:24
			spinner Tightspin2 ""  range:[-1000000,1000000,0] fieldwidth:0 offset:[0,-28]
			spinner tperc ~TPERC_PERCENT~ range:[1,99,5] fieldwidth: 32 type: #integer scale:5 offset:[0,4]
			button centloop ~CENTLOOP_CENTER_CAPTION~ height:17 width:49 offset:[-26,4] tooltip:~CENTER_LOOPS_EDGES_ON_EDGE_RING~
			button spacloop ~SPACLOOP_SPACE_BUTTONTEXT~ height:17 width:49 offset:[25,-22] tooltip:~SPACE_LOOPS_EDGES_VERTS_ALONG_LOOP~
		)
		group ~GROUP_CURVATURE~
		(
			button curvloop ~CURVLOOP_CURVE_BUTTONTEXT~ height:17 width:49 tooltip:~CURVE_LOOP_TOOLTIP~ offset:[-26,-2]
			button strailoop ~STRAILOOP_STRAIGHT_BUTTONTEXT~ height:17 width:49 tooltip:~STRAIGHTEN_LOOP_TOOLTIP~ offset:[25,-22]
			checkbox biascheck ~BIASCHECK_SPACE_LOOP~ checked:true align:#center offset:~BIASCHECK_OFFSET~
			button circloop ~CIRCLOOP_CIRCLE_BUTTONTEXT~ height:17 width:49 tooltip:~TURN_LOOP_INTO_A_CIRCLE_TOOLTIP~ offset:[-26,-2]
			button smootloop ~SMOOTLOOP_RELAX_BUTTONTEXT~ height:17 width:~SMOOTLOOP_WIDTH~ tooltip:~RELAX_LOOP_TOOLTIP~ offset:~SMOOTLOOP_OFFSET~
		)
		
		on circloop pressed do
		(
			PolyToolsModeling.CircleLoop autol.state
		)
		on strailoop pressed do
		(
			PolyToolsModeling.StraightLoop autol.state biascheck.state
		)
		on smootloop pressed do
		(
			PolyToolsModeling.RelaxLoop autol.state
		)
		on curvloop pressed do
		(
			PolyToolsModeling.CurveLoop autol.state biascheck.state
		)
		on spacloop pressed do
		(
			PolyToolsModeling.SpaceLoop autol.state
		)
		on PBo_Flowmain close do (PolyBoost.PBo_Flowmainpos = getdialogpos PBo_Flowmain)
		--on Fconnect pressed do PolyBoost.Flowfunc autol.state
-- 		on Flowset pressed do
-- 		(
-- 			if subobjectlevel == 2 then PolyBSetFlow autol.state keyboard.shiftpressed
-- 			else if subobjectlevel == 1 do PolyBSetFlowVertex()
-- 		)
-- 		on Flowspin buttondown do
-- 		(
-- 			PolyBoost.FlowSel = PolyBGetSel 2
-- 			PolyBSetFlowSpinner autol.state 0 0 1
-- 		)
-- 		on Flowspin buttonup do
-- 		(
-- 			Flowspin.value = 0.0
-- 			PolyBAdjustUndo PolyBoost.FlowSel
-- 		)			
-- 		on Flowspin changed val do
-- 		(
-- 			PolyBSetFlowSpinner false val Fspeed.value 0
-- 		)
		on centloop pressed do
		(
			PolyToolsModeling.CenterLoop autol.state
		)
		on Tightspin buttondown do
		(
			PolyBoost.FlowSel = PolyBGetSel 2
			PolyBAdjustSpinner1 autol.state 0 0 1
		)
		on Tightspin buttonup isCancel do 
		(
			Tightspin.value = 0
			if isCancel then PolyBAdjustCancel PolyBoost.FlowSel
			else PolyBAdjustUndo PolyBoost.FlowSel
		)
		on Tightspin changed val do
		(
			if subobjectLevel == 2 do PolyBAdjustSpinner1 false val tperc.value 0
		)
		on Tightspin2 buttondown do
		(
			PolyBoost.FlowSel = PolyBGetSel 2
			PolyBAdjustSpinner2 autol.state 0 0 1
		)
		on Tightspin2 buttonup isCancel do 
		(
			Tightspin2.value = 0
			if isCancel then PolyBAdjustCancel PolyBoost.FlowSel
			else PolyBAdjustUndo PolyBoost.FlowSel
		)
		on Tightspin2 changed val do
		(
			if subobjectLevel == 2 do PolyBAdjustSpinner1 false val tperc.value 0
		)
	)
--PBo_Flowmainpos = undefined
	if PBo_Flowmainpos != undefined then 
	(
		if PBo_Flowmain.dialogbar do (cui.UnRegisterDialogBar PBo_Flowmain ; destroyDialog PBo_Flowmain)
		createdialog PBo_Flowmain ~PBO_FLOWMAIN_X~ 208 PolyBoost.PBo_Flowmainpos.x PolyBoost.PBo_Flowmainpos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing)
	)
	else (createdialog PBo_Flowmain ~PBO_FLOWMAIN_X2~ 208 157 344 style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing))
	cui.RegisterDialogBar PBo_Flowmain minSize:~PBO_FLOWMAIN_MIN_SIZE~ maxSize:~PBO_FLOWMAIN_MAX_SIZE~
),
fn Flowfunc doring =
(
	cursel = modpanel.getcurrentobject()
	if classof cursel == Edit_Poly or PolyBoost.validobjfunc() do undo ~UNDO_FLOW_CONNECT_CAPTION~ on
	(
		if (subobjectLevel == 2) do
		(
			if classof cursel == Edit_Poly then
			(
				if doring do cursel.ButtonOp #SelectEdgeRing
				cursegs = cursel.connectEdgeSegments
				curpinch = cursel.connectEdgePinch
				curslid = cursel.connectEdgeSlide
				cursel.connectEdgePinch = 0
				cursel.connectEdgeSlide = 0
				cursel.connectEdgeSegments = 1
				cursel.ButtonOp #ConnectEdges
				cursel.connectEdgeSegments = cursegs
				cursel.connectEdgePinch = curpinch
				cursel.connectEdgeSlide = curslid
			)
			else
			(
				if doring do $.EditablePoly.SelectEdgeRing ()
				cursegs = $.connectEdgeSegments
				curpinch = $.connectEdgePinch
				curslid = $.connectEdgeSlide
				$.connectEdgePinch = 0
				$.connectEdgeSlide = 0
				$.connectEdgeSegments = 1
				$.EditablePoly.ConnectEdges ()
				$.connectEdgeSegments = cursegs
				$.connectEdgePinch = curpinch
				$.connectEdgeSlide = curslid
			)
			PolyToolsModeling.SetFlow false
		)
	)
),
fn FindUnwrapfunc =
(
	isUnwrap = for m in $.modifiers where classof m == Unwrap_UVW collect m
	isUnwrap.count > 0
),
fn validUV =
(
	if selection.count == 1 and classof $.baseobject == Editable_Poly and PolyBoost.FindUnwrapfunc() and modpanel.getcurrentobject() == $.Unwrap_UVW then true else false
),
fn validUV2 =
(
	if selection.count == 1 and classof $.baseobject == Editable_Poly and PolyBoost.FindUnwrapfunc() and modpanel.getcurrentobject() == $.baseobject then true else false
),
fn validUVlevel level =
(
	uv = modpanel.getcurrentobject()
	if uv.getTVSubObjectMode() == level then true else false
),
fn UV_ToUvfunc =
(
	if PolyBoost.validUV2() do
	(
		sublev = subobjectLevel
		if sublev == 3 then sublev = 2
		else if sublev == 0 then sublev = 1
		else if sublev == 4 or sublev == 5 do sublev = 3
		din = $.modifiers
		nuf = for i = 1 to din.count where classof din[i] == Unwrap_UVW collect i
		flu = nuf[1]
		selfaces = polyop.getFaceSelection $.baseobject
		if sublev == 3 do subobjectlevel = 0
		modpanel.setCurrentObject $.modifiers[flu]
		$.modifiers[#unwrap_uvw].unwrap.edit ()
		PolyBPolyToUV (modpanel.getcurrentobject()) sublev selfaces
	) 
),
fn Resetxfunc =
(
	for i in selection do	
	(
		try(
		local ntm = i.transform
		i.transform=transMatrix i.pos
		local piv = i.objecttransform * inverse i.transform
		i.objectoffsetPos = [0,0,0]
		i.objectoffsetRot = (quat 0 0 0 1)
		i.objectoffsetScale = [1,1,1]
		ntm.translation = [0,0,0]
		ntm = piv * ntm
		local xformMod = xform()
		addmodifier i xformMod
		xformMod.gizmo.transform=ntm
		maxOps.CollapseNode i off
		)catch(continue)
	)
),
fn GetSizefunc =
(
	if selection.count == 1 do
	(
		rollout PBgetroll ~PBGETROLL_DIMENSIONS~
		(
			label xtlab "X:" pos:[8,8]
			label xlab "" pos:[26,8] align: #left
			label ytlab "Y:" pos:[8,24]
			label ylab "" pos:[26,24] align: #left
			label ztlab "Z:" pos:[8,40]
			label zlab "" pos:[26,40] align: #left
			
			on PBgetroll open do
			(
				xlab.text = ($.max.x-$.min.x) as string
				ylab.text = ($.max.y-$.min.y) as string
				zlab.text = ($.max.z-$.min.z) as string
				when geometry $ changes handleAt:#redrawviews id:#Trans do
				(
					xlab.text = ($.max.x-$.min.x) as string
					ylab.text = ($.max.y-$.min.y) as string
					zlab.text = ($.max.z-$.min.z) as string
				)
			)
			on PBgetroll close do deleteAllChangeHandlers id:#Trans
		)
		--PBo_getmain = undefined
		if PBo_getmain != undefined then
		(
			if PBo_getmain.dialogbar do cui.UnRegisterDialogBar PBo_getmain
			getmp = PBo_getmain.pos
			closerolloutFloater PBo_getmain
			PBo_getmain = newrolloutfloater ~PBO_GETMAIN_SIZE_CAPTION~ 110 90 getmp[1] getmp[2]
			PBo_getmain.pos = getmp
		)
		else (PBo_getmain = newrolloutfloater ~PBO_GETMAIN_SIZE_CAPTION2~ 110 90 515 356)
		addrollout PBgetroll PBo_getmain
		cui.RegisterDialogBar PBo_getmain minSize:[114,95] maxSize:[114,95]
	)
),
fn Clonefunc =
(
	if selection.count != 0 do
	(
		aftersel = #()
		for i in selection do
		(
			maxmin = i.max - i.min
			widx = maxmin[1]
			widy = maxmin[2]
			widz = maxmin[3]
			wirecol = i.wirecolor
			if keyboard.shiftpressed then obj2 = instance i
			else obj2 = copy i
			append aftersel obj2
			obj2.wirecolor = wirecol
			camview = Inverse(getViewTM())
			camdir = -camview.row3
			if getRefCoordsys() == #local then
			(
				seldir = obj2.objecttransform
				dirs = #(acos (dot camdir seldir.row1), acos (dot camdir -seldir.row1), acos (dot camdir seldir.row2), acos (dot camdir -seldir.row2), \
				acos (dot camdir seldir.row3), acos (dot camdir -seldir.row3))
				eldodir = finditem dirs (amin dirs)
				movesarr = #([0,-widy,0], [0,widy,0], [widx,0,0], [-widx,0,0], [0,0,-widz], [0,0,widz])
				in coordsys local move obj2 movesarr[eldodir]
			)
			else
			(
				dirs = #(acos (dot camdir [1,0,0]), acos (dot camdir [-1,0,0]), acos (dot camdir [0,1,0]), acos (dot camdir [0,-1,0]), \
				acos (dot camdir [0,0,1]), acos (dot camdir [0,0,-1]))
				eldodir = finditem dirs (amin dirs)
				movesarr = #([0,-widy,0], [0,widy,0], [widx,0,0], [-widx,0,0], [0,0,-widz], [0,0,widz])
				move obj2 movesarr[eldodir]
			)
		)
		select aftersel
	)
),
fn CreatePolygon =
(
	cursel = modpanel.getcurrentobject()
	if classof cursel == Edit_Poly or PolyBoost.validobjfunc() do undo on
	(
		if subobjectlevel == 2 or subobjectlevel == 3 do cursel.ConvertSelection #Edge #Vertex
		PolyToolsModeling.CreateFace (PolyBGetSel 1)
	)
),
fn NumericDfunc =
(
	rollout NMfaceroll ~SELECT_FACES~ rolledup:true
	(
		
		radiobuttons numradio "" labels:#("=","<",">") default: 1 columns: 3 pos:[12,6]
		button numface ~NUMFACE_SIDES_BUTTONTEXT~ height: 17 width: 46 pos:[4,24] tooltip: ~SELECT_POLYGONS_BY_NUMBER_OF_SIDES_TOOLTIP~
		spinner numfacespin "" range:[3,100,3] fieldwidth: 32 pos:[54,24] type:#integer
		button numnquad ~NQUAD_BUTTONTEXT~ height: 17 width: ~NQUAD_WIDTH~ pos:~NQUAD_POSITION~ tooltip: ~NQUAD_TOOLTIP~
		button numopface ~NUMOPFACE_OPEN_BUTTONTEXT~ height: 17 width: 46 pos:[54,42] tooltip: ~NUMOPFACE_TOOLTIP~
		
		on NMfaceroll open do (if subobjectlevel == 4 or subobjectlevel == 5 do NMfaceroll.open = true)
		on numface pressed do undo on
		(
			PolyToolsSelect.NumericFace numfacespin.value numradio.state keyboard.shiftpressed
		)
		on numnquad pressed do undo on (PolyToolsSelect.NumericFace 4 4 keyboard.shiftpressed)
		on numopface pressed do undo on (PolyToolsSelect.NumericFace 4 5 keyboard.shiftpressed)
	)
	rollout NMvertroll ~NMVERTROLL_SELECT_VERTS~ rolledup:true
	(
		
		radiobuttons numradio2 "" labels:#("=","<",">") default: 1 columns: 3 pos:[12,6]
		button numvert ~NUMVERT_EDGES_BUTTONTEXT~ height: 17 width: 46 pos:[4,24] tooltip: ~NUMVERT_TOOLTIP~
		spinner numvertspin "" range:[0,100,5] fieldwidth: 32 pos:[54,24] type:#integer
		button openvert ~OPENVERT_OPEN_BUTTONTEXT~ height: 17 width: 46 pos:[4,42] tooltip: ~OPENVERT_TOOLTIP~
		
		on NMvertroll open do (if subobjectlevel == 1 do NMvertroll.open = true)
		on numvert pressed do undo on
		(
			PolyToolsSelect.NumericVertex numvertspin.value numradio2.state keyboard.shiftpressed
		)
		on openvert pressed do undo on (PolyToolsSelect.NumericVertex 0 4 keyboard.shiftpressed)
	)
	rollout NMedgeroll ~SELECT_EDGES~ rolledup:true
	(
		
		button numopegde ~NUMOPEGDE_OPEN_BUTTONTEXT~ height: 17 width: 46 pos:[4,6] tooltip: ~NUMOPEGDE_TOOLTIP~
		
		on NMedgeroll open do (if subobjectlevel == 2 or subobjectlevel == 3 do NMedgeroll.open = true)
		on numopegde pressed do undo on (PolyToolsSelect.NumericEdge keyboard.shiftpressed)
	)
	--PBo_NMmain = undefined
	if PBo_NMmain != undefined then
	(
		if PBo_NMmain.dialogbar do cui.UnRegisterDialogBar PBo_NMmain
		NMrds = PBo_NMmain.size
		NMrdp = PBo_NMmain.pos
		closerolloutFloater PBo_NMmain
		PBo_NMmain = newrolloutfloater ~NUMERIC~ 117 NMrds[2] NMrdp[1] NMrdp[2]
		PBo_NMmain.pos = NMrdp
	)
	else (PBo_NMmain = newrolloutfloater ~PBO_NMMAIN_NUMERIC~ 117 138 157 240)
	addrollout NMfaceroll PBo_NMmain
	addrollout NMvertroll PBo_NMmain
	addrollout NMedgeroll PBo_NMmain
	cui.RegisterDialogBar PBo_NMmain minSize:[28,28] maxSize:[122,242]
),
fn validSkinMod =
(
	if (selection.count == 1) and classof $.baseobject == Editable_Poly and modpanel.getcurrentobject() == $.modifiers[#Skin] then true else false
),
fn SkinLoopRing type =
(
	if PolyBoost.validSkinMod() == true do
	(
		selbas = $.baseobject
		eff = polyop.getEdgeSelection selbas
		iniv = polyop.getVertSelection selbas
		skinmod = modpanel.getcurrentobject()
		skinc = skinOps.GetNumberVertices skinmod
		selskin = for i = 1 to skinc where (skinOps.IsVertexSelected skinmod i) == 1 collect i
		polyop.setVertSelection selbas selskin
		$.convertSelection #Vertex #Edge requireAll:true
		if type == 1 then $.EditablePoly.SelectEdgeLoop ()
		else $.EditablePoly.SelectEdgeRing ()
		$.EditablePoly.ConvertSelection #Edge #Vertex
		basev = polyop.getVertSelection selbas
		skinops.selectVertices skinmod basev
		polyop.setEdgeSelection selbas eff
		polyop.setVertSelection selbas iniv
		redrawviews()
	)
),
fn SkinElement =
(
	if PolyBoost.validSkinMod() == true do
	(
		skinmod = modpanel.getcurrentobject()
		skinc = skinOps.GetNumberVertices skinmod
		selskin = for i = 1 to skinc where (skinOps.IsVertexSelected skinmod i) == 1 collect i
		baselem = polyop.getElementsUsingFace $.baseobject (polyop.getFacesUsingVert $.baseobject selskin)
		basev = polyop.getVertsUsingFace $.baseobject baselem
		skinops.selectVertices skinmod basev
		redrawviews()
	)
),
fn SkinGrow =
(
	if PolyBoost.validSkinMod() == true do
	(
		skinmod = modpanel.getcurrentobject()
		skinc = skinOps.GetNumberVertices skinmod
		selskin = for i = 1 to skinc where (skinOps.IsVertexSelected skinmod i) == 1 collect i
		basev = polyop.getVertsUsingEdge $.baseobject (polyop.getEdgesUsingVert $.baseobject selskin)
		skinops.selectVertices skinmod basev
		redrawviews()
	)
),
fn SkinShrink =
(
	if PolyBoost.validSkinMod() == true do
	(
		selbas = $.baseobject
		eff = polyop.getEdgeSelection selbas
		iniv = polyop.getVertSelection selbas
		skinmod = modpanel.getcurrentobject()
		skinc = skinOps.GetNumberVertices skinmod
		selskin = for i = 1 to skinc where (skinOps.IsVertexSelected skinmod i) == 1 collect i
		polyop.setVertSelection selbas selskin
		$.convertSelection #Vertex #Edge requireAll:true
		$.convertSelection #Edge #Vertex requireAll:true
		basev = polyop.getVertSelection selbas
		skinops.selectVertices skinmod basev
		polyop.setEdgeSelection selbas eff
		polyop.setVertSelection selbas iniv
		redrawviews()
	)
),
fn validClothmod =
(
	if selection.count == 1 and (classof (modpanel.getcurrentobject()) == Cloth or classof (modpanel.getcurrentobject()) == mcloth) then true else false
),
fn ClothNumberVertices clothObject node =
(
	if (classof clothObject) == Cloth then ( clothobject.numberVertices node ) else clothobject.numberVertices()
),
fn ClothSelectVertices clothObject sel node =
(
	if (classof clothObject) == Cloth then ( clothobject.selectVertices sel node) else ( clothobject.selectVertices sel )
),
fn ClothGetSelectVertices clothObject node =
(
	if (classof clothObject) == Cloth then ( clothobject.getSelectedVertices node) else ( clothobject.getSelectedVertices() )
),
fn ClothLoopRing type =
(
	if PolyBoost.validClothmod() == true do
	(
		selbas = $.baseobject
		if classof selbas == Editable_Poly then basenum = polyop.getNumVerts selbas else basenum = undefined
		clothobj = modpanel.getcurrentobject()
		clonum = PolyBoost.ClothNumberVertices clothobj  $
		if classof selbas == Editable_Poly and basenum == clonum then
		(
			closel = PolyBoost.ClothGetSelectVertices clothobj $
			yesed = #()
			for i in closel do
			(
				dise = polyop.getEdgesUsingVert selbas i
				othe = polyop.getEdgesUsingVert selbas (closel - #{i}) as array
				for d in dise where finditem othe d != 0 do append yesed d
			)
			polyop.setEdgeSelection selbas yesed
			if type == 1 then $.EditablePoly.SelectEdgeLoop () else $.EditablePoly.SelectEdgeRing ()
			basv = polyop.getVertsUsingEdge selbas (polyop.getEdgeSelection selbas)
			redrawviews()
			PolyBoost.ClothSelectVertices clothobj basv $
		)
		else
		(
			disablesceneredraw()
			clothobj = modpanel.getcurrentobject()
			allmo = $.modifiers.count
			modnum = modPanel.getModifierIndex $ clothobj
			closel = PolyBoost.ClothGetSelectVertices clothobj $
			clotempobj = snapshot $
			convertTo clotempobj Editable_Poly
			polyop.setVertSelection clotempobj.baseobject closel
			clotempobj.convertSelection #Vertex #Edge requireAll:true
			if type == 1 then clotempobj.EditablePoly.SelectEdgeLoop () else clotempobj.EditablePoly.SelectEdgeRing ()
			clotempobj.EditablePoly.ConvertSelection #Edge #Vertex
			basv = polyop.getVertSelection clotempobj.baseobject
			delete clotempobj
			if allmo != modnum do modPanel.setCurrentObject $.modifiers[modnum] node:$
			PolyBoost.ClothSelectVertices clothobj basv $
			enablesceneredraw()
			subobjectlevel = 1
		)
	)
),
fn ClothElement =
(
	if PolyBoost.validClothmod() == true do
	(
		selbas = $.baseobject
		if classof selbas == Editable_Poly then basenum = polyop.getNumVerts selbas else basenum = undefined
		clothobj = modpanel.getcurrentobject()
		clonum = PolyBoost.ClothNumberVertices clothobj $
		if classof selbas == Editable_Poly and basenum == clonum then
		(
			closel = PolyBoost.ClothGetSelectVertices clothobj $
			baselem = polyop.getElementsUsingFace selbas (polyop.getFacesUsingVert selbas closel)
			basv = polyop.getVertsUsingFace selbas baselem
			redrawviews()
			PolyBoost.ClothSelectVertices clothobj basv $
		)
		else
		(
			disablesceneredraw()
			clothobj = modpanel.getcurrentobject()
			allmo = $.modifiers.count
			modnum = modPanel.getModifierIndex $ clothobj
			closel = PolyBoost.ClothGetSelectVertices clothobj $
			clotempobj = snapshot $
			convertTo clotempobj Editable_Poly
			baselem = polyop.getElementsUsingFace clotempobj.baseobject (polyop.getFacesUsingVert clotempobj.baseobject closel)
			basv = polyop.getVertsUsingFace clotempobj.baseobject baselem
			delete clotempobj
			if allmo != modnum do modPanel.setCurrentObject $.modifiers[modnum] node:$
			PolyBoost.ClothSelectVertices clothobj basv $
			enablesceneredraw()
			subobjectlevel = 1
		)
	)
),
fn ClothGrowShrink type =
(
	if PolyBoost.validClothmod() == true do
	(
		selbas = $.baseobject
		if classof selbas == Editable_Poly then basenum = polyop.getNumVerts selbas else basenum = undefined
		clothobj = modpanel.getcurrentobject()
		clonum = PolyBoost.ClothNumberVertices clothobj $
		if classof selbas == Editable_Poly and basenum == clonum then
		(
			closel = PolyBoost.ClothGetSelectVertices clothobj $
			if type == 1 then basv = polyop.getVertsUsingEdge selbas (polyop.getEdgesUsingVert selbas closel)
			else
			(
				iniv = polyop.getVertSelection selbas
				polyop.setVertSelection selbas closel
				$.EditablePoly.ShrinkSelection selLevel:#Vertex
				basv = polyop.getVertSelection selbas
				polyop.setVertSelection selbas iniv
			)
			redrawviews()
			PolyBoost.ClothSelectVertices clothobj basv $
		)
		else
		(
			disablesceneredraw()
			clothobj = modpanel.getcurrentobject()
			allmo = $.modifiers.count
			modnum = modPanel.getModifierIndex $ clothobj
			closel = PolyBoost.ClothGetSelectVertices clothobj $
			clotempobj = snapshot $
			convertTo clotempobj Editable_Poly
			if type == 1 then basv = polyop.getVertsUsingEdge clotempobj.baseobject (polyop.getEdgesUsingVert clotempobj.baseobject closel)
			else
			(
				polyop.setVertSelection clotempobj.baseobject closel
				clotempobj.EditablePoly.ShrinkSelection selLevel:#Vertex
				basv = polyop.getVertSelection clotempobj.baseobject
			)
			delete clotempobj
			if allmo != modnum do modPanel.setCurrentObject $.modifiers[modnum] node:$
			PolyBoost.ClothSelectVertices clothobj basv $
			enablesceneredraw()
			subobjectlevel = 1
		)
	)
),
fn SmartRotate rdeg =
(
	if selection.count != 0 do
	(
		camview = Inverse(getViewTM())
		camdir = camview.row3
		cosys = getRefCoordsys()
		if selection.count == 1 and subobjectlevel != 0 and subobjectlevel != undefined then
		(
			if (Modpanel.getcurrentObject () == $.baseobject) and (classof $.baseobject == Editable_Poly) do
			(
				dosys = 1
				if cosys == #local then dosys = 2
				else if cosys == #screen do dosys = 3
				PolyToolsModeling.RotateSelection rdeg dosys camdir
			)
		)
		else if subobjectlevel == 0 or subobjectlevel == undefined do undo ~ROTATION_SELECTION~ on
		(
			for i in selection do
			(
				doDeg = rdeg
				if cosys == #screen then (allax = #(camdir) ; axdo = 1)
				else
				(
					if cosys == #local then (seldir = i.objecttransform ; comp = #(dot camdir seldir.row1, dot camdir seldir.row2, dot camdir seldir.row3))
					else comp = #(dot camdir [1,0,0], dot camdir [0,1,0], dot camdir [0,0,1])
					comp2 = for t in comp collect (if t < 0 then -t else t)
					axdo = finditem comp2 (amax comp2)
					allax = #([1,0,0],[0,1,0],[0,0,1])
					if comp[axdo] > 0 do doDeg = -doDeg
				)
				if cosys == #screen then rotate i (angleaxis -doDeg allax[axdo])
				else if cosys == #local then in coordsys local rotate i (angleaxis doDeg allax[axdo])
				else rotate i (angleaxis doDeg allax[axdo])
			)
		)
	)
),
fn SetSizefunc val state =
(
	if selection.count != 0 do undo ~SET_SIZE~ on
	(
		for i in selection do
		(
			try(selscale = i.scale)catch(continue) --skip biped objects and other potential objects that does not have scale property
			minmax = i.max - i.min
			if state == 1 and minmax.x != 0 then i.scale.x = (val * i.scale.x) / minmax.x
			else if state == 2 and minmax.y != 0 then i.scale.y = (val * i.scale.y) / minmax.y
			else if state == 3 and minmax.z != 0 then i.scale.z = (val * i.scale.z) / minmax.z
			else if state == 4 do
			(
				if  minmax.x != 0 do i.scale.x = (val * i.scale.x) / minmax.x
				if  minmax.y != 0 do i.scale.y = (val * i.scale.y) / minmax.y
				if  minmax.z != 0 do i.scale.z = (val * i.scale.z) / minmax.z
			)
			if (classof i.baseobject == Editable_Poly and i.modifiers.count == 0) do
			(
				disablesceneredraw()
				setshow = false
				if showEndResult do (setshow = true ; showEndResult = false)
				ptempobji = snapshot i
				i.scale = selscale
				PolyBSetSize ptempobji i
				delete ptempobji
				if setshow do showEndResult = true
				enablesceneredraw()
				redrawviews()
			)
		)
	)
),
fn UVtweakgo mchannel =
(
	max modify mode
	if PolyBoost.validobjfunc() then
	(
		if (polyOp.getMapSupport $.baseobject mchannel) then
		(
			$.EditablePoly.DeleteIsoMapVerts ()
			PolyBUVWTweakSetup mchannel
			PBStartTrack PolyBUVWTweak
		)
		else messagebox ~MSGBOX_MAPCHANNEL_DOES_NOT_EXIST~ title:~UVW_TWEAK~
	)
	else (messagebox ~MSGBOX_NEED_EDITABLE_POLY_OBJ_SELECTED~ title:~UVW_TWEAK_TITLE~)
),
fn topology =
(
	global PBPTmainroll
	rollout PTroll ~PROCEDURAL~
	(
		button PTdo "" height: 26 width: 26 offset:[-43,-2] iconName:"PolyTools/Topology/Wall" tooltip:~WALL_TOOLTIP~
		button PTtwomos "" height: 26 width: 26 offset:[-15,-31] iconName:"PolyTools/Topology/Tiles" tooltip:~TILES_TOOLTIP~
		button PTbricks "" height: 26 width: 26 offset:[13,-31] iconName:"PolyTools/Topology/Brick" tooltip:~PTBRICKS_TOOLTIP~
		button PThive "" height: 26 width: 26 offset:[41,-31] iconName:"PolyTools/Topology/Hive" tooltip:~PTHIVE_TOOLTIP~
		button PTtile2 "" height: 26 width: 26 offset:[-43,-3] iconName:"PolyTools/Topology/Tiles2" tooltip:~PTTILE2_TOOLTIP~
		button PTmos "" height: 26 width: 26 offset:[-15,-31] iconName:"PolyTools/Topology/Mosaic" tooltip:~PTMOS_TOOLTIP~
		button PTfloor "" height: 26 width: 26 offset:[13,-31] iconName:"PolyTools/Topology/Floor" tooltip:~PTFLOOR_TOOLTIP~
		button PTfloor2 "" height: 26 width: 26 offset:[41,-31] iconName:"PolyTools/Topology/Floor2" tooltip:~PTFLOOR2_TOOLTIP~
		button PTskin "" height: 26 width: 26 offset:[-43,-3] iconName:"PolyTools/Topology/Skin" tooltip:~PTSKIN_TOOLTIP~
		button PTholer "" height: 26 width: 26 offset:[-15,-31] iconName:"PolyTools/Topology/Holer" tooltip:~PTHOLER_TOOLTIP~
		button PTedgedir "" height: 26 width: 26 offset:[13,-31] iconName:"PolyTools/Topology/EdgeDirection" tooltip:~PTEDGEDIR_TOOLTIP~
		button PTsim "" height: 26 width: 26 offset:[41,-31] iconName:"PolyTools/Topology/Simplify" tooltip:~PTSIM_TOOLTIP~
		button PTchaos "" height: 26 width: 26 offset:[-43,-3] iconName:"PolyTools/Topology/Chaos" tooltip:~PTCHAOS_TOOLTIP~
		button PTfours "" height: 26 width: 26 offset:[-15,-31] iconName:"PolyTools/Topology/Fours" tooltip:~PTFOURS_TOOLTIP~
		button PTstar "" height: 26 width: 26 offset:[13,-31] iconName:"PolyTools/Topology/SmoothStar" tooltip:~PTSTAR_TOOLTIP~
		button PTcross "" height: 26 width: 26 offset:[41,-31] iconName:"PolyTools/Topology/Cross" tooltip:~PTCROSS_TOOLTIP~
		button PTplanks "P1" height: 26 width: 26 offset:[-43,-3] iconName:"PolyTools/Topology/Planks" tooltip:~PTPLANKS_TOOLTIP~
		button PTplanks2 "P2" height: 26 width: 26 offset:[-15,-31] iconName:"PolyTools/Topology/Planks2" tooltip:~PTPLANKS2_TOOLTIP~
		button PTplanks3 "P3" height: 26 width: 26 offset:[13,-31] iconName:"PolyTools/Topology/Planks3" tooltip:~PTPLANKS3_TOOLTIP~
		button PTplanks4 "P4" height: 26 width: 26 offset:[41,-31] iconName:"PolyTools/Topology/Planks4" tooltip:~PTPLANKS4_TOOLTIP~
		group ~GROUP_TATTER~
		(
			button PTnet "" height: 26 width: 26 iconName:"PolyTools/Topology/Tatter" offset:~PTNET_OFFSET~ tooltip:~PTNET_TOOLTIP~
			spinner netval ~NETVAL_SIZE_CAPTION~ range:[1,100,1] type:#integer fieldwidth: 32  offset:[3,-21]
			spinner netran ~NETRAN_ITERATIONS_CAPTION~ range:[1,100,3] type:#integer fieldwidth: 32  offset:[3,-1]
			spinner netrel ~NETREL_SMOOTH_CAPTION~ range:[0,4,3] type:#integer fieldwidth: 32  offset:[3,-1]
		)
		button PTremo ~PTREMO_SCRAPVERTS~ height: 17 width:~PTREMO_WIDTH~ tooltip:~PTREMO_TOOLTIP~
		button PTplane ~PTPLANE_BUTTONTEXT~ height: 17 width: 46 offset:[-32,1] tooltip:~PTPLANE_TOOLTIP~
		spinner planS "S:" range:[1,1000,26] type:#integer fieldwidth: 32 offset:[3,-21]
		
		on PTdo pressed do undo ~UNDO_TOPOLOGY_WALL~ on (PolyToolsTopology.Wall())
		on PTtwomos pressed do undo ~UNDO_TOPOLOGY_TILES~ on (PolyToolsTopology.Tiles1())
		on PTbricks pressed do undo ~UNDO_TOPOLOGY_BRICK~ on (PolyToolsTopology.Brick())
		on PThive pressed do undo ~UNDO_TOPOLOGY_HIVE~ on (PolyToolsTopology.Hive())
		on PTtile2 pressed do undo ~UNDO_TOPOLOGY_TILES2~ on (PolyToolsTopology.Tiles2())
		on PTmos pressed do undo ~UNDO_TOPOLOGY_MOSIAC~ on (PolyToolsTopology.Mosiac())
		on PTfloor pressed do undo ~UNDO_TOPOLOGY_FLOOR~ on (PolyToolsTopology.Floor1())
		on PTfloor2 pressed do undo ~UNDO_TOPOLOGY_FLOOR2~ on (PolyToolsTopology.Floor2())
		on PTskin pressed do undo ~UNDO_TOPOLOGY_SKIN~ on (PolyToolsTopology.Skin())
		on PTholer pressed do undo ~UNDO_TOPOLOGY_HOLER~ on (PolyToolsTopology.Holer())
		on PTedgedir pressed do undo ~UNDO_TOPOLOGY_EDGEDIR~ on (PolyToolsTopology.EdgeDirection())
		on PTsim pressed do undo ~UNDO_TOPOLOGY_SIMPLIFY~ on (PolyToolsTopology.Simplify())
		on PTchaos pressed do undo ~UNDO_TOPOLOGY_CHAOS~ on (PolyToolsTopology.Chaos())
		on PTfours pressed do undo ~UNDO_TOPOLOGY_FOURS~ on (PolyToolsTopology.Fours())
		on PTstar pressed do undo ~UNDO_TOPOLOGY_SMOOTHSTAR~ on (PolyToolsTopology.SmoothStar())
		on PTcross pressed do undo ~UNDO_TOPOLOGY_CROSS~ on (PolyToolsTopology.Cross())
		on PTplanks pressed do undo ~UNDO_TOPOLOGY_PLANKS1~ on (PolyToolsTopology.Planks1())
		on PTplanks2 pressed do undo ~UNDO_TOPOLOGY_PLANKS2~ on (PolyToolsTopology.Planks2())
		on PTplanks3 pressed do undo ~UNDO_TOPOLOGY_PLANKS3~ on (PolyToolsTopology.Planks3())
		on PTplanks4 pressed do undo ~UNDO_TOPOLOGY_PLANKS4~ on (PolyToolsTopology.Planks4())
		on PTremo pressed do undo ~PTREMO_UNDO_SCRAPVERTS~ on (PolyToolsTopology.ScrapVerts())
		on PTplane pressed do undo ~PTPLANE_UNDO_PLANE_BUTTONTEXT~ on
		(
			daplan = plane width: 120 length: 120 widthsegs: planS.value lengthsegs: planS.value mapcoords: true isselected: on wirecolor: (color 50 70 90)
			convertTo daplan Editable_Poly
		)
		on PTnet pressed do
		(
			max modify mode
			disablesceneredraw()
			setWaitCursor()
			undo ~UNDO_TOPOLOGY_TATTER~ on
			(
				PolyToolsTopology.Tatter netval.value netran.value netrel.value
			)
			setArrowCursor()
			enablesceneredraw()
			redrawviews()
		)
	)
	--PBPTmainroll = undefined
	if PBPTmainroll != undefined then
	(
		if PBPTmainroll.dialogbar do cui.UnRegisterDialogBar PBPTmainroll
		PBps = PBPTmainroll.size
		PBpp = PBPTmainroll.pos
		closerolloutFloater PBPTmainroll
		PBPTmainroll = newrolloutfloater ~PBPTMAINROLL_TOPOLOGY~ PBps[1] PBps[2] PBpp[1] PBpp[2]
		PBPTmainroll.pos = PBpp
	)
	else PBPTmainroll = newrolloutfloater ~PBPTMAINROLL_TOPOLOGY2~ 134 316 146 115
	addrollout PTroll PBPTmainroll
	cui.RegisterDialogBar PBPTmainroll minSize:[138,320] maxSize:[138,324]
),
fn SymmetryD =
(
	rollout PBo_SDmain ~SYMMETRY_TOOLS~
	(
		pickbutton sympick ~SYMPICK_BUTTONTEXT~ height:20 width:~SYMPICK_WIDTH~ align:#center tooltip: ~SYMPICK_TOOLTIP~
		label axilab ~LABEL_AXIS_CAPTION~ offset:[-50,6]
		radiobuttons axirad "" labels:#("X","Y","Z") default:1 columns:3 offset:[20,-18]
		spinner symspin ~SYMSPIN_TOLERANCE_CAPTION~ range:[0.001,100000.0,0.005] scale:0.005 fieldwidth:50 align:#center offset:[0,2]
		group ~GROUP_MAKE_SYMMETRICAL~
		(
			button symbut ~SYMBUT_BUTTONTEXT~ height:17 width:58 offset:[-31,0] tooltip:~SYMBUT_TOOLTIP~
			button symbut2 ~SYMBUT2_BUTTONTEXT~ height:17 width:58 offset:[31,-22] tooltip:~SYMBUT2_TOOLTIP~
			button symflip ~SYMFLIP_BUTTONTEXT~ height:17 width:120 tooltip:~SYMFLIP_TOOLTIP~
		)
		group ~GROUP_VERTEX_POSITIONS~
		(
			button symcopy ~SYMCOPY_COPY_SELECTED_BUTTONTEXT~ height:17 width:120 offset:[0,0] tooltip:~SYMCOPY_TOOLTIP~
			button sympast ~PASTE_BUTTONTEXT~ height:17 width:120 offset:[0,0] tooltip:~SYMPAST_TOOLTIP~
		)
		on PBo_SDmain open do
		(
			if SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly do
			(
				sympick.text = SymmetryMainModel.name
			)
		)
		on PBo_SDmain close do (PolyBoost.PBo_SDmainpos = getdialogpos PBo_SDmain)
		on sympick picked obj do 
		(
			max modify mode
			if classof obj == Editable_Poly then
			(
				setWaitCursor()
				doaxis = #X
				if axirad.state == 2 then doaxis = #Y
				else if axirad.state == 3 do doaxis = #Z
				symresult = PolyToolsModeling.SymmetryGather obj doaxis symspin.value
				SymmetryMainModel = obj
				sympick.text = obj.name
				setArrowCursor()
			)
			else
			(
				sympick.text = ~PICK_MAIN_MODEL~
				messagebox ~MSGBOX_PICK_EDITABLE_POLY_OBJ~ title:"PolyBoost"
			)
		)
		on axirad changed state do
		(
			if SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly do
			(
				setWaitCursor()
				doaxis = #X
				if state == 2 then doaxis = #Y
				else if state == 3 do doaxis = #Z
				PolyToolsModeling.SymmetryGather SymmetryMainModel doaxis symspin.value
				setArrowCursor()
			)
		)
		on symbut pressed do undo on
		(
			max modify mode
			doaxis = #X
			if axirad.state == 2 then doaxis = #Y
			else if axirad.state == 3 do doaxis = #Z
			PolyToolsModeling.SymmetryPosToNeg doaxis
		)
		on symbut2 pressed do undo on
		(
			max modify mode
			doaxis = #X
			if axirad.state == 2 then doaxis = #Y
			else if axirad.state == 3 do doaxis = #Z
			PolyToolsModeling.SymmetryNegToPos doaxis
		)
		on symflip pressed do undo on
		(
			max modify mode
			doaxis = #X
			if axirad.state == 2 then doaxis = #Y
			else if axirad.state == 3 do doaxis = #Z
			PolyToolsModeling.SymmetryFlip doaxis
		)
		on symcopy pressed do
		(
			max modify mode
			PolyToolsModeling.SymmetryCopy()
		)
		on sympast pressed do undo on
		(
			max modify mode
			PolyToolsModeling.SymmetryPaste()
		)
	)
	if PBo_SDmainpos != undefined then 
	(
		if PBo_SDmain.dialogbar do (cui.UnRegisterDialogBar PBo_SDmain ; destroyDialog PBo_SDmain)
		createdialog PBo_SDmain 144 217 PolyBoost.PBo_SDmainpos.x PolyBoost.PBo_SDmainpos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing)
	)
	else (createdialog PBo_SDmain 144 217 157 344 style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing))
	cui.RegisterDialogBar PBo_SDmain minSize:[28,28] maxSize:[142,217]
),
fn PasteSelection type =
(
	if type == 1 then undo ~UNDO_PASTE_SELECTION_CAPTION~ on
	(
		if SelStorage1 == undefined then messagebox ~MSGBOX_NO_SELECTION_STORED~ title: ~MSGBOX_NO_SELECTION_STORED_TITLE~
		else
		(
			if (subobjectLevel == 1) then
			(
				if keyboard.shiftpressed then PolyBSetSel 1 (SelStorage1 + (PolyBGetSel 1))
				else PolyBSetSel 1 SelStorage1
			)
			else if (subobjectLevel == 2) or (subobjectLevel == 3) then
			(
				if keyboard.shiftpressed then PolyBSetSel 2 (SelStorage1 + (PolyBGetSel 2))
				else PolyBSetSel 2 SelStorage1
			)
			else if (subobjectLevel == 4) or (subobjectLevel == 5) then
			(
				if keyboard.shiftpressed then PolyBSetSel 3 (SelStorage1 + (PolyBGetSel 3))
				else PolyBSetSel 3 SelStorage1
			)
			redrawviews()
		)
	)
	else undo ~UNDO_PASTE_SELECTION_CAPTION2~ on
	(
		if SelStorage2 == undefined then messagebox ~MSGBOX_NO_SELECTION_STORED2~ title: ~MSGBOX_NO_SELECTION_STORED2_TITLE~
		else
		(
			if (subobjectLevel == 1) then
			(
				if keyboard.shiftpressed then PolyBSetSel 1 (SelStorage2 + (PolyBGetSel 1))
				else PolyBSetSel 1 SelStorage2
			)
			else if (subobjectLevel == 2) or (subobjectLevel == 3) then
			(
				if keyboard.shiftpressed then PolyBSetSel 2 (SelStorage2 + (PolyBGetSel 2))
				else PolyBSetSel 2 SelStorage2
			)
			else if (subobjectLevel == 4) or (subobjectLevel == 5) then
			(
				if keyboard.shiftpressed then PolyBSetSel 3 (SelStorage2 + (PolyBGetSel 3))
				else PolyBSetSel 3 SelStorage2
			)
			redrawviews()
		)
	)
),
fn StoreApply type =
(
	if type == 1 then undo ~UNDO_ADD_SELECTIONS~ on
	(
		if SelStorage1 == undefined or SelStorage2 == undefined then messagebox ~MSGBOX_THERE_ARE_NOT_2_SELECTIONS_STORED~ title: ~MSGBOX_NO_SELECTION_STORED3_TITLE~
		else
		(
			if (subobjectLevel == 1) then
			(
				if keyboard.shiftpressed then PolyBSetSel 1 ((SelStorage1 + SelStorage2) + (PolyBGetSel 1))
				else PolyBSetSel 1 (SelStorage1 + SelStorage2)
			)
			else if (subobjectLevel == 2) or (subobjectLevel == 3) then
			(
				if keyboard.shiftpressed then PolyBSetSel 2 ((SelStorage1 + SelStorage2) + (PolyBGetSel 2))
				else PolyBSetSel 2 (SelStorage1 + SelStorage2)
			)
			else if (subobjectLevel == 4) or (subobjectLevel == 5) then
			(
				if keyboard.shiftpressed then PolyBSetSel 3 ((SelStorage1 + SelStorage2) + (PolyBGetSel 3))
				else PolyBSetSel 3 (SelStorage1 + SelStorage2)
			)
			SelStorage1 = undefined
			SelStorage2 = undefined
			redrawviews()
		)
	)
	else if type == 2 then undo ~UNDO_SUBTRACT_SELECTIONS~ on
	(
		if SelStorage1 == undefined or SelStorage2 == undefined then messagebox ~MSGBOX_THERE_ARE_NOT_2_SELECTIONS_STORED2~ title: ~MSGBOX_THERE_ARE_NOT_2_SELECTIONS_STORED2_TITLE~
		else
		(
			if (subobjectLevel == 1) then
			(
				if keyboard.shiftpressed then PolyBSetSel 1 ((SelStorage1 - SelStorage2) + (PolyBGetSel 1))
				else PolyBSetSel 1 (SelStorage1 - SelStorage2)
			)
			else if (subobjectLevel == 2) or (subobjectLevel == 3) then
			(
				if keyboard.shiftpressed then PolyBSetSel 2 ((SelStorage1 - SelStorage2) + (PolyBGetSel 2))
				else PolyBSetSel 2 (SelStorage1 - SelStorage2)
			)
			else if (subobjectLevel == 4) or (subobjectLevel == 5) then
			(
				if keyboard.shiftpressed then PolyBSetSel 3 ((SelStorage1 - SelStorage2) + (PolyBGetSel 3))
				else PolyBSetSel 3 (SelStorage1 - SelStorage2)
			)
			SelStorage1 = undefined
			SelStorage2 = undefined
			redrawviews()
		)
	)
	else if type == 3 then undo ~INTERSECT_SELECTIONS~ on
	(
		if SelStorage1 == undefined or SelStorage2 == undefined then messagebox ~MSGBOX_THERE_ARE_NOT_2_SEL_STORED~ title: ~MSGBOX_THERE_ARE_NOT_2_SEL_STORED_TITLE~
		else
		(
			if (subobjectLevel == 1) then
			(
				if keyboard.shiftpressed then PolyBSetSel 1 ((SelStorage1 * SelStorage2) + (PolyBGetSel 1))
				else PolyBSetSel 1 (SelStorage1 * SelStorage2)
			)
			else if (subobjectLevel == 2) or (subobjectLevel == 3) then
			(
				if keyboard.shiftpressed then PolyBSetSel 2 ((SelStorage1 * SelStorage2) + (PolyBGetSel 2))
				else PolyBSetSel 2 (SelStorage1 * SelStorage2)
			)
			else if (subobjectLevel == 4) or (subobjectLevel == 5) then
			(
				if keyboard.shiftpressed then PolyBSetSel 3 ((SelStorage1 * SelStorage2) + (PolyBGetSel 3))
				else PolyBSetSel 3 (SelStorage1 * SelStorage2)
			)
			SelStorage1 = undefined
			SelStorage2 = undefined
			redrawviews()
		)
	)
	else --Clear
	(
		SelStorage1 = undefined
		SelStorage2 = undefined
	)
	PolyToolsUI.StoreSelButton1 = false
	PolyToolsUI.StoreSelButton2 = false
	updateToolbarButtons()
),
fn InsertVertex =
(
	PolyToolsModeling.InsertVertex PolyToolsUI.InsertV
),
fn TopsSelect type =
(
	if type == 1 then PolyToolsSelect.Tops false
	else PolyToolsSelect.Tops true
),
fn LoopSelect type =
(
	if type == 1 and not keyboard.shiftpressed then PolyToolsSelect.Loop false
	else PolyToolsSelect.Loop true
),
fn StepLoopSelect type =
(
	if type == 1 then PolyToolsSelect.StepLoop  false
	else PolyToolsSelect.StepLoop true
),
fn DotLoopSelect type =
(
	if type == 1 then
	(
		PolyToolsSelect.DotLoop PolyToolsUI.DotLoopGap false false
	)
	else if type == 2 then
	(
		PolyToolsSelect.DotLoop PolyToolsUI.DotLoopGap false true
	)
	else
	(
		PolyToolsSelect.DotLoop PolyToolsUI.DotLoopGap true false
	)
),
fn RandomSelect type =
(
	if type == 1 then
	(
		PolyToolsSelect.Random PolyToolsUI.RandomPercent PolyToolsUI.RandomNumber PolyToolsUI.RandomType false
	)
	else 
	(
		PolyToolsSelect.Random PolyToolsUI.RandomPercent PolyToolsUI.RandomNumber PolyToolsUI.RandomType true
	)
),
fn Quadrify type =
(
	if type == 1 then PolyToolsModeling.Quadrify false false
	else if type == 2 then PolyToolsModeling.Quadrify true false
	else if type == 3 then PolyToolsModeling.Quadrify false true
	else PolyToolsModeling.Quadrify true true
),
fn TransformRollout =
(
	if PolyBoost.TransformDialogOpen then
	(
		if PBo_transmain.dialogbar do (cui.UnRegisterDialogBar PBo_transmain ; destroyDialog PBo_transmain)
		PolyBoost.TransformDialogOpen = false
	)
	else
	(
		rollout PBo_transmain ~TRANSFORM_TOOLBOX~
		(
			group ~GROUP_ROTATE~
			(
				dropdownlist degdrop "" items:#("1","5","10","20","30","45","60","90","120","180","240") selection:8 height:12 width:~DEGDROP_WIDTH~ offset:~DEGDROP_OFFSET~
				button rcw "" height:20 width:29 offset:[36,-26] iconName:"Common/RotateCW" iconSize:[20,20] tooltip: ~RCW_TOOLTIP~
				button rccw "" height:20 width:29 offset:[2,-25] iconName:"Common/RotateCCW" iconSize:[20,20]tooltip: ~RCCW_BUTTONTEXT~
				spinner rotspin ~ROTSPIN_DEGREES~ range:[0,360,90] fieldwidth:36 scale:1 align:#center
			)
			group ~GROUP_SIZE~
			(
				button setsize ~SET_SIZE_BUTTONTEXT~ height:17 width:~SET_SIZE_WIDTH~ offset:[0,-4] tooltip: ~SET_SIZE_TOOLTIP~
				button restr ~RESTR_BUTTONTEXT~ height:17 width:~RESTR_WIDTH~ offset:~RESTR_OFFSET~ tooltip: ~RESTR_TOOLTIP~
				spinner sizspin ~SIZSPIN_GROUP_SIZE~  range:[0,1000000,20] fieldwidth:~SIZSPIN_GROUP_FIELDWIDTH~ scale:1 align:#center
				radiobuttons sizeradio "" labels:#("X","Y","Z",~SIZERADIO_ALL_SELECTION~) default:3 columns:~SIZERADIO_COLUMNS~  offset:~SIZERADIO_OFFSET~
				button getsize ~GETSIZE_BUTTONTEXT~ height:17 width:~GETSIZE_WIDTH~ offset:~GETSIZE_OFFSET~ tooltip: ~GETSIZE_TOOLTIP~
				button getsetsize height:17 width:19 offset:~GETSETSIZE_OFFSET~ iconName:"PolyTools/TransformTools/PB_ArrowUp" iconSize:[20,20] tooltip: ~GETSETSIZE_TOOLTIP~
			)
			group ~GROUP_ALIGN_PIVOT~
			(
				radiobuttons pivradios "" labels:#(~MIN~,~MAX~,~CENTER~,~ORIGIN~) default:1 columns:2
				button alignpx "X" height:17 width:24 offset:[-30,-3] tooltip: ~ALIGN_PIVOT_TOOLTIP~
				button alignpy "Y" height:17 width:24 offset:[0,-22] tooltip: ~ALIGN_PIVOT_Y_TOOLTIP~
				button alignpz "Z" height:17 width:24 offset:[30,-22] tooltip: ~ALIGN_PIVOT_Z_TOOLTIP~
				button centp ~CENTP_CENTER_BUTTONTEXT~ height:17 width:57 offset:[-30,-3] tooltip: ~CENTP_CENTER_TOOLTIP~
				button orip ~ORIGIN_BUTTONTEXT~ height:17 width:57 offset:[30,-22] tooltip: ~ORIP_TOOLTIP~
			)
			group ~GROUP_OBJECT~
			(
				button objcenter ~OBJCENTER_BUTTONTEXT~ height:17 width:~OBJCENTER_WIDTH~ offset:~OBJCENTER_OFFSET~ tooltip: ~OBJCENTER_TOOLTIP~
				button cloner ~CLONER_QCLONE_BUTTONTEXT~ height:17 width:~CLONER_QCLONE_WIDTH~ offset:~CLONER_OFFSET~ tooltip: ~CLONER_QCLONE_TOOLTIP~
			)
			
			on PBo_transmain close do
			(
				PolyBoost.PBo_transmainpos = getdialogpos PBo_transmain
				PolyBoost.TransformDialogOpen = false
			)
			on PBo_transmain open do
			(
			)
			on degdrop selected state do
			(
				rotspin.value = degdrop.selected as integer
				rotspin.value = degdrop.selected as integer
			)
			on rcw pressed do PolyBoost.SmartRotate rotspin.value
			on rccw pressed do PolyBoost.SmartRotate -rotspin.value
			on getsize pressed do PolyBoost.GetSizefunc()
			on getsetsize pressed do
			(
				if selection.count == 1 do
				(
					if sizeradio.state == 1 then sizspin.value = $.max.x - $.min.x
					else if sizeradio.state == 2 then sizspin.value = $.max.y - $.min.y
					else if sizeradio.state == 3 do sizspin.value = $.max.z - $.min.z
				)
			)
			on setsize pressed do PolyBoost.SetSizefunc sizspin.value sizeradio.state
			on sizeradio changed state do
			(
				if state == 4 then getsetsize.enabled = false
				else getsetsize.enabled = true
			)
			on restr pressed do undo ~UNDO_RESET_TRANSFORM~ on PolyBoost.Resetxfunc()
			on alignpx pressed do undo ~UNDO_ALIGN_PIVOT~ on
			(
				for i in selection do
				(
					try(
					if pivradios.state == 1 then i.pivot.x = i.min.x
					else if pivradios.state == 2 then i.pivot.x = i.max.x
					else if pivradios.state == 3 then i.pivot.x = i.center.x
					else i.pivot.x = 0.0
					)catch(continue)
				)
			)
			on alignpy pressed do undo ~ALIGNPY_UNDO_ALIGN_PIVOT~ on
			(
				for i in selection do
				(
					try(
					if pivradios.state == 1 then i.pivot.y = i.min.y
					else if pivradios.state == 2 then i.pivot.y = i.max.y
					else if pivradios.state == 3 then i.pivot.y = i.center.y
					else i.pivot.y = 0.0
					)catch(continue)
				)
			)
			on alignpz pressed do undo ~ALIGNPZ_UNDO_ALIGN_PIVOT~ on
			(
				for i in selection do
				(
					try(
					if pivradios.state == 1 then i.pivot.z = i.min.z
					else if pivradios.state == 2 then i.pivot.z = i.max.z
					else if pivradios.state == 3 then i.pivot.z = i.center.z
					else i.pivot.z = 0.0
					)catch(continue)
				)
			)
			on centp pressed do undo ~UNDO_CENTER_PIVOT~ on
			(
				for i in selection do
				(
					try(i.pivot = i.center)catch(continue)
				)
			)
			on orip pressed do undo ~UNDO_PIVOT_TO_ORIGO~ on
			(
				for i in selection do
				(
					try(i.pivot = [0,0,0])catch(continue)
				)
			)
			on objcenter pressed do undo ~UNDO_OBJ_TO_CENTER~ on
			(
				for i in selection do
				(
					try(i.pos = [0,0,0])catch(continue)
				)
			)
			on cloner pressed do undo ~UNDO_QUICK_CLONE~ on
			(
				if keyboard.altpressed do PolyBoost.Clonefunc()
				PolyBoost.Clonefunc()
			)
		)
		--PBo_transmainpos = undefined
		if PBo_transmainpos != undefined then 
		(
			if PBo_transmain.dialogbar do (cui.UnRegisterDialogBar PBo_transmain ; destroyDialog PBo_transmain)
			createdialog PBo_transmain 134 ~PBO_TRANSMAIN_Y~ PolyBoost.PBo_transmainpos.x PolyBoost.PBo_transmainpos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing)
		)
		else (createdialog PBo_transmain ~PBO_TRANSMAIN_X~ ~CREATE_PBO_TRANSMAIN_Y~ 157 344 style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing))
		cui.RegisterDialogBar PBo_transmain minSize:~PBO_TRANSMAIN_MINSIZE~
		PolyBoost.TransformDialogOpen = true
	)
),
fn TextureRollout =
(
	if PolyBoost.TextureToolsOpen then
	(
		if PBo_texturemain.dialogbar do (cui.UnRegisterDialogBar PBo_texturemain ; destroyDialog PBo_texturemain)
		PolyBoost.TextureToolsOpen = false
	)
	else
	(
		rollout PBo_texturemain ~RENDER_SURFACE_MAP~
		(
			group ~GROUP_CREATE_BITMAP~
			(
				spinner siz1 ~SIZ1_CAPTION~ range:[1,16000,512] type:#integer fieldwidth:36 offset:~SIZ1_OFFSET~
				spinner siz2 ~SIZ2_CAPTION~ range:[1,16000,512] type:#integer fieldwidth:36 offset:~SIZ2_OFFSET~
				dropdownlist dlist ~DLIST_SIZE_CAPTION~ items:#("32","64","128","256","512","1024","2048","4096") selection:5 height:10 width:~DLIST_SIZE_WIDTH~ offset:~DLIST_SIZE_OFFSET~
				spinner mch2 ~MAP_CHANNEL_CAPTION~ range:[1,99,1] type:#integer fieldwidth:24 align:#right offset:[0,2]
				spinner padspin ~SEAM_BLEED_CAPTION~ range:[0,100,2] type:#integer fieldwidth:24 align:#right
				label cblab ~BITMAP_TYPE~
				button doit3 ~CAVITY_MAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~CAVITY_MAP_TOOLTIP~
				spinner contspin ~CONTSPIN_CONTRAST~ range:[0,100,1] type:#integer fieldwidth:30 align:#center
				button doit4 ~DENSITY_MAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~DENSITY_MAP_TOOLTIP~
				button doit5 ~DUST_MAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~DUST_MAP_TOOLTIP~
				button doit6 ~SUBSURFACE_MAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~SUBSURFACE_MAP_TOOLTIP~
				spinner subsspin ~SUBSSPIN_CAPTION~ range:[0,10000,1] type:#integer fieldwidth:34 align:#center
				button doit7 ~OCCLUSION_MAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~OCCLUSION_MAP_TOOLTIP~
				button doit2 ~SELECTIONTOBITMAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~DOIT2_TOOLTIP~
				label twlab ~TEXTURE_WRAP~
				button twpicktex ~PICK_TEXTURE_BUTTONTEXT~ width:100 height:17 align:#center tooltip:~TWPICKTEX_TOOLTIP~
				spinner twspin ~TWSPIN_TILE_CAPTION~ range:[-1000.0,1000.0,1.0] scale:0.1 fieldwidth:30 align:#center
				button twdo ~TEXTURE_WRAP_BUTTONTEXT~ width:100 height:17 align:#center tooltip: ~TEXTURE_WRAP_TOOLTIP~
			)
			button BSinibutt ~BITMAP_SELECT_BUTTONTEXT~ width:~BITMAP_SELECT_WIDTH~ height:20 tooltip:~BITMAP_SELECT_TOOLTIP~
				
			on PBo_texturemain open do
			(
				if (PolyBoost.TexWrapFile != undefined) and (doesfileexist PolyBoost.TexWrapFile) do
				(
					twpicktex.text = (getFilenameFile PolyBoost.TexWrapFile) + (getFilenameType PolyBoost.TexWrapFile)
					twpicktex.tooltip = PolyBoost.TexWrapFile
				)
			)
			on PBo_texturemain close do
			(
				PolyBoost.PBo_texturemainpos = getdialogpos PBo_texturemain
				PolyBoost.TextureToolsOpen = false
			)
			on twpicktex pressed do
			(
				PolyBoost.TexWrapFile = getBitmapOpenFileName caption:~POLYBOOST_TEXWRAPFILE_CAPTION~ filename:""
				if PolyBoost.TexWrapFile != undefined then
				(
					twpicktex.text = (getFilenameFile PolyBoost.TexWrapFile) + (getFilenameType PolyBoost.TexWrapFile)
					twpicktex.tooltip = PolyBoost.TexWrapFile
				)
				else (twpicktex.text = ~PICK_TEXTURE_TEXT~ ; twpicktex.tooltip = ~TWPICKTEX_PICK_TEXTURE_TO_WRAP_TOOLTIP~)
			)
			on twdo pressed do
			(
				if (twpicktex.text != ~TWPICKTEX_PICK_TEXTURE_TEXT~) and (PolyBoost.TexWrapFile != undefined) and (doesfileexist PolyBoost.TexWrapFile) and (selection.count == 1) and (classof $.baseobject == Editable_Poly) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						setWaitCursor()
						workmesh = snapshot $ ; hide workmesh
						PolyBTextureWrap workmesh siz1.value siz2.value mch2.value PolyBoost.TexWrapFile ($.max + 0.001) ($.min - 0.001) twspin.value padspin.value $
						delete workmesh
						setArrowCursor()
					)
					else (messagebox ~MESSAGEBOX_MAPCHANNEL_DOES_NOT_EXIST~ beep:false title:~TEXTURE_WRAP_TITLE~)
				)
			)
			on doit3 pressed do
			(
				if (selection.count == 1) and (classof $.baseobject == Editable_Poly) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						setWaitCursor()
						PolyBCavityMap $ siz1.value siz2.value mch2.value contspin.value padspin.value
						setArrowCursor()
					)
					else (messagebox ~MSGBOX_MAPCHANNEL_DOES_NOT_EXIST2~ beep:false title:~CAVITY_MAP_TITLE~)
				)
			)
			on doit4 pressed do
			(
				if (selection.count == 1) and (classof $.baseobject == Editable_Poly) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						setWaitCursor()
						PolyBDensityMap $ siz1.value siz2.value mch2.value padspin.value
						setArrowCursor()
					)
					else (messagebox ~MSGBOX_MAPCHANNEL_DOES_NOT_EXIST3~ beep:false title:~DENSITY_MAP_TITLE~)
				)
			)
			on doit5 pressed do
			(
				if (selection.count == 1) and (classof $.baseobject == Editable_Poly) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						setWaitCursor()
						PolyBDustMap $ siz1.value siz2.value mch2.value padspin.value
						setArrowCursor()
					)
					else (messagebox ~MSGBOX_MAPCH_DOES_NOT_EXIST~ beep:false title:~DENSITY_MAP_TITLE2~)
				)
			)
			on doit6 pressed do
			(
				if (selection.count == 1) and (classof $.baseobject == Editable_Poly) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						setWaitCursor()
						PolyBSubSurfaceMap $ siz1.value siz2.value mch2.value subsspin.value padspin.value
						setArrowCursor()
					)
					else (messagebox ~MSGBOX_MC_DOES_NOT_EXIST~ beep:false title:~DENSITY_MAP_TITLE3~)
				)
			)
			on doit7 pressed do
			(
				if (selection.count == 1) and (classof $.baseobject == Editable_Poly) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						setWaitCursor()
						PolyBOcclusionMap $ siz1.value siz2.value mch2.value subsspin.value padspin.value
						setArrowCursor()
					)
					else (messagebox ~MSGBOX_MC_DOES_NOT_EXIST_CAPTION~ beep:false title:~DENSITY_MAP_TITLE4~)
				)
			)
			on dlist selected state do (siz1.value = dlist.selected as integer ; siz2.value = dlist.selected as integer)
			on doit2 pressed do
			(
				if PolyBoost.validobjfunc() and (subobjectLevel != 0) do
				(
					if (polyOp.getMapSupport $.baseobject mch2.value) then
					(
						PolyBSelToBitmap $ siz1.value siz2.value mch2.value 0
					)
					else (messagebox ~MSGBOX_MAPCHANNEL~ beep:false title:~BITMAPSELECT_TITLE~)
				)
			)
			on BSinibutt pressed do
			(
				rollout BSmainroll ~BSMAINROLL_BITMAP_SELECT~
				(
					mapbutton tru ~TRU_MAP_1_CAPTION~ width:100 height:16 offset:[-12,0] tooltip: ~SELECT_BITMAP_TOOLTIP~
					button clr1 ~CLR1_C_BUTTONTEXT~ width:18 height:16 offset:[52,-21] tooltip: ~CLEAR_MAPSHOT_1_TOOLTIP~
					mapbutton bru ~BRU_MAP2_CAPTION~ width:100 height:16 offset:[-12,-3] tooltip: ~SELECT_BITMAP_TOOLTIP2~
					button clr2 ~CLR2_C_BUTTONTEXT~ width:18 height:16 offset:[52,-21] tooltip: ~CLR2_TOOLTIP~
					mapbutton kru ~KRU_MAP3_CAPTION~ width:100 height:16 offset:[-12,-3] tooltip: ~SELECT_BITMAP_TOOLTIP3~
					button clr3 ~CLR3_C_BUTTONTEXT~ width:18 height:16 offset:[52,-21] tooltip: ~CLR3_TOOLTIP~
					mapbutton nru ~NRU_MAP_4_CAPTION~ width:100 height:16 offset:[-12,-3] tooltip: ~NRU_MAP_4_TOOLTIP~
					button clr4 ~CLR4_C_BUTTONTEXT~ width:18 height:16 offset:[52,-21] tooltip: ~CLEAR_MAPSLOT_4_TOOLTIP~
					spinner frt ~USE_MAP_SLOT_CAPTION~ range:[1,4,1] type:#integer fieldwidth:24 align:#center
					spinner mch ~SPINNER_MAP_CHANNEL_CAPTION~ range:[1,99,1] type:#integer fieldwidth:24 align:#center
					label getlab ~GET_SELECTION_FROM~ align:#center
					radiobuttons whibla labels:#(~WHITE~,~BLACK~,~COLOR~) default: 1 columns: 2
					colorpicker colp offset:[64,-20] width:40 height:~COLP_HEIGHT~
					button doit ~DOIT_BUTTONTEXT~ width:~DOIT_WIDTH~ height:17 align:#center tooltip: ~DOIT_TOOLTIP~
					
					on tru picked mip do
					(
						if classof mip == bitmaptexture do tru.text = mip.filename
					)
					on bru picked pip do
					(
						if classof pip == bitmaptexture do bru.text = pip.filename
					)
					on kru picked gip do
					(
						if classof gip == bitmaptexture do kru.text = gip.filename
					)
					on nru picked rip do
					(
						if classof rip == bitmaptexture do nru.text = rip.filename
					)
					on clr1 pressed do tru.text = ~CLR1_MAP_1_CAPTION~
					on clr2 pressed do bru.text = ~CLR2_MAP2_CAPTION~
					on clr3 pressed do kru.text = ~CLR3_MAP3_CAPTION~
					on clr4 pressed do nru.text = ~CLR4_MAP_4_CAPTION~
					on doit pressed do
					(
						if PolyBoost.validobjfunc() and (subobjectLevel != 0) do undo ~UNDO_BITMAP_SELECT_CAPTION~ on
						(
							if frt.value == 1 and tru.text != ~FRT_CAPTION~ then tex = tru.text
							else if frt.value == 2 and bru.text != ~FRT_MAP2_CAPTION~ then tex = bru.text
							else if frt.value == 3 and kru.text != ~FRT_MAP3_CAPTION~ then tex = kru.text
							else if frt.value == 4 and nru.text != ~FRT_MAP_4_CAPTION~ do tex = nru.text
							
							if frt.value == 1 and tru.text != ~FRT_MAP1_CAPTION~ or frt.value == 2 and bru.text != ~FRT_MAP2_CAPTION2~ or 
							frt.value == 3 and kru.text != ~FRT_MAP3_CAPTION2~ or frt.value == 4 and nru.text != ~FRT_MAP_4_CAPTION2~ do
							(
								if (polyOp.getMapSupport $.baseobject mch.value) then
								(
									if whibla.state == 1 then colcheck = [255,255,255]
									else if whibla.state == 2 then colcheck = [0,0,0]
									else colcheck = colp.color
									PolyToolsSelect.BitmapToSel tex mch.value colcheck
								)
								else (messagebox ~MSGBOX_MAPCHANNEL_DOES_NOT_EXIST4~ beep:false title:~BITMAP_SELECT_TITLE~)
							)
						)
					)
					on BSmainroll open do
					(
						tru.text = PBo_BSmain[2]
						bru.text = PBo_BSmain[3]
						kru.text = PBo_BSmain[4]
						nru.text = PBo_BSmain[5]
						frt.value = PBo_BSmain[6]
						mch.value = PBo_BSmain[7]
						whibla.state = PBo_BSmain[8]
						colp.color = PBo_BSmain[9]
					)
					on BSmainroll close do
					(
						PBo_BSmain = #(getdialogpos BSmainroll, tru.text, bru.text, kru.text, nru.text, frt.value, mch.value, whibla.state,colp.color)
					)
				)
				if PBo_BSmain != undefined and BSmainroll.dialogbar do (cui.UnRegisterDialogBar BSmainroll ; destroyDialog BSmainroll)
				--PBo_BSmain = undefined
				if PBo_BSmain == undefined do PBo_BSmain = #([157,340], ~MAP1~, ~MAP2~, ~MAP3~, ~MAP4~, 1, 1, 1, (color 0 0 255))
				createdialog BSmainroll 140 204 PBo_BSmain[1].x PBo_BSmain[1].y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing)
				cui.RegisterDialogBar BSmainroll minSize:[138,204] maxSize:[138,204]
			)
		)
		--PBo_texturemainpos = undefined
		if PBo_texturemainpos != undefined then 
		(
			if PBo_texturemain.dialogbar do (cui.UnRegisterDialogBar PBo_texturemain ; destroyDialog PBo_texturemain)
			createdialog PBo_texturemain 134 422 PolyBoost.PBo_texturemainpos.x PolyBoost.PBo_texturemainpos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing)
		)
		else (createdialog PBo_texturemain 134 422 157 344 style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing))
		cui.RegisterDialogBar PBo_texturemain minSize:[132,100]
		PolyBoost.TextureToolsOpen = true
	)
),
fn SpinnerChange isDown type =
	(
		sellevel = subobjectlevel
		if sellevel == 0 then sellevel = 1
		else if sellevel == 3 then sellevel = 2
		else if sellevel > 3 do sellevel = 3
		if isDown then SurfSelsel = PolyBGetSel sellevel
		else
		(
			toolstring = ""
			if type == 1 then toolstring = ~SURFACE_SELECT~
			else if type == 2 then toolstring = ~NORMAL_SELECT~
			else if type == 3 then toolstring = ~DISTANCE_SELECT~
			else if type == 4 do toolstring = ~PERSPECTIVE_GROW~
			aftersel = PolyBGetSel sellevel
			undo off (PolyBSetSel sellevel SurfSelsel)
			undo toolstring on (PolyBSetSel sellevel aftersel)
		)
	),
fn PerspectiveSelect =
(
	PolyToolsSelect.Perspective PolyToolsUI.PerspectiveValue PolyToolsUI.PerspectiveOutline
),
fn HalfSelect =
(
	PolyToolsSelect.Half PolyToolsUI.HalfAxis PolyToolsUI.HalfInvert keyboard.shiftpressed
),
fn NumericSelect =
(
	if subobjectlevel == 1 then undo ~NUMERICSELECT~ on
	(
		PolyToolsSelect.NumericVertex PolyToolsUI.NumericEdges PolyToolsUI.NumericType keyboard.shiftpressed
	)
	else if subobjectlevel > 3 do undo ~NUMERICSELECT2~ on
	(
		PolyToolsSelect.NumericFace PolyToolsUI.NumericEdges PolyToolsUI.NumericType keyboard.shiftpressed
	)
),
fn SimilarSelect =
(
	if subobjectlevel == 1 then
	(
		PolyToolsSelect.Similar PolyToolsUI.SimilarV[1] PolyToolsUI.SimilarV[2] PolyToolsUI.SimilarV[3] PolyToolsUI.SimilarV[4] false PolyToolsUI.SimilarV[5]
	)
	else if subobjectlevel == 2 or subobjectlevel == 3 then
	(
		PolyToolsSelect.Similar false PolyToolsUI.SimilarE[1] false PolyToolsUI.SimilarE[2] PolyToolsUI.SimilarE[3] PolyToolsUI.SimilarE[4]
	)
	else if subobjectlevel == 4 or subobjectlevel == 5 do
	(
		PolyToolsSelect.Similar PolyToolsUI.SimilarF[1] false false PolyToolsUI.SimilarF[2] PolyToolsUI.SimilarF[3] PolyToolsUI.SimilarF[4]
	)
),
fn SetFlow =
(
	if subobjectlevel == 2 then PolyToolsModeling.SetFlow PolyToolsUI.SetFlowAutoLoop
	else if subobjectlevel == 1 do PolyToolsModeling.SetFlowVertex()
),
fn FlowConnect =
(
	PolyBoost.Flowfunc PolyToolsUI.FlowConnectAutoLoop
),
fn RandomConnect =
(
	undo ~UNDO_RANDOM_CONNECT~ on
	(
		PolyToolsModeling.RandomConnect PolyToolsUI.RandomConnectJitter PolyToolsUI.RandomConnectAutoLoop
	)
),
fn PolySculptStart tooltype =
(
	if PolyBoost.validobjfunc() or classof (modpanel.getcurrentobject()) == Edit_Poly then
	(
		if PolyToolsUI.SculptTool != 0 do
		(
			PolyToolsUI.SculptButtons[PolyToolsUI.SculptTool] = false
			updateToolbarButtons()
		)
		
		PolyToolsUI.SculptTool = tooltype
		thePainterInterface.maxSize = PolyToolsUI.SculptBrushsize
		thePainterInterface.maxStr = PolyToolsUI.SculptBrushStrength
		PolyBSculptStart tooltype
	)
	else
	(
		PolyToolsUI.SculptButtons[tooltype] = false
		updateToolbarButtons() --turn off button
	)
),
fn PolyShiftStart toolType =
(
	cursel = modpanel.getcurrentobject()
	if selection.count == 1 and cursel == $.baseobject and classof cursel == Editable_Poly or selection.count == 1 and classof cursel == Edit_Poly then
	(
		--Setup intersection object if needed
		gotool = true
		conformObjectSet = false
		if toolType > 3 do
		(
			if PolyToolsUI.PDDrawtype == 2 then --Surface
			(
				if isValidObj PBo_Pickobject then
				(
					gotool = PolyBDrawNodeInit PBo_Pickobject
					if gotool do conformObjectSet = true
				)
				else
				(
					gotool = false
					PolyToolsUI.PDPickButton = false
					messagebox "Use the pickbutton to pick an object to draw on." title:"PolyDraw"
				)
			)
			else if PolyToolsUI.PDDrawtype == 3 do --Selection
			(
					showend = showendresult
					if showend do showendresult = false
					gotool = PolyBDrawNodeInit $
					if showend do showendresult = true
					if gotool do conformObjectSet = true
			)
		)
		
		--Unpress all Ribbon buttons
		for i = 13 to 17 do PolyToolsUI.PDButtons[i] = false
		PolyToolsUI.PSButtons = #(false,false,false)
		
		if gotool then
		(
			--Update which button should be pressed in Ribbon
			case toolType of
			(
				1: PolyToolsUI.PSButtons[1] = true
				2: PolyToolsUI.PSButtons[2] = true
				3: PolyToolsUI.PSButtons[3] = true
				4: PolyToolsUI.PDButtons[13] = true
				5: PolyToolsUI.PDButtons[14] = true
				6: PolyToolsUI.PDButtons[15] = true
				7: PolyToolsUI.PDButtons[16] = true
				8: PolyToolsUI.PDButtons[17] = true
			)

			PolyToolsUI.PolyShiftActive = true
			startNewTool = PolyBShiftSetup toolType
			if (not startNewTool) do return false
			
			if conformObjectSet do
			(
				PolyShiftSetupConformNormals()
			)
			
			PBStartTrack PolyBPolyShift 1
		)
	)
	else
	(
		PolyToolsUI.PSButtons = #(false,false,false)
		updateToolbarButtons() --turn off button
	)
),
fn PolyDrawStart tooltype =
(
	if PolyBoost.validobjfunc() or classof (modpanel.getcurrentobject()) == Edit_Poly or tooltype == 7 or tooltype == 12 then
	(
		gotool = true
		if PolyToolsUI.PDDrawtype == 1 or tooltype == 2 or tooltype == 3 or tooltype == 11 then () --Connect, SwiftLoop and PolyBranch never uses intersection node
		else if PolyToolsUI.PDDrawtype == 2 then --Surface
		(
			if isvalidobj PBo_Pickobject then PolyBDrawNodeInit PBo_Pickobject
			else
			(
				gotool = false
				PolyToolsUI.PDPickButton = false
				messagebox ~MSGBOX_USE_PICKBUTTON~ title:~MSGBOX_USE_PICKBUTTON_TITLE~
			)
		)
		else if PolyToolsUI.PDDrawtype == 3 do --Selection
		(
				showend = showendresult
				if showend do showendresult = false
				PolyBDrawNodeInit $
				if showend do showendresult = true
		)
		if gotool then
		(
			if PolyToolsUI.PDTool != 0 do
			(
				PolyToolsUI.PDButtons[PolyToolsUI.PDTool] = false
				if PolyToolsUI.PDTool == 7 then PolyBPolyTopoEnd()
				else if PolyToolsUI.PDTool == 12 do PolyBPolySplinesEnd()
				updateToolbarButtons()
			)
			PolyToolsUI.PDTool = tooltype
			if tooltype == 1 then
			(
				VertexTicks = $.vertexTicks
				$.vertexTicks = true
				PBStartTrack PolyBPolyDrawBuild
			)
			else if tooltype == 2 then PBStartTrack PolyBPolyDrawConnect
			else if tooltype == 3 then PBStartTrack PolyBPolyDrawSwiftLoop
			else if tooltype == 4 then PBStartTrack PolyBPolyDrawBorder
			else if tooltype == 5 then PBStartTrack PolyBPolyDrawMove
			else if tooltype == 6 then PBStartTrack PolyBPolyDrawOptimizer
			else if tooltype == 7 then
			(
				with redraw off 
				(
					undo off
					(
						domodplace = false
						if selection.count == 1 do
						(
							base = modpanel.getCurrentObject()
							domodplace = true
						)
						toponode = box()
						convertTo toponode Editable_Poly
						if domodplace do modpanel.setCurrentObject base
						PolyBPolyDrawTopoSetup toponode
					)
				)
				PBStartTrack PolyBPolyDrawTopo
			)
			else if tooltype == 8 then PBStartTrack PolyBPolyDrawPolySurf
			else if tooltype == 9 then PBStartTrack PolyBPolyDrawPolyShapes
			else if tooltype == 10 then PBStartTrack PolyBPolyDrawPolyStrips
			else if tooltype == 11 then PBStartTrack PolyBPolyDrawPolyBranch
			else if tooltype == 12 do PBStartTrack PolyBPolyDrawSplines
		)
		else
		(
			PolyToolsUI.PDButtons[tooltype] = false
			updateToolbarButtons() --turn off button
		)
	)
	else
	(
		PolyToolsUI.PDButtons[tooltype] = false
		updateToolbarButtons() --turn off button
	)
),
fn UVWTweakStart =
(
	if PolyBoost.validobjfunc() then
	(
		if (polyOp.getMapSupport $.baseobject PolyToolsUI.UVWTweakChannel) then
		(
			PolyToolsUI.UVWTweakActive = true
			$.EditablePoly.DeleteIsoMapVerts ()
			PolyBUVWTweakSetup PolyToolsUI.UVWTweakChannel
			PBStartTrack PolyBUVWTweak
		)
		else
		(
			PolyToolsUI.UVWTweakButton = false
			updateToolbarButtons() --turn off button
			messagebox ~MB_MC_DOES_NOT_EXIST~ title:~MB_MC_DOES_NOT_EXIST_TITLE~
		)
	)
	else
	(
		PolyToolsUI.UVWTweakButton = false
		updateToolbarButtons() --turn off button
		messagebox ~MSGBOX_NEED_EDITABLE_POLY_OBJ_SELECTED1~ title:~MSGBOX_NEED_EDITABLE_POLY_OBJ_SELECTED1_TITLE~
	)
),
fn ObjectPaintStart theTool =
(
	actionMan.executeAction 60545 "54249"  -- Ribbon: Show Object Paint Tab Ribbon
	doStartTool = true
	if theTool == 2 do
	(
		if (((PolyBGetSel 2) as array).count == 0) do doStartTool = false
	)
	if doStartTool then
	(
		--Check if all nodes to paint with are valid
		nodeCount = ObjectPaint.Nodes.count
		nodearr = #()
		namearr = #()
		selectedIndexValid = true
		if theTool == 1 and (OBJPaintGetSetting 39) == 1 then --Paint with selected objects
		(
			for i = 1 to selection.count do
			(
				if (isValidNode selection[i]) do append nodearr selection[i]
			)
			if nodearr.count != 0 then
			(
				PolyBOBJPaintSetup nodearr theTool
			)
			else
			(
				messagebox ~MSGBOX_SELECT_OBJ_TO_PAINT_WITH~ title:~OBJ_PAINT~
				return false
			)
		)
		else --Use objects in list
		(
		for i = 1 to nodeCount do
		(
			if (isValidNode ObjectPaint.Nodes[i]) then
			(
				append nodearr ObjectPaint.Nodes[i]
				append namearr ObjectPaint.NodeNames[i]
			)
			else ObjectPaint.ListSelectedIndex = 1
		)
		ObjectPaint.Nodes = nodearr
		ObjectPaint.NodeNames = namearr
		if ObjectPaint.Nodes.count != 0 then
		(
			PolyBOBJPaintSetup ObjectPaint.Nodes theTool
			)
			else
			(
				ObjectPaint.OpenNodeDialog()
				--messagebox ~MSGBOX_PICK_OBJ_BUTTON_TO_CHOOSE_OBJ_TO_PAINT_WITH~ title:~OBJ_PAINT~
				return false
			)
		)

			if ObjectPaint.NodeDialogOpen do
			(
				ObjectPaintNodeDialog.moveupbut.enabled = false
				ObjectPaintNodeDialog.movedownbut.enabled = false
				ObjectPaintNodeDialog.pickbut.enabled = false
				ObjectPaintNodeDialog.addbut.enabled = false
				ObjectPaintNodeDialog.addselbut.enabled = false
				ObjectPaintNodeDialog.rembut.enabled = false
			)
			suspendEditing()
			if theTool == 1 then --Paint
			(
				PBStartTrack PolyBOBJPaint
			)
			else --Fill
			(
				result = PolyBOBJPaintGetStrokeFromEdges $
				if result do
				(
					PBStartTrack PolyBOBJFill
				)
			)
			resumeEditing()
			if ObjectPaint.NodeDialogOpen do
			(
				ObjectPaintNodeDialog.moveupbut.enabled = true
				ObjectPaintNodeDialog.movedownbut.enabled = true
				ObjectPaintNodeDialog.pickbut.enabled = true
				ObjectPaintNodeDialog.addbut.enabled = true
				ObjectPaintNodeDialog.addselbut.enabled = true
				ObjectPaintNodeDialog.rembut.enabled = true
			)
			if theTool == 2 and PolyBoost.validobjfunc() do subobjectlevel = 2
		)
		else
		(
		messagebox ~MSGBOX_SELECT_EDGES_TO_FILL~ title:~MSGBOX_SELECT_EDGES_TO_FILL_TITLE~
	)
),
--Toggles on and off PolyDraw,PolySculpt, PolyShift and UVW Tweak. If any of them is active and a different kind of tool is
--started (PolyDraw->PolyShift etc) then the active tool is first ended.
fn ToolToggle type tooltype state =
(
	if state then --start tools
	(
		max modify mode
		curmod = modpanel.getcurrentobject()
		if PolyBoost.validobjfunc() or classof curmod == Edit_Poly do
		(
			curmod.paintdeformmode = 0
		)
		if VertexTicks == false do --If PolyDraw Build has turned on vertex ticks, turn it off
		(
			if selection.count == 1 and superclassof $ == GeometryClass do $.vertexTicks = false
			VertexTicks = undefined
		)
		if type == 1 then --PolyDraw
		(
			if PolyToolsUI.SculptTool != 0 do ToolToggle 2 1 false
			if PolyToolsUI.PolyShiftActive do ToolToggle 3 1 false
			if PolyToolsUI.UVWTweakActive do ToolToggle 4 1 false
			if ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51)) do ToolToggle 5 1 false
			PolyDrawStart tooltype
		)
		else if type == 2 then --PolySculpt
		(
			if PolyToolsUI.PDTool != 0 do ToolToggle 1 PolyToolsUI.PDTool false
			if PolyToolsUI.PolyShiftActive do ToolToggle 3 1 false
			if PolyToolsUI.UVWTweakActive do ToolToggle 4 1 false
			if ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51)) do ToolToggle 5 1 false
			PolySculptStart tooltype
		)
		else if type == 3 then --PolyShift
		(
			if PolyToolsUI.PDTool != 0 do ToolToggle 1 PolyToolsUI.PDTool false
			if PolyToolsUI.SculptTool != 0 do ToolToggle 2 1 false
			if PolyToolsUI.UVWTweakActive do ToolToggle 4 1 false
			if ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51)) do ToolToggle 5 1 false
			PolyShiftStart tooltype
		)
		else if type == 4 then --UVWTweak
		(
			if PolyToolsUI.PDTool != 0 do ToolToggle 1 PolyToolsUI.PDTool false
			if PolyToolsUI.SculptTool != 0 do ToolToggle 2 1 false
			if PolyToolsUI.PolyShiftActive do ToolToggle 3 1 false
			if ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51)) do ToolToggle 5 1 false
			UVWTweakStart()
		)
		else --Object Paint
		(
			if PolyToolsUI.PDTool != 0 do ToolToggle 1 PolyToolsUI.PDTool false
			if PolyToolsUI.SculptTool != 0 do ToolToggle 2 1 false
			if PolyToolsUI.PolyShiftActive do ToolToggle 3 1 false
			if PolyToolsUI.UVWTweakActive do ToolToggle 4 1 false
			ObjectPaintStart tooltype
		)
	)
	else --end tools
	(
		if type == 1 then --end PolyDraw
		(
			PBEndTrack()
			if VertexTicks == false do --If PolyDraw Build has turned on vertex ticks, turn it off
			(
				if selection.count == 1 and superclassof $ == GeometryClass do $.vertexTicks = false
				VertexTicks = undefined
			)
			if tooltype == 7 do PolyBPolyTopoEnd()
			PolyToolsUI.PDTool = 0
			for i = 1 to 12 do PolyToolsUI.PDButtons[i] = false
		)
		else if type == 2 then --end PolySculpt
		(
			PolyBSculptEnd()
			PolyToolsUI.SculptTool = 0
			for i = 1 to 8 do PolyToolsUI.SculptButtons[i] = false
		)
		else if type == 3 then --end PolyShift
		(
			PBEndTrack()
			PolyBPolyShiftReset()
			PolyToolsUI.PolyShiftActive = false
			PolyToolsUI.PSButtons = #(false,false,false)
			for i = 13 to 17 do PolyToolsUI.PDButtons[i] = false
		)
		else if type == 4 then --end UVWTweak
		(
			PBEndTrack()
			PolyBUVWTweakEnd()
			PolyToolsUI.UVWTweakActive = false
			PolyToolsUI.UVWTweakButton = false
		)
		else if type == 5 do --end Object Paint
		(
			PBEndTrack()
			PolyBOBJEndPaint()
		)
		max move
		updateToolbarButtons()
	)
),
fn EndAllTools =
(
	if PolyToolsUI.PDTool != 0 do ToolToggle 1 PolyToolsUI.PDTool false
	if PolyToolsUI.SculptTool != 0 do ToolToggle 2 1 false
	if PolyToolsUI.PolyShiftActive do ToolToggle 3 1 false
	if PolyToolsUI.UVWTweakActive do ToolToggle 4 1 false
	if ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51)) do ToolToggle 5 1 false
),
fn SolveSurface =
(
	max modify mode
	setWaitCursor()
	PolyBSolveSurf PolyToolsUI.PDSolveAngle PolyToolsUI.PDSolveQuads
	setArrowCursor()
),
fn PolyDrawPickFilter obj =
(
	superclassof obj == geometryclass and classof obj != Targetobject
),
fn PolyDrawPickNode =
(
	PolyToolsUI.PDPickButton = true
	updateToolbarButtons()
	pickedobj = pickObject filter:PolyDrawPickFilter
	PolyToolsUI.PDPickButton = false
	if pickedobj != undefined then
	(
		PBo_Pickobject = pickedobj
		pickname = pickedobj.name
		ncount = pickname.count
		if pickname.count > 14 do
		(
			namm = ""
			for i = 1 to 11 do namm += pickname[i]
			namm += "..."
			pickname = namm
		)
		PolyDrawPicktext = pickname
		updateToolbarButtons()
	)
	else
	(
		if not (isValidNode PBo_Pickobject) then
		(
			PBo_Pickobject = undefined
			PolyDrawPicktext = ~POLYDRAWPICKTEXT_PICK~
			updateToolbarButtons()
		)
		if pickedobj != undefined do messagebox ~MSGBOX_PICK_GEOMETRY_OBJ~ title:~POLYDRAW_TITLE~ beep:false
	)
),
fn PaintDeformPickFilter obj =
(
	superclassof obj == shape and classof obj != Targetobject
),
fn PaintDeformPickNode =
(
	PolyToolsUI.SculptPickButton = true
	updateToolbarButtons()
	pickedobj = pickObject filter:PaintDeformPickFilter
	PolyToolsUI.SculptPickButton = false
	if pickedobj != undefined then
	(
		thePainterInterface.setSplineConstraintNode pickedobj
		pickname = pickedobj.name
		ncount = pickname.count
		if pickname.count > 14 do
		(
			namm = ""
			for i = 1 to 11 do namm += pickname[i]
			namm += "..."
			pickname = namm
		)
		PaintDeformPicktext = pickname
		thePainterInterface.useSplineConstraint = true
		updateToolbarButtons()
	)
	else
	(
		if (not thePainterInterface.isSplineConstraintNodeValid()) do
		(
			PaintDeformPicktext = ~PICK_PAINTDEFORM~
			updateToolbarButtons()
		)
		updateToolbarButtons()
		if pickedobj != undefined do messagebox ~MSGBOX_PICK_SPLINE_OBJ~ title:~PAINTDEFORM_PICK_TITLE~ beep:false
	)
),
fn FreeformApplySettings settingsFileName =
(
	if (doesFileExist settingsFileName) do
	(
		settingsFile = openFile settingsFileName
		if settingsFile != undefined do
		(
			deformSettings = execute (readline settingsFile)
			shiftSettings = execute (readline settingsFile)
			close settingsFile
			
			--Paint Deform
			PolyToolsUI.SculptBrushsize = deformSettings[1]
			PolyToolsUI.SculptOffset = deformSettings[3]
			PolyToolsUI.SculptCap = deformSettings[4]
			PolyToolsUI.SculptDirection = deformSettings[5]
			PolyToolsUI.SculptNoiseSeed = deformSettings[6]
			PolyToolsUI.SculptNoiseScale = deformSettings[7]
			PolyToolsUI.SculptNoiseTurbulence = deformSettings[8]
			PolyToolsUI.SculptNoiseIterations = deformSettings[9]
			PolyToolsUI.SculptUseSelectedVerts = deformSettings[10]
			PolyToolsUI.PolySculptSettings()
			thePainterInterface.maxSize = PolyToolsUI.SculptBrushsize
			PolyToolsUI.SculptBrushStrength = deformSettings[2]
			thePainterInterface.maxStr = PolyToolsUI.SculptBrushStrength
			
			--Shift tool
			PolyToolsUI.PSFullStrength = shiftSettings[1]
			PolyToolsUI.PSFalloff = shiftSettings[2]
			PolyToolsUI.PSStrength = shiftSettings[3]
			PolyToolsUI.PSUseSelected = shiftSettings[4]
			PolyToolsUI.PSIgnoreback = shiftSettings[5]
			PolyToolsUI.PSFreezeX = shiftSettings[6]
			PolyToolsUI.PSFreezeY = shiftSettings[7]
			PolyToolsUI.PSFreezeZ = shiftSettings[8]
			PolyToolsUI.PSFreezeEX = shiftSettings[9]
			PolyToolsUI.PSFreezeEY = shiftSettings[10]
			PolyToolsUI.PSFreezeEZ = shiftSettings[11]
			PolyToolsUI.PSMirror = shiftSettings[12]
			PolyToolsUI.PSMirrorAxis = shiftSettings[13]
			PolyToolsUI.PSUseRelativeOffset = shiftSettings[14]
			PolyToolsUI.PSConformAmount = shiftSettings[15]
			PolyToolsUI.PSConformDirection = shiftSettings[16]
			PolyToolsUI.PSBrushAffect = shiftSettings[17]
			PolyToolsUI.PolyShiftSettings()
			
			updateToolbarButtons()
		)
	)
),
fn FreeformLoadDefaultSettings =
(
	settingsFileName = getdir #plugcfg_ln + ("\\PolyTools\\Freeform\\Settings\\Default.txt")
	FreeformApplySettings settingsFileName
),
fn FreeformLoadSettings =
(
	settingsDir = getdir #plugcfg_ln + ("\\PolyTools\\Freeform\\Settings\\")
	settingsFileName = GetOpenFileName caption:~FREEFORM_LOAD_CAPTION~ filename:settingsDir types:"Text(*.txt)|*.txt|"
	if settingsFileName != undefined do
	(
		FreeformApplySettings settingsFileName
	)
),
fn FreeformWriteSettings settingsFileName =
(
	if (doesFileExist settingsFileName) and (getFileAttribute settingsFileName #readOnly) do
	(
		setFileAttribute settingsFileName #readOnly false
	)
	settingsFile = createfile settingsFileName
	if settingsFile != undefined do
	(
		deformSettings = #(thePainterInterface.maxSize, thePainterInterface.maxStr, PolyToolsUI.SculptOffset, PolyToolsUI.SculptCap, PolyToolsUI.SculptDirection, PolyToolsUI.SculptNoiseSeed, PolyToolsUI.SculptNoiseScale, PolyToolsUI.SculptNoiseTurbulence, PolyToolsUI.SculptNoiseIterations,PolyToolsUI.SculptUseSelectedVerts)
		shiftSettings = #(PolyToolsUI.PSFullStrength, PolyToolsUI.PSFalloff, PolyToolsUI.PSStrength, PolyToolsUI.PSUseSelected, PolyToolsUI.PSIgnoreback, PolyToolsUI.PSFreezeX, PolyToolsUI.PSFreezeY, PolyToolsUI.PSFreezeZ, PolyToolsUI.PSFreezeEX, PolyToolsUI.PSFreezeEY, PolyToolsUI.PSFreezeEZ, PolyToolsUI.PSMirror, PolyToolsUI.PSMirrorAxis, PolyToolsUI.PSUseRelativeOffset, PolyToolsUI.PSConformAmount, PolyToolsUI.PSConformDirection, PolyToolsUI.PSBrushAffect)
		format (deformSettings as string) to:settingsFile
		format "\n" to:settingsFile
		format (shiftSettings as string) to:settingsFile
		close settingsFile
	)
),
fn FreeformSaveSettings =
(
	settingsFileDir = getdir #plugcfg_ln + ("\\PolyTools\\Freeform\\Settings\\Freeform_Brushes_01.txt")
	settingsFileName = GetSaveFileName caption:~FREEFORM_SAVE_CAPTION~ filename:settingsFileDir types:"Text(*.txt)|*.txt|"
 	if settingsFileName != undefined do
 	(
		FreeformWriteSettings settingsFileName
 	)
),
fn FreeformSetDefaultSettings =
(
	if (querybox ~FREEFORM_SETDEFAULT_QUERYBOX~ title:~FREEFORM_SETDEFAULT_QUERYBOX_TITLE~) do
	(
		settingsFileName = getdir #plugcfg_ln + ("\\PolyTools\\Freeform\\Settings\\Default.txt")
		FreeformWriteSettings settingsFileName
	)
)
) --End struct
PolyBoost = PolyBoostStruct()

--Object paint - functions and node dialog rollout
struct ObjectPaintStruct
(
Nodes = #(),
NodeNames = #(),
IsPickingObject = false,
NodeDialogOpen = false,
ListSelectedIndex = 1,
hasStartedSpacingButtonDown = false,
nodeDialogPos = [0,0],
fn UseIndexCallback =
(
	if (OBJPaintGetSetting 38) then --Use all objects in list
	(
		if (OBJPaintGetSetting 16) then 3 --all of list in random order
		else 2 --all of list in order
	)
	else 1 --single object
),
fn SetSelectedObject index =
(
	ListSelectedIndex = index
	if NodeDialogOpen do
	(
		ObjectPaintNodeDialog.objlist.selection = index
	)
	OBJPaintSetSetting 100 index
	updateToolbarButtons()
),
fn UseObjectText =
(
	nodeCount = Nodes.count
	if (nodeCount != 0) and (ListSelectedIndex <= nodeCount) and (isValidNode Nodes[ListSelectedIndex]) then
	(
		nodeName = Nodes[ListSelectedIndex].name
		if (nodeName.count > 11) then
		(
			shortName = (substring nodeName 1 11) + "..."
			shortName
		)
		else nodeName
	)
	else ~ELSE_NO_OBJECT~
),
fn ObjectPaintPickObject =
(
	oneNode = pickObject count:1
	if oneNode != undefined and isValidNode oneNode and oneNode != #escape do
	(
		thename = oneNode.name
		numobj = NodeNames.count
		found = false
		for d = 1 to numobj do
		(
			if thename == NodeNames[d] do found = true
		)
		if not found do
		(
			append NodeNames thename
			append Nodes oneNode
			if NodeDialogOpen do ObjectPaintNodeDialog.objlist.items = NodeNames
			SetSelectedObject Nodes.count
		)
	)
),
fn MotionTypeCallback =
(
	if (OBJPaintGetSetting 37) then 1 else 2
),
fn LoadDefaultSettings =
(
	settingsDir = getdir #plugcfg_ln + ("\\PolyTools\\ObjectPaint\\Settings\\")
	settingsFileName = settingsDir + "Default.txt"
	if (doesFileExist settingsFileName) do
	(
		settingsFile = openFile settingsFileName
		if settingsFile != undefined do
		(
			settings = execute (readline settingsFile)
			close settingsFile
			numSettings = settings.count
			for i = 1 to numSettings do
			(
				OBJPaintSetSetting i settings[i]
			)
			updateToolbarButtons()
		)
	)
),
fn OpenNodeDialog =
(
	rollout ObjectPaintNodeDialog ~OBJECTPAINTNODEDIALOG_CAPTION~
	(
		label objlab1 ~OBJ_PAINT_NODEDIALOG_LABEL1~
		label objlab2 ~OBJ_PAINT_NODEDIALOG_LABEL2~
		label objlab3 ~OBJ_PAINT_NODEDIALOG_LABEL3~
		MultiListBox objlist "" items:#()
		button moveupbut ~MOVEUPBUT_BUTTONTEXT~ width:~MOVEUPBUT_WIDTH~ height:21 offset:~MOVEUPBUT_OFFSET~
		button movedownbut ~MOVEDOWNBUT_CAPTION~ width:~MOVEDOWNBUT_WIDTH~ height:21 offset:~MOVEDOWNBUT_OFFSET~
		checkbutton pickbut ~PICKBUT_CAPTION~ width:~PICKBUT_WIDTH~ height:21 offset:~PICKBUT_OFFSET~
		button addbut ~ADDBUT_BUTTONTEXT~ width:~ADDBUT_WIDTH~ height:21 offset:~ADDBUT_OFFSET~
		button addselbut ~ADDSELBUT_BUTTONTEXT~ width:~ADDSELBUT_WIDTH~ height:21 offset:~ADDSELBUT_OFFSET~
		button rembut ~REMBUT_BUTTONTEXT~ width:~REMBUT_WIDTH~ height:21 offset:~REMBUT_OFFSET~
		
		on objlist selectionEnd do
		(
			itemCount = objlist.items.count
			found = false
			for i = 1 to itemCount where objlist.selection[i] do
			(
				ObjectPaint.SetSelectedObject i
				found = true
				exit
			)
			if not found and itemCount != 0 do
			(
				ObjectPaint.SetSelectedObject itemCount
			)
		)
		on ObjectPaintNodeDialog open do
		(
			nodeCount = ObjectPaint.Nodes.count
			nodearr = #()
			namearr = #()
			for i = 1 to nodeCount do
			(
				if (isValidNode ObjectPaint.Nodes[i]) do
				(
					append nodearr ObjectPaint.Nodes[i]
					append namearr ObjectPaint.NodeNames[i]
				)
			)
			ObjectPaint.Nodes = nodearr
			ObjectPaint.NodeNames = namearr
			objlist.items = ObjectPaint.NodeNames
			if (nodeCount != 0) do objlist.selection = ObjectPaint.ListSelectedIndex
			--if tool is active, disable
			if ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51)) do
			(
				moveupbut.enabled = false
				movedownbut.enabled = false
				pickbut.enabled = false
				addbut.enabled = false
				addselbut.enabled = false
				rembut.enabled = false
			)
			ObjectPaint.NodeDialogOpen = true
		)
		on ObjectPaintNodeDialog close do
		(
			ObjectPaint.NodeDialogOpen = false
			ObjectPaint.nodeDialogPos = getDialogPos ObjectPaintNodeDialog
			updateToolbarButtons()
		)
		fn addNodes theNodes =
		(
			if (theNodes != undefined) and (theNodes != #escape) do
			(
				nodeCount = theNodes.count
				if nodeCount != 0 do
				(
					curarr = objlist.items
					for i = 1 to nodeCount do
					(
						thename = theNodes[i].name
						numobj = objlist.items.count
						found = false
						for d = 1 to numobj do
						(
							if thename == objlist.items[d] do found = true
						)
						if not found do
						(
							append curarr thename
							append ObjectPaint.Nodes theNodes[i]
						)
					)
					objlist.items = curarr
					newNodeCount = curarr.count
					if newNodeCount != 0 do
					(
						ObjectPaint.SetSelectedObject newNodeCount
					)
					ObjectPaint.NodeNames = objlist.items
				)
			)
		)
		on moveupbut pressed do
		(
			numNodes = objlist.items.count
			for i = 1 to numNodes do
			(
				if i > 1 and objlist.selection[i] do
				(
					tempnode = ObjectPaint.Nodes[i]
					ObjectPaint.Nodes[i] = ObjectPaint.Nodes[i-1]
					ObjectPaint.Nodes[i-1] = tempnode
					tempitem = copy objlist.items[i-1]
					tempitem2 = copy objlist.items[i]
					objlist.items[i] = tempitem
					objlist.items[i-1] = tempitem2
					ObjectPaint.SetSelectedObject (i-1)
					exit
				)
			)
			ObjectPaint.NodeNames = objlist.items
			objlist.items = objlist.items
		)
		on movedownbut pressed do
		(
			numNodes = objlist.items.count
			for i = 1 to (numNodes - 1) do
			(
				if objlist.selection[i] do
				(
					tempnode = ObjectPaint.Nodes[i]
					ObjectPaint.Nodes[i] = ObjectPaint.Nodes[i+1]
					ObjectPaint.Nodes[i+1] = tempnode
					tempitem = copy objlist.items[i+1]
					tempitem2 = copy objlist.items[i]
					objlist.items[i] = tempitem
					objlist.items[i+1] = tempitem2
					ObjectPaint.SetSelectedObject (i+1)
					exit
				)
			)
			ObjectPaint.NodeNames = objlist.items
			objlist.items = objlist.items
		)
		on addselbut pressed do
		(
			theNodes = selection as array
			addNodes theNodes
		)
		on pickbut changed state do
		(
			ObjectPaint.ObjectPaintPickObject()
			pickbut.state = false
		)
		on addbut pressed do
		(
			theNodes = selectByName title:~SELECTBYNAME_TITLE~ buttonText:~SELECTBYNAME_BUTTONTEXT~ showHidden:false single:false
			addNodes theNodes
		)
		on rembut pressed do
		(
			listsel = objlist.selection
			numobj = objlist.items.count
			newarr = #()
			nodearr = #()
			for i = 1 to numobj do
			(
				if not listsel[i] do
				(
					append newarr objlist.items[i]
					append nodearr ObjectPaint.Nodes[i]
				)
			)
			ObjectPaint.Nodes = nodearr
			objlist.items = newarr
			ObjectPaint.NodeNames = objlist.items
			nodeCount = ObjectPaint.Nodes.count
			if nodeCount != 0 do
			(
				ObjectPaint.ListSelectedIndex = 0
				for i = 1 to nodeCount where objlist.selection[i] do
				(
					ObjectPaint.SetSelectedObject i
					exit
				)
				if ObjectPaint.ListSelectedIndex == 0 then --what was removed was the last item in the list
				(
					ObjectPaint.SetSelectedObject nodeCount
				)
				else ObjectPaint.SetSelectedObject ObjectPaint.ListSelectedIndex
			)
			updateToolbarButtons()
		)
	)
	if ObjectPaint.nodeDialogPos == [0,0] then createDialog ObjectPaintNodeDialog 200 282
	else createDialog ObjectPaintNodeDialog 200 282 ObjectPaint.nodeDialogPos.x ObjectPaint.nodeDialogPos.y
)
) --end ObjectPaintStruct
ObjectPaint = ObjectPaintStruct()
ObjectPaint.LoadDefaultSettings()
PolyBoost.FreeformLoadDefaultSettings()

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB2kk6i1HJNeDQYM/q+8ClKBD9ZXXHY4mqL
-- 47WqEBwdbGb/lzNc0xL+KOBeZnY1IqeHacI0Reac/gQxiZPAFSZ8ocffikX7SR3i
-- 9LQ0l9V+TM9SGwvMyYaZPIxDN6WZ8iSwPZhiIuh6ZpL0dcFElFwEJPYIdQilJd/0
-- fdjP+aZ7II0BvOAJIbDFu/TwtTapM07gzY6S2YDu7nyTbdqIu0IdEXISeQL5Ijcb
-- oFNByRqU0ahKPxL6NwBrdeXcRtzQTYMmIm8qmMPAof9Vm5eMqS/HZ/WAoHgx7A7V
-- bQlYD5/tD8ci4ChmqnB9iyAvSonbEWC8T3flbhjVFDsSrfIlv6DH
-- -----END-SIGNATURE-----