-- MAXScript File
-- Created:  May 04, 2011
-- Author:   David Cunningham
-- Support scripts for Ribbon
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

struct Main_Ribbon
(
	
fn AllAreEditPatch =
(
	local isPatch = true
	if (classof $ != ObjectSet) then
	(
		isPatch = classof $ == Editable_Patch
	)
	else 
	(
		for i = 1 to $.count while isPatch do
		(
			isPatch = classof $[i] == Editable_Patch
		)
	)
	isPatch
),

fn AllAreClass classToCheck=
(
	local isClass = true
	if (classof $ != ObjectSet) then
	(
		isClass = classof $ == classToCheck
	)
	else 
	(
		for i = 1 to $.count while isClass do
		(
			isClass = classof $[i] == classToCheck
		)
	)
	isClass
),

fn AllAreSuperclass superclassToCheck=
(
	local isClass = true
	if (classof $ != ObjectSet) then
	(
		isClass = superclassof $ == superclassToCheck
	)
	else 
	(
		for i = 1 to $.count while isClass do
		(
			isClass = superclassof $[i] == superclassToCheck
		)
	)
	isClass
),

fn IsPrimitive objToCheck=
(
	if(objToCheck != undefined) then objToCheck.category == #Standard_Primitives or objToCheck.category == #Extended_Primitives 
	else
		false
),

fn AllArePrimitives =
(
	local isPrim = true
	if (classof $ != ObjectSet) then
	(
		isPrim = IsPrimitive $
	)
	else 
	(
		for i = 1 to $.count while isPrim do
		(
			isPrim = Main_Ribbon.IsPrimitive $[i]
		)
	)
	isPrim
),

fn FlipAllLights =
(
	for x in $selection where ((superclassof x.baseobject)==Light) do (try ( x.on = (not x.on)); catch())
),


fn EscapeSOMode =
(
	subobjectlevel=0
	clearselection()
),


fn AllChildrenSelectedRecursive theNode =
(
	local res = true
	for child in theNode.children while res do
	(
		if  not child.isSelected then 
			res = false
		else
			res = Main_Ribbon.AllChildrenSelectedRecursive child
	)
	res
),

fn IsValidGroupSelection =
(
	local selCount = selection.count
	local onlyWholeGroupSelected = selCount != 0
	-- check for the edge case of a single open group head selected
	if(selcount == 1 and (isOpenGroupHead $ or isGroupMember $)) then
	(
    	onlyWholeGroupSelected = true
	)
	else 
	(
		for obj in selection while (onlyWholeGroupSelected) do
		(
			onlyWholeGroupSelected = ((isGroupMember obj) and obj.parent.isSelected) or (isGroupHead obj)
			if (onlyWholeGroupSelected and (isGroupHead obj)) do
			(
				onlyWholeGroupSelected = Main_Ribbon.AllChildrenSelectedRecursive obj
			)
		)
	)
	onlyWholeGroupSelected
)

)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAo2T0D19oPqSTGgVfaF8ZGD/YBFQIFU4wf
-- q7NA/+a+WjRWP9WkAfEwcsqXW+UV5LVMbpTYYDZSZBtDtNaTWgFCCOYhMuMkgorU
-- UK1Ec7O5my5gpGkgauflE0edfJ5j6e3Dr52t3yweuzkYFrArNTVkfzofRy+3oaFp
-- 4xmZIsYTaPfQJMP3qr7Si3qn0EPZAC7UeOrmVzirARl0PFbpMbb1jEyQWg8f2HMd
-- qtL908hl6MaIWe1qW3u+rPBbfRHINPLau+Pc6gmX5c5KlBUtG6xFHohDTM8cGaS3
-- cC4mX8qRFRr2MBOmA5unMPXSto7jfAgvrXYV2vRv033AZigdFqIK
-- -----END-SIGNATURE-----