
-- This structure wraps operations specific to Max Creation Graph
global lvops --using lvops "ListViewOps" struct definition found in <3dsmax>\stdplugs\stdscripts\NET_ListViewWrapper.ms
struct MCGParameterOps
(
	--Resources
	AddButtonText = ~ARRAYPARAM_ADD~,
	UpdateButtonText = ~ARRAYPARAM_UPDATE~,
	InsertButtonText = ~ARRAYPARAM_INSERT~,
	RemoveButtonText = ~ARRAYPARAM_REMOVE~,
	ArrayParamValueText = ~ARRAYPARAM_VALUE~,
	ReinitSimButtonText = ~REINITSIM_VALUE~,
	NoAssetToolTipTest = ~ASSETPARAM_NOFILE_TEXT~,
	
	NodeWrapperClass = dotNetClass "Autodesk.Max.MaxPlus.INode",
	fn InitListView table columnNamesArray colWidths =
	(
		local colNames = #("") + columnNamesArray
		lvops.InitListView table pLabelEdit:false pAllowReorder:false pInitColumns:colNames pInitColWidths:colWidths pCheckBoxes:false
		local sortOrder = dotNetClass "System.Windows.Forms.SortOrder"
		table.Sorting = sortOrder.None; --remove the sorting
		table.hideSelection = false --show row selection
	),
	fn GetSelectionIndices lv = --returns an array of indices hat are zero based.
	(
		local count = lv.SelectedItems.Count-1
		local indices = #()
		for i = count to 0 by -1 do
		(
			append indices (lv.SelectedItems.Item[i].index)
		)
		return indices
	),
	fn FillInOneColTable lv objectsList objectToStringFunc =
	(
		local theRange = #()
		local LineNumber = 1
		for o in objectsList do
		(
			li = dotNetObject "System.Windows.Forms.ListViewItem" (lineNumber as string)
			li.SubItems.add (objectToStringFunc o)
			append theRange li
			LineNumber=LineNumber+1
		)
		lv.Items.Clear()
		lv.Items.AddRange theRange
	),
	fn MakeNodeWrapper obj =
	(
		if(NodeWrapperClass == undefined) do
		(
			NodeWrapperClass = dotNetClass "Autodesk.Max.MaxPlus.INode"
		)
		return (NodeWrapperClass._CreateWrapper obj)
	),
	fn ToStringFunc n =  ( n as string ),
	fn INodeToStringFunc n = 
	( 
		if(n == undefined) then
		(
			return "undefined"
		)
		else
		(
			return n.name 
		)
	),
	fn OneColParamsOpen ui tab toStringMethod colNamesArray &selected: = 
	(
		InitListView ui colNamesArray #(20,99)
		FillInOneColTable ui tab toStringMethod
		--load list selection
		for item in selected do
		(
			lvops.SelectLvItem ui item
		)
		selected = #()
	),
	fn OneColParamsClose ui &selected: =
	(
		--save list selection
		local count = ui.SelectedItems.Count-1
		while (ui.items.count > 0 and count >= 0) do
		(
			append selected (ui.SelectedItems.Item[count].index)
			count = count - 1
		)
	),
	fn OneColArrayParamPreInvoke ui tab paramsOpen toStringMethod = 
	(
		if paramsOpen do
		(
			for n =1 to (tab.count) do
			(
				local val = lvops.GetLvItemName ui (n-1) 1
				local tabVal = toStringMethod(tab[n])
				if(val != tabVal) do
				(
					lvops.SetLvItemName ui (n-1) 1 tabVal
				)
			)
		)
	),
	
	
	--Float Parameter Array Functions
	fn FloatA_Initialization &list: = 
	(
		if list == undefined then
		(
			list = (dotNetClass "Viper3dsMaxBridge.FloatList").CreateInstance()
		)
		else
		(
			list.Clear()
		)
	),
	fn FloatA_ParamPreInvoke ui list tab paramsOpen = 
	(
		--update UI
		OneColArrayParamPreInvoke ui tab paramsOpen ToStringFunc
		--Always Update List
		list.Clear()
		for ele in tab do
		(
			list.AddElement ele
		)
	),
	fn FloatA_TabChanged action index count ui list tab =
	(
		if action == #append then
		(
			for i = 1 to count do
			(
				lvops.AddLvItem ui pTextItems:#(index as string, tab[index] as string)
			)
		)
		if action == #insert then
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
			lvops.SelectLvItem ui (index-1)
		)
		else if action == #SetCount then
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
		)
		else if action == #delete then
		(
			for i = 0 to count-1 do
			(
				lvops.DeleteLvItem ui (index+i-1)
			)
			--update the line numbers
			for i = index-1 to ui.items.count-1 do
			(
				lvops.SetLvItemName ui i 0 ((i+1) as string)
			)
		)
		else if action == #sort then
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
		)
		else
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
		)
	),
	fn FloatA_TabSet val index ui list = 
	(
		lvops.SetLvItemName ui (index-1) 1 val
	),
	fn FloatA_AddToList tab spinner =
	(
		append tab spinner.value
	),
	fn FloatA_UpdateSelected ui tab spinner =
	(
		local indecies = GetSelectionIndices ui
		for index in indecies do
		(
			tab[index+1] = (spinner.value)
		)
	),
	fn FloatA_InsertToList ui tab spinner =
	(
		if ui.SelectedItems.Count > 0 then
		(
			index = ui.SelectedItems.Item[0].index
			insertItem (spinner.value) tab (index+1)
		)
	),
	fn FloatA_RemoveFromList ui tab =
	(
		local indecies = GetSelectionIndices ui
		for index in indecies do
		(
			deleteItem tab (index+1)
		)
	),
	
	
	--INode Parameter Array Functions
	fn INodeA_Initialization &list: = 
	(
		if list == undefined then
		(
			list = (dotNetClass "Viper3dsMaxBridge.INodeList").CreateInstance()
		)
		else
		(
			list.Clear()
		)
	),
	fn INodeA_PreInvoke ui list tab paramsOpen = 
	(
		--update UI
		OneColArrayParamPreInvoke ui tab paramsOpen INodeToStringFunc
		--Update List
		if list.list.count == 0 then
		(
			for ele in tab do
			(
				list.AddElement (MakeNodeWrapper ele)
			)
		)
	),
	fn INodeA_TabChanged action index count ui list tab paramsOpen =
	(
		list.clear() --table changed clear the list and rebuild before evaluation
		if (paramsOpen == false) then
		(
			return ok
		)
		if action == #append then
		(
			for i = 1 to count do
			(
				lvops.AddLvItem ui pTextItems:#(index as string, tab[index].name)
			)
		)
		else if action == #insert then
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
			lvops.SelectLvItem ui (index-1)
		)
		else if action == #SetCount then
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
		)
		else if action == #delete or action == #refDeleted then
		(
			for i = 0 to count-1 do
			(
				lvops.DeleteLvItem ui (index+i-1)
			)
			--update the line numbers
			for i = index-1 to ui.items.count-1 do
			(
				lvops.SetLvItemName ui i 0 ((i+1) as string)
			)
		)
		else if action == #sort then
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
		)
		else
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
		)
	),
	fn INodeA_TabSet newNode index ui list paramsOpen = 
	(
		list.clear()
		if (paramsOpen == false) then
		(
			return ok
		)
		lvops.SetLvItemName ui (index-1) 1 (newNode.name)
		
	),
	fn INodePickingMethod tab =
	(
		try
		(
			local n = pickobject message:~PICKOBJECT_MESSAGE~
			while(n != undefined and n != #escape) do
			(
				if ((findItem tab n) == 0) do
				(
					append tab n --might throw exception is a dependency loop is detected
				)
				n = pickobject message:~PICKOBJECT_MESSAGE~
			)
		)
		catch ()
	),
	fn INodeA_AddToList tab state checkBtn = 
	(
		if state == on then
		(
			INodePickingMethod tab
			checkBtn.state = off
		)
		else
		(
			-- exit pickobject mode if turning the button off
			toolmode.commandmode = #SELECT
		)
	),
	fn INodeA_RemoveFromList ui tab =
	(
		local indecies = GetSelectionIndices ui
		for index in indecies do
		(
			deleteItem tab (index+1)
		)
	),
	
	--String Parameter Functions
	fn StringParameterEdit editText paramString =
	(
		if editText.text != paramString then
		(
			if editText.caption[1] != "*" then editText.caption = "*" + editText.caption
		)
		else
		(
			editText.text = paramString
			if editText.caption[1] == "*" then editText.caption = 
			editText.caption = substring editText.caption 2 (editText.caption.count-1)
		)
	),
	
	--Asset Parameter Functions
	fn AssetParamPickFile paramAsset assetUI =
	(
		local pathSeed = paramAsset
		if (pathSeed == undefined or pathSeed == "") then (
			pathSeed = (dotNetClass "Viper3dsMaxBridge.Main").UserToolsDirectory
		)
		local f = getOpenFileName caption:"" filename:pathSeed
		if f == undefined or f == "" then (
			f = undefined
		)
		else (
			assetUI.tooltip = f
		)
		return f
	),
	fn AssetParamSetToolTip paramsOpen paramAsset assetUI =
	(
		if paramsOpen then
		(
			if (paramAsset == undefined or paramAsset == "") then
			(
				assetUI.tooltip = NoAssetToolTipTest
			)
			else
			(
				assetUI.tooltip = paramAsset
			)
		)
	)
)
global mcgOps = MCGParameterOps()
global mcgAPOps = mcgOps -- for compatibility with existing custom UI code

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA4LGqttv+mBgUWEWY2Q1EFDcztKJBSJ+8j
-- vgEnAmIp2sbimde+O/JtOkOxigZ33pLjhceggfogtY9Ta64h/S6EcTP7axMFRzze
-- XJsFQRNHEEIibVkK7zdKlOWnfscLePJEgKyMfyGMpO8mE9PWH3UuxKaGBCfBKftk
-- c3QZ3gaGf1II/9FSB/zfYR4LE2h5dML7lN/Z/obWj0tZFB0h/bZicnvh2CI0ZswH
-- VIic4l2hfXQq/fSRZ27/NWX+3mudMoT3lJZw07XN1e28UT+BPzNVkAOLiEPyNdyB
-- DoL5oCxNiW/w/l/e7E0WYg20HiU3466IzyDC6CUjoOMboqC6S/HN
-- -----END-SIGNATURE-----