plugin Geometry IdleAreaObj
name:~NAME_IDLE_AREA~
classID:#(685327,452283)
extends:Editable_Poly replaceUI:true version:1
invisible:true
( 
	fn LookAtObjFilter obj =
	(
		classof obj != GeppSkinObj and classof obj.controller != GeppSegCharControl
	)
	parameters main rollout:params
	(
		--- people
		density		type:#float		default:0.5	animatable:false ui:density
		groups			type:#float		default:0.5		animatable:false	ui:groups
		pair			type:#float		default:0.5		animatable:false	ui:pair
		gender			type:#float		default:0.5		animatable:false	ui:gender
		--- individual orientations
		orient			type:#float		default:0.0		animatable:false	ui:orient
		orientspread	type:#float		default:360.0	animatable:false	ui:orientspread
		lookat			type:#boolean	default:false	animatable:false	ui:lookat
		lookatobj		type:#node						animatable:false	ui:idle_lookatobjBtn
		--- sampling
		randseedGroup	type:#integer	default:1		animatable:false	ui:randseedGroup
		randseedIndiv	type:#integer	default:1		animatable:false	ui:randseedIndiv
		randseedRot		type:#integer	default:1		animatable:false	ui:randseedRot
		randseedGen		type:#integer	default:1		animatable:false	ui:randseedGen
		randseedMtn		type:#integer	default:1		animatable:false	ui:randseedMtn
		id				type:#integer	default:1		animatable:false

		-- enforce parameter ranges
		on density set val do (if (val < 0) then this.density = 0  if (val > 1) then this.density = 1)
		on groups  set val do (if (val < 0) then this.groups  = 0  if (val > 1) then this.groups  = 1)
		on pair    set val do (if (val < 0) then this.pair    = 0  if (val > 1) then this.pair    = 1)
		on gender  set val do (if (val < 0) then this.gender  = 0  if (val > 1) then this.gender  = 1)
		on orient  set val do (if (val < 0) then this.orient  = 0  if (val > 360) then this.orient  = 360)
		on orientspread  set val do (if (val < 0) then this.orientspread  = 0  if (val > 360) then this.orientspread  = 360)
		on randseedGroup set val do (if (val < 1) then this.randseedGroup = 1)
		on randseedIndiv set val do (if (val < 1) then this.randseedIndiv = 1)
		on randseedRot   set val do (if (val < 1) then this.randseedRot   = 1)
		on randseedGen   set val do (if (val < 1) then this.randseedGen   = 1)
		on randseedMtn   set val do (if (val < 1) then this.randseedMtn   = 1)
	)
	rollout params ~PARAMS_IDLE_AREA~
	(
		group ~GROUP_PEOPLE~
		(
			slider density		~SLIDER_IDLE_DENSITY~ 	range:[0.0, 1.0, 0.5]	scale:.01 ticks:0 offset:[6,0]
			slider groups		~SLIDER_IDLE_GROUPS~  	range:[0.0, 1.0, 0.5]	scale:.01 ticks:0 offset:[6,0]
			slider pair			~SLIDER_IDLE_PAIR~		range:[0.0, 1.0, 0.5] 	scale:.01 ticks:0 offset:[6,0]
			slider gender		~SLIDER_IDLE_GENDER~	range:[0.0, 1.0, 0.5] 	scale:.01 ticks:0 offset:[6,0]
		)
		group ~GROUP_SINGLE_ORIENTATION~
		(
			slider orient		~SLIDER_IDLE_ORIENT~			range:[0.0, 360.0, 0.0]	scale:.01 ticks:0 offset:[6,0]
			slider orientspread	~SLIDER_IDLE_ORIENT_SPREAD~ 	range:[0.0, 360.0, 360.0]	scale:.01 ticks:0 offset:[6,0]
			checkbox lookat		~CHECKBOX_IDLE_LOOKAT~			offset:[6,0]
			pickbutton idle_lookatobjBtn	~PICKBUTTON_IDLE_LOOKATOBJBTN~	width:60 offset:[30,-24] toolTip:~TOOLTIP_PICK_LOOKATOBJ~ filter:LookAtObjFilter
		)
		group ~GROUP_RANDOMIZATION_SEED~
		(
			spinner randseedGroup	~SPINNER_IDLE_RANDERSEEDGROUP~	align:#right range:[1, 10000, 1]	scale:1 fieldwidth:55 offset:[-12,0]
			spinner randseedIndiv	~SPINNER_IDLE_RANDERSEEDINDIV~	align:#right range:[1, 10000, 1]	scale:1 fieldwidth:55 offset:[-12,0]
			spinner randseedRot		~SPINNER_IDLE_RANDERSEEDROT~	align:#right range:[1, 10000, 1]	scale:1 fieldwidth:55 offset:[-12,0]
			spinner randseedGen		~SPINNER_IDLE_RANDERSEEDGEN~	align:#right range:[1, 10000, 1]	scale:1 fieldwidth:55 offset:[-12,0]
			spinner randseedMtn		~SPINNER_IDLE_RANDERSEEDMTN~	align:#right range:[1, 10000, 1]	scale:1 fieldwidth:55 offset:[-12,0]
		)
		on idle_lookatobjBtn picked obj do
		(
			idle_lookatobjBtn.text=obj.name
		)
		on lookatobj set  obj do
		(
			idle_lookatobjBtn.text=obj.name
		)
		on params open do
		(
			if lookatobj != undefined then
			(
				idle_lookatobjBtn.text = lookatobj.name
			)
			else
			(
				idle_lookatobjBtn.text = ~TEXT_NONE~
			)
		)
		--- this will re-enable the simulate button
		on density buttonup do updatetoolbarbuttons()
		on groups buttonup do updatetoolbarbuttons()
		on pair buttonup do updatetoolbarbuttons()
		on gender buttonup do updatetoolbarbuttons()
		on orient buttonup do updatetoolbarbuttons()
		on orientspread buttonup do updatetoolbarbuttons()
		on lookat buttonup do updatetoolbarbuttons()
		on lookatobj buttonup do updatetoolbarbuttons()
		on randseedGroup buttonup do updatetoolbarbuttons()
		on randseedIndiv buttonup do updatetoolbarbuttons()
		on randseedRot buttonup do updatetoolbarbuttons()
		on randseedGen buttonup do updatetoolbarbuttons()
		on randseedMtn buttonup do updatetoolbarbuttons()
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCftZ5Vc6yfzRzyTsqJjLBLVJ2gQ0dNIvE1
-- kJkmSbJey9Y8xGEjsFsmU8lWAeWqOyD8228QBsepU0SZkpAohka4TkBRr4nMR9Bb
-- ekBOM8IihpvVVyfdxoj2/ipv9ULZtnwqr/rVd0xuiLwYi6B/m74hWKobC7JShorE
-- oHmMlI/PIKfgDVHOvC5bllZUzx/ZTZQBc8kg4XG9oEHI8y8POL+19tb4fy82ogHI
-- 59PMbU77zBOs1xdUvhoiLZEl7OWaEJNl3CvblulV+ISfnHkOcJ8jKJVScJ/eA21k
-- n3P61PoYS2+JsZDaD3w23OyNuHqK4Wu1EHpqOiBqeYEEZxKaudCL
-- -----END-SIGNATURE-----