
--------------------------- General Geppetto UI -----------------------------------

struct NumFramesSpinnerCallback
(
	fn OnChanged iValue = 
	(
		pop.numFrames = iValue
		updatetoolbarbuttons() -- for typed in values
	),
	fn onButtonUp iValue =
	(
		updatetoolbarbuttons()
	),
	fn getValue =
	(
		pop.numFrames
	)
)

struct SeatFemalePctSpinnerCallback
(
	fn OnChanged fValue = 
	(
		pop.seatFemalePct = fValue
		updatetoolbarbuttons() -- for typed in values
	),
	fn onButtonUp fValue =
	(
		updatetoolbarbuttons()
	),
	fn getValue =
	(
		pop.seatFemalePct
	)
)

fn popSkinCharSelected =
(
	for i in selection do
		if classof i == popSkinObject
		then return true
	return false
)

--------------------------- Crowd Area Draw Tools -----------------------------------

fn CrowdAreaToolToggle toolType =
(
	currentTool = CrowdAreaGetActiveTool()
	if (currentTool != 0) then --End any active tool
	(
		max modify mode
		CrowdAreaEnd()
		PBEndTrack()
		if (currentTool != toolType) do --Start another tool
		(
			CrowdAreaSetup toolType
			PBStartTrack CrowdAreaDrawing 1
--			CrowdAreaEnd()
		)
	)
	else --Start tool
	(
		CrowdAreaSetup toolType
		PBStartTrack CrowdAreaDrawing 1
--		CrowdAreaEnd()
	)
)

fn CrowdAreaEndTools =
(
	CrowdAreaEnd()
	PBEndTrack()
)

struct CrowdAreaBrushSizeSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetBrushSize iValue
	),
	fn getValue =
	(
		CrowdAreaGetBrushSize()
	)
)

struct CrowdAreaBrushSizePathSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetBrushSizePath iValue
	),
	fn getValue =
	(
		CrowdAreaGetBrushSizePath()
	)
)

struct CrowdAreaCircleSidesSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetCircleSides iValue
	),
	fn getValue =
	(
		CrowdAreaGetCircleSides()
	)
)


--------------------------- Called by Orchestrator Actions -----------------------------------

fn ActionCreateFlow =
(
	if (CrowdAreaGetActiveTool() == 0) then
	(
		subobjectlevel = 0
		CrowdAreaSetup 6
		PBStartTrack CrowdPathDrawing 1
--		CrowdAreaEnd()
	)
	else
	(
		currentTool = CrowdAreaGetActiveTool()
		CrowdAreaEnd()
		PBEndTrack()
		if (currentTool != 6) do
		(
			subobjectlevel = 0
			CrowdAreaSetup 6
			PBStartTrack CrowdPathDrawing 1
--			CrowdAreaEnd()
		)
	)
)

fn ActionEditFlow =
(
	if (CrowdAreaGetActiveTool() != 0) do
	(
		CrowdAreaEnd()
		PBEndTrack()
	)
	if (subobjectlevel == 1 or subobjectlevel == 2) then
	(
		subobjectlevel = 0
	)
	else
	(
		max modify mode
		subobjectlevel = 1
	)
)

fn ActionExtendFlow =
(
	currentTool = CrowdAreaGetActiveTool()
	CrowdAreaEnd()
	PBEndTrack()
	if (currentTool != 7) do
	(
		CrowdAreaSetup 7
		PBStartTrack CrowdPathExtend
		--CrowdAreaEnd()
		--CrowdDoRestartPathTool() --If user clicked endpoint, start path drawing tool
	)
)

fn ActionIdleAddMode =
(
	if (CrowdAreaGetAddMode() == 1) then
	(
		CrowdAreaSetAddMode 0
	)
	else
	(
		CrowdAreaSetAddMode 1
	)
	updateToolbarButtons()
)

fn ActionIdleSubtractMode =
(
	if (CrowdAreaGetAddMode() == 2) then
	(
		CrowdAreaSetAddMode 0
	)
	else
	(
		CrowdAreaSetAddMode 2
	)
	updateToolbarButtons()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAalxsMncYSEtBesPu3jbZlfg2cM3VEKQsR
-- VraAtxDrl8II3IY/MssUZgrIWCP37ea0+90pJDfM5Gg0sc965Y+T8pwR3/Rb0A4q
-- 1qeC3bS4qLlBanYEoNXDOELox6mRUYyL5xJDzlRrYXrOVgvDTVfKiQMy45at50iu
-- ADisxVbJmpPy8E5+qkywye3qi30sl+07jVPu1HnL5li6j0YGfCdHEM5bBiaQmQf3
-- 2pUlBWs7dm71D8FPG3pcAyclKafefUz8G4PTmT/ROQ6auXXUjI1/pwUbg1SMLC+i
-- uqlBSfD3csMjyhZBlnpvmWlcZXv23Mor3W3Bt3an5purTxgaVTIB
-- -----END-SIGNATURE-----