
-- Creates the given camera class (FreeCamera, TargetCamera, PhysicalCamera) from the current view
-- Used by the macroscript associated with ctrl-c
fn CreateCameraFromView camera_class =
(
	--camera variable
	local c
	local wcol = (color 5 54 179)
	local targdist = viewport.GetFocalDistance()
	-- get viewport tm
	local viewfov = getVIewFOV()
	local cXform =  InverseHighPrecision(viewport.getTM())
	  
	--disablesceneredraw() 
	-- perspective views
	if viewport.Gettype() == #view_persp_user
	then
	(
	if (superclassof selection[1]) == camera --check if selection is a camera
		then --if selection is a camera, than call the match camera to view action
		(
			actionMan.executeAction 0 "40249" --loc_notes: do not localize this
		)
		else --if selection is not a camera, then create it for the user
		(
			-- creates a camera, and assigns the current Vport Transforms
			c = camera_class  targetDistance:targdist isSelected:on wirecolor:wcol
			-- Physical camera needs to be set to "Specify FOV"
			if(camera_class == Physical_Camera) then
			(
				c.specify_fov = true
			)
			c.fov = viewfov			
			-- Force perspective camera. Standard camera has "orthoProjection" property, but Physical camera doesn't.
			if(hasproperty c "orthoProjection") then
			(
				c.orthoProjection = false 
			)
			c.Transform = cXform 
			viewport.setcamera c
			if(Perspective_Match.IsMatching() == false) then
			(
				-- Standard camera has "type", Physical camera has "targeted"
				if(hasproperty c "type") then
					c.type = #target
				else if(hasproperty c "targeted") then
					c.targeted = true
				c.target.wirecolor = wcol
			)
			else
			(
				-- Standard camera has "type", Physical camera has "targeted"
				if(hasproperty c "type") then
					c.type = #free
				else if(hasproperty c "targeted") then
					c.targeted = false				
			)
		)--end then
	)--end then
	else
	(

	)--end else

	-- clears the local variables
	c = undefined 
	viewfov = undefined
	cXform  = undefined
	  
	--enablesceneredraw()
) 
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAEs5Jc2o+O1TlTIbwJd7mxJ5/X3jjz0wjR
-- pwlFR+hag6fUEfW5LHHDV5D7iC5iUz/snQ0PceNTbkZ5zUxYizmEQTmvRjbGAkC9
-- Z7NvIfeBR334r3zZjAHwsGhui2Agp4ig6xLJtGcQrQNOijFUiYV1gT7gdBb4IJNk
-- WpnuCxx2OcvuIyg0T9Ki0TH7KZq6T92beVT2a52V076b2QcQfmts+BzD96Q8ZugL
-- xkHLXK46wY3pKrzvzASJHtxTZq+2FqwPQpqbdg4iByM0XG78bIROtXCf6GrG6B6J
-- oYhuk9JFwgpdjZEgICNnB3HpVx39MyZOMN3AS3nHI9qVhHJUk/qf
-- -----END-SIGNATURE-----