-------------------------------------------------------------------------------------------
--   File:		CharacterPluginobject.MS
--   Description:	A character assembly scripted plugin
--   By:			Ravi Karra [Discreet] 			ravi.karra@autodesk.com
--   Created:		11/26/01
--	Modified:		
--	05/08/2003 - aszabo - 
--		Added ability to add multiple members at once or without re-clicking 
--		the Add button. "Add" btn uses pickObject count:1. "Add List" button 
--		allows for picking multiple objects from Select By Name dlg
--	06/08/2003 - aszabo - 
--		Fixed #429406. Display of low\full\all objects is done on on displayRes 
--		get handler. displayRes made non-animatable
--	04/20/2006 - Chris P. Johnson
--		Removed the activeX listview control, replaced it with a dotNet listview
--		Cleaned up the code, and routed most calls to the listview through a
--		 light listview wrapper.
--		Part of cleaning up the code was removing a few global variables and
--		 taking the rcmenu out of the global scope. This removed the need for the
--		 timer and all the garbage that went with it.
--		Version was changed to 2
--***********************************************************************************************
--global g_characterAction, g_characterTimer,  
global rMergeAnim, rObjectMapping, g_suspendCharacterRedraw = false
	
global lvops --The ListViewOps struct definition found in <3dsmax>\stdplugs\stdscripts\NET_ListViewWrapper.ms

colorMan.registerColor #chr_color ~WIRE_COLOR~ ~CHARACTER~ [0.858824,0.858824,0]

plugin helper CharacterAssembly
name:~NAME_CHARACTER~
category:"Standard"
classID:#(0xcbbf6436, 0x899498a9)
extends:character
replaceui:true
invisible:true
version:2
(
	--Variable declarations
	local m_AssemblyHead	--The head of the assembly or group.
	local m_Members = #()	--The members of the assembly or group. These are also children to m_AssemblyHead
		
	-- This flag is used to keep the Add checkbutton depressed while picking character members
	local inPickMode = false
	local lastDisplayRes = 0
	
	function getGroupHead nodes = 
	(	
		local theGroupHead = undefined
		for n in nodes do 
		(
			if isGroupHead n then 
			(
				theGroupHead = n
			)		
		)
		theGroupHead
	)
	function genRndNumber = 
	(
		local imax = 650000
		(random 1 imax) + (random 1 imax) + (bit.shift ((random 1 imax) + (random 1 imax)) -16)
	)
	function getNodes chr =
	(
		for n in (refs.dependents chr) where ((isValidNode n) and n.baseobject == chr) collect n
	)	
	function getMembers hparent =
	(
		local tempArray = #()
		for c in hparent.children do
		(
			if isGroupMember c then append tempArray c
			join tempArray (getMembers c)
		)
		tempArray
	)
	function getBoundingSize objs = 
	(
		disableSceneRedraw()
		local sel = selection as array
		select objs
		local size = selection.max - selection.min
		select sel
		enableSceneRedraw()
		size
	)
	
	function InitAssemblyHead = 
	(
--		if m_AssemblyHead == undefined then
--		(
			m_AssemblyHead = getGroupHead (selection as array)
			if m_AssemblyHead == undefined then m_AssemblyHead = (getNodes this)[1]
--		)
	)
	

	
	rollout rParams ~RPARAMS_CHARACTER_ASSEMBLY~ width:160 height:324
	(
		GroupBox 	grpPose 			~GRPPOSE_SKIN_POSE~				width:~GRPPOSE_WIDTH~ height:80		align:#center
		button btnSetSkinPose ~BTNSETSKINPOSE_CAPTION~ width:~BTNSETSKINPOSE_WIDTH~ height:16 align:#center offset:[0,-68] --enabled:false
		button		btnAssumeSkinPose 	~BTNASSUMESKINPOSE_CAPTION~ 		width:~BTNASSUMESKINPOSE_WIDTH~ height:16
		checkbutton ckbSkinPoseMode 	~CKBSKINPOSEMODE_CAPTION~		width:~CKBSKINPOSEMODE_WIDTH~ height:16		--enabled:false						
		
		GroupBox 	grpDisplay 		~GRPDISPLAY_CAPTION~ 					width:~GRPDISPLAY_WIDTH~ height:~GRPDISPLAY_HEIGHT~	align:#center offset:~GRPDISPLAY_OFFSET~
		spinner		spnIconSize		~SPNICONSIZE_CAPTION~				width:~SPNICONSIZE_WIDTH~ height:20		align:#left offset:~SPNICONSIZE_OFFSET~ type:#integer range:[1, 1000, 10]

		radioButtons rbDispRes		labels:#(~LOW_RES_OBJECTS~, ~FULL_RES_OBJECTS~, ~ALL_OBJECTS~) columns:1	align:#left across:3  offset:~RBDISPRES_OFFSET~
		
		GroupBox	grpAnim 		~GRPANIM_CAPTION~ 				width:~GRPANIM_WIDTH~ height:85	align:#center offset:~GRPANIM_OFFSET~
		button btnInsertAnim ~BTNINSERTANIM_CAPTION~ width:~BTNINSERTANIM_WIDTH~ height:16 align:#center offset:~BTNINSERTANIM_OFFSET~
		button btnSaveAnim ~BTNSAVEANIM_CAPTION~ width:~BTNSAVEANIM_WIDTH~ height:16 align:#center offset:~BTNSAVEANIM_OFFSET~
		button btnResetAnim	~BTNRESETANIM_CAPTION~ width:~BTNRESETANIM_WIDTH~ height:16	align:#center offset:~BTNRESETANIM_OFFSET~

		function updateUI =
		(
			if m_AssemblyHead != undefined then
				ckbSkinPoseMode.checked = m_AssemblyHead.SkinPoseMode
			btnSetSkinPose.enabled = ckbSkinPoseMode.enabled = btnInsertAnim.enabled = btnSaveAnim.enabled = btnResetAnim.enabled = (m_AssemblyHead != undefined)
		)
		
		on rParams open do 
		(
			InitAssemblyHead()
			updateUI()
		)
		on btnSetSkinPose pressed do
		(
			local res = queryBox ~QUERYBOX_SET_THE_SKIN_POSE~ title:~QUERYBOX_SET_THE_SKIN_POSE_TITLE~
			if res then
			(	
				undo ~UNDO_SET_AS_SKIN_POSE~ on
				(
					m_AssemblyHead.setSkinPose()
					for m in m_members do m.setSkinPose()
				)
			)
		)
		on btnAssumeSkinPose pressed do
		(
			undo ~UNDO_ASSUME_SKIN_POSE~ on
			(						
				ckbSkinPoseMode.checked = false
				m_AssemblyHead.SkinPoseMode = false
				m_AssemblyHead.assumeSkinPose()
				for m in m_members do
				(
					m.SkinPoseMode = false
					m.assumeSkinPose()
				)
			)
		)
		on ckbSkinPoseMode changed state do 
		(
			m_AssemblyHead.SkinPoseMode = state
			for m in m_members do m.SkinPoseMode = state
		)
		on btnDispAll pressed do
		(
			this.displayBones = this.displayHelpers = this.displayGeometry = this.displayIK = this.displayLowRes = this.displayFullRes = true
		)
		
		on btnDispNone pressed do
		(
			this.displayBones = this.displayHelpers = this.displayGeometry = this.displayIK = this.displayLowRes = this.displayFullRes = false
		)
		
		on btnDispInvert pressed do
		(
			this.displayBones = not this.displayBones
			this.displayHelpers = not this.displayHelpers
			this.displayGeometry = not this.displayGeometry
			this.displayIK = not this.displayIK
			this.displayLowRes = not this.displayLowRes
			this.displayFullRes = not this.displayFullRes
		)
		
		on btnInsertAnim pressed do
		(
			rMergeAnim.openDialog()
			rObjectMapping.etCurrent.text = rObjectMapping.etSource.text = m_AssemblyHead.name
			rMergeAnim.btnSource.pressed()
			if rMergeAnim.file_name != undefined then
			(
				rMergeAnim.show_messages = false
				try (
					rMergeAnim.dontFilterChildren = true
					rMergeAnim.updateSource()
					rMergeAnim.updateCurrent()
					rObjectMapping.btnAutoMap.pressed()
				) catch ( MessageBox (~MSGBOX_ERROR_OCCURED_WHILE_MERGING~ + rMergeAnim.file_name))
			)
		)
		on btnSaveAnim pressed do
		(
			local f = getSaveFileName types:"3ds Max Animation (*.anm)|*.anm|XML Animation (*.xml)|*.xml|All (*.*)|*.*|"
			if f != undefined then
			(
				if (getFilenameType f) == ".xml" then
				(
					rMergeAnim.openDialog()
					rMergeAnim.Save2XML f nodes:#(m_AssemblyHead) --.children
					destroyDialog rMergeAnim
				)
				else
				(
					with redraw Off
					(
						local locked = assemblyMgr.canOpen m_AssemblyHead 	
						assemblyMgr.close m_AssemblyHead select:false
						print m_members
						saveNodes m_members f
						if not locked then assemblyMgr.open m_AssemblyHead clearSelection:false
						select m_AssemblyHead
					)
				)
			)
		)
		on btnResetAnim pressed do
		(
			local res = queryBox ~QUERYBOX_RESET_ALL_ANIMATION~ title:~QUERYBOX_RESET_ALL_ANIMATION_TITLE~
			if res then
			(
				undo ~UNDO_RESET_ALL_ANIMATION~ on
				(
					rMergeAnim.resetNodeAnim m_AssemblyHead
					for m in m_members do
						rMergeAnim.resetNodeAnim m
				)
			)
		)
	)
	
	parameters pbParams rollout:rParams
	(
		characterID		type:#integer subAnim:false animatable:false default:0
		iconSize		type:#integer default:10 ui:spnIconSize animatable:false	
		-- Helper objects are not evaluated by the renderer, so switching LOD via  
		-- the displayRes param won't be visible in rendering of frame sequences other than the current frame
		displayRes		type:#radiobtnIndex default:3 ui:rbDispRes animatable:false
		
        	on iconSize get val do 
		(
		    iconsize = delegate.size
		)
		on iconSize set val do
		(
			delegate.Size = val
		)	
	
		-- Updating the hidden\non-hidden state of character members in the get handler
		-- ensures proper display in the viewport of the hidden\non-hidden objects
		on displayRes get val do
		(
			if (val != lastDisplayRes) do
			(	
				lastDisplayRes = val
				case val of
				(
					1: for m in m_members do m.isHidden = ((getAppData m this.characterID) != "true")
					2: for m in m_members do 
					(
						local no_proxy = (getAppData m this.characterID)
						m.isHidden = (no_proxy == "true")
						--format "proxy setting: % - %\n" m no_proxy
					)
					3: (for m in m_members do m.isHidden = false)
				)			
			)
			val
		)
	)
	
	
		
	rollout rMembers ~CHARACTER_MEMBERS~ width:160 height:360
	(
		 
		local listItems
		
		function pickFilter obj = 
		(
			local pickable = obj.baseObject != this	and assemblyMgr.canAttach #(obj) assembly:m_AssemblyHead
/*			while obj.parent != undefined do
			(
				if obj.parent == m_AssemblyHead do return false
				obj = obj.parent
			)
			return pickable
*/			
		)
		
		/* Note: 
			RCMenu's cannot be defined in the body of a plugin, or as a member of a rollout. 
			This RCmenu will get defined in the initListView function when the rollout opens. */
		local CharMenu --RCMenu

		checkbutton ckAdd		 	~CKADD_CAPTION~ 		width:~CKADD_WIDTH~ height:~CKADD_HEIGHT~		align:#left   offset:~CKADD_OFFSET~ across:3
		button		btnAddList	~BTNADDLIST_CAPTION~	width:~BTNADDLIST_WIDTH~ height:~BTNADDLIST_HEIGHT~		align:#center offset:~BTNADDLIST_OFFSET~
		button 		btnRemove		~BTNREMOVE_CAPTION~		width:~BTNREMOVE_WIDTH~ height:~BTNREMOVE_HEIGHT~		align:#right  offset:~BTNREMOVE_OFFSET~ enabled:false
		dotNetControl  lvMembers 	"ListView"	width:160 height:620	align:#center offset:[0,0]
		
		function getProxySetting obj = --no change needed
		(
			(getAppData obj characterID) == "true"
		)
		function setProxySetting obj val = --no change needed
		(
			setAppData obj characterID (val as string)
			
			case this.displayRes of
			(
				1: obj.isHidden = not val
				2: obj.isHidden = val
				3: obj.isHidden = false
			)
		)
		function updateUI = --fixed
		(
			local sel = lvops.GetLvSelection lvMembers --Returns an array of selected ListViewItem's
			ckAdd.enabled = (m_AssemblyHead != undefined)
			ckAdd.state = inPickMode
			btnAddList.enabled = (m_AssemblyHead != undefined)
			
			btnRemove.enabled = CharMenu.mi_remove.enabled = ((sel.count > 0) and (assemblyMgr.canDetach sel[1].tag.value))	
		)
		function initListView = --fixed
		(
			lvops.InitListView lvMembers pCheckBoxes: true
			
			lvops.AddLvColumnHeader lvMembers pCaption: ~LVMEMBERS_CAPTION~ pWidth: (rMembers.Width - 10)
			lvops.refreshListView lvMembers
			
			CharMenu = rcmenu CharacterMenu
			(
				menuItem mi_remove		~MI_REMOVE_CAPTION~
				menuItem mi_lowres		~MI_LOWRES_CAPTION~
				menuItem mi_fullres		~MI_FULLRES_CAPTION~		
				
				on mi_remove	picked do ( rMembers.executeAction #remove )
				on mi_lowres	picked do ( rMembers.executeAction #lowres )
				on mi_fullres	picked do ( rMembers.executeAction #fullres)
			)
		)
		function updateList = --fixed
		(	
			m_Members = #()
			if m_AssemblyHead != undefined then (m_Members = getMembers m_AssemblyHead)
			
			lvops.ClearLvItems lvMembers
				
			-- Cache these methods to increase performance
			local LVAdd = lvops.AddLvItem
			
			for m in m_members do
			(
				local doCheck = (getProxySetting m) as booleanClass
				
				LVAdd lvMembers pTextItems: #(m.name) pTag: (dotNetMXSValue m) pChecked: doCheck
			)
			lvops.SelectLvItem lvMembers 0
			
			UpdateUI()
		)
		function removeSelMembers =  --fixed
		(
			local selectedLVItems = lvops.GetLvSelection lvMembers
			undo ~UNDO_REMOVE_CHARACTER_MEMBERS~ on
			(
				for li in selectedLVItems where li.selected do
				(
					--g_characterTimer = tmr
					--callbacks.addScript #sceneUndo "g_characterTimer.active = true" id:#character
					--callbacks.addScript #sceneRedo "g_characterTimer.active = true" id:#character					
					
					local member = undefined
					if (li.tag != undefined and li.tag.value != undefined) do member = li.tag.value	
						
					local hparent = if member.parent == m_AssemblyHead then m_AssemblyHead.parent else member.parent
					member.parent = undefined
					assemblyMgr.detach member
					-- reset the parent
					member.parent = hparent
					if (getProxySetting member) then
						member.isHidden = false
				)
				updateList()
			)
		)		
		function executeAction action = --fixed
		(
			case action of
			(
				#remove:
				(
					removeSelMembers()
				)
				#lowres:
				(
					local selectedLVItems = lvops.GetLvSelection lvMembers
					for li in selectedLVItems where li.selected do
					(
						setProxySetting li.tag.value true
						li.checked = true
					)
				)
				#fullres:
				(
					local selectedLVItems = lvops.GetLvSelection lvMembers
					for li in selectedLVItems where li.selected do
					(
						setProxySetting li.tag.value false
						li.checked = false
					)
				)
			)
			rParams.updateUI()
			if g_suspendCharacterRedraw then redrawViews()
		)
		on rMembers open do --no change needed
		(			
			if not g_suspendCharacterRedraw then
			(
				initListView()
				updateList()
			)
		)
		on lvMembers itemChecked arg do --fixed
		(
			-- arg is System.Windows.Forms.ItemCheckedEventArgs
			--print (arg.item.checked)
			setProxySetting (arg.item.tag.value) arg.item.checked
		)
		on lvMembers afterLabelEdit arg do --fixed
		(
			local lvItem = lvMembers.items.item[arg.item]
			if (arg.label != undefined) do (
				lvItem.tag.value.name = arg.label
			)
		)
		on lvMembers SelectedIndexChanged arg do --fixed up (mostly)
		(
			--the arg returned here is useless
			local selectedLVItems = lvops.GetLvSelection lvMembers
			
			if (selectedLVItems.count > 0) then
			(
				local lastIndex = selectedLVItems.count
				local obj = selectedLVItems[lastIndex].tag.value
				btnRemove.enabled = CharMenu.mi_remove.enabled = (assemblyMgr.canDetach obj)
			)
		)
		on lvMembers MouseUp arg do --fixed
		( 	
			-- arg is System.Windows.Forms.MouseEventArgs
			local mouseButtons = dotNetClass "System.Windows.Forms.MouseButtons"
			local pt = point2 arg.x arg.y
			
			if arg.button == mouseButtons.right do
			(
				g_characterAction = undefined
				g_characterTimer = tmr
				popupmenu CharMenu pop:[pt.x, pt.y] rollout:rMembers
			)
		)
		
		on btnAddList pressed do --fixed
		(
			local objs = (selectByName title:~OBJS_PICK_CHARACTER_MEMBERS_TITLE~ buttonText:~OBJS_PICK_CHARACTER_MEMBERS_BUTTONTEXT~ filter:pickFilter showHidden:false single:false)
			if (objs != undefined) do
			(
			    --format "objs.count=%\n" (objs as array).count
				undo ~UNDO_CHAR_MEMBERS~ on
				(
					assemblyMgr.attach (objs as array) assembly:m_AssemblyHead
					for obj in objs do setProxySetting obj false	
				)
				updateList()
			)
		)

		function PickMultiple = --no fix needed
		(
			while ((obj = (pickObject message:~PICKOBJECT_MESSAGE~ count:1 filter:pickFilter forceListenerFocus:false)); isValidNode obj) do
			(
				undo ~UNDO_ADD_CHAR_MEMBERS~ on
				(
					assemblyMgr.attach obj assembly:m_AssemblyHead
					setProxySetting obj false	
				)
			)
		)

		on ckAdd changed theState do --no fix needed
		(
			if (true == theState ) then 
			(
				inPickMode = true
				
				PickMultiple()
			  	
				inPickMode = false
				ckAdd.checked = false
			)
			else 
			(
				-- When the user clicks on the Add button to turn it off,
				-- terminate the current pickObejct mode
				toolmode.CommandMode = #select
			)
		)
		
		on btnRemove pressed do --no fix needed
		(
			removeSelMembers()
		)
	) --End of Rollout
	
	on create do
	(

		
		if this.characterID == 0 then 
		(
			-- assign a unique id to the character
			this.characterID = genRndNumber()
		)
		InitAssemblyHead()
	)	
	
	-- commented for now
	on clone fromObj do
	(
		local thisMembers = #()
		this.characterID = genRndNumber()
		
		-- Get the this node
		InitAssemblyHead()
		if (m_AssemblyHead != undefined) then
		(
			m_AssemblyHead.assemblyBBoxDisplay = false
		)		
	)
	-- Prevent attempts to access UI items that aren't present
	on update do 
	(
		if not g_suspendCharacterRedraw then
		(
			InitAssemblyHead()
			if rParams.open do rParams.updateUI()
			if rMembers.open do rMembers.updateUI()			
		)
		if rMembers.open do g_characterTimer = rMembers.tmr
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCrHvQTvQZ6VzHeLBS0VhOg283dMz+yAQt2
-- zJfWHwqKkHq+1aG+0p6ggHqyOd1DRszwXG/elYN9F5fm+YvyGJdeQByZtv0IZofs
-- MhNHXojRyBfEPvhGF95enMGFS9Hgrx8chQ0eXv1uplNoGneo/15Daw0uKLU5R7LK
-- SSMv72QB4Pxa6ahyhdZuHWBBR486mgitvmftOwWNHGvMlD8blCAUwYkMD8CQ3fQq
-- fT0bl9fBJhetQ3efC938tFaK4jY3mTRWwsHpN3IL6Zu5PO1+J/wrK/UM3xKzfk68
-- +NjB+OOyD7XiK+WrZRAVxJBz92KktTYlAy1gv7IjdZmXneSIIi35
-- -----END-SIGNATURE-----