filein "CATMacroUtilFunctions.ms"

animposeini = ((getDir #plugcfg_ln) + "\\CAT\\animpose.ini");	

global rSaveFile;
rollout rSaveFile ~RSAVEFILE_CAPTION~ width:248 height:65
(
	local catctrl;
	local folderpath;
	local filetype = "Pose";
	local suffix = ".pse";
	
	editText edtFileName "" pos:[8,8] width:216 height:16
	button btnBrowse ~BTNBROWSE_BUTTONTEXT~ 	pos:[224,7] width:18 height:18
	checkbox chkSaveRig ~CHKSAVERIG_CAPTION~ pos:~CHKSAVERIG_POSITION~ width:~CHKSAVERIG_WIDTH~ height:~CHKSAVERIG_HEIGHT~ visible:false;
	
	spinner spnStartTime ~SPNSTARTTIME_CAPTION~ pos:[24,32] width:96 height:16 range:[-99999,99999,0] fieldwidth:50	visible:false;
	spinner spnEndTime ~SPNENDTIME_CAPTION~ pos:[144,32] width:96 height:16 range:[-99999,99999,0] fieldwidth:50		visible:false;

	button btnCancel ~BTNCANCEL_CAPTION~	pos:[100,36] width:72 height:24
	button btnOk ~BTNOK_BUTTONTEXT~ 			pos:[176,36] width:64 height:24
	
	fn ResetSpinnerRanges =
	(
		spnStartTime.range = [-99999, spnEndTime.value, spnStartTime.value]
		spnEndTime.range = [spnStartTime.value, 99999, spnEndTime.value]
	)	
	fn GenerateFilename redo:false =
	(
		-- -we only re-generatethe name if we have the spinners visible(clp);
		aParent = GetCATParent catctrl
		if redo and (filterstring edtFileName.text "-").count != 4 then return OK;
		if chkSaveRig.checked then
		(
			if suffix == ".pse" then
				 edtFileName.text = (aParent.catname +  "-" + (currenttime as string));
			else edtFileName.text = (aParent.catname + "-" + ((spnStartTime.value as time) as string) + ~TO~ + ((spnEndTime.value as time) as string));
		)else(
			if suffix == ".pse" then
				 edtFileName.text = (aParent.catname + catctrl.name + "-" + (currenttime as string));
			else edtFileName.text = (aParent.catname + catctrl.name + "-" + ((spnStartTime.value as time) as string) + ~TO_CAPTION~ + ((spnEndTime.value as time) as string));
		)
		local array = filterstring edtFileName.text "."
		edtFileName.text = "";
		for i in array do edtFileName.text += i +(if (i!=array[array.count])then "_" else "")
	)

	fn InitPaths = 
	(
		if suffix == ".pse" then
			 folderpath = ((getDir #plugcfg_ln) + "\\CAT\\Poses\\");	
		else folderpath = ((getDir #plugcfg_ln) + "\\CAT\\Clips\\");
	
		theParent = GetCATParent catctrl
		if chkSaveRig.checked then
		(
			edtFileName.text = (theParent.catname + "_" + (currenttime as string));
		)
		else
		(
			case (classof catctrl) of
			(
			ArbBone:(		rSaveFile.title = (~SAVE_BONE~ +filetype);		folderpath+=~EXTRA_BONES~;  			);
			HubTrans:(		rSaveFile.title = (~SAVE_HUB~ +filetype);		folderpath+=~HUBS~; 					);
			CATLimbData2:(	rSaveFile.title = (~SAVE_LIMB~ +filetype);		folderpath+=~LIMBS~;	 );
			PalmTrans:(		rSaveFile.title = (~SAVE_PALM~ +filetype);		folderpath+=~PALMS~;	
							edtFileName.text = (theParent.catname + catctrl.limb.name + catctrl.name + "_" + (currenttime as string));
			);
			DigitData:(		rSaveFile.title = (~SAVE_DIGIT~ +filetype);	folderpath+=~DIGITS~;	
							edtFileName.text = (theParent.catname + catctrl.palm.limb.name + catctrl.palm.name + catctrl.name + "_" + (currenttime as string));
			);
			TailData2:(		rSaveFile.title = (~SAVE_TAIL~ +filetype);		folderpath+=~TAILS~;					);
			)
		)
	)

	fn ArrangeUI =
	(
		if suffix == ".clp" then ( -- Save Clip
			spnStartTime.value = currenttime.frame;
			spnEndTime.value = (currenttime.frame + 20);
			spnStartTime.visible = true;
			spnEndTime.visible = true;
			if (classof catctrl) == HubTrans then (
				chkSaveRig.visible = true;
				spnStartTime.pos.y = 56;
				spnEndTime.pos.y = 56;
				btnCancel.pos.y = 86;
				btnOk.pos.y = 86;
				rSaveFile.height = 120;
			) else (
				if (classof catctrl) == CATParentTrans then (
					chkSaveRig.checked = true;
				)
				btnCancel.pos.y = 56;
				btnOk.pos.y = 56;
				rSaveFile.height = 90;
			)
			ResetSpinnerRanges();
		) else ( -- Save Pose
			if (classof catctrl) == HubTrans then (
				chkSaveRig.visible = true;
				btnCancel.pos.y = 56;
				btnOk.pos.y = 56;
				rSaveFile.height = 90;
			) else if (classof catctrl) == CATParentTrans then (
				chkSaveRig.checked = true;
			)
		)
	)

	fn openDialog node type filesuffix = 
	(
		try(destroyDialog rSaveFile)catch();
		createDialog rSaveFile pos:(mouse.pos-[50,-68])  style:#(#style_titlebar) --modal:true
		catctrl = GetCATNodeGroup node;
		filetype = type;
		suffix = filesuffix;
		
		ArrangeUI(); 
		InitPaths();
		GenerateFilename(); 
		
		callbacks.addScript 	#selectionSetChanged	"destroyDialog rSaveFile" 	id:#rSaveFile
		
	)	
	on rSaveFile close do			(	callbacks.removeScripts id:#rSaveFile;	)
	on btnBrowse pressed do
	(
		local file = getSaveFileName 	caption:rSaveFile.title \
										filename:(folderpath + edtFileName.text + suffix) \
										types:("CAT "+filetype+" file (*"+suffix+")|"+suffix)
		if file!= undefined then(
			edtFileName.text = getFilenameFile file;	
			folderpath = getFilenamePath file;
		)
	)
	on btnOk pressed do
	(
		try(
			local file = (folderpath + edtFileName.text + suffix);
			-- Create folder if it doesn't exist...
			makedir folderpath
			if chkSaveRig.checked then
			(
				aParent = GetCATParent catctrl
				if suffix == ".pse" then
					 aParent.SavePose file --spnTime.value
				else aParent.SaveClip file spnStartTime.value spnEndTime.value aParent.SelectedLayer aParent.SelectedLayer
				
				setIniSetting animposeini "LastFiles" 	("Rig"+filetype) file;
				setIniSetting animposeini "Parameters" 	("Rig"+filetype) "true";
			)
			else
			(
				
				if suffix == ".pse" then
					 catctrl.SavePose file --spnTime.value
				else catctrl.SaveClip file spnStartTime.value spnEndTime.value 
				
				case (classof catctrl) of
				(
				ArbBone:(		setIniSetting animposeini "LastFiles" ("ExtraBones"+filetype) file;	)
				HubTrans:(		setIniSetting animposeini "LastFiles" ("Hub"+filetype) 		file;	
								setIniSetting animposeini "Parameters" ("Rig"+filetype)		"false";
				)
				CATLimbData2:(	setIniSetting animposeini "LastFiles" ("Limb"+filetype)		file;	)
				PalmTrans:(		setIniSetting animposeini "LastFiles" ("Palm"+filetype) 	file;	)
				DigitData:(		setIniSetting animposeini "LastFiles" ("Digit"+filetype) 	file;	)
				TailData2:(		setIniSetting animposeini "LastFiles" ("Tail"+filetype) 	file;	)
				default:(		setIniSetting animposeini "LastFiles" ("Hub"+filetype)	 	file;	)
				)
			)
			
			-- Save out a screencapture of the current viewport, users can use this to navigate their poses/clips
			bm = viewport.getViewportDib()
			bm.filename = folderpath + edtFileName.text + ".jpg"
			save bm
			
		)catch( MessageBox ~MSGBOX_SAVE_UNSUCCESSFUL~ );
		destroyDialog rSaveFile;
	)
	on btnCancel pressed do
	(
		destroyDialog rSaveFile;
	)
	on spnStartTime entered do		(		ResetSpinnerRanges();	GenerateFilename redo:true; 	)
	on spnEndTime entered do		(		ResetSpinnerRanges();	GenerateFilename redo:true; 	)
	on chkSaveRig changed state do
	(
		InitPaths();
		GenerateFilename(); 
	)
)


global rLoadFile;
rollout rLoadFile ~LOAD_FILE~ width:168 height:140
(
	local CreateDestroyTransformNode, openDialog, closeDialog, tryDestroyDialog, DoPaste;
	local locked = false;
	local transformnode;
--	local transformnode;
	local initialTranform;
--	local pastebone;
	local selectednode, newselection;
	local pastetime;
--	local autokeystate;
	local rigtm;
	local catctrl;
	local folderpath;
	local files, folders;
	local filetype = "Pose";
	local suffix = ".pse";
	local ok = true;
	
	editText edtFileName "" pos:[5,5] width:140 height:16 enabled:false
	checkbutton btnFiles ">" pos:[145,5] width:18 height:18 
	spinner spnLoadTime ~LOAD_TIME~ pos:[24,26] width:104 height:16 fieldwidth:50 range:[-9999, 9999, currenttime]
	checkbox chkMirror ~MIRROR~ pos:[16,46] width:96 height:16
	checkbox chkLoadRig ~LOAD_WHOLE_RIG~ pos:[16,66] width:~LOAD_WHOLE_RIG_WIDTH~ height:16 visible:false;
--	checkbox chkScale ~SCALE~ pos:[16,66] width:96 height:16
	listbox lbxFiles "" pos:[180,5] width:240 height:9
	
	------------------------------------------------------------------------------
	checkbox chkTransform ~TRANSFORM_TYPE_IN~  pos:[16,86] width:~TRANSFORM_TYPE_IN_WIDTH~ height:16
	button btnResetTransforms ~RESET_TRANSFORMS~ pos:~RESET_TRANSFORMS_POSITION~ width:~RESET_TRANSFORMS_WIDTH~ height:16 visible:false
	local tmgroup = 105
	groupBox grpPos ~POS_OFFSET~ 	pos:[2,tmgroup] 		width:250 	height:40 visible:false 
	spinner spnPosX "X:" 			pos:[14,tmgroup+16] 	width:70 	height:16 visible:false range:[-99999,99999,0]
	spinner spnPosY "Y:" 			pos:[95,tmgroup+16] 	width:70 	height:16 visible:false range:[-99999,99999,0]
	spinner spnPosZ "Z:" 			pos:[175,tmgroup+16] 	width:70 	height:16 visible:false range:[-99999,99999,0]
	groupBox grpRot ~ROT_OFFSET~ 	pos:[2,tmgroup+40] 		width:250 	height:40 visible:false 
	spinner spnRotX "X:" 			pos:[14,tmgroup+72]		width:70 	height:16 visible:false range:[-360,360,0]
	spinner spnRotY "Y:" 			pos:[95,tmgroup+72] 	width:70 	height:16 visible:false range:[-360,360,0]
	spinner spnRotZ "Z:" 			pos:[175,tmgroup+72] 	width:70 	height:16 visible:false range:[-360,360,0]
	local transfomrui = #(btnResetTransforms, grpPos, spnPosX, spnPosY, spnPosZ, grpRot, spnRotX, spnRotY, spnRotZ)
	------------------------------------------------------------------------------

	
	button btnCancel ~CANCEL~ pos:[8,110] width:72 height:24
	button btnOk ~BTNOK_TEXT~ pos:[88,110] width:72 height:24
	
	timer tmrOpenDlg "" interval:40 active:false;
	on tmrOpenDlg tick do(
		theHold.Begin();
		DoPaste();
		tmrOpenDlg.active = false;	
	)
	timer tmrCloseDlg "" interval:40 active:false
	on tmrCloseDlg tick do( locked=true;theHold.Cancel(); locked=false; closeDialog();	)
	
	timer tmrPastePose "" interval:40 active:false
	on tmrPastePose tick do(	tmrPastePose.active = false; 		)

	fn closeDialog = 
	(
		destroyDialog rLoadFile; 
		if(transformnode != undefined)then (
			theHold.Suspend();
 			delete transformnode;
			transformnode = undefined;
			theHold.Resume();
		)
	)	
	fn tryDestroyDialog = 
	(
		if not locked then ( 
			-- Kill the Dialog as soon as possible. 
			-- Don't kill it instantly because we are in the middle of registering an undo
			-- The undo system is actually disabled at this point in time, so the new undo won't be registered.
			tmrCloseDlg.active = true;
		)
	)
	fn Refresh =
	(
		btnOk.enabled = (doesFileExist (folderpath + edtFileName.text + suffix));	
		for uiitem in transfomrui do uiitem.enabled = (transformnode!=undefined);
		
		if transformnode!=undefined then
		(
			local offsetTM = transformnode.transform;
			spnPosX.value = offsetTM.translationpart.x
			spnPosY.value = offsetTM.translationpart.y
			spnPosZ.value = offsetTM.translationpart.z
			spnRotX.value = (offsetTM.rotationpart as eulerAngles).x
			spnRotY.value = (offsetTM.rotationpart as eulerAngles).y
			spnRotZ.value = (offsetTM.rotationpart as eulerAngles).z
		)
	)
	
	fn DoPaste redo:false  =
	(
		if not btnOk.enabled then return OK;
		-- switch panels so that we are not looking at the motion panel
		local oldpanel = getCommandPanelTaskMode()
		setCommandPanelTaskMode #display		
		
		
		if redo then ( 
			-- put the undo system back to the state it was when the current undo was begun.
			theHold.Restore();
			theHold.Release();
		)
		try(
		--	at time spnLoadTime.value (
				local file = (folderpath + edtFileName.text + suffix);
				locked = true
				if chkLoadRig.checked then(
					theParent = GetCATParent catctrl
					if suffix == ".pse" then
						 theParent.LoadPose file spnLoadTime.value mirrordata:chkMirror.checked;		
					else theParent.LoadClip file spnLoadTime.value mirrordata:chkMirror.checked;		
				)else(
					if suffix == ".pse" then
						 catctrl.LoadPose file spnLoadTime.value chkMirror.checked;		
					else catctrl.LoadClip file spnLoadTime.value chkMirror.checked;		
				)
				locked = false;
			--	if not ok then MessageBox "Load Unsuccessful"
		--	)
		)catch(  
			MessageBox ~LOAD_UNSUCCESSFUL~
			theHold.Cancel();
			destroyDialog rLoadFile;
			throw();
		)
		setCommandPanelTaskMode oldpanel;
		Refresh();
	)
	fn FillListBox =
	(	
		local listboxItems = #("<..>");
		folders = getDirectories (folderpath + "*");
		for folder in folders do(
			append listboxItems ("<" + (substring folder (folderpath.count + 1) -1) + ">")
		)
		
		files = getFiles (folderpath + "*" + suffix)
		for file in files do(
			append listboxItems (getFilenameFile file)
			if edtFileName.text==(getFilenameFile file) then
				lbxFiles.selection = listboxItems.count;
		)
		lbxFiles.items = listboxItems;
	)
	on lbxFiles selected sel do
	(
		if sel > (folders.count+1) then (
			edtFileName.text = getFilenameFile files[sel - (folders.count+1)];
			DoPaste redo:true;
		)
		Refresh();
	)
	
	on lbxFiles doubleClicked sel do
	(	
		if(sel>(folders.count+1))then return OK; -- Files are loaded on a single click, so skip this function
		if(sel==1)then(
			folderpath = getFilenamePath (substring folderpath 1 (folderpath.count-2))
		)else if sel <= (folders.count+1) then(
			folderpath = folders[sel-1];
		)
		edtFileName.text = "";
		FillListBox();
		Refresh();
	)
	fn InitPaths catctrlpath windowtitle iniparam =
	(
		folderpath = (getIniSetting animposeini "LastFiles" iniparam)
		if folderpath=="" then folderpath = ((getDir #plugcfg_ln) + catctrlpath);
		else(
			edtFileName.text = getFilenameFile folderpath;	
			folderpath = getFilenamePath folderpath;
		)		
		rLoadFile.title = windowtitle
	)
	
	fn openDialog node type filesuffix = 
	(
		try(destroyDialog rLoadFile)catch();
		if node==undefined then return OK;
		
		createDialog rLoadFile pos:mouse.pos style:#(#style_titlebar) --modal:true
		catctrl = GetCATNodeGroup node;
		filetype = type;
		suffix = filesuffix;
		case (classof catctrl) of
		(
		ArbBone:(		InitPaths ("\\CAT\\" +filetype+ "s\\ExtraBones\\")	(~LOAD_BONE~+ filetype)	("ExtraBones"+filetype);
						chkTransform.pos = 	[16,66];
						btnCancel.pos 	= [8,90]
						btnOk.pos 	 	= [88,90]
						rLoadFile.height = 120;
		);
		HubTrans:(		chkLoadRig.visible = true;	
						if (getIniSetting animposeini ~PARAMETERS~ (~RIG~+filetype))=="true" then(
							  chkLoadRig.checked = true;
							  InitPaths ("\\CAT\\" +filetype+ "s\\")		(~LOAD_RIG~+ filetype)		("Rig"+filetype);	
						)else InitPaths ("\\CAT\\" +filetype+ "s\\Hubs\\")	(~LOAD_HUG~+ filetype)		("Hub"+filetype);	
										);
		CATLimbData2:(	InitPaths ("\\CAT\\" +filetype+ "s\\Limbs\\")	(~LOAD_LIMB~+ filetype)	("Limb"+filetype);	
						chkMirror.visible = false;	
						chkTransform.pos = 	[16,46];
						btnResetTransforms.pos = [140,46];
						btnCancel.pos 	= [8,70]
						btnOk.pos 	 	= [88,70]
						rLoadFile.height = 100;
		);
		PalmTrans:(		InitPaths ("\\CAT\\" +filetype+ "s\\Hubs\\"	)	(~LOAD_PALM~+ filetype)	("Palm"+filetype);	
						chkMirror.visible = false;
						chkTransform.pos = 	[16,46];
						btnCancel.pos 	= [8,70]
						btnOk.pos 	 	= [88,70]
						rLoadFile.height = 100;
		);
		DigitData:(		InitPaths ("\\CAT\\" +filetype+ "s\\Digits\\")	(~LOAD_DIGIT~+ filetype)	("Digit"+filetype);	
						chkMirror.visible = false;
						chkTransform.pos = 	[16,46];
						btnCancel.pos 	= [8,70]
						btnOk.pos 	 	= [88,70]
						rLoadFile.height = 100;
		);
		TailData2:(		InitPaths ("\\CAT\\" +filetype+ "s\\Tails\\")	(~LOAD_TAIL~+ filetype)	("Tail"+filetype);	
						chkTransform.pos = 	[16,66];
						btnCancel.pos 	= [8,90]
						btnOk.pos 	 	= [88,90]
						rLoadFile.height = 120;
		);
		default:(		InitPaths ("\\CAT\\" +filetype+ "s\\")			(~LOAD_RIG~+ filetype)		("Rig"+filetype);	
						chkLoadRig.checked = true;
			);
		)
		
		selectednode = node;
	--	autokeystate = animButtonState;
		ourParent = GetCATParent catctrl;
		initialTranform = ourParent.CATRigSpace;
		FillListBox();
		Refresh();
		
		-- position all the transforms offset spinenrs relative to the bottom of the window
		grpPos.pos.y = rLoadFile.height - 35
		spnPosX.pos.y = rLoadFile.height - 17
		spnPosY.pos.y = rLoadFile.height - 17
		spnPosZ.pos.y = rLoadFile.height - 17
		
		grpRot.pos.y = rLoadFile.height + 5
		spnRotX.pos.y = rLoadFile.height + 23
		spnRotY.pos.y = rLoadFile.height + 23
		spnRotZ.pos.y = rLoadFile.height + 23
		
		-- This callback will mean that if the user deselects the past bone for whatever reason
		-- the paste will be cancelled.
		callbacks.addScript 	#selectionSetChanged	"rLoadFile.tryDestroyDialog()" 	id:#rLoadFile;
		

		theHold.Suspend();
		transformnode = ourParent.CreatePasteLayerTransformNode();
		theHold.Resume();

		-- set a timer going to trigger the actual pasting of the data.
		-- This is a way of allowing this rollout to register an 
		-- undo that is indepenndant of the macroscript undo. 
		-- We want this to happen because we want this window to not be modal. 
		-- that means taht the executon will return to the caller afterthis funtion exits
		-- and a new undo will be registered because this woindow was poped up from a macro
	--	transformnode = undefined;
		tmrOpenDlg.active = true;
	)
	on rLoadFile close do
	(
		callbacks.removeScripts id:#rLoadFile;
	)
	----------------------------------------------------------------------------------
	-- UI Item Callbacks
/*	on chkTransform changed state do(	
		DisplayTransformTypeIn state ;	
		DoPaste redo:true;
	)
*/	
	on chkLoadRig changed state do(	
	 	if state then 	InitPaths ("\\CAT\\" +filetype+ "s\\")			(~IF_STATE_LOAD_RIG~+ filetype)	("Rig"+filetype);	
		else 			InitPaths ("\\CAT\\" +filetype+ "s\\Hubs\\")	(~LOAD_HUB~+ filetype)	("Hub"+filetype);
		DoPaste redo:true;
	)

	on chkMirror changed state do(	DoPaste redo:true;		)
	on spnLoadTime entered do(		if filetype!="Pose" then DoPaste redo:true;		)
	on spnLoadTime changed val do(	if filetype=="Pose" then DoPaste redo:true;		)
	
	on chkTransform changed state do(	
		local deltax, deltay;
		if state then( deltax = 90; deltay = 80; )else( deltax = -90; deltay = -80;)
		
		rLoadFile.height = rLoadFile.height + deltay;
		rLoadFile.width  = rLoadFile.width + deltax;
		
		for uiitem in transfomrui do uiitem.visible = state
	
		lbxFiles.pos    = [lbxFiles.pos.x + deltax, lbxFiles.pos.y]
		btnCancel.pos 	= [btnCancel.pos.x, btnCancel.pos.y + deltay]
		btnOk.pos 	 	= [btnOk.pos.x, btnOk.pos.y + deltay]
		lbxFiles.height = rLoadFile.height - 10;
		Refresh();
	)
	fn SetTransform =
	(
		if transformnode!=undefined then
		(
			local TM = ((eulerAngles spnRotX.value spnRotY.value spnRotZ.value) as matrix3)
			TM.translation += [spnPosX.value, spnPosY.value, spnPosZ.value];
			transformnode.transform = TM;
		)
	)
	
	on btnResetTransforms pressed do
	(
		if transformnode!=undefined then
		(
			transformnode.transform = Matrix3 1;
			Refresh(); 
		)
	)
	
	on spnRotX entered do(	SetTransform();	)
	on spnRotY entered do(	SetTransform();	)
	on spnRotZ entered do(	SetTransform();	)
	on spnPosX entered do(	SetTransform();	)
	on spnPosY entered do(	SetTransform();	)
	on spnPosZ entered do(	SetTransform();	)
	
	on btnOk pressed do
	(
		locked = true;
		theHold.Accept (~PASTE~ + filetype);
		locked = false;
		closeDialog();
	)
	on btnCancel pressed do
	(
		locked = true;
		theHold.Cancel();
		locked = false;
		closeDialog();

	)
	on btnFiles changed state do
	(
		if state then	(	rLoadFile.width = rLoadFile.width + 260;	rLoadFile.height = rLoadFile.height + 160; 	)
		else			(	rLoadFile.width = rLoadFile.width - 260;	rLoadFile.height = rLoadFile.height - 160;	)
		lbxFiles.height = rLoadFile.height - 10;
	)
)


--- These used to be called when setting up the menus.  But they don't appear to be used anywhere.  So they no longer exist.  SA 5/29/2009
---setIniSetting animposeini "RCMenus" "SavePose" "true"
---setIniSetting animposeini "RCMenus" "LoadPose" "true"
---setIniSetting animposeini "RCMenus" "SaveAnim" "true"
---setIniSetting animposeini "RCMenus" "LoadAnim" "true"



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA1OkiNYzALeHUPW6PrqE8BXOI4Lm6Iu+KS
-- zSW5PPPnf5eMXGJYeK2KJLQftzH7yKyK6WmALfNTcaJ4uCzogFKbD2pLwabqG/6C
-- SIWnEakR6gw4fZulNpKaL6jNFAb2qQy/AgKGKnU9bjV6LIBMDhIPGWaJHRNvZNgO
-- zXYDwpnJ65fFwsXCauHFK3Q3bO9GFwtQT/eKWGx5hbEim0NUbTvTEqRaPLTI0R6W
-- jpwnQVmsXG+zihTTfmIpdNSdVh/rf90L5XKeqoblvyBnNv/7d7jPAe9qqkrNN3CU
-- EX2MEAB6X4FUxeBRQoRpz9srqHG0rq1zteh9wtedekGUtCHMVJzs
-- -----END-SIGNATURE-----