
#secHeader
#secHierarchy
#secBasePosition
#secData
global rImportHTR;
rollout rImportHTR ~RIMPORTHTR_CAPTION~ width:405 height:150
(
	local ini_file = ((getDir #plugcfg_ln) + "\\CAT\\importhtr.ini");
	local catparentnode;
	local fhandle
	local filename;
	local camfile = "";
	

	checkbox chkAnimation ~CHKANIMATION_CAPTION~ pos:[30,24] width:~CHKANIMATION_WIDTH~ height:16 checked:true
	checkbox chkCapAnim ~CHKCAPANIM_CAPTION~ pos:[30,45] width:~CHKCAPANIM_WIDTH~ height:16 checked:true
	button btnCamFile ~BTNCAMFILE_CAPTION~ pos:[30,70] width:120 height:24	
	
	spinner spnScale ~SPNSCALE_CAPTION~ pos:[256,48] width:120 height:16 enabled:true range:[0.0001,10000,1] type:#float scale:0.1 fieldwidth:50
	spinner spnStartTime ~SPNSTARTTIME_CAPTION~ pos:[264,24] width:112 height:16 type:#integer fieldwidth:50
	spinner spnBoneSize ~SPNBONESIZE_CAPTION~ pos:[224,72] width:152 height:16 range:[0,100,20] fieldwidth:50
	
	progressBar pb "ProgressBar" pos:[159,108] width:144 height:24
	label lblStatus ~LBLSTATUS_CAPTION~ pos:[8,108] width:144 height:23
	button btnOk ~BTNOK_CAPTION~ pos:[312,108] width:80 height:24	
	
	fn SetStatus txt = 
	(
		lblStatus.text = txt;
	)
	fn SetProgress percent = 
	(
		pb.value = percent;
	)
		
	struct htrSegment (
		index       = 0,
		label       = "",    -- segment name
		parent      = 0,     -- index of parent
		children    = #(),   -- list of child indexes
		position    = [0,0,0],
		rotation    = (EulerAngles 0 0 0),
		bonelength  = 0
	)
	
	struct htrSegmentMotion (
		translation = [0,0,0],
		rotation    = (EulerAngles 0 0 0),
		scale       = 1.0
	)
	
	struct htrHeader (
		FileType,
		DataType,
		FileVersion,
		NumSegments,
		NumFrames,
		DataFrameRate,
		EulerRotationOrder,
		CalibrationUnits,
		RotationUnits,
		GlobalAxisofGravity,
		BoneLengthAxis,
		ScaleFactor,
		UnitConversion
	)
	
	struct htrMaxConfig (
	--	eulerRotationOrder = "XYZ",
	--	axisOrder    = 1,
	--	axisRotation = (Quat 0 0 0 1),
		rotUnitScale = 1.0,
		xaligned = true,
		preTransform,
		postTransform,
	--	X = 1,                         -- position in HTR [1,2,3] of Max X-axis
	--	Y = 2,                         -- position in HTR [1,2,3] of Max Y-axis
	--	Z = 3,                         -- position in HTR [1,2,3] of Max Z-axis (vertical)
	--	xMul = 1,
	--	yMul = 1,
	--	zMul = 1,
		boneSize
	)
	
	struct htrStuff (
		hdr        = htrHeader(),
		cfg        = htrMaxConfig(),
		hierarchy  = #(),          -- array of htrSegment structs
		bones      = #(),           -- array of max objects representing skeleton
		rootnode
	)
	
	-----------------
	-- Import Data --
	-----------------
	local htr, htrCreateSkeleton
	
	fn htrInitGlobals = (
		htr = htrStuff();
		htr.cfg.xaligned = true;
	)
	
	---------------------------------------------------------------------------
	-- Reads the next non-blank from file, removing comments
	---------------------------------------------------------------------------
	fn htrReadLine fhandle = (
		local split
	--	do (
		while (not eof fhandle) do (
			if eof fhandle then return undefined;
			local line = readLine fhandle
			local commentPos = findString line "#"
			if (commentPos != undefined) then line = subString line 1 (commentPos-1)
			split = filterString line " \t"
			if split.count > 0 then exit;
		)
	--	) while (split.count == 0 or eof fhandle)
	--	if eof fhandle then undefined else split
		return split;
	)
	
	
	---------------------------------------------------------------------------
	-- Finds a the index of the segment named by 'label'
	---------------------------------------------------------------------------
	fn htrFindSegmentIndex label = (
		local index = undefined
		for seg in htr.hierarchy do if seg.label==label then index=seg.index
		index
	)
	
	
	---------------------------------------------------------------------------
	-- Returns 'str' as a new string converted to uppercase
	---------------------------------------------------------------------------
	fn strupr str = (
		local upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
		local lower = "abcdefghijklmnopqrstuvwxyz"
		local s = copy str
		for c = 1 to str.count do
			if s[c] >= "a" and s[c] <= "z" then s[c] = upper[findString lower s[c]]
		s
	)
	
	---------------------------------------------------------------------------
	-- Initialises settings for converting HTR co-ordinate system to Max
	---------------------------------------------------------------------------
	fn htrSetMaxConfig = (
		-- Factor for converting rotation units to degrees
		case (strupr htr.hdr.RotationUnits) of (
			~DEGREES_CAPTION~: htr.cfg.rotUnitScale = 1.0
			~RADIANS_CAPTION~: htr.cfg.rotUnitScale = pi / 180
			default: throw(~UNSUPPORTED~+htr.hdr.RotationUnits)
		)
	
		htr.cfg.preTransform = Matrix3 1
		htr.cfg.postTransform = Matrix3 1
		
		if htr.cfg.xaligned then
		(
			RotateX htr.cfg.preTransform 90
			RotateY htr.cfg.preTransform 90
			RotateX htr.cfg.preTransform 180	
			RotateX htr.cfg.postTransform -180
			RotateY htr.cfg.postTransform -90
			RotateX htr.cfg.postTransform -90
		)
		else
		(
			RotateX htr.cfg.preTransform 90			
			RotateZ htr.cfg.preTransform 180	
			RotateZ htr.cfg.postTransform -180
			RotateX htr.cfg.postTransform -90
		)

	
		OK
	)
	
	---------------------------------------------------------------------------
	-- parse a HTR file into gloabals 'header' and 'hierarchy'
	---------------------------------------------------------------------------
	fn htrParseFile filename parseanimation starttime = 
	(
		local fhandle
		local section
		local currentLabel, currentNodeId, currentNode
		local totalDataLines, processedDataLines	
		local line, data, motionData, node, index, eulerrotation, pos
		local importing = true;
	
		fhandle = openFile filename
		if (fhandle == undefined) then return undefined
		
		rImportHTR.title = (~ABORT~+ (getFilenameFile filename))
			
		do (
			if importing and keyboard.escPressed then(
				SetStatus ~ABORTING_IMPORT~
				importing = false;
			) 
			
			line = htrReadLine fhandle
			if line == undefined then exit
	
			-------------------------------------
			-- A new section label has arrived --
			-------------------------------------
			if line[1][1] == "[" then (
				currentLabel = subString line[1] 2 (line[1].count-2)
				
				case (strupr line[1]) of (
				  "[HEADER]": section = #secHeader
				  "[SEGMENTNAMES&HIERARCHY]": (
				  	section = #secHierarchy
					
					-- Post-header processing
					totalDataLines = htr.hdr.NumSegments * htr.hdr.NumFrames
					processedDataLines = 0;
					
					htrSetMaxConfig()
				  )
				  "[BASEPOSITION]": section = #secBasePosition
				  "[ENDOFFILE]":  	exit;
				  default: (
					if not parseanimation then exit;
				  	-- we have a motion group
					if htr.rootnode==undefined then	
					(
						htrCreateSkeleton (GetFileNameFile filename)
					)
					SetStatus ~LOADING_ANIMATION~

				  	section = #secData
					currentNodeId = htrFindSegmentIndex currentLabel
					if (currentNodeId == undefined) do throw(~ERROR_SEGMENT~+currentLabel+~DOES_NOT_EXIST~)
					currentNode = htr.hierarchy[currentNodeId]
				--	gc()
				  )
				)
				continue
			)
	
			case section of (
			  --------------
			  -- [Header] --
			  --------------
			  #secHeader: (
			  	SetStatus ~LOADING_HEADER~
			  	case line[1] of (
				  ~FILETYPE~:            htr.hdr.FileType = line[2]
				  ~DATATYPE~:            htr.hdr.DataType = line[2]
				  ~FILEVERSION~:         htr.hdr.FileVersion = line[2]
				  ~NUMSEGMENTS~:         htr.hdr.NumSegments = line[2] as number
				  ~NUMFRAMES~:           htr.hdr.NumFrames = line[2] as number
				  ~DATAFRAMERATE~:       htr.hdr.DataFrameRate = line[2] as number
				  ~EULERROTATIONORDER~:  htr.hdr.EulerRotationOrder = line[2]
				  ~CALIBRATIONUNITS~:
					(
					    htr.hdr.CalibrationUnits = line[2]
						case htr.hdr.CalibrationUnits of(
							"in":(
								case units.SystemType of(
									#inches:		htr.hdr.UnitConversion = 1.0;	
									#feet:			htr.hdr.UnitConversion = 0.0833333333;
									#millimeters:	htr.hdr.UnitConversion = 25.4; 
									#centimeters:	htr.hdr.UnitConversion = 2.54; 
									#meters:		htr.hdr.UnitConversion = 0.0254;
									default: htr.hdr.UnitConversion = 1.0;
								)
							)
							"ft":(
								case units.SystemType of(
									#inches:		htr.hdr.UnitConversion = 12.0;	
									#feet:			htr.hdr.UnitConversion = 1.0;
									#millimeters:	htr.hdr.UnitConversion = 304.8; 
									#centimeters:	htr.hdr.UnitConversion = 30.48; 
									#meters:		htr.hdr.UnitConversion = 0.3048;
									default: htr.hdr.UnitConversion = 1.0;
								)
							)
							"mm":(
								case units.SystemType of(
									#inches:		htr.hdr.UnitConversion = 0.0393700787;	
									#feet:			htr.hdr.UnitConversion = 0.0032808399;
									#millimeters:	htr.hdr.UnitConversion = 1.0; 
									#centimeters:	htr.hdr.UnitConversion = 0.1; 
									#meters:		htr.hdr.UnitConversion = 0.001;
									default: htr.hdr.UnitConversion = 1.0;
								)
							)
							"cm":(
									case units.SystemType of(
									#inches:		htr.hdr.UnitConversion = 0.393700787;	
									#feet:			htr.hdr.UnitConversion = 0.032808399;
									#millimeters:	htr.hdr.UnitConversion = 10.0; 
									#centimeters:	htr.hdr.UnitConversion = 1.0; 
									#meters:		htr.hdr.UnitConversion = 0.01;
									default: htr.hdr.UnitConversion = 1.0;
								)
							)
							"m":(
								case units.SystemType of(
									#inches:		htr.hdr.UnitConversion = 39.3700787;	
									#feet:			htr.hdr.UnitConversion = 3.2808399;
									#millimeters:	htr.hdr.UnitConversion = 1000.0; 
									#centimeters:	htr.hdr.UnitConversion = 100.0; 
									#meters:		htr.hdr.UnitConversion = 1.0;
									default: htr.hdr.UnitConversion = 1.0;
								)
							)
							default: htr.hdr.UnitConversion = 1.0;
						)
					)
				  ~ROTATIONUNITS~:       htr.hdr.RotationUnits = line[2]
				  ~GLOBALAXISOFGRAVITY~: htr.hdr.GlobalAxisofGravity = line[2]
				  ~BONELENGTHAXIS~:      htr.hdr.BoneLengthAxis = line[2]
	  			  ~SCALEFACTOR~:(  /*    htr.hdr.ScaleFactor = line[2] as number */	)
				  default: throw(~UNKNOWN_HEADER_TYPE~+line[1])
				)
			  )
			  
			  ------------------------------
			  -- [SegmentNames&Hierarchy] --
			  ------------------------------
			  #secHierarchy: (
			  	SetStatus ~LOADING_HIERARCHY~
				if (htrFindSegmentIndex line[1] != undefined) then
					throw(~ERROR_DUPLICATE_SEGMENT_DEFINITION_FOR~+line[1])
	
			  	node = htrSegment label:line[1] index:(htr.hierarchy.count+1)
				if (line[2] != "GLOBAL") then (
					node.parent = htrFindSegmentIndex line[2]
					if (node.parent == undefined) then
						throw(~ERROR_PARENT_SEGMENT~ +line[2]+ ~SPACE_FOR_SPACE~ +line[1]+ ~DOES_NOT_EXIST_EXCLAMATION~)
					append htr.hierarchy[node.parent].children node.index
				)
			  	append htr.hierarchy node
			  )
	
			  --------------------
			  -- [BasePosition] --
			  --------------------		  
			  #secBasePosition: (
			  	SetStatus ~LOADING_BASEPOSITION~
			  	index = htrFindSegmentIndex line[1]
				if (index == undefined) then 
					throw(~UNKNOWN_SEGMENT~+line[1])
				
				node = htr.hierarchy[index]
				
				-- the bone length axis for most mocap files is 'Y'.
				-- so here we are converting translations to a 'Z' axis format.				
				pos = [(line[1+1] as number), (line[1+2] as number), line[1+3] as number]
				-- Translate axes into Z-vertical
			--	pos = pos * htr.cfg.preTransform;
				-- now convert to the current max units
				node.position = pos * htr.hdr.UnitConversion
			
				eulerrotation = EulerAngles 0 0 0
				eulerrotation.x = (line[4+1] as number) * htr.cfg.rotUnitScale
				eulerrotation.y = (line[4+2] as number) * htr.cfg.rotUnitScale
				eulerrotation.z = (line[4+3] as number) * htr.cfg.rotUnitScale
				
				node.rotation = eulerrotation
			
				--if (node.parent == 0) then node.rotation *= htr.cfg.axisRotation
	
				node.bonelength = line[8] as number
			  )
			  
			  ------------------------
			  -- Segment frame data --
			  ------------------------
			  #secData: (
			  	if not parseanimation then continue;
			--	SetStatus (~LOADING~ + currentLabel)
				
				data = htrSegmentMotion()
				pos = [(line[1+1] as number), (line[1+2] as number), line[1+3] as number]

				-- now convert to the current max units
				data.translation = pos * htr.hdr.UnitConversion
	
				eulerrotation = EulerAngles 0 0 0
				eulerrotation.x = (line[4+1] as number) * htr.cfg.rotUnitScale
				eulerrotation.y = (line[4+2] as number) * htr.cfg.rotUnitScale
				eulerrotation.z = (line[4+3] as number) * htr.cfg.rotUnitScale
				data.rotation = eulerrotation 
	
				data.scale = line[8] as number
				
				--------------------------------------------------------------------
				-- convert beteen file frames times and max time values
				-- the first frame needs to be 0, not 1
				local frame = (line[1] as number) - 1;
				keyframetime = (starttime as float) + (frame * ((framerate as float)/(htr.hdr.DataFrameRate as float)))
				
				if (data.translation != [0,0,0]) then (
					key = addNewKey htr.bones[currentNodeId].position.controller keyframetime
					-- This needs to handle the case where the default pos contains position offset
					key.value = ((data.translation + htr.Hierarchy[currentNodeId].position) * htr.hdr.scalefactor) * htr.cfg.preTransform;
				)

				local rot = (eulerToQuat (eulerAngles htr.Hierarchy[currentNodeId].rotation.x htr.Hierarchy[currentNodeId].rotation.y htr.Hierarchy[currentNodeId].rotation.z) order:1) as matrix3
				local loc = (eulerToQuat (eulerAngles data.rotation.x data.rotation.y data.rotation.z) order:1) as matrix3
				local ang = htr.cfg.postTransform * loc * rot * htr.cfg.preTransform
				at time keyframetime animate on htr.bones[currentNodeId].rotation.controller.value = Quat(ang);
						
			--	SetProgress (((frame as float)/((htr.hdr.NumFrames-1) as float)) * 100.0);
				SetProgress (((processedDataLines as float)/(totalDataLines as float)) * 100.0);
				--------------------------------------------------------------------
				data = undefined;
				
				processedDataLines += 1
				if (processedDataLines == totalDataLines) do exit
			  )
			)
		) while ((not eof fhandle) and importing)

		close fhandle
	  	if htr.rootnode==undefined and importing then	
		(
			htrCreateSkeleton (GetFileNameFile filename)
		)
		return importing
	)
	
	---------------------------------------------------------------------------
	--
	---------------------------------------------------------------------------
	fn htrCreateSkeleton name = 
	(
		SetStatus ~CREATING_SKELETON~
		htr.rootnode = Point axistripod:on Box:on name:name
		print htr.rootnode
		if htr.cfg.xaligned then
		(
			rotate htr.rootnode (angleaxis -90 [0,1,0]);
		)
		rotate htr.rootnode (angleaxis 180 [0,0,1]);
			
		for node in htr.hierarchy do (
			local bone = box name:node.label width:(htr.cfg.boneSize * htr.hdr.UnitConversion * htr.hdr.scalefactor) length:(htr.cfg.boneSize * htr.hdr.UnitConversion * htr.hdr.scalefactor) height:(node.bonelength * htr.hdr.UnitConversion * htr.hdr.scalefactor)
			if (node.parent>0) then bone.parent = htr.bones[node.parent] --attachObjects htr.bones[node.parent] bone
			else 					bone.parent = htr.rootnode
			htr.bones[node.index] = bone
	
			--in coordsys parent bone.position = node.position
			bone.position.controller = bezier_position()
			bone.position.controller.value = (node.position * htr.hdr.scalefactor) * htr.cfg.preTransform;
			bone.rotation.controller = tcb_rotation()
			bone.scale.controller = bezier_scale()
	
			rot = matrix3 1
			rotateX rot node.rotation.x
			rotateY rot node.rotation.y
			rotateZ rot node.rotation.z
			bone.rotation.controller.value = (htr.cfg.postTransform * rot * htr.cfg.preTransform) as eulerangles;
			
			if htr.cfg.xaligned then
			(	
				bone.objectoffsetrot = ((Eulerangles 0 90 0 ) as quat);
			)
		)
		OK
	)

	--------------------------------------------------------------------------------
	-- This sets up a scene and animates the first frame
	--------------------------------------------------------------------------------
	fn ImportHTR filename startt scale:1.0 quiet:false loadanimation:true bonesize:5.0 captureanim:true CapFrequency:2 =
	(
		if filename == undefined then return OK;
	--	gc();
		
		-- we need LOTs of script memory to import large HTR files
		if heapSize < 12000000 then heapSize += 2000000

		-- for some wird reason the importer causes havok with the motion panel rollout
		local panel = getCommandPanelTaskMode();
		setCommandPanelTaskMode mode:#display
		
		with redraw off (	
			with undo off (
				with animate off (
					htrInitGlobals()
					
					htr.hdr.scalefactor = scale;
					htr.cfg.boneSize = bonesize;	

					if catparentnode != undefined and catparentnode.lengthaxis=="Z" then
						htr.cfg.xaligned = false;				
					
					if not htrParseFile filename loadanimation startt then
						chkCapAnim.checked = false;
				)
			)
		)
		-- keep track of the root and calculate the timerange
		local htrroot = htr.rootnode;
		local timerange = Interval startt (execute ((((htr.hdr.NumFrames as float)/(htr.hdr.DataFrameRate as float)) as string) + "s"))
			
		-- free up all this memory we have used
		htr = undefined;
		
		if(htrroot != undefined and catparentnode != undefined and captureanim) then(
			-- create the layer we should put the animation onto
		--	catparentnode.AppendLayer (getFilenameFile filename) "mocap"
		--	catparentnode.catmode = 1;
			
			CaptureAnimation catparentnode htrroot CamFile:camfile quiet:quiet delsrc:true StartTime:timerange.start EndTime:timerange.end Frequency:CapFrequency
		)
		-- put us back on the we were in before import
		setCommandPanelTaskMode mode:panel
	)
	
	fn Refresh =
	(
		if filename != undefined then
			rImportHTR.title = (~IMPORTING~+ (getFilenameFile filename))
			
		if camfile != undefined and (doesFileExist camfile) then
			btnCamFile.text = (getFilenameFile camfile)
	)


	fn openDialog catparent:undefined fname:undefined cam:undefined quiet:false scale:1.0 timeoffset:0 = 
	(
		if fname == undefined then (
			local lastfileloaded = getIniSetting ini_file ~FILES~ ~LASTFILELOADED~
			if(lastfileloaded.count == 0)then lastfileloaded = ((getDir #plugcfg_ln) + "\\CAT\\*.htr")
			
			fname = getOpenFileName caption:~FNAME_CAPTION~ \
					                   types:~MOTION_ANALYSIS_FILE_TYPES~ \
									   filename:lastfileloaded
		)
		
		if fname != undefined then
			setIniSetting ini_file "Files" "LastFileLoaded" fname
		else return OK;
		
		if quiet then(
		
			createDialog rImportHTR style:#(#style_border, #style_titlebar, #style_sysmenu) width:310 height:40 escapeEnable:true
			
			filename = fname;
			catparentnode = catparent;
			camfile = cam;
			
			chkAnimation.visible = false;
			spnScale.visible = false;
			spnStartTime.visible = false;
			spnBoneSize.visible = false;
			btnOk.visible = false;	
			
			lblStatus.pos = [10, 10]
			pb.pos = [160, 10]
			
		)else(
			local pos = execute (getIniSetting ini_file #general #position)
			if pos == ok then pos = [100, 100]
			createDialog rImportHTR pos:pos style:#(#style_border, #style_titlebar, #style_sysmenu)
			filename = fname;
			catparentnode = catparent;
			camfile = cam;
		
			local str = getIniSetting ini_file "Params" "LoadAnimation"
			if (str.count > 0) then 	chkAnimation.checked = execute str
			
			str = getIniSetting ini_file "Params" "ScaleFactor"
			if (str.count > 0) then 	spnScale.value = str as number
			
			str = getIniSetting ini_file "Params" "StartTime"
			if (str.count > 0) then 	spnStartTime.value = str as number
			
			str = getIniSetting ini_file "Params" "BoneSize"
			if (str.count > 0) then 	spnBoneSize.value = str as number
			
			str = getIniSetting ini_file "Params" "CaptureAnimation"
			if (str.count > 0) then 	chkCapAnim.checked = execute str
						
			camfile = getIniSetting ini_file "Params" "CAMFile"
		)
		Refresh()
	)

	on btnCamFile pressed do
	(
		if camfile==undefined then(
			camfile = getIniSetting ini_file "Params" "CAMFile"
			if camfile==undefined then(
				camfile = ((getDir #plugcfg_ln) + "\\CAT\\*.cam")
			)
		)
		camfile = getOpenFileName caption:~CAMFILE_CAPTION~ \
				                   types:~CAPTURE_ANIMATION_MAPPING_FILE_TYPES~ \
								   filename:camfile		
		Refresh()
	)

	on btnOk pressed do
	(
		ImportHTR filename spnStartTime.value scale:spnScale.value loadanimation:chkAnimation.checked bonesize:spnBoneSize.value captureanim:chkCapAnim.checked
		
		setIniSetting ini_file "Params" "LoadAnimation" 	(chkAnimation.checked as string)
		setIniSetting ini_file "Params" "ScaleFactor" 		(spnScale.value as string)
		setIniSetting ini_file "Params" "StartTime" 		(spnStartTime.value as string)
		setIniSetting ini_file "Params" "BoneSize" 			(spnBoneSize.value as string)
		setIniSetting ini_file "Params" "CaptureAnimation" 	(chkCapAnim.checked as string)
		setIniSetting ini_file "Params" "CAMFile"			camfile
		
		DestroyDialog rImportHTR;
	)
)
-- this function is called by CAT
fn CATImportHTR catparentnode htrfile CamFile:undefined quiet:false scale:1.0 timeoffset:0 CapFrequency:2 = 
(
	if quiet then
	(
		rImportHTR.openDialog catparent:catparentnode  fname:htrfile cam:CamFile quiet:true 
			
		rImportHTR.ImportHTR htrfile timeoffset quiet:quiet scale:scale CapFrequency:2
		DestroyDialog rImportHTR;
	)
	else rImportHTR.openDialog catparent:catparentnode  fname:htrfile cam:CamFile
)


-- To simply run the HTR importer directly, simply call
--rImportHTR.openDialog()

-- For batch processing purposes, you can import in quiet mode using a call like the following
--rImportHTR.ImportHTR "C:\\CAT\\Script Projects\\Export HTR\\test5.htr" 0 scale:1.0 bonesize:1.0
--CATImportHTR catparentnode htrfile CamFile:undefined quiet:false




-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBSZNf82o9qR7VLxsD1mwtSzIOV9y5/up9r
-- nMHgUP4hXpXDXsy9UQH39CmF+7uqIEPrQTc0Q4TkOA8+4JtquxkOXgHBcYA5lZlu
-- TwqyML5mwfIqbPQbYDNt9GE30TogA0bcItnsqx8X/sH2J/wLI0si7oI1UM/w1J7O
-- lFhxdU8y9E0ygdEqW5SZ7OBZO87I/2z00s8CCy6ZU1fZRW8KnbDdKi9ZI119stsu
-- YDtwAvdxYA1pq0hcAW8AfSGB0hreZ/alM70PklXURrrXjBlbfhSde7Jaj50M0onn
-- Srg2TRy3b1xtCm2q3aydQCVQ8cxdgONjzZvq9LRFA5jK88nzCUnz
-- -----END-SIGNATURE-----