-- Helper Functions for CAT macroscripts

-----------------------------------------------------------------------------------------------
-- function: GetCATNodeGroup
-- Does: Finds the group (data) controller of the passed node, if it exists
-- Arguments: aNode a node to search.
-- Returns: The group controller of the node.
-----------------------------------------------------------------------------------------------	
fn GetCATNodeGroup aNode = 
(
	local catctrl = aNode.controller
	
	catctrl = case (classof catctrl) of
	(
		CATBoneSegTrans:	( catctrl = catctrl.bonedata.limb; )
		CollarboneTrans:		( catctrl = catctrl.Limb; )
		CATDigitSegTrans:	( catctrl = catctrl.digitdata.controller; )
		TailTrans:		( catctrl = catctrl.taildata;  )
		default:			( catctrl; )
	)
	
	catctrl;
)

-----------------------------------------------------------------------------------------------
-- function: GetCatParent 	
-- Does: Finds the CATParent of passed node or controller, if it is part of a CAT character
-- Arguments: aNodeOrController Either a node or controller to search.
-- Returns: CATparent found, or undefined if not a member of a CAT character
-----------------------------------------------------------------------------------------------	
fn GetCATParent aNodeOrController = 
(
	res = undefined;
	ctrl = aNodeOrController;
	if (iskindof aNodeOrController Node) then ctrl = aNodeOrController.controller

	if (ctrl != undefined) then (
		if ((GetInterface ctrl "ICATControlFPInterface") != undefined) then (res = ctrl.catparent)
		else if (classof ctrl == CATParentTrans) do (res = ctrl.node.baseobject)
	)
	res;
)

function GetSelectedSubAnim subAnimIndex = 
(
	result = undefined
	if selection.count == 1 then 
	(
		local selObj = selection[1]
		if (selObj.numSubs >= subAnimIndex) then
		(
			result = GetSubAnim selObj subAnimIndex
		)
	)
	result
)

function GetSelectedCATParent = 
(
	result = undefined
	local selSubAnim = GetSelectedSubAnim 3
	if (selSubAnim != undefined) then
	(
		result = GetCATParent selSubAnim;
	)
	result
)
function SelectionHasCATParent = 
(
	result = false
	local cparent = GetSelectedCATParent()
	if (cparent != undefined) then
	(
		result = true
	)
	result
)

function CATParentSetupMode = 
(
	result = false
	local selCatParent = GetSelectedCATParent()
	if (selCatParent != undefined) then
	(
		if( selCatParent.catmode == 0 ) then 
			result = true;
	)
	result
)

function IsSelectionSubAnimClassOf classType = 
(
	result = false
	if selection.count == 1 then 
	(
		local selObj = selection[1]
		if (selObj.numSubs >= 3) then
		(
			local selSubAnim = GetSubAnim selObj 3
			if (selSubAnim != undefined) then
			(
				if (hasproperty selSubAnim "CatParent") then
				(
					if(classof selSubAnim.controller) == classType then 
						result = true;
				)
			)
		)
	)
	result
)

function DoesSelectedContainInterface interfaceName = 
(
	local result = false
	for obj in selection while result == false do
	(
		if (getinterface obj[3] interfaceName) != undefined then
		(
			result = true;
		)
	)
	result	
)

function IsFloatController v = 
(
	isValid = (isProperty v.anim #value) and (classof v.anim.value == Float) and (isPropertyAnimatable v.client v.name)
	isValid
)

function IsCATEntity v = ( res = (GetCATParent v != undefined); res )

-- Global shut down utility function for CAT
function CAT_OnMaxShutdown =
(
	unregisterSelectFilterCallback IsCATEntity
	unregisterDisplayFilterCallback IsCATEntity
	callbacks.RemoveScripts id: #CATUtils
)

-- Global startup utility function for CAT
function CAT_OnMaxStartup = 
(
	-- Register a display filter to display only CATEntities
	registerSelectFilterCallback IsCATEntity ~SELECT_FILTER_CALL_CATENTITY_NAME~
	registerDisplayFilterCallback IsCATEntity ~DISPLAY_FILTER_CALL_CATENTITY_NAME~
	-- Failing to unregister these callbacks will result in a memory leak. Thus we have to register a callback to do that
	-- when max quits
	callbacks.RemoveScripts id: #CATUtils -- Attempt to remove the old one if the script is re-evaluated
	callbacks.AddScript #preSystemShutdown "CAT_OnMaxShutdown()" id: #CATUtils
)
CAT_OnMaxStartup();
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAGCwco/kCWeKgBA2SEIZ55Q63So99ttZ+7
-- LePvDncbf1yXTktCoaYT1m0w/Z/1OqHhZ7lA0zkrVLKCYwW5uyDvyeeePoliUHyn
-- TRj+vd6OWJd/V/pTu4RLYAH8QyUFx7LhVPRLYTCQt9v4JRnh2mvxc9vBXVR3k+bi
-- D9rBx/8M6cUqrNWhlfWXeP51HgrHNNs1naLHN8nK3dGZR0ngWMkT1KG6wAllZUfv
-- dlUrgAoxVleT8FiHymHumh/qA4aNBNhmCBgwb7nAuM2Bhmnidi+x8Az9Qlkv3Lgl
-- 7h4OJ3JqxOonW8hmgxygIojMNaNFP9GmYoGjVRMhwazkJZ+UTtxz
-- -----END-SIGNATURE-----