if (IsNetServer() == false) do
(
    if ((getIniSetting (GetDir #plugcfg_ln + "\projects.ini") "Projects" "AutomaticSwitch") == "1") do
    (
	    callbacks.addScript #filePreOpenProcess "autoSwitchProject()"
    )
)

------------------------------------------------------------------------------------------
fn findProjectFolderFromFileName fileName =
(
	projectFolder = undefined
	if (pathConfig.isAbsolutePath(fileName) == true) then
	(
		rootFolder = pathConfig.stripPathToTopParent(getFilenamePath(fileName))
		candidateFolder = getFilenamePath(fileName)
		done = false
		while (done == false) do
		(
			if pathConfig.isProjectFolder(candidateFolder) then
			(
				projectFolder = candidateFolder
			) 
			else
			(
				isRootFolderReached = (0 == (stricmp rootFolder candidateFolder))
				if isRootFolderReached == false then
				(
					candidateFolder = pathConfig.removePathLeaf candidateFolder
				)
			)
			done = (projectFolder != undefined) or isRootFolderReached
		)
	)
	return projectFolder
)

------------------------------------------------------------------------------------------
fn autoSwitchProject = 
(
	notifParams = callbacks.notificationParam()
	isNormalOpen = (1 == notifParams[1])
	if isNormalOpen then
	(
		fileName = notifParams[2]
		isMaxFile = (0 == (stricmp ".max" (getFilenameType(fileName))))
		if isMaxFile then
		(
			newProjectFolder = findProjectFolderFromFileName(fileName)
			if (newProjectFolder != undefined) then
			(
				if(pathConfig.pathsResolveEquivalent newProjectFolder (pathconfig.getCurrentProjectFolder())) == false then
				(
					pathConfig.doProjectSetupStepsUsingDirectory(newProjectFolder)
				)
			)
		)
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCJ1Q5Yrfe4SWqIa7uBJl+XHZXnvAe3Maf0
-- jdK2g42aqEG6/byKAXAyIZsD8TfVaO4isbhgoVkjq1WEjHETfNR2iUd8XN7lZpDU
-- ZLaRHSQ2SVrGqlndSAStFht41YZLP1AVPX3aaa2U2M3Fl0oAypjrCCvFM6n72evT
-- 57g0hkQNEh2oQEK/uhAr58kSP0BPXYfTWtYtW3jv+38/Egks8dPsIyzbnjxiWQq3
-- apGbvvmdDGvDA6C7wv7oy/VauRm5Y6qhw2bFgx0UJEK/CVecb4J82O31GAd4IJnw
-- D4EQGWWdoPjTVzxb8iDXgqhJSezJm6yl0fwF7x/iwJSnNP6K/+lz
-- -----END-SIGNATURE-----