
-- need it as a global otherwiser garbage collector will delete its reference...
-- Nicolas Lonard: moved in from px_PhysXPanel.ms
global physXpaneldata = PhysXPanelInterface.instance

global PxGetPhysXPanelTab  -- Forward declaration

struct DebugVisualizerGroup_struct
(
	groupUIName = undefined,	-- localizable name of the group as it is to appear in the UI
	groupRootName = undefined,	-- internal name (alphanumerical characters)
	groupParamMembers = #()		-- array of paramters to be put in this group, automatically computed
)

struct DebugVisualizerParam_struct  -- 
(
	paramRoot = undefined,		-- e.g. "bodyAxis"
	paramDefVal = undefined,	-- value at creation
	paramSDK_name = undefined,	-- e.g. "NX_VISUALIZE_BODY_AXES"
	controlName = undefined,	-- e.g. "Local Axis"
	controlTooltip = undefined,	-- the rollout control tooltip
	controlGroup = undefined	-- the group the control belongs to.  Should match the groupUIName for that group
)

fn initGroupMembers paramGroup paramList =
(
	for noParam = 1 to paramList.count do
	(
		if paramList[noParam].controlGroup == paramGroup.groupRootName then
		(
			append paramGroup.groupParamMembers noParam
		)
	)
)

fn GenerateControlSection groupList paramList =
(
	local ctrlStr = ""
	
	-- Create all controls in the appropriate group
	for noGroup = 1 to groupList.count do
	(
		local nbControlsInGroup = groupList[noGroup].groupParamMembers.count
		if nbControlsInGroup > 0 then
		(
			append ctrlStr "\tgroup \""
			append ctrlStr groupList[noGroup].groupUIName
			append ctrlStr "\"\n"
			append ctrlStr  "\t(\n"
			for noParam = 1 to  nbControlsInGroup do
			(
				-- produce one line per parameter.  It should look like this:
				-- 		checkbox	cb_bodyAxis	"Body Axis"	align:#left offset:[-5, 0]  width:160 checked:true	 tooltip:"Body Axis"
				paramIndex = groupList[noGroup].groupParamMembers[noParam]
				append ctrlStr "\t\tcheckbox\tcb_"
				append ctrlStr paramList[paramIndex].paramRoot
				append ctrlStr "\t\""
				append ctrlStr paramList[paramIndex].controlName
				append ctrlStr "\"\t"
				append ctrlStr "align:#left offset:[-5, 0]  width:160 checked:"
				append ctrlStr (paramList[paramIndex].paramDefVal as string)
				append ctrlStr "\ttooltip:\""
				-- @todo: use paramList[paramIndex].controlTooltip
				append ctrlStr paramList[paramIndex].controlName
				append ctrlStr "\"\n"
			)
			append ctrlStr "\t)\n\n"
		)
	)
	return ctrlStr
)

fn GenerateLoadValuesFn paramList =
(
	local loadValStr = "\tfn loadValues = 
	(
		-- set dialog values from the panel data 
		cb_enableViz.checked = physXpaneldata.visualizerEnable = nvpx.VisualizerGetEnabled()
		sp_scale.value = physXpaneldata.visualizerScale = nvpx.VisualizerGetScale()\n"
	
	for noParam = 1 to paramList.count do
	(
		-- generate a line similar to
		-- cb_bodyAxis.checked = physXpaneldata.bodyAxis = (nvpx.getSDKParameter "NX_VISUALIZE_BODY_AXES" != 0.0)
		append loadValStr "\t\tcb_"
		append loadValStr paramList[noParam].paramRoot
		append loadValStr ".checked = physXpaneldata."
		append loadValStr paramList[noParam].paramRoot
		append loadValStr " = (nvpx.getSDKParameter \""
		append loadValStr paramList[noParam].paramSDK_name
		append loadValStr "\" != 0.0)\n"
	)
	append loadValStr "\t)\n\n"
	return loadValStr
)

fn GenerateSaveValuesFn paramList =
(
	local saveValStr = "\tfn saveValues = 
	(
		-- save dialog values to the SDK and to the panel data
		nvpx.VisualizerSetEnabled (physXpaneldata.visualizerEnable = cb_enableViz.checked)
		nvpx.VisualizerSetScale (physXpaneldata.visualizerScale = sp_scale.value)\n\n"
	
	for noParam = 1 to paramList.count do
	(
		-- generate a line similar to:
		-- physXpaneldata.bodyAxis = cb_bodyAxis.checked
		append saveValStr "\t\tphysXpaneldata."
		append saveValStr paramList[noParam].paramRoot
		append saveValStr " = cb_"
		append saveValStr paramList[noParam].paramRoot
		append saveValStr ".checked\n"
	)
	append saveValStr "\t)\n\n"
	return saveValStr
)

fn GenerateControlChangedFn paramList =
(
	local changedFnStr = ""
	-- *****************************************************************************************
	-- for each parameter add a function that sets the SDK values and combo box from the panel data
	-- *****************************************************************************************
	for noParam = 1 to paramList.count do
	(
		append changedFnStr "\tfn "
		append changedFnStr paramList[noParam].paramRoot
		append changedFnStr "Changed =\n\t(\n\t\tcb_"
		append changedFnStr paramList[noParam].paramRoot
		append changedFnStr ".checked = physXpaneldata."
		append changedFnStr paramList[noParam].paramRoot
		append changedFnStr "\n\t)\n"
	)
	return changedFnStr
)

fn GenerateGroupChangedFunctions groupList paramList =
(
	local changedFnStr = "\tfn optionsChanged = \n\t(
		nvpx.VisualizerSetEnabled (cb_enableViz.checked = physXpaneldata.visualizerEnable)
		nvpx.VisualizerSetScale (sp_scale.value = physXpaneldata.visualizerScale)
	)\n\n"

	for noGroup = 1 to groupList.count do
	(
		local nbControlsInGroup = groupList[noGroup].groupParamMembers.count
		if nbControlsInGroup > 0 then
		(
			append changedFnStr "\tfn "
			append changedFnStr groupList[noGroup].groupRootName
			append changedFnStr "Changed =\n\t(\n"
			for noParam = 1 to  nbControlsInGroup do
			(
				local paramIndex = groupList[noGroup].groupParamMembers[noParam]
				append changedFnStr "\t\t"
				append changedFnStr paramList[paramIndex].paramRoot
				append changedFnStr "Changed()\n"
			)
			append changedFnStr "\t\tRedrawViews()\n\t)\n\n"
		)
	)
	return changedFnStr
)

fn GenerateControlEventHandler paramList =
(
	local handlerStr = ""
	for noParam = 1 to paramList.count do
	(
		append handlerStr "\ton cb_"
		append handlerStr paramList[noParam].paramRoot
		append handlerStr " changed value do\n\t(\n\t\tundo \"PhysX Visualizer "
		append handlerStr paramList[noParam].controlGroup
		append handlerStr " edit\" on\n\t\t(\n\t\t\tphysXpaneldata."
		append handlerStr paramList[noParam].paramRoot
		append handlerStr " = value\n\t\t)\n\t\t"
		append handlerStr paramList[noParam].paramRoot
		append handlerStr "Changed()\n\t)\n"
	)
	return handlerStr
)

fn GenerateFullRolloutString groupList paramList =
(
	local rolloutName = nvpx.GetPluginCompanyName() + nvpxText.UI_PANEL_VISUALIZE_ROLLOUT_VISUALIZE_SUFFIX

	local rolloutStr = "rollout px_panel_debugVisualizer \"" + rolloutName + "\" rolledUp:false
(
	group \"Options\"
	(
		checkbox		cb_enableViz	\"Enable Visualizer\"	align:#left  checked:false
		label			lb_scale	\"Scale\"	 align:#left across:2
		spinner         sp_scale	align:#right width:65 range:[0, PxMaxValue, 5]
	)\n\n"

	append rolloutStr (GenerateControlSection groupList paramList)

	-- Add function loadValues()/saveValues()
	append rolloutStr (GenerateLoadValuesFn paramList)
	append rolloutStr (GenerateSaveValuesFn paramList)
	
	-- Add control and group property changed functions
	append rolloutStr (GenerateControlChangedFn paramList)
	append rolloutStr (GenerateGroupChangedFunctions groupList paramList)

	
	-- *****************************************************************************************
	-- Event handlers
	-- *****************************************************************************************
	append rolloutStr "

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexDisplay
	)
		
	on px_panel_debugVisualizer open do
	(
		loadValues()
        -- setup localized group name
        px_panel_debugVisualizer.controls[1].text = nvpxText.displayPanelVisualizerOptions
		px_panel_debugVisualizer.cb_enableViz.text = nvpxText.UI_PANEL_VISUALIZE_ENABLE
		px_panel_debugVisualizer.lb_scale.text = nvpxText.UI_PANEL_VISUALIZE_SCALE
		px_panel_debugVisualizer.sp_scale.tooltip = nvpxText.UI_PANEL_VISUALIZE_SCALE_TOOLTIP
	)
	
	on px_panel_debugVisualizer close do
	(
		saveValues()
	)
	
	on cb_enableViz changed value do
	(
		undo \"PhysX Visualizer Enable edit\" on
		(
			TurnOnMacroRecorderContext true
			physXpaneldata.visualizerEnable = value
			TurnOnMacroRecorderContext false
		)
		nvpx.VisualizerSetEnabled value
	)
	
	on sp_scale changed value do
	(
		undo \"PhysX Visualizer Scale edit\" on
		(
			TurnOnMacroRecorderContext true
			physXpaneldata.visualizerScale = value
			TurnOnMacroRecorderContext false
		)
		nvpx.VisualizerSetScale value
	)
	
	on px_panel_debugVisualizer help do( HelpSystem.ShowProductHelp 15013 )\n\n"
	
	append rolloutStr (GenerateControlEventHandler paramList)

	-- Final closing parenthesis for rollout
	append rolloutStr ")\n"
	return rolloutStr
)

fn GenerateUndoFunction groupList =
(
	local undoFnStr = "fn pxDebugVisualizerUndo =
(
	local t = callbacks.notificationParam()\n"
	
	local firstGroup = true
	for noGroup = 1 to groupList.count do (
		local nbControlsInGroup = groupList[noGroup].groupParamMembers.count
		if nbControlsInGroup > 0 then
		(
			append undoFnStr "\t"
			if (not firstGroup) then
				append undoFnStr "else "
			append undoFnStr "if t == \"PhysX Visualizer "
			append undoFnStr groupList[noGroup].groupUIName
			append undoFnStr " edit\" then (\n\t\tpx_panel_debugVisualizer."
			append undoFnStr groupList[noGroup].groupRootName
			append undoFnStr "Changed()\n\t)\n"
			firstGroup = false
		)
	)
	append undoFnStr ")\n\n"
	return undoFnStr
)

fn debugVisualizerAutoUI = 
(
	local debugVisualizerGroups = #(
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_OBJECT_PROPERTIES	groupRootName:"objectProperties"),
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_JOINT_PROPERTIES	groupRootName:"jointProperties"),
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_CONTACT_MARKERS	groupRootName:"contactProperties"),
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_COLLISION_MARKERS	groupRootName:"collisionProperties")
	)

	local debugVisualizerList = #(
		(DebugVisualizerParam_struct	paramRoot:"bodyAxis"		paramDefVal:true	paramSDK_name:"NX_VISUALIZE_BODY_AXES"  		controlName:nvpxText.UI_PANEL_VISUALIZE_BODY_AXES			controlGroup:"objectProperties"),
		(DebugVisualizerParam_struct	paramRoot:"bodyLinearVel"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_BODY_LIN_VELOCITY"  controlName:nvpxText.UI_PANEL_VISUALIZE_BODY_LIN_VELOCITY	controlGroup:"objectProperties"),
		(DebugVisualizerParam_struct	paramRoot:"bodyAngularVel"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_BODY_ANG_VELOCITY"  controlName:nvpxText.UI_PANEL_VISUALIZE_BODY_ANG_VELOCITY	controlGroup:"objectProperties"),

		(DebugVisualizerParam_struct	paramRoot:"jointLocalAxis"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_JOINT_LOCAL_AXES"	controlName:nvpxText.UI_PANEL_VISUALIZE_JOINT_LOCAL_AXES	controlGroup:"jointProperties"),
		(DebugVisualizerParam_struct	paramRoot:"jointWorldAxis"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_JOINT_WORLD_AXES"	controlName:nvpxText.UI_PANEL_VISUALIZE_JOINT_WORLD_AXES	controlGroup:"jointProperties"),
		(DebugVisualizerParam_struct	paramRoot:"jointLimits"		paramDefVal:false	paramSDK_name:"NX_VISUALIZE_JOINT_LIMITS"		controlName:nvpxText.UI_PANEL_VISUALIZE_JOINT_LIMITS		controlGroup:"jointProperties"),

		(DebugVisualizerParam_struct	paramRoot:"contactPoints"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_CONTACT_POINT"		controlName:nvpxText.UI_PANEL_VISUALIZE_CONTACT_POINT	controlGroup:"contactProperties"),
		(DebugVisualizerParam_struct	paramRoot:"contactNormal"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_CONTACT_NORMAL"		controlName:nvpxText.UI_PANEL_VISUALIZE_CONTACT_NORMAL	controlGroup:"contactProperties"),
		(DebugVisualizerParam_struct	paramRoot:"contactForce"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_CONTACT_FORCE"		controlName:nvpxText.UI_PANEL_VISUALIZE_CONTACT_FORCE		controlGroup:"contactProperties"),

		(DebugVisualizerParam_struct	paramRoot:"collisionShapes"		paramDefVal:true	paramSDK_name:"NX_VISUALIZE_COLLISION_SHAPES"	controlName:nvpxText.UI_PANEL_VISUALIZE_COLLISION_SHAPES	controlGroup:"collisionProperties"),
		(DebugVisualizerParam_struct	paramRoot:"collisionCompounds"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_COLLISION_COMPOUNDS" controlName:nvpxText.UI_PANEL_VISUALIZE_COLLISION_COMPOUNDS	controlGroup:"collisionProperties"),
		(DebugVisualizerParam_struct	paramRoot:"collisionSpheres"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_COLLISION_SPHERES"	controlName:nvpxText.UI_PANEL_VISUALIZE_COLLISION_SPHERES	controlGroup:"collisionProperties")
	)

	-- put each parameter into the groupParamMembers of the group it belongs to.
	-- This has to be done before we generate the rollout 
	for noGroup = 1 to debugVisualizerGroups.count do (
		initGroupMembers debugVisualizerGroups[noGroup] debugVisualizerList
	)

	local rolloutStr = GenerateFullRolloutString debugVisualizerGroups debugVisualizerList
	execute rolloutStr
	
	-- Generate pxDebugVisualizerUndo(), an undo function that can handle this rollout's events
	local undoStr = GenerateUndoFunction debugVisualizerGroups
	execute undoStr
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBiBu/upoKXAqeAcPw7o/sLG1wGpa52W7Uw
-- gO1OKZB9IPoVgkXTnb33Yx8IxneXlI6Xb3Bs4QmaDBDtGE7Q3hJWbyI7PmmPwgvS
-- I40gKH0sDkozqkvzl2doJXiFpadHyPvq+o/p1l7LVtmJnqxvKqn0F9w7NiGrqAXB
-- +1jklXOFfdPWHnYNsmIYB96cKsP38M1arzWhLW4Vg0A981pzdD8gosbreEwjwJP4
-- ZaxmMxgjyT9+8+/KL1Q1VUD6XWQo7Q4tKCVA37aEoDxEE2s7/GcrfB1g7WXtsobv
-- 7+I6bEg0IqvntTV103ZI0Nfsj418Ia0yrf8tQuKF1zoRu7zj2Tvi
-- -----END-SIGNATURE-----