-- Not used by Autodesk MassFX: no localization.

-- PhysX utilities and exporter
try( removerollout px_utility) catch()

utility px_utility "PhysX Plugin" rolledUp:true
(
	timer   simClock  "simulationClock" interval:1 active:false
	-- quitMaxClock is for batch exporting
	timer   quitMaxClock  "delayQuitMax" interval:100 active:false
	
	button  bt_export                       "Export"     tooltip:"Export PhysX scene" across:2
  	button  bt_about                        "About"      tooltip:"Show version information and credits"
  	
  	on bt_export pressed do
  	(
  		global PxExportPxProj_Prompting
  		PxExportPxProj_Prompting(false)
  	)
  	
  	on bt_about pressed do
  	(
  		nvpx.ShowAboutDialog()
  	)

	
	local   lastTime = 0;
	on simClock tick do 
	(
		simClock.active = false
		if animButtonState then	animButtonState = false
	
		tDelta = 1000.0/(frameRate); 
		
		--DETERMINE BURN TIME IF SIMULATING TOO LAST--		
		tStart = timeStamp()
		tEnd = lastTime + tDelta
		if (tEnd > tStart) then
		(
			while timeStamp() < tEnd do
			(
			)
		)
		lastTime = tEnd
		if(lastTime < tStart) then lastTime = tStart
		
		--SIMULATE--
		
		with redraw off 
		(
			undo off
			(
				try
				(
					PxSimulateOneFrame(); 
				) catch ()
			)
		)
		
		redrawviews();

		
		simClock.active = true
		
		if (sliderTime >= animationRange.end) then
		(	
			case gPxOnLastFrame of
			(
				1: slidertime = animationRange.end
				2: PxPauseSimulation()
				3: if gPxLoopAnimation == 1 then (PxStopSimulation(); PxRunSimulation()) else sliderTime = animationRange.start
			)
		)	
	)
	
	on quitMaxClock tick do
	(
		quitMaxClock.active = false
		quitMAX #noPrompt
	)
)

fn PxCheckViewer = 
(
	if (nvpx.ShouldViewerSync()) do
	(
		PxShowViewer()
	)

	-- 
	local vcommand = nvpx.GetViewerCommand()
	if(vcommand == 1) do
	(
		nvpx.SetViewerCommand(0);   -- clear flag to prevent repeat
		PxShowPhysicsPanel(1);      -- see also: VIEWERCOMMAND_SHOW_PHYSXPANEL
		setFocus px_physXPanel
	)
	
	if(vcommand == 2) do            -- restart viewer
	(
		nvpx.SetViewerCommand(0);   -- clear flag to prevent repeat
		PxShowViewer()
	)
	
	nvpx.CheckViewerState()
)

fn PxStartViewerClock = 
(
	global gViewerClock
	gViewerClock.Enabled = true
)

fn PxStopViewerClock = 
(
	global gViewerClock
	gViewerClock.Enabled = false
)

global gViewerClock = dotNetObject "System.Windows.Forms.Timer" 
dotnet.addEventHandler  gViewerClock "tick" PxCheckViewer
gViewerClock.interval = 500
gViewerClock.Enabled = false




-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCiit0WdGzxG6az6JrtRdEnG09nmBIlV8PB
-- bibXsZDtBppm3OcPcUOYmWdpGMq70yCEWAh52fZI9ASG6dW4YKoZzqyL2Ekc4YyQ
-- iqOL0/GjbkidYSUNrri94IlKlO51SSplbqxH/cT723bBRNwyTORP3DLyY7bHfvd0
-- 6PHdmCp66dy7mm0XwRVRLFcocmmkD5IbE7nzDlJIM1f44QaizNLei3F9RIlDMiuo
-- 6tzWVV4AcROhQkntg5FBQ9dxNxLj+K9bmBORSZJW1lzdZtK1HzMlN2HI4GiyX4F8
-- yoJAbXIGagpDzBYzvx1yMnjiJk0eVZkLDZnDMm32hnTLx7jDdBEM
-- -----END-SIGNATURE-----