-- Plugin
global nvpx
global PhysXModRB

global PxIsBone
global PxGetRootParent

-- note: ragdoll rb type is  different to the type of one rb, which is defined as PX_PHYSTYPE_DYNAMIC/PX_PHYSTYPE_KINEMATIC/PX_PHYSTYPE_STATIC
global PX_RAGDOLL_RBTYPE_KINEMATIC = 0
global PX_RAGDOLL_RBTYPE_DYNAMIC = 1

global PX_RAGDOLL_MESHTYPE_CAPSULE = 0
global PX_RAGDOLL_MESHTYPE_CONVEX = 1

global PX_RAGDOLL_MESHFROM_SKIN = 0
global PX_RAGDOLL_MESHFROM_BONE = 1

fn PxGetRagdollHelperRootBone n =
(
	root = PxGetRootParent(n)
	handle = (getuserprop root "RagdollMesh")
	if handle != undefined then (
		root
	) else if PxIsBone(n) then (
		root
	)
	else (
		root = nvpx.RagdollGetRootBone n
	)
)

fn PxPotentialRagdollHelper n =
(
	-- it should be a bone or a skinned mesh
	if PxIsBone(n) then
	(
		if ((classof n) == CATBone) or ((classof n) == HubObject) then
			false
		else
			true
	)
	else
	(
		ret = false
		m = n.modifiers[#Physique]
		if m == undefined then m = n.modifiers[#Skin]
		(m != undefined)
	)
)


fn PxGetRagdollHelper n =
(
	if classof(n) == RagdollHelper then n
	else
	(
		ret = undefined
		root = PxGetRootParent(n)
		for i in objects do (
			if classof(i) == RagdollHelper then (
				if i.rootbone == root then ( ret = i; exit )
				-- iterates on multiple ragdoll skins
				for skin in i.multiRagdollSkins do
				(
					if skin == root then ( ret = i; exit )
				)
			)
		)
		ret
	)
)

fn PxGetRagdollHelperNode n =
(
	if nvpx.IsRagdollNode(n) then n
	else
	(
		ret = undefined
		root = PxGetRootParent(n)
		for i in objects do (
			if nvpx.RagdollGetRootBone(i) == root then (
				ret = i
				exit
			)
		)
		ret
	)
)

fn PxCreateDynamicRagdoll n =
(
	ret = undefined
	if n !=undefined and (PxPotentialRagdollHelper(n) or (classof(n) == RagdollHelper )) then (
		local setKeyMode = maxOps.setKeyMode
		maxOps.setKeyMode = false
		
		rag = PxGetRagdollHelper(n)
		--format " find rag %\n" rag
		if rag != undefined then (
			select rag
			 --forces a reset
			rag.rbtype = PX_RAGDOLL_RBTYPE_DYNAMIC
			rag.create(true)
			max modify mode
			ret = rag
		) else (
			rootBone = PxGetRagdollRootBone(n)
			if rootBone == undefined then 
			(
				messagebox nvpxText.TXT_RAGDOLL_ERR_UNKNOWN
			)
			else
			(
				rag = nvpx.CreateRagdollHelper()
				rag.rbtype = PX_RAGDOLL_RBTYPE_DYNAMIC
				rag.rootbone = rootBone
				--rag.pos = rootBone.transform.pos
				ragdollskin = PxGetRagdollHelperNode n
				if (ragdollskin != undefined) do
					append rag.multiRagdollSkins ragdollskin
				-- if there is skin, Graphical Mesh From uses 'skinned mesh'. If not, uses 'bones'
				rag.meshfrom = 1
				for skin in rag.multiRagdollSkins do
				(
					if skin != undefined then rag.meshfrom = 0
				)
				rag.create(false) -- rag.handle
				max modify mode
				select rag
				ret = rag
			)
		)
		
		maxOps.setKeyMode = setKeyMode
	)
	ret
)


fn PxCreateDynamicRagdollHelper =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
		PxCreateDynamicRagdoll(currentNode)
)

fn PxCreateKinematicRagdoll n =
(
	ret = undefined
	if n !=undefined and (PxPotentialRagdollHelper(n) or (classof(n) == RagdollHelper )) then (
		local setKeyMode = maxOps.setKeyMode
		maxOps.setKeyMode = false
		
		rag = PxGetRagdollHelper(n)
		--format " find rag %\n" rag
		if rag != undefined then (
			select rag
			rag.rbtype = PX_RAGDOLL_RBTYPE_KINEMATIC
			-- forces a reset
			rag.create(true)
			max modify mode
			ret = rag
		) else (
			rootBone = PxGetRagdollHelperRootBone(n)
			if rootBone == undefined then 
			(
				messagebox nvpxText.ragdollErrorNoRoot
			)
			else
			(
				rag = nvpx.CreateRagdollHelper()
				rag.rbtype = PX_RAGDOLL_RBTYPE_KINEMATIC
				rag.rootBone = rootBone
				rag.pos = rootBone.transform.pos
				ragdollskin = PxGetRagdollHelperNode n
				if (ragdollskin != undefined) do
					append rag.multiRagdollSkins ragdollskin
				-- if there is skin, Graphical Mesh From uses 'skinned mesh'. If not, uses 'bones'
				rag.meshfrom = 1
				for skin in rag.multiRagdollSkins do
				(
					if skin != undefined then rag.meshfrom = 0
				)
				rag.create(false) -- 
				max modify mode
				select rag
				ret = rag
			)
		)

		maxOps.setKeyMode = setKeyMode
	)
	ret
)

fn PxCreateKinematicRagdollHelper =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
		PxCreateKinematicRagdoll currentNode
)

fn PxRemoveRagdollByNode node = 
(
	if node != undefined then 
	(
		rag = PxGetRagdollHelper(node)
		if rag != undefined then 
		(
			info = nvpxText.ragdollDeleteRB
			yes  = queryBox info
			if yes then 
			(
				rag.removeAll()
			)
			else
			( 
				rag.disconnectAll()
			)
			delete rag
		)
	)
)

fn PxRemoveRagdollHelper =
(
	selNodes = PxGetSelectedNodes()
	
	for currentNode in selNodes do
	( 
		PxRemoveRagdollByNode currentNode
	)
	selHelper = PxGetSelectedHelpers()
	
	for currentNode in selHelper do
	( 
		PxRemoveRagdollByNode currentNode	
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAd8dN8HORsa+RIlSVJbdqA7ouiVPhag6Ja
-- Ylxzo6jVbIOJOpuXI5sS+l/V4TWZAzfKl49Kz32zURcnu02u0zrYiQm+9hP/UTa3
-- horNTKfdNJOgTDZIw1XLF87DtyITzb7iBPpMCbHXUX9Z5Cb8rN5KdJ8OrsQ6Z2uY
-- coQsxVLg5AabeWQgzZjIgkeU+HEwXUIllvxBn93XWqwITOitZ9GD24U7h9Q4pfnE
-- 1GT3Yz1yvgbO8QVwXdyUfl49FmuWX0tImOJMrihTjrpoPQrVdx+1/7bglpYv3GJP
-- IJhvqPBYAR9ebvlYOcozSBFQCJ4SMXFhYaVTNzncWU0KpQ9aU9Yb
-- -----END-SIGNATURE-----