-- Multi-Edit tab in MassFX Tools dialog.
-- Rollouts for Constraint objects
-- UI and Functionality scripted by Michaelson Britt. 6.8.2010.


---------- ---------- ---------- ----------
-- Forward declarations
---------- ---------- ---------- ----------

global px_multiedit_methods  -- forward declaration

-- Defined in px_globals.ms:
-- struct MultiEdit_ControlInfo_struct


---------- ---------- ---------- ----------
-- General Rollout
---------- ---------- ---------- ----------

rollout px_panel_multiedit_constraints_general "General" rolledUp:false category:1
(
	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	groupBox grp_Behavior "Behavior" width:170 height:15 across:1 align:#center
	label lbl_UseAcceleration "Constraint Behavior" align:#left offset:[0,3] across:1
	  -- TO DO: Bug, the X and Y offset values are reversed by the system
	radioButtons rdo_UseAcceleration "" labels:#(
		nvpxText.panelMultiConstraintUseAccelerationOn,
		nvpxText.panelMultiConstraintUseAccelerationOff) \
		columns:1 align:#left offsets:#([14,0],[14,5]) 
	label lbl_UseHardLimits "Constraint Limits" align:#left offset:[0,4] across:1
	  -- TO DO: Bug, the X and Y values are reversed by the system
	radioButtons rdo_UseHardLimits "" labels:#(
		nvpxText.panelMultiConstraintUseHardLimitsOn,
		nvpxText.panelMultiConstraintUseHardLimitsOff) \
		columns:1 align:#left offsets:#([14,0],[14,5])
	
	label lbl_HelperSize "Icon Size" align:#left offset:[0,12] across:2
	spinner spn_HelperSize "" type:#worldunits range:[0.0, PxMaxValue,  100.0] width:60 align:#right offset:[0,10]
	
	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	struct BoolToIntLookup_struct
	(
		fn ControlToParamFn controlItem controlVal = ( if controlVal==1 then true else false ),
		fn ParamToControlFn controlItem paramVal =   ( if paramVal==true then 1 else 2 )
	)
	local boolToIntLookup = BoolToIntLookup_struct()
	
	local controlInfoList =
	#(
		(MultiEdit_ControlInfo_struct		controlItem:rdo_UseAcceleration	paramIdent:#useAcceleration	controlValLookup:boolToIntLookup),
		(MultiEdit_ControlInfo_struct		controlItem:rdo_UseHardLimits	paramIdent:#useHardLimits	controlValLookup:boolToIntLookup),
		(MultiEdit_ControlInfo_struct		controlItem:spn_HelperSize		paramIdent:#helperSize)
	)	

	fn IsVisible =
	(
		(px_multiedit_methods.IsTabVisible()) and
			px_multiedit_methods.showConstraintRollouts
	)
	
	fn UpdateUI isForceUpdate:false =
	(
		-- Basic default handling
		px_multiedit_methods.UpdateUI_DefaultHandling_Constraint controlInfoList
	)
	
	on rdo_UseAcceleration changed val do	px_multiedit_methods.SetControlToConstraintList rdo_UseAcceleration val
	on spn_HelperSize changed val do			px_multiedit_methods.SetControlToConstraintList spn_HelperSize val
	on rdo_UseHardLimits changed val do
	(
		px_multiedit_methods.SetControlToConstraintList rdo_UseHardLimits val
		
		px_multiedit_methods.UpdateUI_ConstraintLimitRollouts()
	)

	on px_panel_multiedit_constraints_general open do
	(
		px_panel_multiedit_constraints_general.title = nvpxText.panelMultiConstraintGeneral
		
		-- NOTE: rdo_UseAcceleration radio buttons already localized, in declaration
		-- NOTE: rdo_UseHardLimits radio buttons already localized, in declaration
		lbl_UseAcceleration.text	= nvpxText.panelMultiConstraintUseAcceleration
		lbl_UseHardLimits.text		= nvpxText.panelMultiConstraintUseHardLimits
		lbl_HelperSize.text			= nvpxText.panelMultiConstraintHelperSize

		grp_Behavior.height = 42 + (rdo_UseHardLimits.pos.y - grp_Behavior.pos.y)
		grp_Behavior.text = nvpxText.panelMultiConstraintBehaviorGroup
	)

	on px_panel_multiedit_constraints_general close do
	(
	)
	
	on px_panel_multiedit_constraints_general help do
		(HelpSystem.ShowProductHelp 15012) --id_massfx_tools_edit
	
)

---------- ---------- ---------- ----------
-- Translation Limits Rollout
---------- ---------- ---------- ----------

rollout px_panel_multiedit_constraints_translationLimits "Translation Limits" rolledUp:false category:2
(

	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	label lbl_Column_LockedType "Locked" offset:[8,0] across:3
	label lbl_Column_LimitedType "Limited" offset:[8,0]
	label lbl_Column_FreeType	"Free" offset:[8,0]
	
	label lbl_Row_X "X" align:#left across:2
	radioButtons rdo_Row_X "" labels:#("         ","         ","") columns:3 offset:[-12,0]
	
	label lbl_Row_Y "Y" align:#left across:2
	radioButtons rdo_Row_Y "" labels:#("         ","         ","") columns:3 offset:[-12,0]

	label lbl_Row_Z "Z" align:#left across:2
	radioButtons rdo_Row_Z "" labels:#("         ","         ","") columns:3 offset:[-12,0]
	
	label lbl_LimitRadius "Limit Radius" align:#left offset:[0,10] across:2
	spinner spn_LimitRadius "" type:#worldunits range:[0.0, PxMaxValue,  100.0] width:60 align:#right offset:[0,10]

	label lbl_Bounce "Bounce" align:#left across:2
	spinner spn_Bounce "" type:#float range:[0.0, 1.0, 0.0] scale:0.01 width:60 align:#right

	label lbl_Spring "Spring" align:#left across:2
	spinner spn_Spring "" type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 width:60 align:#right

	label lbl_Damping "Damping" align:#left across:2
	spinner spn_Damping "" type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 width:60 align:#right
	

	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	local controlInfoList =
	#(
		(MultiEdit_ControlInfo_struct		controlItem:rdo_Row_X				paramIdent:#linearModeX),
		(MultiEdit_ControlInfo_struct		controlItem:rdo_Row_Y				paramIdent:#linearModeY),
		(MultiEdit_ControlInfo_struct		controlItem:rdo_Row_Z				paramIdent:#linearModeZ),
		(MultiEdit_ControlInfo_struct		controlItem:spn_LimitRadius		paramIdent:#linearPosition),
		(MultiEdit_ControlInfo_struct		controlItem:spn_Bounce			paramIdent:#linearRestitution),
		(MultiEdit_ControlInfo_struct		controlItem:spn_Spring				paramIdent:#linearSpring),
		(MultiEdit_ControlInfo_struct		controlItem:spn_Damping			paramIdent:#linearDamping)
	)

	fn IsVisible =
	(
		(px_multiedit_methods.IsTabVisible()) and
			px_multiedit_methods.showConstraintRollouts
	)
	
	fn UpdateUI_ParamRolloutEnables isForceUpdate:false =
	(
		local isHardLimits = (px_multiedit_methods.GetParamFromConstraintList #useHardLimits)
		local isLimitedX = ((px_multiedit_methods.GetParamFromConstraintList #linearModeX) == 2)
		local isLimitedY = ((px_multiedit_methods.GetParamFromConstraintList #linearModeY) == 2)
		local isLimitedZ = ((px_multiedit_methods.GetParamFromConstraintList #linearModeZ) == 2)
		local isAnyLimited = (isLimitedX or isLimitedY or isLimitedZ)
		
		spn_LimitRadius.enabled = lbl_LimitRadius.enabled = isAnyLimited
		spn_Bounce.enabled = lbl_Bounce.enabled = (isAnyLimited and (isHardLimits==true))
		spn_Spring.enabled = lbl_Spring.enabled = (isAnyLimited and (isHardLimits==false))
		spn_Damping.enabled = lbl_Damping.enabled = (isAnyLimited and (isHardLimits==false))
	)
	
	fn UpdateUI isForceUpdate:false =
	(
		-- Basic default handling
		px_multiedit_methods.UpdateUI_DefaultHandling_Constraint controlInfoList
		
		UpdateUI_ParamRolloutEnables isForceUpdate:isForceUpdate
	)
	
	fn SetControlAndUpdate controlItem controlVal =
	(
		px_multiedit_methods.SetControlToConstraintList controlItem controlVal
		UpdateUI_ParamRolloutEnables()
	)
	
	on rdo_Row_X changed val do			SetControlAndUpdate rdo_Row_X val
	on rdo_Row_Y changed val do			SetControlAndUpdate rdo_Row_Y val
	on rdo_Row_Z changed val do			SetControlAndUpdate rdo_Row_Z val
		
	on spn_LimitRadius changed val do		px_multiedit_methods.SetControlToConstraintList spn_LimitRadius val
	on spn_Bounce changed val do			px_multiedit_methods.SetControlToConstraintList spn_Bounce val
	on spn_Spring changed val do			px_multiedit_methods.SetControlToConstraintList spn_Spring val
	on spn_Damping changed val do			px_multiedit_methods.SetControlToConstraintList spn_Damping val
	
	on px_panel_multiedit_constraints_translationLimits open do
	(	-- Set text labels here, for compatiblity with older versions of 3ds max
		px_panel_multiedit_constraints_translationLimits.title = nvpxText.panelMultiConstraintTranslationLimits
		
		-- TO DO: Support localized radio buttons.  MaxScript doesn't allow the 'labels' property to be set
		local spacingLabels = #(
			nvpxText.panelMultiConstraintRowLabelSpacing,
			nvpxText.panelMultiConstraintRowLabelSpacing,
			"")
			
		lbl_Column_LockedType.text	= nvpxText.panelMultiConstraintLocked
		lbl_Column_LimitedType.text	= nvpxText.panelMultiConstraintLimited
		lbl_Column_FreeType.text		= nvpxText.panelMultiConstraintFree
	
		lbl_Row_X.text					= nvpxText.panelMultiConstraintRowX
		lbl_Row_Y.text					= nvpxText.panelMultiConstraintRowY
		lbl_Row_Z.text					= nvpxText.panelMultiConstraintRowZ
		--rdo_Row_X.labels					= spacingLabels
		--rdo_Row_Y.labels					= spacingLabels
		--rdo_Row_Z.labels					= spacingLabels

		lbl_LimitRadius.text				= nvpxText.panelMultiConstraintLimitRadius
		lbl_Bounce.text					= nvpxText.panelMultiConstraintBounce
		lbl_Spring.text						= nvpxText.panelMultiConstraintSpring
		lbl_Damping.text					= nvpxText.panelMultiConstraintDamping
	)
	on px_panel_multiedit_constraints_translationLimits close do
	(
	)
	
	on px_panel_multiedit_constraints_translationLimits help do
		(HelpSystem.ShowProductHelp 15012) --id_massfx_tools_edit
)


---------- ---------- ---------- ----------
-- Swing & Twist Limits Rollout
---------- ---------- ---------- ----------

rollout px_panel_multiedit_constraints_swingTwistLimits "Swing & Twist Limits" rolledUp:false category:3
(

	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	groupBox grp_SwingY "Swing Y" width:170 height:15 across:1
	
	label lbl_Column_LockedTypeY "Locked" across:3
	label lbl_Column_LimitedTypeY "Limited"
	label lbl_Column_FreeTypeY "Free"
 
	
	radiobuttons rdo_Mode_Y "" labels:#("          ", "          ", "") columns:3 offset:[18,0] across:1
	
	label lbl_AngleLimitY "Angle Limit" align:#left offset:[0,10] across:2 
	spinner spn_AngleLimitY "" width:60 type:#float range:[0.0,180.0,45.0] align:#right offset:[0,10]

	label lbl_BounceY "Bounce" align:#left across:2
	spinner spn_BounceY "" width:60 type:#float range:[0.0, 1.0, 0.0] scale:0.01 align:#right

	label lbl_SpringY "Spring" align:#left across:2
	spinner spn_SpringY "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right

	label lbl_DampingY "Damping" align:#left across:2
	spinner spn_DampingY "" width:60 range:[0.0, PxMaxValue, 0.0] type:#float scale:0.01 align:#right
	
	groupBox grp_SwingZ "Swing Z" width:170 height:15 offset:[0,10] across:1
	
	label lbl_Column_LockedTypeZ "Locked" across:3
	label lbl_Column_LimitedTypeZ "Limited"
	label lbl_Column_FreeTypeZ "Free"
 
	
	radiobuttons rdo_Mode_Z "" labels:#("          ", "          ", "") columns:3 offset:[18,0] across:1
	
	label lbl_AngleLimitZ "Angle Limit" align:#left offset:[0,10] across:2 
	spinner spn_AngleLimitZ "" width:60 type:#float range:[0.0, 180.0, 45.0] align:#right offset:[0,10]

	label lbl_BounceZ "Bounce" align:#left across:2
	spinner spn_BounceZ "" width:60 type:#float range:[0.0, 1.0, 0.0] scale:0.01 align:#right

	label lbl_SpringZ "Spring" align:#left across:2
	spinner spn_SpringZ "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right

	label lbl_DampingZ "Damping" align:#left across:2
	spinner spn_DampingZ "" width:60 range:[0.0, PxMaxValue, 0.0] type:#float scale:0.01 align:#right	
	
	
	groupBox grp_Twist "Twist" width:170 height:15 offset:[0,10] across:1
	
	label lbl_Column_LockedTypeTwist "Locked" across:3
	label lbl_Column_LimitedTypeTwist "Limited"
	label lbl_Column_FreeTypeTwist "Free"
 
	
	radiobuttons rdo_Mode_Twist "" labels:#("          ", "          ", "") columns:3 offset:[18,0] across:1
	
	label lbl_HiLoStub "" offset:[0,5] across:3
	label lbl_HiLoLeft "Left" offset:[4,5] align:#left
	label lbl_HiLoRight "Right"  offset:[4,5] align:#left
	
	label lbl_LimitTwist "Limit" align:#left offset:[0,5] across:3
	spinner spn_LimitTwistLo "" width:48 type:#float range:[-180.0,180.0,45.0] offset:[0,5] align:#right
	spinner spn_LimitTwistHi "" width:48 type:#float range:[-180.0,180.0,45.0] offset:[0,5] align:#right

	label lbl_BounceTwist "Bounce" align:#left across:3
	spinner spn_BounceTwistLo "" width:48 type:#float range:[0.0, 1.0, 0.0] scale:0.01 align:#right
	spinner spn_BounceTwistHi "" width:48 type:#float range:[0.0, 1.0, 0.0] scale:0.01 align:#right

	label lbl_SpringTwist "Spring" align:#left across:3
	spinner spn_SpringTwistLo "" width:48 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right
	spinner spn_SpringTwistHi "" width:48 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right

	label lbl_DampingTwist "Damping" align:#left across:3
	spinner spn_DampingTwistLo "" width:48 range:[0.0, PxMaxValue, 0.0] type:#float scale:0.01 align:#right	
	spinner spn_DampingTwistHi "" width:48 range:[0.0, PxMaxValue, 0.0] type:#float scale:0.01 align:#right	


	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	local controlInfoList =
	#(
		(MultiEdit_ControlInfo_struct		controlItem:rdo_Mode_Y			paramIdent:#swing2mode),
		(MultiEdit_ControlInfo_struct		controlItem:spn_AngleLimitY		paramIdent:#swing2Angle),
		(MultiEdit_ControlInfo_struct		controlItem:spn_BounceY			paramIdent:#swing2Restitution),
		(MultiEdit_ControlInfo_struct		controlItem:spn_SpringY			paramIdent:#swing2Spring),
		(MultiEdit_ControlInfo_struct		controlItem:spn_DampingY			paramIdent:#swing2Damping),
		
		(MultiEdit_ControlInfo_struct		controlItem:rdo_Mode_Z			paramIdent:#swing1mode),
		(MultiEdit_ControlInfo_struct		controlItem:spn_AngleLimitZ		paramIdent:#swing1Angle),
		(MultiEdit_ControlInfo_struct		controlItem:spn_BounceZ			paramIdent:#swing1Restitution),
		(MultiEdit_ControlInfo_struct		controlItem:spn_SpringZ			paramIdent:#swing1Spring),
		(MultiEdit_ControlInfo_struct		controlItem:spn_DampingZ			paramIdent:#swing1Damping),

		(MultiEdit_ControlInfo_struct		controlItem:rdo_Mode_Twist		paramIdent:#twistMode),
		(MultiEdit_ControlInfo_struct		controlItem:spn_LimitTwistLo		paramIdent:#twistAngleLow),
		(MultiEdit_ControlInfo_struct		controlItem:spn_LimitTwistHi		paramIdent:#twistAngleHigh),
		(MultiEdit_ControlInfo_struct		controlItem:spn_BounceTwistLo	paramIdent:#twistRestitutionLow),
		(MultiEdit_ControlInfo_struct		controlItem:spn_BounceTwistHi	paramIdent:#twistRestitutionHigh),
		(MultiEdit_ControlInfo_struct		controlItem:spn_SpringTwistLo	paramIdent:#twistSpringLow),
		(MultiEdit_ControlInfo_struct		controlItem:spn_SpringTwistHi	paramIdent:#twistSpringHigh),
		(MultiEdit_ControlInfo_struct		controlItem:spn_DampingTwistLo paramIdent:#twistDampingLow),
		(MultiEdit_ControlInfo_struct		controlItem:spn_DampingTwistHi paramIdent:#twistDampingHigh)
	)

	fn IsVisible =
	(
		(px_multiedit_methods.IsTabVisible()) and
			px_multiedit_methods.showConstraintRollouts
	)
	
	fn UpdateUI_SwingYEnables isHardLimits:undefined isForceUpdate:false =
	(
		if isHardLimits==undefined do isHardLimits = (px_multiedit_methods.GetParamFromConstraintList #useHardLimits)
		local isLimitedY = ((px_multiedit_methods.GetParamFromConstraintList #swing2mode) == 2)
		
		spn_AngleLimitY.enabled = lbl_AngleLimitY.enabled = isLimitedY
		spn_BounceY.enabled = lbl_BounceY.enabled = (isLimitedY and (isHardLimits==true))
		spn_SpringY.enabled = lbl_SpringY.enabled = (isLimitedY and (isHardLimits==false))
		spn_DampingY.enabled = lbl_DampingY.enabled = (isLimitedY and (isHardLimits==false))
	)

	fn UpdateUI_SwingZEnables isHardLimits:undefined isForceUpdate:false =
	(
		if isHardLimits==undefined do isHardLimits = (px_multiedit_methods.GetParamFromConstraintList #useHardLimits)
		local isLimitedZ = ((px_multiedit_methods.GetParamFromConstraintList #swing1mode) == 2)
		
		spn_AngleLimitZ.enabled = lbl_AngleLimitZ.enabled = isLimitedZ
		spn_BounceZ.enabled = lbl_BounceZ.enabled = (isLimitedZ and (isHardLimits==true))
		spn_SpringZ.enabled = lbl_SpringZ.enabled = (isLimitedZ and (isHardLimits==false))
		spn_DampingZ.enabled = lbl_DampingZ.enabled = (isLimitedZ and (isHardLimits==false))
	)

	fn UpdateUI_TwistEnables isHardLimits:undefined isForceUpdate:false =
	(
		if isHardLimits==undefined do isHardLimits = (px_multiedit_methods.GetParamFromConstraintList #useHardLimits)
		local isLimitedTwist = ((px_multiedit_methods.GetParamFromConstraintList #twistMode) == 2)
		
		spn_LimitTwistLo.enabled = spn_LimitTwistHi.enabled = lbl_LimitTwist.enabled = isLimitedTwist
		spn_BounceTwistLo.enabled = spn_BounceTwistHi.enabled = lbl_BounceTwist.enabled = (isLimitedTwist and (isHardLimits==true))
		spn_SpringTwistLo.enabled = spn_SpringTwistHi.enabled = lbl_SpringTwist.enabled = (isLimitedTwist and (isHardLimits==false))
		spn_DampingTwistLo.enabled = spn_DampingTwistHi.enabled = lbl_DampingTwist.enabled = (isLimitedTwist and (isHardLimits==false))
	)
	fn UpdateUI isForceUpdate:false =
	(
		-- Basic default handling
		px_multiedit_methods.UpdateUI_DefaultHandling_Constraint controlInfoList
		
		local isHardLimits = (px_multiedit_methods.GetParamFromConstraintList #useHardLimits)

		UpdateUI_SwingYEnables isHardLimits:isHardLimits isForceUpdate:isForceUpdate
		UpdateUI_SwingZEnables isHardLimits:isHardLimits isForceUpdate:isForceUpdate
		UpdateUI_TwistEnables isHardLimits:isHardLimits isForceUpdate:isForceUpdate
	)
	
	-- Used to set a control that might influence values of other controls (sets the control and updates others)
	fn SetControlAndUpdateValues controlItem controlVal =
	(  
		px_multiedit_methods.SetControlToConstraintList controlItem controlVal
		px_multiedit_methods.UpdateUI_DefaultHandling_Constraint controlInfoList updateEnables:false
	)
	
	on rdo_Mode_Y changed val do
	(
		px_multiedit_methods.SetControlToConstraintList rdo_Mode_Y val
		UpdateUI_SwingYEnables()
	)
	on spn_AngleLimitY changed val do		px_multiedit_methods.SetControlToConstraintList spn_AngleLimitY val
	on spn_BounceY changed val do		px_multiedit_methods.SetControlToConstraintList spn_BounceY val
	on spn_SpringY changed val do			px_multiedit_methods.SetControlToConstraintList spn_SpringY val
	on spn_DampingY changed val do		px_multiedit_methods.SetControlToConstraintList spn_DampingY val
	on rdo_Mode_Z changed val do
	(
		px_multiedit_methods.SetControlToConstraintList rdo_Mode_Z val
		UpdateUI_SwingZEnables()
	)
	on spn_AngleLimitZ changed val do		px_multiedit_methods.SetControlToConstraintList spn_AngleLimitZ val
	on spn_BounceZ changed val do		px_multiedit_methods.SetControlToConstraintList spn_BounceZ val
	on spn_SpringZ changed val do			px_multiedit_methods.SetControlToConstraintList spn_SpringZ val
	on spn_DampingZ changed val do		px_multiedit_methods.SetControlToConstraintList spn_DampingZ val
	on rdo_Mode_Twist changed val do
	(
		px_multiedit_methods.SetControlToConstraintList rdo_Mode_Twist val
		UpdateUI_TwistEnables()
	)
	on spn_LimitTwistLo changed val do			SetControlAndUpdateValues spn_LimitTwistLo val
	on spn_LimitTwistHi changed val do			SetControlAndUpdateValues spn_LimitTwistHi val
	on spn_BounceTwistLo changed val do		SetControlAndUpdateValues spn_BounceTwistLo val
	on spn_BounceTwistHi changed val do		SetControlAndUpdateValues spn_BounceTwistHi val
	on spn_SpringTwistLo changed val do			SetControlAndUpdateValues spn_SpringTwistLo val
	on spn_SpringTwistHi changed val do			SetControlAndUpdateValues spn_SpringTwistHi val
	on spn_DampingTwistLo changed val do		SetControlAndUpdateValues spn_DampingTwistLo val
	on spn_DampingTwistHi changed val do		SetControlAndUpdateValues spn_DampingTwistHi val
	
	on px_panel_multiedit_constraints_swingTwistLimits open do
	(	-- Set text labels here, for compatiblity with older versions of 3ds max
		px_panel_multiedit_constraints_swingTwistLimits.title = nvpxText.panelMultiConstraintSwingTwistLimits
		
		-- TO DO: Support localized radio buttons.  MaxScript doesn't allow the 'labels' property to be set
		local spacingLabels = #(
			nvpxText.panelMultiConstraintModeLabelSpacing,
			nvpxText.panelMultiConstraintModeLabelSpacing,
			"")

		grp_SwingY.text					= nvpxText.panelMultiConstraintSwingY
		lbl_Column_LockedTypeY.text	= nvpxText.panelMultiConstraintLocked
		lbl_Column_LimitedTypeY.text	= nvpxText.panelMultiConstraintLimited
		lbl_Column_FreeTypeY.text	= nvpxText.panelMultiConstraintFree
		--rdo_Mode_Y.labels				= spacingLabels
		lbl_AngleLimitY.text				= nvpxText.panelMultiConstraintAngleLimit
		lbl_BounceY.text					= nvpxText.panelMultiConstraintBounce
		lbl_SpringY.text					= nvpxText.panelMultiConstraintSpring
		lbl_DampingY.text				= nvpxText.panelMultiConstraintDamping

		grp_SwingZ.text					= nvpxText.panelMultiConstraintSwingZ
		lbl_Column_LockedTypeZ.text	= nvpxText.panelMultiConstraintLocked
		lbl_Column_LimitedTypeZ.text	= nvpxText.panelMultiConstraintLimited
		lbl_Column_FreeTypeZ.text	= nvpxText.panelMultiConstraintFree
		--rdo_Mode_Z.labels				= spacingLabels
		lbl_AngleLimitZ.text				= nvpxText.panelMultiConstraintAngleLimit
		lbl_BounceZ.text					= nvpxText.panelMultiConstraintBounce
		lbl_SpringZ.text					= nvpxText.panelMultiConstraintSpring
		lbl_DampingZ.text				= nvpxText.panelMultiConstraintDamping

		grp_Twist.text						= nvpxText.panelMultiConstraintTwist
		lbl_Column_LockedTypeTwist.text = nvpxText.panelMultiConstraintLocked
		lbl_Column_LimitedTypeTwist.text = nvpxText.panelMultiConstraintLimited
		lbl_Column_FreeTypeTwist.text = nvpxText.panelMultiConstraintFree
		--rdo_Mode_Twist.labels			= spacingLabels
		lbl_HiLoLeft.text					= nvpxText.panelMultiConstraintLimitLeft
		lbl_HiLoRight.text					= nvpxText.panelMultiConstraintLimitRight
		lbl_LimitTwist.text				= nvpxText.panelMultiConstraintTwistLimit
		lbl_BounceTwist.text			= nvpxText.panelMultiConstraintBounce
		lbl_SpringTwist.text				= nvpxText.panelMultiConstraintSpring
		lbl_DampingTwist.text			= nvpxText.panelMultiConstraintTwist


		grp_SwingY.height = 155
		grp_SwingY.pos.x = 4
		grp_SwingZ.height = 155
		grp_SwingZ.pos.x = 4
		grp_Twist.height = 173
		grp_Twist.pos.x = 4
		px_panel_multiedit_constraints_swingTwistLimits.height += 8
		
		UpdateUI()
	)
	on px_panel_multiedit_constraints_swingTwistLimits close do
	(
	)
	
	on px_panel_multiedit_constraints_swingTwistLimits help do
		(HelpSystem.ShowProductHelp 15012) --id_massfx_tools_edit
)


---------- ---------- ---------- ----------
-- Spring Rollout
---------- ---------- ---------- ----------

rollout px_panel_multiedit_constraints_spring "Spring" rolledUp:false category:4
(

	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	groupBox grp_Position "Spring To Resting Postion" width:170 height:15 across:1
	
	label lbl_PositionSpringiness "Springiness" align:#left offset:[0,5] across:2
	spinner spn_PositionSpringiness "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 offset:[0,5] align:#right
	label lbl_PositionDamping "Damping" align:#left across:2
	spinner spn_PositionDamping "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right

	groupBox grp_Swing "Spring To Resting Swing" width:170 height:15 offset:[0,10] across:1
	
	label lbl_SwingSpringiness "Springiness" align:#left across:2 offset:[0,5]
	spinner spn_SwingSpringiness "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right offset:[0,5] 
	label lbl_SwingDamping "Damping" align:#left across:2
	spinner spn_SwingDamping "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right

	groupBox grp_Twist "Spring To Resting Twist" width:170 height:15 offset:[0,10] across:1
	
	label lbl_TwistSpringiness "Springiness" align:#left offset:[0,5] across:2
	spinner spn_TwistSpringiness "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right offset:[0,5]
	label lbl_TwistDamping "Damping" align:#left across:2
	spinner spn_TwistDamping "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] scale:0.01 align:#right

	
	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	local controlInfoList =
	#(
		(MultiEdit_ControlInfo_struct		controlItem:spn_PositionSpringiness	paramIdent:#posSpring),
		(MultiEdit_ControlInfo_struct		controlItem:spn_PositionDamping		paramIdent:#posDamping),

		(MultiEdit_ControlInfo_struct		controlItem:spn_SwingSpringiness		paramIdent:#swingSpring),
		(MultiEdit_ControlInfo_struct		controlItem:spn_SwingDamping			paramIdent:#swingDamping),

		(MultiEdit_ControlInfo_struct		controlItem:spn_TwistSpringiness		paramIdent:#twistSpring),
		(MultiEdit_ControlInfo_struct		controlItem:spn_TwistDamping			paramIdent:#twistDamping)
	)

	fn IsVisible =
	(
		(px_multiedit_methods.IsTabVisible()) and
			px_multiedit_methods.showConstraintRollouts
	)
	
	fn UpdateUI isForceUpdate:false =
	(
		-- Basic default handling
		px_multiedit_methods.UpdateUI_DefaultHandling_Constraint controlInfoList
	)
	
	on spn_PositionSpringiness changed val do	px_multiedit_methods.SetControlToConstraintList spn_PositionSpringiness val
	on spn_PositionDamping changed val do		px_multiedit_methods.SetControlToConstraintList spn_PositionDamping val

	on spn_SwingSpringiness changed val do		px_multiedit_methods.SetControlToConstraintList spn_SwingSpringiness val
	on spn_SwingDamping changed val do			px_multiedit_methods.SetControlToConstraintList spn_SwingDamping val

	on spn_TwistSpringiness changed val do		px_multiedit_methods.SetControlToConstraintList spn_TwistSpringiness val
	on spn_TwistDamping changed val do			px_multiedit_methods.SetControlToConstraintList spn_TwistDamping val
	
	on px_panel_multiedit_constraints_spring open do
	(	-- Set text labels here, for compatiblity with older versions of 3ds max
		px_panel_multiedit_constraints_spring.title = nvpxText.panelMultiConstraintSpring

		grp_Position.text					= nvpxText.panelMultiConstraintSpringPosition
		lbl_PositionSpringiness.text	= nvpxText.panelMultiConstraintSpringiness
		lbl_PositionDamping.text		= nvpxText.panelMultiConstraintDamping

		grp_Swing.text					= nvpxText.panelMultiConstraintSpringSwing
		lbl_SwingSpringiness.text		= nvpxText.panelMultiConstraintSpringiness
		lbl_SwingDamping.text			= nvpxText.panelMultiConstraintDamping

		grp_Twist.text						= nvpxText.panelMultiConstraintSpringTwist
		lbl_TwistSpringiness.text		= nvpxText.panelMultiConstraintSpringiness
		lbl_TwistDamping.text			= nvpxText.panelMultiConstraintDamping


		grp_Position.height = 70
		grp_Position.pos.x = 4
		grp_Swing.height = 70
		grp_Swing.pos.x = 4
		grp_Twist.height = 70
		grp_Twist.pos.x = 4
		px_panel_multiedit_constraints_spring.height += 8
		
		UpdateUI()
	)
	on px_panel_multiedit_constraints_spring close do
	(
	)
	
	on px_panel_multiedit_constraints_spring help do
		(HelpSystem.ShowProductHelp 15012) --id_massfx_tools_edit
)


---------- ---------- ---------- ----------
-- Advanced Rollout
---------- ---------- ---------- ----------

rollout px_panel_multiedit_constraints_advanced "Advanced" rolledUp:false category:5
(

	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	checkbox chk_ParentChildCollisions "Parent/Child Collisions" across:1
	
	groupBox grp_Breakable "Breakable Constraint" width:170 height:15 align:#center offset:[0,10]
	checkbox chk_Breakable "Breakable" across:1
	label lbl_ForceThreshold "Break Force" align:#left offset:[19,5] across:2
	spinner spn_ForceThreshold "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] offset:[0,5] align:#right
	label lbl_TorqueThreshold "Break Torque" align:#left offset:[19,0] across:2
	spinner spn_TorqueThreshold "" width:60 type:#float range:[0.0, PxMaxValue, 0.0] align:#right

	groupBox grp_Projection "Projection" width:170 height:15 align:#center offset:[0,10]
	label lbl_ProjectionType "Projection Type" align:#left offset:[0,3] across:1
	radiobuttons rdo_ProjectionOff "" labels:#(nvpxText.panelMultiConstraintProjectionNone) align:#left across:1 offset:[14,0]
	radiobuttons rdo_ProjectionLinear "" labels:#(nvpxText.panelMultiConstraintProjectionLinear) align:#left across:1 offset:[14,0]
	radiobuttons rdo_ProjectionLinearAngular "" labels:#(nvpxText.panelMultiConstraintProjectionLinAngular) across:1 align:#left offset:[14,0]
	label lbl_ProjectionSettings "Projection Settings" align:#left offset:[0,4] across:1
	label lbl_ProjectionDistance "Distance" align:#left offset:[19,0] across:2
	spinner spn_ProjectionDistance "" width:60 type:#float range:[0.0, 100.0, 0.0] align:#right
	label lbl_ProjectionAngle "Angle" align:#left offset:[19,0] across:2
	spinner spn_ProjectionAngle "" width:60 type:#float range:[0.0, 100.0, 0.0] align:#right

	-- TO DO:  SHOULD PROJECTION SPINNERS REALLY BE CAPPED AT 100 ??
	

	-- IMPORTANT:  KEEP CONTROL DECLARATIONS / CONTROL INFO LIST IN SYNC

	local controlInfoList =
	#(
		(MultiEdit_ControlInfo_struct		controlItem:chk_ParentChildCollisions	paramIdent:#Collision),
		(MultiEdit_ControlInfo_struct		controlItem:chk_Breakable					paramIdent:#breakable),
		(MultiEdit_ControlInfo_struct		controlItem:spn_ForceThreshold			paramIdent:#maxForce),
		(MultiEdit_ControlInfo_struct		controlItem:spn_TorqueThreshold		paramIdent:#maxTorque),
		(MultiEdit_ControlInfo_struct		controlItem:rdo_ProjectionOff),
		(MultiEdit_ControlInfo_struct		controlItem:rdo_ProjectionLinear),
		(MultiEdit_ControlInfo_struct		controlItem:rdo_ProjectionLinearAngular),
		(MultiEdit_ControlInfo_struct		controlItem:spn_ProjectionDistance		paramIdent:#projectionDist),
		(MultiEdit_ControlInfo_struct		controlItem:spn_ProjectionAngle			paramIdent:#projectionAngle)
	)

	fn IsVisible =
	(
		(px_multiedit_methods.IsTabVisible()) and
			px_multiedit_methods.showConstraintRollouts
	)
		
	fn UpdateUI_BreakableEnables isForceUpdate:false =
	(
		local isBreakable = ((px_multiedit_methods.GetParamFromConstraintList #breakable) == true)
		
		spn_ForceThreshold.enabled = lbl_ForceThreshold.enabled = isBreakable
		spn_TorqueThreshold.enabled = lbl_TorqueThreshold.enabled = isBreakable
	)

	fn UpdateUI_Projection isForceUpdate:false =
	(
		-- Update Projection Mode
		local projectionEnabled = px_multiedit_methods.GetParamFromConstraintList #useProjection
		local projectionMode = px_multiedit_methods.GetParamFromConstraintList #projectionMode

		local state =
			if (projectionEnabled==true) and (projectionMode==1) then 3
			else if (projectionEnabled==true) and (projectionMode==0) then 2
			else if (projectionEnabled==false) then 1
			else 0  -- projectionEnabled is undefined, or it's true and projectionMode is undefined
			
		rdo_ProjectionOff.state = (if (state==1) then 1 else 0)
		rdo_ProjectionLinear.state = (if (state==2) then 1 else 0)
		rdo_ProjectionLinearAngular.state = (if (state==3) then 1 else 0)
		lbl_ProjectionDistance.enabled = spn_ProjectionDistance.enabled = ((state==2) or (state==3))
		lbl_ProjectionAngle.enabled = spn_ProjectionAngle.enabled = (state==3)
	)
		
	fn UpdateUI isForceUpdate:false =
	(
		-- Basic default handling
		px_multiedit_methods.UpdateUI_DefaultHandling_Constraint controlInfoList
		
		UpdateUI_Projection isForceUpdate:isForceUpdate
		UpdateUI_BreakableEnables isForceUpdate:isForceUpdate
	)
	
	on chk_Breakable changed val do
	(
		px_multiedit_methods.SetControlToConstraintList chk_Breakable val
		UpdateUI_BreakableEnables()
	)
	on spn_ForceThreshold changed val do		px_multiedit_methods.SetControlToConstraintList spn_ForceThreshold val
	on spn_TorqueThreshold changed val do		px_multiedit_methods.SetControlToConstraintList spn_TorqueThreshold val
	on spn_ProjectionDistance changed val do	px_multiedit_methods.SetControlToConstraintList spn_ProjectionDistance val
	on spn_ProjectionAngle changed val do		px_multiedit_methods.SetControlToConstraintList spn_ProjectionAngle val
	on chk_ParentChildCollisions changed val do	px_multiedit_methods.SetControlToConstraintList chk_ParentChildCollisions val
	on rdo_ProjectionOff changed val do
	(	-- assume message is projecting being toggled on (user may check "projection off" radio button, but cannot explicitly un-check)
		px_multiedit_methods.SetParamToConstraintList #useProjection false
		UpdateUI_Projection()
	)
	on rdo_ProjectionLinear changed val do
	(	-- assume message is Linear being toggled on (user may check "Linear" radio button, but cannot explicitly un-check)
		px_multiedit_methods.SetParamToConstraintList #useProjection true
		px_multiedit_methods.SetParamToConstraintList #projectionMode 0
		UpdateUI_Projection()
	)
	on rdo_ProjectionLinearAngular changed val do
	(	-- assume message is Linear/Angular being toggled on (user may check "Linear/Angular" radio button, but cannot explicitly un-check)
		px_multiedit_methods.SetParamToConstraintList #useProjection true
		px_multiedit_methods.SetParamToConstraintList #projectionMode 1
		UpdateUI_Projection()
	)
	
	on px_panel_multiedit_constraints_advanced open do
	(	-- Set text labels here, for compatiblity with older versions of 3ds max
		px_panel_multiedit_constraints_advanced.title = nvpxText.panelMultiConstraintAdvanced
		
		chk_ParentChildCollisions.text	= nvpxText.panelMultiConstraintParentChildCollisions
		grp_Breakable.text				= nvpxText.panelMultiConstraintBreakableConstraint
		chk_Breakable.text				= nvpxText.panelMultiConstraintBreakable
		lbl_ForceThreshold.text			= nvpxText.panelMultiConstraintBreakForce
		lbl_TorqueThreshold.text		= nvpxText.panelMultiConstraintBreakTorque

		grp_Projection.text				= nvpxText.panelMultiConstraintProjection
		lbl_ProjectionType.text			= nvpxText.panelMultiConstraintProjectionType
		-- NOTE: rdo_ProjectionOff radio buttons already localized, in declaration
		-- NOTE: rdo_ProjectionLinear radio buttons already localized, in declaration
		-- NOTE: rdo_ProjectionLinearAngular radio buttons already localized, in declaration		
		lbl_ProjectionSettings.text		= nvpxText.panelMultiConstraintProjectionSettings
		lbl_ProjectionDistance.text		= nvpxText.panelMultiConstraintProjectionDistance
		lbl_ProjectionAngle.text			= nvpxText.panelMultiConstraintProjectionAngle

		grp_Breakable.height = 20 + (spn_TorqueThreshold.pos.y - grp_Breakable.pos.y)
		grp_Projection.height = 20 + (lbl_ProjectionAngle.pos.y - grp_Projection.pos.y)
		px_panel_multiedit_constraints_advanced.height += 8
		
		UpdateUI()
	)
	on px_panel_multiedit_constraints_advanced close do
	(
	)
	
	on px_panel_multiedit_constraints_advanced help do
		(HelpSystem.ShowProductHelp 15012) --id_massfx_tools_edit
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB/HzZzNX73C2uPcJyNUTZ5VKNJ+FM4K82h
-- 2swQhfkTuaLIH3c4vYL+41Csm+2h6css5QW1Dq22ygB+ZOHtBYvSIMS8CnyGXvE5
-- tuhQMV48o3VhMgHGjw0+bv+oU4sdM3czwYkNpFVCMRmBAbaQoLqn0cV1AKHJjlZv
-- 0GP0h0qyyRu61nxv94JfBnijhhO0BnyZmkRhcDA38HwzmUIUjyDQHx3gOquVmuQ1
-- 5dDeFLIiLZkrH+VtpKYbx14ro1Zm9BdqyBRqrpCYbNhwONePFLAGgZExg5BcgKif
-- QnOV9HSpYpDDfRk1F8PlFDNdZAFB2kcgcz2OhZAtfyJFMJZpCXNw
-- -----END-SIGNATURE-----