
-- remember keys for Rigidbodies. only care about default PRS controller (especially Euler_XYZ and Potion_XYZ parts)
-- then we can reset scene exactly as beginning. and get simulation determinism

-- global varible for storing node keys
global gPxRBKeys = #()

struct pxNodeKeys
(
	inode,
	posTimes = #(),
	posx = #(),
	posy = #(),
	posz = #(),
	rotTimes = #(),
	rotx = #(),
	roty = #(),
	rotz = #(),

	fn Init =
	(
		posTimes = #()
		posx = #()
		posy = #()
		posz = #()
		rotTimes = #()
		rotx = #()
		roty = #()
		rotz = #()
	),
	
	fn SaveKeys=
	(
		-- clear old data
		Init()
		
		-- save Position keys
		if classof(inode.position.controller) == Position_XYZ then
		(
			c = inode.position.controller;
			for i = 1 to c.keys.count do 
			(
				t = c.keys[i].time
				append posTimes t
				at time t
				(
					append posx c.x_position
					append posy c.y_position
					append posz c.z_position
				)
			)
		)
		
		-- save Rotation keys
		if classof(inode.rotation.controller) == Euler_XYZ then
		(
			c = inode.rotation.controller;
			for i = 1 to c.keys.count do 
			(
				t = c.keys[i].time
				append rotTimes t
				at time t
				(
					append rotx c.x_rotation
					append roty c.y_rotation
					append rotz c.z_rotation
				)
			)
		)
	),
	
	fn ResetKeys =
	(
		with animate on
		(
			-- reset position keys
			c = inode.position.controller
			
			-- check controller type because it may be changed by some other codes
			if classof(c) == Position_XYZ then
			(
				for i = 1 to posTimes.count do
				(
					at time posTimes[i]
					(
						c.x_position = posx[i]
						c.y_position = posy[i]
						c.z_position = posz[i]
					)
				)
			)
			
			-- reset rotation keys
			c = inode.rotation.controller
			
			-- check controller type because it may be changed by some other codes
			if classof(c) == Euler_XYZ then
			(
				for i = 1 to rotTimes.count do
				(
					at time rotTimes[i]
					(
						c.x_rotation = rotx[i]
						c.y_rotation = roty[i]
						c.z_rotation = rotz[i]
					)
				)
			)
		)
	),
	
	-- use the following function to test before calling SaveKeys() and ResetKeys()
	fn HaveKeys pnode =
	(
		if pnode != undefined and superclassof(pnode.baseobject) == GeometryClass and classof(pnode.controller) == PRS then
		(
			pnode.position.controller.keys.count > 0 or pnode.rotation.controller.keys.count > 0
		)
		else
		(
			false
		)
	)
)


fn PxClearSavedRBKeys =
(
	gPxRBKeys = #()
)

fn PxSaveRBKeys pnode =
(
	if pxNodeKeys.HaveKeys(pnode) then
	(
		global PxGetModRB
		modRB = PxGetModRB pnode
		
		-- do not care about baked nodes
		if modRB != undefined and (modRB.baked == 0) then
		(
			newkeys = pxNodeKeys pnode
			append gPxRBKeys newkeys
			gPxRBKeys[gPxRBKeys.count].SaveKeys()
		)
	)
)

fn PxResetRBKeys =
(
	for i in gPxRBKeys do
	(
		if (IsValidNode(i) == true) do
			i.ResetKeys()
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA2nHefosuGo/wmVzevd13atBkI+BVadrO9
-- gP0wUX2Ppu9PT5v0d1t3rW7dQ/j+bKQaAO21ehg0wVGb0Q4VwiXfPm3pF2E9IaL+
-- thUrCvXN4/O4PX+9eu3h53Z6fshq6vvSU7vCO5Jz+X+qY6Tb3WSr4fphus2BINnZ
-- y8o8OVK3QzJzgSLIe8+lB7XGamsInlB3GNmUFIiSLq36DBflWpZLDI5amED8V53f
-- fj122L9dSdVzoKwgOZ46ZhgR4LBocY0ztZ/0WRfdDfRc+kqK4kdtZdrhZ4tQTOho
-- nXXyuMeNd9ifwned4PaMdBsgM+j31kYty7lFOtVn6gdSXu34BMSP
-- -----END-SIGNATURE-----