--px_ragdoll_sync.ms is for User dragging tools on max nodes when simulating. 
--Author : Hypark Piao
--Contact : hpiao@nvidia.com
--Copyright (C) 2008-2009 nVIDIA Corp.
--For conditions of distribution and use, see copyright notice in http://www.nvidia.com/PhysX.

--purpose: The original intersection plane position when user start dragging.
global objPos

--purpose: Get the correct world position for perspective view corresponding to the mouse current position.
/*!details: Get the world position of the current mouse point by calculating a plane/ray intersection equation below.
Plane: A(x-x0) + B(y-y0) + C(z-z0)
Ray: x = x1+mt, y = y1+nt, z = z1+pt
*/
--@param mousePt the current mouse position.
--@param obj for get the object current position for determine the correct construction plane and objNormal nolmal of the construction plane.
--@return undefined
fn GetPersWorldPosForMouse mousePt obj = 
(
	local wldRay = mapScreenToWorldRay mousePt
	local rayPos = wldRay.pos
	local rayDir = wldRay.dir
	
	-- The affine TM transforms from world coords to view coords
	-- so we need the inverse of this matrix
	local coordSysTM = Inverse(viewport.getTM())
	
	-- The Z axis of this matrix is the view direction.
	local objNormal = coordSysTM.row3
	--local objPos = obj.pos
	
	-- Get the parametric represtentaion of the ray.
	local divs = objNormal.x*rayDir.x + objNormal.y*rayDir.y + objNormal.z*rayDir.z
	local divd = objNormal.x*(objPos.x-rayPos.x)+objNormal.y*(objPos.y-rayPos.y)+objNormal.z*(objPos.z-rayPos.z)
	
	wldPt = [0,0,0]
	if divs!=0 do
	(
		local t = divd/divs
		wldPt = [rayPos.x+rayDir.x*t, rayPos.y+rayDir.y*t, rayPos.z+rayDir.z*t]
	)
	
	wldPt
)

struct IMouseDragger
(
	--purpose: Last button status.
	_bPrevLButton = false,
	
	--purpose: Current button status.
	_bCurLButton = false,
	
	--purpose: Determine if in dragging now.
	_bInDragging = false,
	
	--purpose: Tracks the object world pos from drag starts to end.
	_aryContrail = #(),
	
	--purpose: Size of the contrail array.
	_nConSize = 5,
	
	--purpose: World Position of the dragging object.
	_objPos = [0, 0, 0],
	
	--purpose: Offset between Mouse point & obj world position.
	_pivotOffset = [ 0, 0, 0],
	
	--purpose: The node being dragged.
	_objDragged = undefined,
	
	--purpose: The max throwing velocity.
	_maxVel = 4.0,
	
	--purpose: If in indirect dragging mode. Usualy used for ragdoll dragging.
	_bIndirectMode = false,
	
	--purpose: Calculate the linear velocity by using data from _aryContrail.
	fn CalcVelocity = 
	(
		if _aryContrail.count>0 and _objDragged!=undefined do
		(
			timeElapsed = _aryContrail[_aryContrail.count][2] - _aryContrail[1][2]
			offsetPos = _aryContrail[_aryContrail.count][1] - _aryContrail[1][1]
			vVelocity = offsetPos/timeElapsed
			vVelocity = vVelocity*100
			
			-- Limite max velocity
			if length vVelocity > _maxVel do
			(
				vVelMax = normalize vVelocity
				vVelocity = vVelocity*_maxVel
			)
			
			INF = 100000.0f
			if _objDragged!=undefined and vVelocity!=[0,0,0] do
			(
				if vVelocity.x<INF and vVelocity.y<INF and vVelocity.z<INF and 
				   vVelocity.x>-INF and vVelocity.y>-INF and vVelocity.z>-INF do
					nvpx.SetLinearVelocity _objDragged vVelocity
			)
			
			--format " %, % \n" timeElapsed offsetPos
		)
	),
	
	--purpose: if should be in indirect mode ,return true. else return false
	fn TestIndirectMode obj =
	(
		local bool result = nvpx.IsBiped obj
		
		if result==true then
			true
		else
			false
	),
	
	--purpose: Called when enter drag mode, start recording mouse input.
	--@return undefined
	fn onStartDrag =
	(
		--nvpx.SetNullCM()
		
		_aryContrail = #()
		
		-- Calculate the dragged node by hit-testing. 
		local r = mapScreenToWorldRay mouse.pos
		hits = intersectRayScene r
		
		_objDragged = undefined
		for i in hits do
		(
			if findString i[1].name "hull" == undefined do
			(
				_objDragged = i[1]
				
				_bIndirectMode = TestIndirectMode _objDragged
				
				if  _bIndirectMode==false then
				(
					-- Calc pivot offset
					objPos = _objDragged.pos
				)
				else
				(
					objPos = biped.getTransform _objDragged #pos
					nvpx.StartIndirectDrag _objDragged
				)
				
				mousePos = GetPersWorldPosForMouse mouse.pos _objDragged
				_pivotOffset = objPos - mousePos
				
				exit
			)
		)
	),
	
	--purpose: Called when enter drag mode, clear all recording mouse input data.
	--@return undefined
	fn onEndDrag = 
	(
		if _bIndirectMode==false then
		(
			-- Set linear velocity when dragging end.
			CalcVelocity()
		
			/*format "---------------------------------------------\n"
			for i in _aryContrail do print i*/
			_aryContrail = #()
		)
		else
			nvpx.EndIndirectDrag()

		-- Free the dragged node.
		_objDragged = undefined
		_bIndirectMode=false
	),
	
	--purpose: Called when in dragging
	--details: set the selection position corresponding to the current mouse position, and determin the rotation force when mouse releases
	--@return undefined
	fn onDragging = 
	(		
		--format "Dragging\n"
		validMode = (toolMode.commandMode==#SELECT) or (toolMode.commandMode==#MOVE) or (toolMode.commandMode==#ROTATE)
		if validMode and _objDragged!=undefined do 
		(
			--Sync the obj position by case #perspective view & #othoritic view
			type = viewport.getType()
			if type==#view_persp_user or type==#view_iso_user then
			(
				_objPos = GetPersWorldPosForMouse mouse.pos _objDragged
			)
			else
			(
				--selectedNodesArray = PxGetSelectedNoes()
				--format " %! \n " selectedNodesArray[1].pos
				pt2D = gw.getPointOnCP mouse.pos
				_objPos = gw.mapCPToWorld pt2D
			)
			
			if _bIndirectMode == false then
			(
				_objDragged.pos = _objPos + _pivotOffset
				
				-- Append world pos & time of selected obj.
				curTime = timeStamp()
				append _aryContrail #(_objPos, curTime)
			
				-- For memory case, control the size of _aryContrail in _nConSize.
				if _aryContrail.count>_nConSize do
				(
					aryTmp  = #()
					for i=_aryContrail.count-_nConSize+1 to _aryContrail.count do
					(
						append aryTmp _aryContrail[i]
					)
				
					_aryContrail = #()
					_aryContrail = aryTmp
				)
			
				nvpx.SetLinearVelocity _objDragged [0.0,0.0,0.0]
				--print "normal mode on dragging"
			)
			else
			(
				local mousePos = _objPos + _pivotOffset
				
				nvpx.OnIndirectDrag mousePos
			)
		)
	),
	
	--purpose: Main entry for whole the mouse dragging funcs, user should invoke this when needing dragging support.
	--@return undefined
	fn onProceccing =
	(
		-- Force using select command mode.
		--if toolmode.commandmode!=#SELECT do toolmode.commandmode=#SELECT
		--nvpx.SetNullCM()
		
		-- Mouse left button is down 
		if mouse.mode==2 and mouse.buttonStates[1]==true then
		(
			_bCurLButton = true
		)
		else
		(
			_bCurLButton = false
		)
		
		-- Enter the dragging mode
		if _bPrevLButton==false and _bCurLButton==true then
		(
			--format "enter\n"
			_bInDragging = true
			onStartDrag()
		)
		
		-- Leave the dragging mode
		if _bPrevLButton==true and _bCurLButton==false and _objDragged != undefined then
		(
			--format "left\n"
			_bInDragging = false
			onEndDrag()
		)
		
		-- In the dragging mode
		if _bInDragging==true then
		(
			onDragging()
		)
		
		_bPrevLButton = _bCurLButton
	)
)

global g_dragger = IMouseDragger()

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQACm8gaXfhL5AQNBTBcBwFG4hWyf8B1a4Og
-- 5iBts6ECEnaSeQG/kp1CDC5LhCD3es+LoUBGDUdMZtJdIICPBCMUZYhBHQOxCzOo
-- OVCwqW/SmTUPK40jOruPPuB++aWQIqrxSSPPhEUcFMfp1HlxvUmX6yi4NZc8tcn/
-- GuLM9cqOI+gJg9E3FTqIRB5tWeyV0tFqL6xucjuVvcVKMfFhl0GCUGBnm7zW6VHb
-- 16MJY7XXmCKJUNroeX3JSAlKjFW7Hjo9DPROTp3rqTU2GuPL8TkXJ3BAPr4wJfKR
-- uShXmDr9+JKve/NHgIGrKvCFPwxHDeGFvHWQCJPP29usnmW4EwxL
-- -----END-SIGNATURE-----