global PxApexModsToDelete = #()			-- needs to delete the modifiers in the array after adding the new physics modifier.
global PxApexModsToDeleteForce = #()	-- always force to delete modifiers in the array

-- Is this a graphical mesh modifier?
fn PxIsApexGraphicalMod modApexClothing =
(
	if	modApexClothing.name == nvpxText.TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME or 
		modApexClothing.name == nvpxText.TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME then true
	else false
)

-- Find the clothing modifier on the given node
fn PxFindApexGraphicalMod node =
(
	if node == undefined then undefined
	else
	(
		modClothing	  = node.modifiers[nvpxText.TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME]
		modSBClothing = node.modifiers[nvpxText.TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME]
		if isgrouphead(node) then
		( 
			modClothing = node.children[1].modifiers[nvpxText.TXT_MODIFIERCLOTHING_CLOTHING_CLASS_NAME]
			modSBClothing = node.children[1].modifiers[nvpxText.TXT_MODIFIERCLOTHING_SBCLOTHING_CLASS_NAME]
		)
		
		if modClothing != undefined and modSBClothing != undefined then 
			print "APEX Clothing and APEX Softbody should not be applied to the same node!"
			
		if modClothing == undefined then modSBClothing
		else modClothing
	)
)

-- Find the clothing LOD modifier on the given node
fn PxFindApexLODMod node =
(
	if node == undefined then
	(
		undefined
	)
	else
	(	
		modClothing = node.modifiers[nvpxText.TXT_MODIFIERCLOTHING_LOD_CLASS_NAME]
		
		if isgrouphead(node) then modeClothing = node.children[1].modifiers[nvpxText.TXT_MODIFIERCLOTHING_LOD_CLASS_NAME]
		
		modClothing
	)
)

-- Store modifiers in a list to be later deleted
fn PxAddModifierToTrash node mod =
(
	mods = node.modifiers
	PxApexModsToDelete = #()
	if PxIsApexGraphicalMod(mod) then 
		append PxApexModsToDelete mod
)

-- Remove any modifiers that match the spec in our trash list
fn PxEmptyModifierTrash node mod =
(
	--format "PxEmptyModifierTrash\n"
	for i in PxApexModsToDelete do
	(
		if i == mod then
		(
			--format "Remove: %\n" i
			deleteModifier node i
		)
	)
	
	for j in PxApexModsToDeleteForce do
	(
		deleteModifier node j
	)
	PxApexModsToDeleteForce = #()
)

-- Turn a node into a graphical modifier node.  Called when you choose the menu option, instead
-- of directly adding the modifier.
fn PxAddApexClothingMod n =
(
	if isgroupmember(n) then undefined
	else
	(
		modClothing = PxFindApexGraphicalMod n
		
		modClothingLOD = PxFindApexLODMod n
		--format "PxAddApexClothingMod: %, %\n" modClothing modClothingLOD
		if modClothing == undefined and modClothingLOD == undefined then 
		(
			modClothing = APEXClothing()

			if isgrouphead(n) then
			(
				children = #()
				pxSelectionTool.GetAllGroupChildren n children
				for i in children do addmodifier i modClothing
			)
			else
			(
				--format "add mod to node: %\n" n
				addmodifier n modClothing
			)
		)
	)
)

-- add apex softbody clothing modifier via script
fn PxAddApexSBClothingMod n =
(
	if isgroupmember(n) then undefined
	else
	(
		modClothing = PxFindApexGraphicalMod n
		modClothingLOD = PxFindApexLODMod n
		
		if modClothing == undefined and modClothingLOD == undefined then 
		(
			modClothing = APEXSBClothing()

			if isgrouphead(n) then
			(
				children = #()
				pxSelectionTool.GetAllGroupChildren n children
				for i in children do addmodifier i modClothing
			)
			else
			(
				addmodifier n modClothing
			)
		)
	)
)

-- Given a list of nodes, add apex clothing to them
fn PxAddApexClothingToNodes nodes =
(
	for i in nodes do PxAddApexClothingMod i
)

fn PxAddApexSBClothingToNodes nodes =
(
	for i in nodes do PxAddApexSBClothingMod i
)

-- If adding an apex modifier, prepare to remove the previous one so there is only one on the stack
fn PxApexModifierPreAdded =
(

	t = callbacks.notificationParam()
	node = t[1]
	modApexClothing  = t[2]
	
	if (node != undefined) then
	(
		if PxIsApexGraphicalMod(modApexClothing) then 
		(
			-- Don't add it if there is no skin
			if (node.modifiers[#Skin] == undefined) then
			(
				messagebox nvpxText.TXT_MODIFIERCLOTHING_FAIL_TO_ADD
				PxApexModsToDeleteForce = #()
				PxApexModsToDelete = #()
				append PxApexModsToDeleteForce modApexClothing
			)
			else
			(
				PxStopSimulation()
				-- cancel this addition
				existingClothingMod = PxFindApexGraphicalMod node
				--format "PxApexModifierPreAdded %\n" existingClothingMod
				
				if (existingClothingMod != undefined) then
					PxAddModifierToTrash node modApexClothing
			)
		)	
	)
)

-- Delete a modifer that was prepared to be deleted, and setup the physical mesh
fn PxApexModifierPostAdded =
(
	t = callbacks.notificationParam()
	node = t[1]
	
	if node != undefined then
	(
		modApexClothing  = t[2]
		
		-- If we added a graphical modifier...
		if PxIsApexGraphicalMod(modApexClothing) then 
		(
			-- Remove new clothing modifier on this node
			PxEmptyModifierTrash node modApexClothing
		)
	)	
)

-- If the modifier is being deleted, stop the simulation
fn PxApexModifierPreDelete =
(
	t = callbacks.notificationParam()
	node = t[1]
	mod  = t[2]
	
	if PxIsApexGraphicalMod(mod) then
	(
		PxStopSimulation()
	)
)

-- Intialize the callbacks
callbacks.removeScripts id:#ApexClothingModifier
callbacks.addScript #preModifierAdded    "PxApexModifierPreAdded()"       id:#ApexClothingModifier
callbacks.addScript #postModifierAdded   "PxApexModifierPostAdded()"      id:#ApexClothingModifier
callbacks.addScript #preModifierDeleted  "PxApexModifierPreDelete()"      id:#ApexClothingModifier


-- Export

fn APEXSaveFBX filename scale =
(
	format nvpxText.TXT_MODIFIERCLOTHING_INFO_SAVING_FMT filename
	
	pluginManager.loadClass FBXEXP 
		
	FBXExporterSetParam "Animation" true 
	FBXExporterSetParam "ForceNormalsByControlPoint" false 
	FBXExporterSetParam "GeomAsBone" true 
	FBXExporterSetParam "BakeAnimation" true -- set to bake animation to ensure exporting to Clothing Tool works
	FbxExporterSetParam "NormalsPerPoly" false
	FBXExporterSetParam "Skin" true
	FBXExporterSetParam "Shape" true
	FBXExporterSetParam "PointCache" false 
	FBXExporterSetParam "Removesinglekeys" true
	FBXExporterSetParam "Export|IncludeGrp|Animation|CurveFilter" true
	FBXExporterSetParam "Export|IncludeGrp|Animation|CurveFilter|CurveFilterApplyUnroll" true
	FBXExporterSetParam "FilterKeyReducer" false 
	FBXExporterSetParam "Cameras" false 
	FBXExporterSetParam "Lights" false 
	FBXExporterSetParam "EmbedTextures" false 
	--REM:DH we should not be converting units.--FBXExporterSetParam "ConvertUnit" "in" 
	FBXExporterSetParam "UpAxis" "Z" 
	FBXExporterSetParam "ShowWarnings" false
	FBXExporterSetParam "FileVersion" "FBX201000" 
	FBXExporterSetParam "ScaleFactor" scale
	ExportFile filename #noPrompt selectedOnly:false using:FBXEXP

	undefined
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQALFGuB+a6nmEtopNFyGrK7RzHUUS6+cK2a
-- eEWLYQIHeltDcBdBdyVIPuZJK8IAZ/Y4R7tKNUO7TrmIC0t6GDNaK5rBCwIpRD8w
-- 2L1hXH7e7XZSioin7AwIqaviUNXZriWJiXjrfnZeWsMYXPtya7MZhYFCkN1Tozdw
-- vC0fdHYsaeObkZRdKw85lBM9bwVUM6KUUkSHussPT3Ub7dntr38OpMlDCLyZ2bgS
-- 2J8d8yZmyU4CI2h2IL8ZZI086Mx671Q9GSqSr65CsKN9T4MZ3f/yN7Ue8W0b3T+B
-- vaDwa5NWYfymh73yj5mWrUuCY0gw72lUtkT1g7bg8vVSR0OvkHjB
-- -----END-SIGNATURE-----