-- file not used: not localized

-- PhysX GUI for SB

rollout px_panel_softbody_collision		"PhysX SoftBody - Collision" rolledUp:false
(
	label       lbl_01                      "Relative Grid Space"		align:#left across:2
	spinner		relativegridspacing_ui		""			                align:#right  width:70 range:[0.01,10.0,0.25]		type:#float
	checkbox	selfcollision_ui			"Selfcollision"				checked:false
	
	group  "Valid Bounds"
	(
	checkbox	validbounds_ui				"Valid Bounds"				checked:false
	label       lbl_1                 "Min"                       align:#right  width:40 across:4
	spinner     bounds_min_x          "x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  
	spinner     bounds_min_y          "y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	spinner     bounds_min_z          "z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	label       lbl_2                 "Max"                       align:#right  width:40 across:4
	spinner     bounds_max_x          "x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  
	spinner     bounds_max_y          "y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	spinner     bounds_max_z          "z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	)
	
	group "Collision with Rigidbody"
	(
	label       lbl_r01                     "Collision Resp."			align:#right across:2
	spinner		collisionresponsecoeff_ui	""							align:#right width:70 range:[0.0,PxMaxValue.0,0.2]		type:#float
	checkbox	disable_collision_ui		"Disable Collision"			checked:false
	checkbox	disable_dynamic_ccd 		"Disable Dynamic CCD"		checked:false
	checkbox	twowaycollision_ui			"Two-way Collision"			checked:false
	)
	group "Collision with Fluid"
	(
	checkbox	fluidcollision_ui			"Fluid Collision"			checked:false
	label       lbl_f01                     "To Fluid Resp."			align:#right across:2
	spinner		tofluidresponsecoeff_ui		""							align:#right width:70 range:[0.0,PxMaxValue.0,1.0]		type:#float
	label       lbl_f02                     "From Fluid Resp."			align:#right across:2
	spinner		fromfluidresponsecoeff_ui	""						    align:#right width:70 range:[0.0,PxMaxValue.0,1.0]		type:#float
	)
)

rollout px_panel_softbody_tearing		"PhysX SoftBody - Tearing" rolledUp:false
(
	checkbox	tearable_ui					"Tearable"					checked:false
	spinner		tearfactor_ui				"Tear factor"				range:[1.01,10.0,1.5]		type:#float  enabled:false
)

rollout px_panel_softbody_attachment	"PhysX SoftBody - Attachment" rolledUp:false
(
	label       lbl_a00                     "Attach. Response"			align:#left across:2
	spinner		attachmentresponsecoeff_ui	""							align:#right width:70 range:[0.0,1.0,0.2]		type:#float
	checkbox    flag_attach_twoway			"Two-way interaction"		align:#left                  -- NX_SOFTBODY_ATTACHMENT_TWOWAY
	label       lbl_a01                     "Two-way Resp."			align:#right across:2
	spinner		attachtwowayresp			""						align:#right width:70 range:[0, 1, 0.2] scale:0.01 
	checkbox	attachmentTearable_ui		"Tearable"					checked:false
	label       lbl_a02                     "Tear factor"			align:#right across:2
	spinner		attachmenttearfactor_ui		""						align:#right width:70 range:[1.01,10.0,1.5]		type:#float
	checkbox	attachmentAdhere_ui			"Adhere"					checked:false
	label       lbl_a03                     "Min Vel."			align:#right across:2
	spinner		attachmentAdhereVel			""					align:#right width:70 range:[0, PxMaxValue, 1]		type:#float
	
	label		  attachlbl		  "Attach Method"       align:#left across:2
	dropdownlist  attachMethod    ""                    align:#right width:85 items:#("none", "Automated", "User Define")
	listbox   attachments         caption:"List of Attachments"  height:5   items:#()
	button    add                 "Add"                align:#right across:2 tooltip:"Add tearing surface which cuts the Softbody"
	button    remove              "Remove"             align:#right 

	on add pressed do ()
	on remove pressed do ()
	
	fn loadValues =
	(
		attachmentTearable_ui.checked   = PxGetNodeUserProp pxCurrentNode "px_sbf_attachment_tearable" false
		attachmenttearfactor_ui.value   = PxGetNodeUserProp pxCurrentNode "px_sbp_attachTearFactor" 1.5
		flag_attach_twoway.checked      = PxGetNodeUserProp pxCurrentNode "px_sbf_attachment_twoway" false
		attachtwowayresp.value          = PxGetNodeUserProp pxCurrentNode "px_sbp_attachResponseCoef" 0.2
		attachmentAdhere_ui.checked     = PxGetNodeUserProp pxCurrentNode "px_sbf_attachAdhere" false
		attachmentAdhereVel.value       = PxGetNodeUserProp pxCurrentNode "px_sbp_attachAdhereVel" 1.0
		attachMethod.selection          = PxGetNodeUserProp pxCurrentNode "px_sbp_attachmode" 1
	)
	
	on px_panel_softbody_attachment open do 
	(
		loadValues()
	)
)

rollout px_panel_softbody_mesh			"PhysX SoftBody - Mesh" rolledUp:false
(
	label		lbl_a						"Mesh Settings"
	checkbox	meshtetras_ui				"Mesh is tetrahedra"		checked:true
	checkbox	isosurface_ui				"Create iso surface"
	checkbox	isosurfacesingle_ui			"Single iso surface"
	spinner		subdivisionlevel_ui			"Subdivision lvl"			range:[1,90,20]				type:#integer
	spinner		surfacesimplification_ui	"Surface simpl."			range:[0.0,1.0,0.5]			type:#float

	checkbox	meshtearable_ui				"Mesh Tearable" 			checked:false
	checkbox	sixteenbit_ui				"16 bit indices"			checked:false
	checkbox	vertexcolor_ui				"Vertex color -> tearable"	checked:false
	checkbox	meshhardware_ui				"Hardware"					checked:false
)

fn editSoftbodyAttachment =
(
	if px_panel_softbody_attachment != undefined then DestroyDialog px_panel_softbody_attachment
	--format "px_panel_softbody_attachment = %\n" px_panel_softbody_attachment
	createDialog px_panel_softbody_attachment width:220
)


fn editSoftbodyCollisions =
(
	if px_panel_softbody_collision != undefined then DestroyDialog px_panel_softbody_collision
	--format "px_panel_softbody_collision = %\n" px_panel_softbody_collision
	createDialog px_panel_softbody_collision width:220
)

fn editSoftbodyTearing =
(
	if px_panel_softbody_tearing != undefined then DestroyDialog px_panel_softbody_tearing
	--format "px_panel_softbody_tearing = %\n" px_panel_softbody_tearing
	createDialog px_panel_softbody_tearing width:220
)

fn editSoftbodyMesh =
(
	if px_panel_softbody_mesh != undefined then DestroyDialog px_panel_softbody_mesh
	--format "px_panel_softbody_mesh = %\n" px_panel_softbody_mesh
	createDialog px_panel_softbody_mesh width:220
)


rollout px_panel_softbody "PhysX SoftBody" rolledUp:false
(
	group "Basic Properties"
	(
	spinner		density_ui					"Density"					range:[0.01,PxMaxValue,1.0]	type:#float
	spinner		particleradius_ui			"Particle radius"			range:[0.0,1.0,0.1]			type:#float
	spinner		friction_ui					"Friction"					range:[0.0,1.0,0.5]			type:#float
	spinner		solveriterations_ui			"Solver Iter."				range:[1,100,5]				type:#integer
	spinner		sleepVel_ui					"Sleep Vel."				range:[-1.0,PxMaxValue,-1]	type:#float
	spinner		wakeupCounter_ui			"Wakeup Counter"			range:[0,PxMaxValue,0.4]		type:#float
	spinner		stretchingstiff_ui			"Stretch. Stiff."			range:[0.01,1.0,1.0]			type:#float
	label       lbl_2						"External Acceleration:"	align:#left
	spinner     external_acc_x				"x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  across:3
	spinner     external_acc_y				"y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	spinner     external_acc_z				"z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	)
	
	group "Flags"
	(
	checkbox	bodyhardware_ui				"Hardware"					checked:false
	checkbox	gravity_ui					"Gravity"					checked:true
	checkbox	static_ui					"Static"					checked:false
	checkbox	dampingflag_ui				"Damping"					checked:false  width:70
	label       lbl_f0                      "Damping Coef."				align:#right across:2
	spinner		damping_ui					""							align:#right   width:70 range:[0.0,1.0,0.5]			type:#float
	checkbox	comdamping_ui				"Center of Mass Damp."		checked:false
	checkbox	volumeconservation_ui		"Volume Conservation"		checked:true
	label       lbl_02                      "Volume stiff."				align:#right across:2
	spinner		volumestiff_ui				""							align:#right width:70 range:[0.0,1.0,1.0]			type:#float
	--checkbox	visualization_ui			"Visualization"				checked:false
	)
	
	group "Tetrahedral Creation"
	(
		label       lblTetrahedral              "Tetrahedral"               align:#left  width: 70 across:2
		pickbutton  tetraHull                   "undefined"                 align:#right enabled:false
		label       lbl_04                      "Subdivision lvl"			align:#left  across:2
		spinner		subdivisionlevel_ui			""							align:#right width:70 range:[2,90,10]		type:#integer
		label       lbl_06                      "Surface simpl."			align:#left  across:2
		spinner		surfacesimplification_ui	""							align:#right width:70 range:[0.0,1.0,0.5]	type:#float
		button		buildmesh_ui				"Build mesh"				align:#right width:70 tooltip:"Push this button to build a mesh suitable for SoftBody simulation using the parameters above"
	)
	
	button collision   "Collisions"   align:#left  width:90 across:2
	button attachment  "Attachments"  align:#right width:90 
	button mesh        "Mesh"         align:#left  width:90 across:2
	button tearing     "Tearing"      align:#right width:90
	
	on attachment  pressed do ( editSoftbodyAttachment() )
	on collision   pressed do ( editSoftbodyCollisions() )
	on tearing     pressed do ( editSoftbodyTearing() )
	on mesh        pressed do ( editSoftbodyMesh() )

	function enableControls state = 
	(
		local enableControls = not meshtetras_ui.checked;

		isosurface_ui.enabled = enableControls;
		isosurfacesingle_ui.enabled = enableControls;
		subdivisionlevel_ui.enabled = enableControls;
		surfacesimplification_ui.enabled = enableControls;

		-- not implemented
		vertexcolor_ui.enabled = false;
		vertexcolor_ui.checked = false;
		
		meshhardware_ui.enabled = state and px.hwAvailable();
		bodyhardware_ui.enabled = state and px.hwAvailable();
	)

	on meshtetras_ui changed val do
	(
		enableControls true; -- don't need the parameter for this class, but need to send something
	)

	function updateSelection &props = 
	( 
		local differences = false;
		for n in $selection do
		(
			if (checkBoolProperty n &props "px_sb_meshistetra" true) then differences = true;
			if (checkBoolProperty n &props "px_sb_createisosurface" true) then differences = true;
			if (checkBoolProperty n &props "px_sb_createsingleisosurface" false) then differences = true;
			if (checkIntegerProperty n &props "px_sb_subdivisionlevel" 20) then differences = true;
			if (checkFloatProperty n &props "px_sb_surfacesimplificationfactor" 0.5) then differences = true;
		
			if (checkBoolProperty n &props "px_sbmf_tearable" false) then differences = true;
			if (checkBoolProperty n &props "px_sbmf_16bit" false) then differences = true;
			if (checkBoolProperty n &props "px_sbmp_vertex" false) then differences = true;
			if (checkBoolProperty n &props "px_sbmf_hardware" false) then differences = true;

			if (checkIntegerProperty n &props "px_sbp_compartment" 0) then differences = true;
			if (checkFloatProperty n &props "px_sbp_volumestiffness" 1.0) then differences = true;
			if (checkFloatProperty n &props "px_sbp_stretchingstiffness" 1.0) then differences = true;
			if (checkFloatProperty n &props "px_sbp_density" 1.0) then differences = true;
			if (checkFloatProperty n &props "px_sbp_damping" 0.5) then differences = true;
			if (checkFloatProperty n &props "px_sbp_friction" 0.5) then differences = true;
			if (checkFloatProperty n &props "px_sbp_particleradius" 0.1) then differences = true;
			if (checkIntegerProperty n &props "px_sbp_solveriterations" 5) then differences = true;
			if (checkFloatProperty n &props "px_sbp_tearfactor" 1.5) then differences = true;
			if (checkFloatProperty n &props "px_sbp_collisionresponse" 0.2) then differences = true;
			if (checkFloatProperty n &props "px_sbp_attachmentresponse" 0.2) then differences = true;
			if (checkFloatProperty n &props "px_sbp_attachmenttearfactor" 1.5) then differences = true;
			if (checkFloatProperty n &props "px_sbp_tofluidresponse" 1.0) then differences = true;
			if (checkFloatProperty n &props "px_sbp_fromfluidresponse" 1.0) then differences = true;
			if (checkFloatProperty n &props "px_sbp_relativegridspacing" 0.25) then differences = true;

			if (checkBoolProperty n &props "px_sbf_static" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_disablecollision" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_selfcollision" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_visualization" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_gravity" true) then differences = true;
			if (checkBoolProperty n &props "px_sbf_volumeconservation" true) then differences = true;
			if (checkBoolProperty n &props "px_sbf_damping" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_twowaycollision" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_tearable" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_hardware" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_comdamping" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_validbounds" false) then differences = true;
			if (checkBoolProperty n &props "px_sbf_fluidcollision" false) then differences = true;
		)
		differences; 
	)

	function getValueAsBool val defaultValue = 
	(
		try (
			val as BooleanClass
		) catch
		(
			try
			(
				local tmp = val as integer;
				tmp != 0;
			) catch(defaultValue)
		);
	)

	function getValueAsFloat val defaultValue =
	(
		try (
			val as float;
		) catch(defaultValue);
	)

	function getValueAsInt val defaultValue =
	(
		try (
			val as integer;
		) catch(defaultValue);
	)


	function updateUIWithReadValues &props = 
	(
		meshtetras_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sb_meshistetra" true) true;
		isosurface_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sb_createisosurface" true) true;
		isosurfacesingle_ui.checked			= getValueAsBool (pxMap_getValue &props "px_sb_createsingleisosurface" false) false;
		subdivisionlevel_ui.value			= getValueAsInt (pxMap_getValue &props "px_sb_subdivisionlevel" 20) 20;
		surfacesimplification_ui.value		= getValueAsFloat (pxMap_getValue &props "px_sb_surfacesimplificationfactor" 0.5) 0.5;

		meshtearable_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sbmf_tearable" false) false;
		sixteenbit_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sbmf_16bit" false) false;
		vertexcolor_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sbmp_vertex" false) false;
		meshhardware_ui.checked					= getValueAsBool (pxMap_getValue &props "px_sbmf_hardware" false) false;

		compartment_ui.value				= getValueAsInt (pxMap_getValue &props "px_sbp_compartment" 0) 0;
		volumestiff_ui.value				= getValueAsFloat (pxMap_getValue &props "px_sbp_volumestiffness" 1.0) 1.0;
		stretchingstiff_ui.value			= getValueAsFloat (pxMap_getValue &props "px_sbp_stretchingstiffness" 1.0) 1.0;
		density_ui.value					= getValueAsFloat (pxMap_getValue &props "px_sbp_density" 1.0) 1.0;
		damping_ui.value					= getValueAsFloat (pxMap_getValue &props "px_sbp_damping" 0.5) 0.5;
		friction_ui.value					= getValueAsFloat (pxMap_getValue &props "px_sbp_friction" 0.5) 0.5;
		particleradius_ui.value				= getValueAsFloat (pxMap_getValue &props "px_sbp_particleradius" 0.1) 0.1;
		solveriterations_ui.value			= getValueAsInt (pxMap_getValue &props "px_sbp_solveriterations" 5) 5;
		tearfactor_ui.value					= getValueAsFloat (pxMap_getValue &props "px_sbp_tearfactor" 1.5) 1.5;
		collisionresponsecoeff_ui.value		= getValueAsFloat (pxMap_getValue &props "px_sbp_collisionresponse" 0.2) 0.2;
		attachmentresponsecoeff_ui.value	= getValueAsFloat (pxMap_getValue &props "px_sbp_attachmentresponse" 0.2) 0.2;
		attachmenttearfactor_ui.value		= getValueAsFloat (pxMap_getValue &props "px_sbp_attachmenttearfactor" 1.5) 1.5;
		tofluidresponsecoeff_ui.value		= getValueAsFloat (pxMap_getValue &props "px_sbp_tofluidresponse" 1.0) 1.0;
		fromfluidresponsecoeff_ui.value		= getValueAsFloat (pxMap_getValue &props "px_sbp_fromfluidresponse" 1.0) 1.0;
		relativegridspacing_ui.value		= getValueAsFloat (pxMap_getValue &props "px_sbp_relativegridspacing" 0.25) 0.25;

		static_ui.checked					= getValueAsBool (pxMap_getValue &props "px_sbf_static" false) false;
		disable_collision_ui.checked		= getValueAsBool (pxMap_getValue &props "px_sbf_disablecollision" false) false;
		selfcollision_ui.checked			= getValueAsBool (pxMap_getValue &props "px_sbf_selfcollision" false) false;
		visualization_ui.checked			= getValueAsBool (pxMap_getValue &props "px_sbf_visualization" false) false;
		gravity_ui.checked					= getValueAsBool (pxMap_getValue &props "px_sbf_gravity" true) true;
		volumeconservation_ui.checked		= getValueAsBool (pxMap_getValue &props "px_sbf_volumeconservation" true) true;
		dampingflag_ui.checked					= getValueAsBool (pxMap_getValue &props "px_sbf_damping" false) false;
		twowaycollision_ui.checked			= getValueAsBool (pxMap_getValue &props "px_sbf_twowaycollision" false) false;
		tearable_ui.checked					= getValueAsBool (pxMap_getValue &props "px_sbf_tearable" false) false;
		bodyhardware_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sbf_hardware" false) false;
		comdamping_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sbf_comdamping" false) false;
		validbounds_ui.checked				= getValueAsBool (pxMap_getValue &props "px_sbf_validbounds" false) false;
		fluidcollision_ui.checked			= getValueAsBool (pxMap_getValue &props "px_sbf_fluidcollision" false) false;
	)

	on px_panel_softbody open do
	(
		enableControls true;
	)

	on meshtetras_ui changed val do updateEditProperties();
	on isosurface_ui changed val do updateEditProperties();
	on isosurfacesingle_ui changed val do updateEditProperties();
	on subdivisionlevel_ui changed val do updateEditProperties();
	on surfacesimplification_ui changed val do updateEditProperties();

	on meshtearable_ui changed val do updateEditProperties();
	on sixteenbit_ui changed val do updateEditProperties();
	on vertexcolor_ui changed val do updateEditProperties();
	on meshhardware_ui changed val do updateEditProperties();

	on compartment_ui changed val do updateEditProperties();
	on volumestiff_ui changed val do updateEditProperties();
	on stretchingstiff_ui changed val do updateEditProperties();
	on density_ui changed val do updateEditProperties();
	on damping_ui changed val do updateEditProperties();
	on friction_ui changed val do updateEditProperties();
	on particleradius_ui changed val do updateEditProperties();
	on solveriterations_ui changed val do updateEditProperties();
	on tearfactor_ui changed val do updateEditProperties();
	on collisionresponsecoeff_ui changed val do updateEditProperties();
	on attachmentresponsecoeff_ui changed val do updateEditProperties();
	on attachmenttearfactor_ui changed val do updateEditProperties();
	on tofluidresponsecoeff_ui changed val do updateEditProperties();
	on fromfluidresponsecoeff_ui changed val do updateEditProperties();
	on relativegridspacing_ui changed val do updateEditProperties();

	on static_ui changed val do updateEditProperties();
	on disable_collision_ui changed val do updateEditProperties();

	on selfcollision_ui changed val do updateEditProperties();
	on visualization_ui changed val do updateEditProperties();
	on gravity_ui changed val do updateEditProperties();
	on volumeconservation_ui changed val do updateEditProperties();
	on dampingflag_ui changed val do updateEditProperties();
	on twowaycollision_ui changed val do updateEditProperties();
	on tearable_ui changed val do updateEditProperties();
	on bodyhardware_ui changed val do updateEditProperties();
	on comdamping_ui changed val do updateEditProperties();
	on validbounds_ui changed val do updateEditProperties();
	on fluidcollision_ui changed val do updateEditProperties();
	*/
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBkqaDOsr0K8RiKcN6m9mF4gb7mheoMUyCb
-- ur/J0Gg/MvARA1y0WF4VR4FlObHK3q7qr4uDWPfHIgLDOUSB7kmIngYEh4By1bWZ
-- 1yU+1Hs9Bt9LU4Phpn2tAVW5hsgtSjyeOJImYSF9OlRVmkGcK35dzo+oRzVBpPCD
-- ZeFNJE2QsCyewYyRw59VUFjC3iScMwU9A2Rk2fzeT2AfmGX763Z7X/3fwNSrTQXl
-- 7M/38xHJ7SKxhlEb+lhUetf1feBCa9leWwqBsVP8kTgDZ3OMbTYX9TKjSrQ3UGXa
-- XX2r5xB2JHm4+W0NUGn5ziLykey22dGUFePIC9EFajqC2DphfY9P
-- -----END-SIGNATURE-----