-- Not used by Autodesk MassFX: no localization.
-- PhysX Main GUI system
-- toolbar
global PxAddApexClothingToNodes
global PxAddApexSBClothingToNodes


-- Menu System
-- static handle to PhysXMenu
global pxPhysXMenu
global gPhysXMenuRunSimItem


-- Menu System
global Menu_Separator			= -10
global Menu_RemovePhysX         = 5
global Menu_CreateCloth         = 20
global Menu_CreateSoftBody      = 30
global Menu_CreateForcefiled    = 35
global Menu_CreateRagdoll       = 40
global Menu_CreateD6Constraint  = 45
global Menu_CreateFluid         = 50
global Menu_CreateEmitter       = 60
global Menu_SDKParameter        = 70
global Menu_Export              = 80
global Menu_Run                 = 90
global Menu_Step                = 100
global Menu_Stop                = 120
global Menu_Reset				= 125

global Menu_APEXCreateClothing  = 130
global Menu_APEXCreateSBClothing= 131
global Menu_APEXImportTemplate	= 135
global Menu_APEXExportTemplate  = 136
global Menu_APEXExportClothing	= 137
global Menu_APEXRebuildSelectedClothing	= 138

global Menu_APEXCreateDestruction = 139

global Menu_RB_CreateDynamic = 150
global Menu_RB_CreateKinematic = 151
global Menu_RB_CreateStatic = 152
global Menu_RB_BakeAll = 153
global Menu_RB_BakeSelected = 154
global Menu_RB_UnbakeAll = 155
global Menu_RB_UnbakeSelected = 156
global Menu_RB_CapInitTrans	 = 157
global Menu_RB_CapInitTrans_Selected = 158

global Menu_Constraint_Rigid = 161
global Menu_Constraint_Slide = 162
global Menu_Constraint_Hinge = 163
global Menu_Constraint_Twist = 164
global Menu_Constraint_Universal = 165
global Menu_Constraint_Ball = 166
global Menu_Constraint_Gear = 167
global Menu_Ragdoll_Dynamic = 171
global Menu_Ragdoll_Kinematic = 172
global Menu_Ragdoll_Remove = 173

global Menu_ShowUI_Toolbar	= 180
global Menu_ShowUI_Tools	= 181
global Menu_Help  = 190
global Menu_About = 200
global Menu_Validate = 210

global Menu_Switch_To_SDK3 = 220
global Menu_Switch_To_SDK2 = 230

global Menu_Forces_Hammer = 231
global Menu_Forces_Bomb = 232

global PxExportPxProj_Prompting

fn PxMenuAction index=
(
	ifsim = nvpx.IsSimulating()
	ifsim = not ifsim
	case index of
	(
	Menu_Run:                PxRunSimulation()
	Menu_Step:               PxStepSimulation()
	Menu_Reset:				 PxStopSimulation()

	Menu_Help:				 nvpx.OpenHelpFile()
	Menu_About:				 nvpx.ShowAboutDialog()
	Menu_ShowUI_Toolbar:	 nvpx.ShowToolbar(true)
	Menu_ShowUI_Tools:		 PxShowPhysicsPanel(1)
	
	Menu_SDKParameter:       PxShowPhysicsPanel(1)
	Menu_Export:             PxExportPxProj_Prompting(false)
	Menu_Validate:			 (nvpx.ShowValidateScene false)
	
	Menu_Switch_To_SDK3:      (PxSwitchSDK 3 false)
	Menu_Switch_To_SDK2:      (PxSwitchSDK 2 false)
	)
	
	case index of
	(	
	Menu_RemovePhysX:        PxCreateAs PX_PHYSTYPE_UNDEFINED
	Menu_CreateCloth:        PxCreateAs PX_PHYSTYPE_CLOTH
	Menu_CreateSoftBody:     PxCreateAs PX_PHYSTYPE_SOFTBODY
	Menu_CreateForcefiled:   PxCreateAs PX_PHYSTYPE_FORCEFIELD
	Menu_CreateD6Constraint: PxCreateConstraint()
	Menu_CreateFluid:        (messagebox nvpxText.TXT_GUISHOWMENU_NO_FLUID )
	Menu_CreateEmitter:      (messagebox nvpxText.TXT_GUISHOWMENU_NO_EMITTER )
	
	-- Rigid bodies	
	Menu_RB_CreateDynamic:		PxCreateAsDynamic()
	Menu_RB_CreateKinematic:	PxCreateAsKinetic()
	Menu_RB_CreateStatic:		PxCreateAsStatic()
	Menu_RB_CapInitTrans:		PxCaptureTransform(false)        --PxForceCreatePhysXScene()
	Menu_RB_CapInitTrans_Selected:   PxCaptureTransform(true)
	Menu_RB_BakeAll:			pxBakeAll false
	Menu_RB_BakeSelected:		pxBakeSelection false
	Menu_RB_UnbakeAll:			pxBakeAll true
	Menu_RB_UnbakeSelected: 	pxBakeSelection true
	
	Menu_Constraint_Rigid: PxCreateConstrintRigid()
	Menu_Constraint_Slide: PxCreateConstrintSlide()
	Menu_Constraint_Hinge: PxCreateConstrintHinge()
	Menu_Constraint_Twist: PxCreateConstrintTwist()
	Menu_Constraint_Universal: PxCreateConstrintUniv()
	Menu_Constraint_Ball: PxCreateConstrintBallSocket()
	Menu_Constraint_Gear: PxCreateConstrintGear()
	
	Menu_Ragdoll_Dynamic: PxCreateDynamicRagdollHelper()
	Menu_Ragdoll_Kinematic: PxCreateKinematicRagdollHelper()
	Menu_Ragdoll_Remove: PxRemoveRagdollHelper()
	
	Menu_APEXCreateClothing:	PxCreateAs PX_PHYSTYPE_CLOTHING
	Menu_APEXCreateSBClothing:	PxCreateAs PX_PHYSTYPE_SBCLOTHING
	Menu_APEXImportTemplate:	PxImportTemplate()
	Menu_APEXExportTemplate:	PxExportTemplate()
	Menu_APEXRebuildSelectedClothing: PxRebuildSelectedClothing()
	--Menu_APEXExportClothing:	(messagebox "Export APEX Clothing will be supported soon" )
	
	Menu_APEXCreateDestruction: PxCreateAs PX_PHYSTYPE_DESTRUCTION
	
	Menu_Forces_Hammer: nvpx.ToggleHammer()
	Menu_Forces_Bomb: nvpx.ToggleBomb()
	
	)
)

global PxFlagOutputMenuMacros = false

fn PxShowMainMenu =
(
	-- if menu is shown, close it first
	PxCloseMenu()

	-- used for generating macros locally
	local macroContents = ""
	
	StrSeparator = "---"
	
	--------------------creating menu
	mainMenuBar = menuMan.getMainMenuBar()
	pxPhysXMenu = menuMan.findMenu nvpxText.TXT_GUISHOWMENU_MENUNAME_PHYSX
	if pxPhysXMenu != undefined then false
	else
	(
		pxPhysXMenu = menuMan.createMenu nvpxText.TXT_GUISHOWMENU_MENUNAME_PHYSX
		------------- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! ---------------------------
		------------- if you changes menu, please do following steps:
		-------------  1. change codes:  global PxFlagOutputMenuMacros = false to global PxFlagOutputMenuMacros = true
		-------------  2. start max and check the output in the script window. It tells where to find the generated mcr
		-------------  3. update the mcr file to p4
		-------------  4. change codes back to:  global PxFlagOutputMenuMacros = false
		------------- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! ---------------------------
		-------------------- creating run-maroscripts and populating menu
		MainItemNames = #(nvpxText.TXT_GUISHOWMENU_HELP, 
						StrSeparator, nvpxText.TXT_GUISHOWMENU_SHOW_UI, nvpxText.TXT_GUISHOWMENU_SIMULATION, 
						StrSeparator, nvpxText.TXT_GUISHOWMENU_RB, nvpxText.TXT_GUISHOWMENU_CONSTRAINTS, nvpxText.TXT_GUISHOWMENU_RAGDOLLS,
						nvpxText.TXT_GUISHOWMENU_CLOTHING, nvpxText.TXT_GUISHOWMENU_DESTRUCTION, nvpxText.TXT_GUISHOWMENU_FORCES, 
						StrSeparator, nvpxText.TXT_GUISHOWMENU_VALIDATE, 
						nvpxText.TXT_GUISHOWMENU_ABOUT)
						
		SubItemNames = #(nvpxText.TXT_GUISHOWMENU_TOOLBAR, nvpxText.TXT_GUISHOWMENU_TOOLS,
						
						nvpxText.TXT_GUISHOWMENU_RUN, nvpxText.TXT_GUISHOWMENU_STEP, nvpxText.TXT_GUISHOWMENU_RESET,
						
						nvpxText.TXT_GUISHOWMENU_DYNAMIC_RB, nvpxText.TXT_GUISHOWMENU_KINEMATIC_RB, nvpxText.TXT_GUISHOWMENU_STATIC_RB, StrSeparator, 
						nvpxText.TXT_GUISHOWMENU_INIT_TRANS, nvpxText.TXT_GUISHOWMENU_SEL_TRANS, StrSeparator, nvpxText.TXT_GUISHOWMENU_BAKE_ALL, nvpxText.TXT_GUISHOWMENU_BAKE_SEL, nvpxText.TXT_GUISHOWMENU_UNBAKE_ALL, nvpxText.TXT_GUISHOWMENU_UNBAKE_SEL,
						
						nvpxText.TXT_GUISHOWMENU_RIGID_CONSTR, nvpxText.TXT_GUISHOWMENU_SLIDE_CONSTR, nvpxText.TXT_GUISHOWMENU_HINGE_CONSTR, nvpxText.TXT_GUISHOWMENU_TWIST_CONSTR, nvpxText.TXT_GUISHOWMENU_UNIV_CONSTR, 
						nvpxText.TXT_GUISHOWMENU_BALL_CONSTR, 
						--omit "Create Gear Constraint",
						
						nvpxText.TXT_GUISHOWMENU_DYNAMIC_RAG, nvpxText.TXT_GUISHOWMENU_KINEMATIC_RAG, nvpxText.TXT_GUISHOWMENU_RM_RAG,
						
						nvpxText.TXT_GUISHOWMENU_NEW_CLOTHING, StrSeparator, 
						nvpxText.TXT_GUISHOWMENU_IMPORT_CLOTH, nvpxText.TXT_GUISHOWMENU_EXPORT_CLOTH, StrSeparator, 
						nvpxText.TXT_GUISHOWMENU_REBUILD_SEL, --, "Export APEX Clothing..."
						
						nvpxText.TXT_GUISHOWMENU_NEW_DESTRUCTION,
						
						nvpxText.TXT_GUISHOWMENU_HAMMER, nvpxText.TXT_GUISHOWMENU_BOMB
						
						)
		
		ActionList	= #(Menu_Help, 
		
						Menu_Separator,
		
						Menu_ShowUI_Toolbar, Menu_ShowUI_Tools,
						
						Menu_Run, Menu_Step, Menu_Reset,
						
						Menu_Separator,
						
						Menu_RB_CreateDynamic, Menu_RB_CreateKinematic, Menu_RB_CreateStatic, Menu_Separator, 
						Menu_RB_CapInitTrans, Menu_RB_CapInitTrans_Selected, Menu_Separator, Menu_RB_BakeAll, Menu_RB_BakeSelected, Menu_RB_UnbakeAll, Menu_RB_UnbakeSelected,
						-- Named Sets is not supported yet, #5042: Update to Named Sets can crash max
						-- Menu_Separator, Menu_RB_NamedSets,
												
						Menu_Constraint_Rigid, Menu_Constraint_Slide, Menu_Constraint_Hinge, Menu_Constraint_Twist, 
						Menu_Constraint_Universal, Menu_Constraint_Ball, 
						--omit Menu_Constraint_Gear,
						
						Menu_Ragdoll_Dynamic, Menu_Ragdoll_Kinematic, Menu_Ragdoll_Remove,
						
						Menu_APEXCreateClothing, Menu_Separator, 
						Menu_APEXImportTemplate, Menu_APEXExportTemplate, Menu_Separator, 
						Menu_APEXRebuildSelectedClothing, -- Menu_APEXExportClothing,
						
						Menu_APEXCreateDestruction,
						
						Menu_Forces_Hammer, Menu_Forces_Bomb,		

						Menu_Separator, 
								
						Menu_Validate, 
						
						Menu_About)
		
		/*
		 *	positive value: item count of sub menu
		 *  0: single item, could be a separator or a menu item
		 *	negtive value:	invalid item, ignored 
		 */
		ItemCountList = #(0, 0, 2, 3, 0, 11, 6, 3, 6, 0, 2, 0, 0, 0)
		
		apex = nvpx.IsApexAvailable()
		-- old code where the index to stop creating menu was wrong
			-- when we remove Cloth from the menu
		if apex == false then ItemCountList[9] = -ItemCountList[9]
		
		id = 0	-- index to ActionList
		j  = 0	-- index to MainItemNames
		k  = 0  -- index to SubItemNames
		for n in ItemCountList do
		(
			j = j + 1
			
			if n < 0 do 
			(
				id = id - n
				continue()
			)
			
			if n > 0 then
			(
				tempMenu = menuMan.createMenu MainItemNames[j]
				tempItem = menuMan.createSubMenuItem "" tempMenu

				for i = 1 to n do
				(
					id = id + 1
					 k =  k + 1
					if SubItemNames[k] != StrSeparator then
					(
						if PxFlagOutputMenuMacros then
						(
							str = "macroscript nvpxMenu" + (id as string) + " category:\"nvpxMenu\" tooltip: \"" + (SubItemNames[k]) + "\" buttontext:\"" +(SubItemNames[k]) + "\" ( on execute do PxMenuAction " + (ActionList[id] as string) +")"
							macroContents += str
							macroContents += "\n\n"
							execute str
						)
				
						actItem = menuMan.createActionItem ("nvpxMenu" + (id as string)) "nvpxMenu"
						tempMenu.addItem actItem -1

						if PxFlagOutputMenuMacros then
						(
							local macroClearFiles = (GetDir #userMacros) + "\\nvpxMenu-nvpxMenu" + (id as string) + ".mcr"
							deletefile macroClearFiles
						)
					)
					else
					(
						actItem = menuMan.createSeparatorItem()
						tempMenu.addItem actItem -1
					)
				)
			)
			else if n == 0 then
			(
				id = id + 1
				if MainItemNames[j] != StrSeparator then
				(
					if PxFlagOutputMenuMacros then
					(
						str = "macroscript nvpxMenu" + (id as string) + " category:\"nvpxMenu\" tooltip: \"" + (MainItemNames[j]) + "\" buttontext:\"" +(MainItemNames[j]) + "\" ( on execute do PxMenuAction " + (ActionList[id] as string) +")"
						macroContents += str
						macroContents += "\n\n"
						execute str
					)

					tempItem = menuMan.createActionItem ("nvpxMenu" + (id as string)) "nvpxMenu"

					if PxFlagOutputMenuMacros then
					(
						local macroClearFiles = (GetDir #userMacros) + "\\nvpxMenu-nvpxMenu" + (id as string) + ".mcr"
						deletefile macroClearFiles
					)
				)
				else
				(
					tempItem = menuMan.createSeparatorItem()
				)
			)
			pxPhysXMenu.addItem tempItem -1
		)
		
		-- used for generating macros locally
		if PxFlagOutputMenuMacros do
		(
			local fileName = GetDir #userScripts
			fileName = fileName + "\\Macro_PhysX_Menus.mcr"
			local macroFile = createFile fileName
			if macroFile != undefined then
			(
				format macroContents to: macroFile
				flush macroFile
				close macroFile
				format "Macros for PhysX Plugin menus is saved to disk file: \n    "
				print fileName
				print "Please copy to \\p4autodesk\\metools\\public\\PhysxPluginsForDCC\\main\\nvidia\\deploy\\3dsMax\\AppDir\\ui\\MacroScripts and check into p4."
			)
			else
			(
				print "Macros for PhysX Plugin menus is not created! Please debug codes to fix it."
			)
		)
		
		-- save the "simulation" menu handle
		id = 1
		for menu_name in MainItemNames do
		(
			if menu_name == nvpxText.TXT_GUISHOWMENU_SIMULATION then exit
			id = id + 1
		)

		simItem = pxPhysXMenu.getItem id
		simMenu = simItem.getSubMenu()
		gPhysXMenuRunSimItem = simMenu.getItem 1
		gPhysXMenuRunSimItem.setUseCustomTitle true
		gPhysXMenuRunSimItem.setTitle nvpxText.TXT_GUISHOWMENU_RUN

		-----------------------add to main menu and then update menu
		PhysXItem = menuMan.createSubMenuItem "" pxPhysXMenu
		ItemPos = mainMenuBar.numItems() - 1
		mainMenuBar.addItem PhysXItem ItemPos
		
		menuMan.updateMenuBar()
		true
	)
)

fn PxOutputMenuMacros = 
(
	PxFlagOutputMenuMacros = true
	PxShowMainMenu()
	PxFlagOutputMenuMacros = false
)

-- clear toolbar configuration files under Max data path
-- it seems it is not possible to make toolbar correct inside max.Hope future breakthrough on this.
fn PxClearOldToolbarConfig = 
(
	t1 = getdir #maxData
	t2 = filterstring t1 "\\"
	datapath = ""; for i = 1 to t2.count do datapath = datapath + t2[i] + "/"
	targetFiles = getFiles (dataPath + "UI/usermacros/NVIDIA*.*")
	for i in targetFiles do deleteFile i
	targetFiles = getFiles (dataPath + "UI/usermacros/nvpx*.*")
	for i in targetFiles do deleteFile i
	targetFiles = getFiles (dataPath + "UI/Max*.*")
	for i in targetFiles do deleteFile i
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCrrVerwReBIGTjbF9ek0a3AsWhycXKJN/s
-- yQAf2Y8U8KSyoVy9Yw85f9PqdVdiDdDSFtiIV2GivZMFYibr4k8Hhx66qGVKijBS
-- oO/Xrg5W7TIjNzaIWiEbaV2DQh+J1N5eJb0kwrSlUQYLGatc4g8iCKY43Nk5h6bO
-- B/vgLBIAkVFRDqUVEkBtNSD0VcJ2YrijtvRKIgb/2OtYv/cntX82bRg2CcMBHjPr
-- PQvNXrLvqHW1AnNS7AZtD1v3WcEd/px8nGpyO5pviPWaq3on+QlUskDaQ7ioZG35
-- /Q31hBFZ4VDEp6hfgY6BkpCpIw+hJHAvxAnDH0/+Wi7ZgrkSquhC
-- -----END-SIGNATURE-----