

fn PxShowAbout =
(
	nvpx.ShowAboutDialog()
)

fn PxCreateAs type = 
(
	-- stop simulation
	PxStopSimulation()
	
	if (type == PX_PHYSTYPE_DESTRUCTION) then
	(
		nvpx.CreateDestruction(PxGetSelectedNodes())
	)
	else
	(
				
		-- check whether there is node selected or not
		currentNode = PxGetCurrentNode()
		if currentNode != undefined then
		(
			if pxCurrentNodeType != type  then
			(
				test = PxGetRootParent currentNode
				
				if (PxGetSelectionCount() > 0) or IsGroupHead(test) or (SuperClassof(test) == GeometryClass) then
				(
					--format "create it as %, pxCurrentNodeType = %\n" type pxCurrentNodeType
					
					local errorInfo
					local target = #()
					case type of
					(
					PX_PHYSTYPE_UNDEFINED:  (target = PxGetSelectedNodes(); )
					PX_PHYSTYPE_DYNAMIC:    (PxDynamicRBNodes(PxGetSelectedNodes()); )
					PX_PHYSTYPE_CLOTH:      (target = PxGetSingleNodes()  ; if PxGetGroupNodesCount() > 0 then errorInfo = nvpxText.guiMenuNoGroupCloth)
					PX_PHYSTYPE_CLOTHING:   (PxAddApexClothingToNodes(PxGetSelectedNodes()); )
					PX_PHYSTYPE_SBCLOTHING: (PxAddApexSBClothingToNodes(PxGetSelectedNodes()); )
					PX_PHYSTYPE_SOFTBODY:   (target = PxGetSingleNodes()  ; if PxGetGroupNodesCount() > 0 then errorInfo = nvpxText.guiMenuNoGroupSB)
					PX_PHYSTYPE_FORCEFIELD: (target = PxGetSingleNodes()  ; if PxGetGroupNodesCount() > 0 then errorInfo = nvpxText.guiMenuNoGroupFF)
					)
					--format "count = %\n" count
					if target.count > 0 then
					(
						pxCurrentNodeType = type
					)
					if errorInfo != undefined then messagebox errorInfo
					if PX_PHYSTYPE_UNDEFINED != type then
					(
						--if target.count == 0 then           messagebox "Does not find qualified nodes."
						if PxGetSelectedHelpersCount() > 0 then messagebox nvpxText.guiMenuNoHelper
					)
				)
			)
		)
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCq0ArO40BHR/J34QoPhKXZO1h/gvT60f+U
-- qWrA05cEjLAvfXr+eTcae9BAFJefJEwCUHhE9MCeOvIEMqxDTqYze4z3ZroRD31K
-- Dgu/Tt8fMUzbT7q4NFLRHVLcQ1V7WLlM+a642/gKfTuRSYttyH2w6xz5j7wRsbCk
-- Bx47kpU6SXE/ojnngg5Y6BYdzXATGvDalXPxkY9mrxRi5V4EOo2Jx9T8LjkewRbm
-- d2YV7SWbGGi6WoV4Gm7NHqAhTQUN5VpPp2hYIXxzlDLX5mIEzBTJRFEer8O482Kq
-- aHaJK37rPW2kNWCbl/Br/y/rpJbY2raVEkF4QSBNXuCdfs4i8CMV
-- -----END-SIGNATURE-----