-- invisible helper - no localization?

-- PhysX GUI for Distance Joint

plugin helper nvSpring
name:"nvSpring"
category:"NVIDIA PhysX"
classID:#(0x294f1fb0, 0xbe0488a)
invisible:true
extends:dummy replaceui:true
(
	parameters jointspec rollout: px_panel_connection
	(
		body0           type:#node      ui:body0_ui
		body1           type:#node      ui:body1_ui

		--aptype			type:#index		default: 1
		--globalAnchor    type:#point3    default:[0, 0, 0]
		--globalAxis      type:#point3    default:[1, 0, 0]
		
		breakable       type:#boolean   ui:breakable_ui   default: false
		maxForce        type:#float     ui:maxForce_ui    default: 100.0
		maxTorque       type:#float     ui:maxTorque_ui   default: 10.0
	)
	
	rollout px_panel_connection "Connection" rolledUp:false  category:1
	(
		label         lbl1_ui       "Parent: "           align:#left across:3
		pickbutton    body0_ui      "undefined"          align:#left toolTip:"Specify Parent" autoDisplay: true
		button		  rembody0_ui	"x"					 align:#right toolTip:"Remove Parent"
		label         lbl2_ui       "Child: "            align:#left across:3
		pickbutton    body1_ui      "undefined"          align:#left toolTip:"Specify Child" autoDisplay: true
		button		  rembody1_ui	"x"					 align:#right toolTip:"Remove Child"
		
		checkbox      breakable_ui  "Breakable"         checked:false
		label         maxForce_lb   "Max Force"         align:#left  across:2 offset:[20, 0]
		spinner       maxForce_ui   ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50 
		label         maxTorque_lb  "Max Torque"        align:#left  across:2 offset:[20, 0]
		spinner       maxTorque_ui  ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50
	    
	    --on breakable_ui  changed value do   (UpdateD6Param "breakable" (breakable as string) )
	    --on maxForce_ui  changed value do   (UpdateD6Param "maxForce"  (maxForce as string) )
	    --on maxTorque_ui changed value do   (UpdateD6Param "maxTorque" (maxTorque as string) )
	    
		on rembody0_ui pressed do
		(
			PxStopSimulation()
			body0_ui.object = undefined;
		)
		
		on body0_ui picked obj do
		(
			PxStopSimulation()
			if (obj != undefined) then
			(
				if (obj == undefined) then
				(
				)
				else if isgroupmember(obj) then
				(
					obj = PxGetRootParent obj
					body0_ui.object = obj
				)
				if obj == body1 then
				(
					messagebox "The two nodes connecting to Constraint should be different."
					body0_ui.object = undefined
				)
				else if (superclassof(obj) == helper) and (not isgrouphead(obj)) then
				(
					format "obj = %, and old = %\n" obj.name body0.name
					messagebox "Helper node can not be set as part of PhysX Constraint."
					body0_ui.object = undefined
				)
				else if PxIsDynamicRB(obj) then
				(
					body0_ui.object = obj
					pxCurrentNode.parent = obj
				)
				else if PxIsKinematicRB(obj) then
				(
					if body1 == undefined then
					(
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
					else if PxIsKinematicRB(body1) then
					(
						format "obj = %, body1 = %\n" obj.name body1.name
						info = "It is not valid that two Kinematic Rigid Bodies connect to a constraint."
						messagebox info
						body0_ui.object = undefined
					)
					else
					(
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
				)
				else if PxIsStaticRB(obj) then
				(
					info = obj.name + " is not a Dyanmic or Kinematic Rigid Body."
					messagebox info
					body0_ui.object = undefined
				)
				else 
				(
					local strStream = StringStream("")
					format nvpxText.TXT_CONSTRAINT_QUERY_APPLYRBMTO1 obj.name to:strStream
					info = nvpxText.TXT_CONSTRAINT_QUERY_MUSTBERB + (strStream as string)
					yes  = queryBox info
					if yes then
					(
						PxMakeDynamicRB obj
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
					else
					(
						body0_ui.object = undefined
					)
				)
			)
		)

		on rembody1_ui pressed do
		(
			PxStopSimulation()
			body1_ui.object = undefined;
		)
		
		on body1_ui picked obj do
		(
			PxStopSimulation()
			
			if (obj != undefined) then
			(
				if (obj == undefined) then
				(
				)
				else if isgroupmember(obj) then
				(
					obj = PxGetRootParent obj
					body1_ui.object = obj
				)
				if obj == body0 then
				(
					messagebox "The two nodes connecting to Constraint should be different."
					body1_ui.object = undefined
				)
				else if (superclassof(obj) == helper) and (not isgrouphead(obj)) then
				(
					format "obj = %, and old = %\n" obj.name body0.name
					messagebox "Helper node can not be set as part of PhysX Constraint."
					body1_ui.object = undefined
				)
				else if PxIsDynamicRB(obj) then
				(
					body1_ui.object = obj
				)
				else if PxIsKinematicRB(obj) then
				(
					if body0 == undefined then
					(
						body1_ui.object = obj
					)
					else if PxIsKinematicRB(body0) then
					(
						info = "It is not valid that two Kinematic Rigid Bodies connect to a constraint."
						messagebox info
						body1_ui.object = undefined
					)
					else
					(
						body1_ui.object = obj
					)
				)
				else if PxIsStaticRB(obj) then
				(
					info = obj.name + " is not a Dyanmic or Kinematic Rigid Body."
					messagebox info
					body1_ui.object = undefined
				)
				else 
				(
					local strStream = StringStream("")
					format nvpxText.TXT_CONSTRAINT_QUERY_APPLYRBMTO1 obj.name to:strStream
					info = nvpxText.TXT_CONSTRAINT_QUERY_MUSTBERB + (strStream as string)
					yes  = queryBox info
					if yes then
					(
						PxMakeDynamicRB obj
						body1_ui.object = obj
					)
					else
					(
						body1_ui.object = undefined
					)
				)
			)
		)
	)

	parameters jointspec rollout: px_panel_spring
	(
		minDistance        type:#float      ui:minDistance_ui            default:0
		maxDistance        type:#float      ui:maxDistance_ui            default:10
		enableSpring       type:#boolean    ui:enableSpring_ui           default: true
		spring             type:#float      ui:spring_ui                 default:1
		damping            type:#float      ui:damping_ui                default:0.3
		targetValue        type:#float      ui:targetValue_ui            default:0
	)
	
	rollout px_panel_spring "Spring" rolledUp:false  category:2
	(
		group "Defaults"
		(
		label     lbl_sp01          "Min Distance"         align:#left  across:2
		spinner   minDistance_ui    ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label     lbl_sp02          "Max Distance"         align:#left  across:2
		spinner   maxDistance_ui    ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		checkbox  enableSpring_ui   "Spring"
		label     lbl_sp03          "Spring"               align:#left  across:2 offset:[10, 0]
		spinner   spring_ui         ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label     lbl_sp04          "Damping"              align:#left  across:2 offset:[10, 0]
		spinner   damping_ui        ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label     lbl_sp05          "Target Value"         align:#left  across:2 offset:[10, 0]
		spinner   targetValue_ui    ""                     align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		)
	)

	tool create
	(
		on mousepoint click do
		case click of
		(
			1: 
			(
				nodeTM.translation = worldpoint;
				delegate.boxsize = [3, 3, 3];
				#stop
			)
		)
	)
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCtJhH3cKKTyCvGjDv9hmJeoZh5T1Wi+D3Q
-- 8drU5T7G9fTY8O/7Qo87MS3V614i8zML1LWDboscbMiBHzHTa6dPBBCKxx0UnhwY
-- UBegI+GD7kfuXb0907bV+aPHoi8Vm1oG2VbhYFRLoNKLi5wOvVX+O2QjTe9S7r16
-- VDyHOhaiQtPlypurY+H43kLEIOnDh2YiP/P44+NCtrlKGbfYIp4IAUvSwStm5vQm
-- RhOvMD0QDsTdL6Y80ck+OBjL6tVJYqvwWSFeTGhOoUtkM6kD99hXWkUPW19DhyOR
-- AXtWJmZL6BsNCm3bHxgniRVkefGYQMvaVKnqxtbyVVzLo1SZqoO7
-- -----END-SIGNATURE-----