-- Legacy PhysX file not localised.
-- PhysX GUI for D6

plugin helper nvConstraint
name:"PhysX Constraint"
category:"NVIDIA PhysX"
classID:#(0x549039fe, 0x4ff74db6)
extends:D6Joint replaceui:true
(
	local body1_oldPos
	local joint_oldPos
	local joint_posStill           -- the position when not simulating
	local mynode = undefined             -- used to track the helper itself
	local springDist
	
	fn setMyNode =
	(
		if mynode == undefined then 
		(
			for i in objects do
			(
				if classof(i) == nvConstraint then
				(
					if i.mynode == undefined then i.mynode = i
				)
			)
			--format " constraint is  = %\n" (PxGetNodeByHandle mynode)
		)
	)
				
	parameters jointspec rollout: px_panel_d6connection
	(
		body0           type:#node      ui:body0_ui
		body1           type:#node      ui:body1_ui

		unused1			type:#index		default: 1
		unused2			type:#point3    default:[0, 0, 0]
		unused3			type:#point3    default:[1, 0, 0]		
		
		breakable       type:#boolean   ui:breakable_ui   default: false
		maxForce        type:#float     ui:maxForce_ui    default: 100.0
		maxTorque       type:#float     ui:maxTorque_ui   default: 10.0
	)
	
	parameters jointspec rollout:px_panel_d6translation
	(
		linearModeX  type:#integer   ui:x_range  default:1
		linearModeY  type:#integer   ui:y_range  default:1
		linearModeZ  type:#integer   ui:z_range  default:1
		
		linearPosition       type:#float     ui:linear_ui_position default: 100
		linearRestitution    type:#float     ui:linear_ui_rest     default: 0
		linearSpring         type:#float     ui:linear_ui_spring   default: 0
		linearDamping        type:#float     ui:linear_ui_damp     default: 0
	)
	
	parameters jointspec rollout:px_panel_d6_swingtwist 
	(
		swing1Mode   type:#integer   ui:swing1_mode   default:1
		
		swing1Angle          type:#float     ui:swing1_ui_angle    default: 45
		swing1Restitution    type:#float     ui:swing1_ui_rest     default: 0.1
		swing1Spring         type:#float     ui:swing1_ui_spring   default: 0
		swing1Damping        type:#float     ui:swing1_ui_damp     default: 0
		
		swing2Mode   type:#integer   ui:swing2_mode   default:1
		
		swing2Angle          type:#float     ui:swing2_ui_angle    default: 45
		swing2Restitution    type:#float     ui:swing2_ui_rest     default: 0.1
		swing2Spring         type:#float     ui:swing2_ui_spring   default: 0
		swing2Damping        type:#float     ui:swing2_ui_damp     default: 0
		
		twistMode   type:#integer   ui:twist_mode   default:1
		
		twistAngleLow           type:#float     ui:twist_angle_low    default: 45
		twistAngleHigh          type:#float     ui:twist_angle_high   default: 45
		twistRestitutionLow     type:#float     ui:twist_rest_low     default: 0
		twistRestitutionHigh    type:#float     ui:twist_rest_high    default: 0
		twistSpringLow          type:#float     ui:twist_spring_low   default: 0
		twistSpringHigh         type:#float     ui:twist_spring_high  default: 0
		twistDampingLow         type:#float     ui:twist_damp_low     default: 0
		twistDampingHigh        type:#float     ui:twist_damp_high    default: 0
	)
	
	parameters jointspec rollout: px_panel_spring
	(
		posSpring        type:#float      ui:posSpring_ui            default:0
		posDamping       type:#float      ui:posDamping_ui           default:0

		swingSpring        type:#float      ui:swingSpring_ui            default:0
		swingDamping       type:#float      ui:swingDamping_ui           default:0

		twistSpring        type:#float      ui:twistSpring_ui            default:0
		twistDamping       type:#float      ui:twistDamping_ui           default:0
	)
	
	parameters jointspec rollout: px_panel_d6advanced
	(
		helpersize  type: #float    ui: helpersize_ui  default: 10
		
		collision   type:#boolean   ui:collision_ui   default: false

		gearing         type:#boolean   ui:gearing_ui     default: false
		gearRatio       type:#float     ui:gearratio_ui   default: 1

		useProjection   type:#boolean   ui:useProj_ui     default:false
		projectionMode  type:#integer   ui:projmode_ui    default:1
		projectionDist  type:#float     ui:projdist_ui    default: 0.1
		projectionAngle type:#float     ui:projangle_ui	  default: 5         -- degree
	)
	
	-- set to default values for those changes with system unit
	fn Init =
	(
		projectionDist = 0.1*PxMeterToSystemUnit
	)

	fn UpdateD6Param paramString valueString =
	(
		nvpx.SetConstraintParam pxCurrentNode paramString valueString
		nvpx.GetConstraintParam pxCurrentNode paramString
	)
	
	rollout px_panel_d6connection "Connection" rolledUp:false  category:1
	(
		label         lbl1_ui       "Parent: "           align:#left across:3 offset:[0, 4] 
		pickbutton    body0_ui      "undefined"          align:#left toolTip:nvpxText.UI_GUID6_D6CONN_TT_PARENT autoDisplay: true
		button		  rembody0_ui	"x"					 align:#right toolTip:nvpxText.UI_GUID6_D6CONN_TT_RM_PARENT
		label         lbl2_ui       "Child: "            align:#left across:3 offset:[0, 4]
		pickbutton    body1_ui      "undefined"          align:#left toolTip:nvpxText.UI_GUID6_D6CONN_TT_CHILD autoDisplay: true
		button		  rembody1_ui	"x"					 align:#right toolTip:nvpxText.UI_GUID6_D6CONN_TT_RM_CHILD
		
		checkbox      breakable_ui  "Breakable"         checked:false
		label         maxForce_lb   "Max Force"         align:#left  across:2 offset:[20, 0]
		spinner       maxForce_ui   ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50 enabled:false
		label         maxTorque_lb  "Max Torque"        align:#left  across:2 offset:[20, 0]
		spinner       maxTorque_ui  ""                  align:#right range:[0.01,PxMaxValue,0.01] type:#float width:50 enabled:false
	    
	    on px_panel_d6connection open do
	    (
			px_panel_d6connection.title = nvpxText.UI_GUID6_D6CONN_TITLE

			lbl1_ui.text = nvpxText.UI_GUID6_D6CONN_LB_PARENT
			body0_ui.text = nvpxText.UI_GUID6_D6CONN_UNDEF
			lbl2_ui.text = nvpxText.UI_GUID6_D6CONN_LB_CHILD
			body1_ui.text = nvpxText.UI_GUID6_D6CONN_UNDEF
			breakable_ui.text = nvpxText.UI_GUID6_D6CONN_CB_BREAK
			maxForce_lb.text = nvpxText.UI_GUID6_D6CONN_LB_MAXF
			maxTorque_lb.text = nvpxText.UI_GUID6_D6CONN_LB_MAXT
	    )
	    
	    on breakable_ui  changed value do   
		(
			UpdateD6Param "breakable" (breakable as string) 
			maxForce_ui.enabled = breakable
			maxTorque_ui.enabled = breakable
		)
	    on maxForce_ui  changed value do   (UpdateD6Param "maxForce"  (maxForce as string) )
	    on maxTorque_ui changed value do   (UpdateD6Param "maxTorque" (maxTorque as string) )
	    
		on rembody0_ui pressed do
		(
			PxStopSimulation()
			body0_ui.object = undefined;
		)
		
		on body0_ui picked obj do
		(
			PxStopSimulation()
			if mynode == undefined then mynode = pxCurrentNode
			if (obj != undefined) then
			(
				if (obj == undefined) then
				(
				)
				else if isgroupmember(obj) then
				(
					obj = pxSelectionTool.GetRootParent obj
					body0_ui.object = obj
				)
				if obj == body1 then
				(
					messagebox nvpxText.TXT_GUID6_MSG_IDENT_NODES
					body0_ui.object = undefined
				)
				else if (superclassof(obj) == helper) and (not isgrouphead(obj)) then
				(
					--format "obj = %, and old = %\n" obj.name body0.name
					messagebox nvpxText.TXT_GUID6_MSG_NO_HELPER
					body0_ui.object = undefined
				)
				else if PxIsDynamicRB(obj) then
				(
					body0_ui.object = obj
					pxCurrentNode.parent = obj
				)
				else if PxIsKinematicRB(obj) then
				(
					if body1 == undefined then
					(
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
					else if PxIsKinematicRB(body1) then
					(
						--format "obj = %, body1 = %\n" obj.name body1.name
						info = nvpxText.TXT_GUID6_MSG_INVALID_TWO_KINE
						messagebox info
						body0_ui.object = undefined
					)
					else
					(
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
				)
				else if PxIsStaticRB(obj) then
				(
					info = obj.name + nvpxText.TXT_GUID6_MSG_NOT_RB
					messagebox info
					body0_ui.object = undefined
				)
				else 
				(
					local strStream = StringStream("")
					format nvpxText.TXT_CONSTRAINT_QUERY_APPLYRBMTO1 obj.name to:strStream
					info = nvpxText.TXT_CONSTRAINT_QUERY_MUSTBERB + (strStream as string)
					yes  = queryBox info
					if yes then
					(
						PxMakeDynamicRB obj
						body0_ui.object = obj
						pxCurrentNode.parent = obj
					)
					else
					(
						body0_ui.object = undefined
					)
				)
			)
		)

		on rembody1_ui pressed do
		(
			PxStopSimulation()
			body1_ui.object = undefined;
		)
		
		on body1_ui picked obj do
		(
			PxStopSimulation()
			if mynode == undefined then mynode = pxCurrentNode
			
			if (obj != undefined) then
			(
				if (obj == undefined) then
				(
				)
				else if isgroupmember(obj) then
				(
					obj = pxSelectionTool.GetRootParent obj
					body1_ui.object = obj
				)
				if obj == body0 then
				(
					messagebox nvpxText.TXT_GUID6_MSG_IDENT_NODES
					body1_ui.object = undefined
				)
				else if (superclassof(obj) == helper) and (not isgrouphead(obj)) then
				(
					--format "obj = %, and old = %\n" obj.name body0.name
					messagebox nvpxText.TXT_GUID6_MSG_NO_HELPER
					body1_ui.object = undefined
				)
				else if PxIsDynamicRB(obj) then
				(
					body1_ui.object = obj
				)
				else if PxIsKinematicRB(obj) then
				(
					if body0 == undefined then
					(
						body1_ui.object = obj
					)
					else if PxIsKinematicRB(body0) then
					(
						info = nvpxText.TXT_GUID6_MSG_INVALID_TWO_KINE
						messagebox info
						body1_ui.object = undefined
					)
					else
					(
						body1_ui.object = obj
					)
				)
				else if PxIsStaticRB(obj) then
				(
					info = obj.name + nvpxText.TXT_GUID6_MSG_NOT_RB
					messagebox info
					body1_ui.object = undefined
				)
				else 
				(
					local strStream = StringStream("")
					format nvpxText.TXT_CONSTRAINT_QUERY_APPLYRBMTO1 obj.name to:strStream
					info = nvpxText.TXT_CONSTRAINT_QUERY_MUSTBERB + (strStream as string)
					yes  = queryBox info
					if yes then
					(
						PxMakeDynamicRB obj
						body1_ui.object = obj
					)
					else
					(
						body1_ui.object = undefined
					)
				)
			)
		)
	)
	
	rollout px_panel_d6translation "Translation Limits" rolledUp:false  category:2
	(
		label         lbl_t0            "Locked   Limited  Free"    align:#right
		label         lbl_t1            "X"                         align:#left  across:2
		radiobuttons  x_range           ""                          labels:#("      ", "      ", "      ")  width:100 columns:3 align:#right
		label         lbl_t2            "Y"                         align:#left  across:2
		radiobuttons  y_range           ""                          labels:#("      ", "      ", "      ")  width:100 columns:3 align:#right
		label         lbl_t3            "Z"                         align:#left  across:2
		radiobuttons  z_range           ""                          labels:#("      ", "      ", "      ")  width:100 columns:3 align:#right

		label         lbl_t4            "Limit Radius"              align:#left  across:2 offset:[0, 1]
		spinner       linear_ui_position  ""             range:[0,PxMaxValue,0] scale:0.05 type:#worldunits align:#right width:60
		label         lbl_t5            "Bounce"                    align:#left  across:2 offset:[0, 1]
		spinner       linear_ui_rest    ""          range:[0, 1, 0] scale:0.05 type:#float  align:#right width:60
		label         lbl_t6            "Spring"                    align:#left  across:2 offset:[0, 1]
		spinner       linear_ui_spring  ""               range:[0,PxMaxValue,0] scale:0.05 type:#float align:#right width:60
		label         lbl_t7            "Damping"                   align:#left  across:2 offset:[0, 1]
		spinner       linear_ui_damp    ""              range:[0,1000,0] scale:0.05 type:#float align:#right width:60
		
		on linear_ui_position changed value do   (UpdateD6Param "linearPosition"    (linearPosition as string) )
		on linear_ui_rest     changed value do   (UpdateD6Param "linearRestitution" (linearRestitution as string) )
		on linear_ui_spring   changed value do   (UpdateD6Param "linearSpring"      (linearSpring as string) )
		on linear_ui_damp     changed value do   (UpdateD6Param "linearDamping"     (linearDamping as string) )
		
		on px_panel_d6translation open do
		(
			px_panel_d6translation.title = nvpxText.UI_GUID6_TRANS_TITLE
			
			lbl_t0.text = nvpxText.UI_GUID6_TRANS_LB_LLF
			lbl_t4.text = nvpxText.UI_GUID6_TRANS_LB_RADIUS
			lbl_t5.text = nvpxText.UI_GUID6_TRANS_LB_BOUNCE
			lbl_t6.text = nvpxText.UI_GUID6_TRANS_LB_SPRING
			lbl_t7.text = nvpxText.UI_GUID6_TRANS_LB_DAMP
		)
		
		fn updateEnableState =
		(
			local state = (x_range.state == 2) or (y_range.state == 2) or (z_range.state == 2)
			lbl_t4.enabled = state
			lbl_t5.enabled = state
			lbl_t6.enabled = state
			lbl_t7.enabled = state
			linear_ui_position.enabled = state
			linear_ui_rest.enabled = state
			linear_ui_spring.enabled = state
			linear_ui_damp.enabled = state
		)

		on x_range changed state do (updateEnableState(); UpdateD6Param "linearModeX" (linearModeX as string) )
		on y_range changed state do (updateEnableState(); UpdateD6Param "linearModeY" (linearModeY as string) )
		on z_range changed state do (updateEnableState(); UpdateD6Param "linearModeZ" (linearModeZ as string) )
		
		on px_panel_d6translation open do
		(
			updateEnableState()
		)
	)

	rollout px_panel_d6_swingtwist "Swing & Twist Limits" category:3
	(
		group nvpxText.UI_GUID6_TWIST_GROUPY
		(
		label         lbl_s10           "Locked      Limited      Free  "    align:#right
		radiobuttons  swing1_mode       ""   labels:#("          ", "        ", "  ") width:130 columns:3 align:#right

		label         lbl_s11           "Angle Limit"                                   align:#left  across:2
		spinner       swing1_ui_angle   ""   range:[0,180,0] scale:0.5 type:#float  align:#right width:60
		label         lbl_s12           "Bounce"                                        align:#left  across:2
		spinner       swing1_ui_rest    ""   range:[0, 1, 0] scale:0.5 type:#float     align:#right width:60
		label         lbl_s13           "Spring"                                        align:#left  across:2
		spinner       swing1_ui_spring  ""   range:[0,PxMaxValue,0] scale:0.05 type:#float  align:#right width:60
		label         lbl_s14           "Damping"                                       align:#left  across:2
		spinner       swing1_ui_damp    ""   range:[0,PxMaxValue,0] scale:0.05 type:#float    align:#right width:60
		)

		group nvpxText.UI_GUID6_TWIST_GROUPZ
		(
		label         lbl_s20           "Locked      Limited      Free  "    align:#right
		radiobuttons  swing2_mode       ""   labels:#("          ", "        ", "  ") width:130 columns:3 align:#right

		label         lbl_s21           "Angle Limit"                                   align:#left  across:2
		spinner       swing2_ui_angle   ""   range:[0,180,0] scale:0.5 type:#float     align:#right width:60
		label         lbl_s22           "Bounce"                                        align:#left  across:2
		spinner       swing2_ui_rest    ""   range:[0, 1, 0] scale:0.5 type:#float     align:#right width:60
		label         lbl_s23           "Spring"                                        align:#left  across:2
		spinner       swing2_ui_spring  ""   range:[0,PxMaxValue,0] scale:0.05 type:#float  align:#right width:60
		label         lbl_s24           "Damping"                                       align:#left  across:2
		spinner       swing2_ui_damp    ""   range:[0,PxMaxValue,0] scale:0.05 type:#float    align:#right width:60
		)
		
		group nvpxText.UI_GUID6_TWIST_GROUPT
		(
		label         lbl_tw0           "Locked      Limited      Free  "    align:#right
		radiobuttons  twist_mode        ""   labels:#("          ", "        ", "  ") width:130 columns:3 align:#right
		
		label         twist_lbl0        "Left          Right     "    align:#right
		label         twist_lbl1        "Limit"                       align:#left  across:3
		spinner       twist_angle_low   ""                            align:#right range:[-180,180,0] scale:0.5 type:#float width:45
		spinner       twist_angle_high  ""                            align:#right range:[-180,180,0] scale:0.5 type:#float width:45 
		label         twist_lbl2        "Bounce"                      align:#left  across:3
		spinner       twist_rest_low    ""                            align:#right range:[0,1,0] scale:0.05 type:#float width:45
		spinner       twist_rest_high   ""                            align:#right range:[0,1,0] scale:0.05 type:#float width:45 
		label         twist_lbl3        "Spring"                      align:#left  across:3
		spinner       twist_spring_low  ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45
		spinner       twist_spring_high ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45
		label         twist_lbl4        "Damping"                     align:#left  across:3
		spinner       twist_damp_low    ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45
		spinner       twist_damp_high   ""                            align:#right range:[0,PxMaxValue,0] scale:0.05 type:#float width:45 
		)
		
		on px_panel_d6_swingtwist open do
		(
			px_panel_d6_swingtwist.title = nvpxText.UI_GUID6_TWIST_TITLE
			
			lbl_s10.text = nvpxText.UI_GUID6_TWIST_LB_LLF
			lbl_s11.text = nvpxText.UI_GUID6_TWIST_LB_ANGLE         
			lbl_s12.text = nvpxText.UI_GUID6_TRANS_LB_BOUNCE
			lbl_s13.text = nvpxText.UI_GUID6_TRANS_LB_SPRING
			lbl_s14.text = nvpxText.UI_GUID6_TRANS_LB_DAMP  
			lbl_s20.text = nvpxText.UI_GUID6_TWIST_LB_LLF   
			lbl_s21.text = nvpxText.UI_GUID6_TWIST_LB_ANGLE 
			lbl_s22.text = nvpxText.UI_GUID6_TRANS_LB_BOUNCE
			lbl_s23.text = nvpxText.UI_GUID6_TRANS_LB_SPRING
			lbl_s24.text = nvpxText.UI_GUID6_TRANS_LB_DAMP  
			lbl_tw0.text = nvpxText.UI_GUID6_TWIST_LB_LLF   
			twist_lbl0.text = nvpxText.UI_GUID6_TWIST_LB_LR 
			twist_lbl1.text = nvpxText.UI_GUID6_TWIST_LB_LIMIT
			twist_lbl2.text = nvpxText.UI_GUID6_TRANS_LB_BOUNCE
			twist_lbl3.text = nvpxText.UI_GUID6_TRANS_LB_SPRING
			twist_lbl4.text = nvpxText.UI_GUID6_TRANS_LB_DAMP
		)
		
		fn updateSwing1EnableState =
		(
			local state = (swing1_mode.state == PX_DOF_LIMITED)
			lbl_s11.enabled = state
			lbl_s12.enabled = state
			lbl_s13.enabled = state
			lbl_s14.enabled = state
			swing1_ui_angle.enabled = state
			swing1_ui_rest.enabled = state
			swing1_ui_spring.enabled = state
			swing1_ui_damp.enabled = state
		)
		
		fn updateSwing2EnableState =
		(
			local state = (swing2_mode.state == PX_DOF_LIMITED)
			lbl_s21.enabled = state
			lbl_s22.enabled = state
			lbl_s23.enabled = state
			lbl_s24.enabled = state
			swing2_ui_angle.enabled = state
			swing2_ui_rest.enabled = state
			swing2_ui_spring.enabled = state
			swing2_ui_damp.enabled = state
			)
		
		fn updateTwistEnableState =
		(
			local state = (twist_mode.state == PX_DOF_LIMITED)
			twist_lbl0.enabled = state
			twist_lbl1.enabled = state
			twist_lbl2.enabled = state
			twist_lbl3.enabled = state
			twist_lbl4.enabled = state
			twist_angle_low.enabled = state
			twist_angle_high.enabled = state
			twist_rest_low.enabled = state
			twist_rest_high.enabled = state
			twist_spring_low.enabled = state
			twist_spring_high.enabled = state
			twist_damp_low.enabled = state
			twist_damp_high.enabled = state
		)

		-- SDK requires the following rule to make a valid D6 joint
		fn KeepValidSwing1Value =
		(
			if swing2Mode == PX_DOF_FREE and swing1Angle > 90 then swing1Angle = 90
		)
		
		-- SDK requires the following rule to make a valid D6 joint
		fn KeepValidSwing2Value =
		(
			if swing1Mode == PX_DOF_FREE and swing2Angle > 90 then swing2Angle = 90
		)

		on swing1_mode changed state do 
		(
			KeepValidSwing2Value();
			updateSwing1EnableState(); 
			
			UpdateD6Param "swing1Mode"    (swing1Mode as string) 
		)
		
		on swing2_mode changed state do 
		(	
			KeepValidSwing1Value();
			updateSwing2EnableState(); 
			
			UpdateD6Param "swing2Mode"    (swing2Mode as string) 
		)
		
		on twist_mode  changed state do (updateTwistEnableState();  UpdateD6Param "twistMode"     (twistMode as string) )
		
		on swing1_ui_angle changed state  do (
			KeepValidSwing1Value()
			UpdateD6Param "swing1Angle"     (swing1Angle as string) 
			
		)
		
		on swing2_ui_angle changed state  do (
			KeepValidSwing2Value()
			UpdateD6Param "swing2Angle"     (swing2Angle as string) 
			
		)
		
		on twist_angle_low changed state  do (
			if(twistAngleLow > twistAngleHigh) then (
				twistAngleHigh = twistAngleLow + 0.01
				UpdateD6Param "twistAngleHigh"  (twistAngleHigh as string)
			)
			UpdateD6Param "twistAngleLow"   (twistAngleLow as string) 
			
		)
		on twist_angle_high changed state do (
			if(twistAngleLow > twistAngleHigh) then (
				twistAngleLow = twistAngleHigh - 0.01
				UpdateD6Param "twistAngleLow"  (twistAngleLow as string)
			)
			UpdateD6Param "twistAngleHigh"  (twistAngleHigh as string) 
			
		)
		
		on swing1_ui_rest    changed state  do (UpdateD6Param "swing1Restitution"     (swing1Restitution as string) )
		on swing1_ui_spring  changed state  do (UpdateD6Param "swing1Spring"          (swing1Spring as string) )
		on swing1_ui_damp    changed state  do (UpdateD6Param "swing1Damping"         (swing1Damping as string) )
		on swing2_ui_rest    changed state  do (UpdateD6Param "swing2Restitution"     (swing2Restitution as string) )
		on swing2_ui_spring  changed state  do (UpdateD6Param "swing2Spring"          (swing2Spring as string) )
		on swing2_ui_damp    changed state  do (UpdateD6Param "swing2Damping"         (swing2Damping as string) )

		on twist_rest_low    changed state  do (
			if twistRestitutionLow > twistRestitutionHigh then (
				twistRestitutionHigh = twistRestitutionLow
				UpdateD6Param "twistRestitutionHigh"  (twistRestitutionHigh as string)
			)
			UpdateD6Param "twistRestitutionLow"   (twistRestitutionLow as string) 
		)
		on twist_rest_high   changed state  do (
			if twistRestitutionLow > twistRestitutionHigh then (
				twistRestitutionLow = twistRestitutionHigh
				UpdateD6Param "twistRestitutionLow"  (twistRestitutionLow as string)
			)
			UpdateD6Param "twistRestitutionHigh"  (twistRestitutionHigh as string) 
		)
		on twist_spring_low  changed state  do (
			if twistSpringLow > twistSpringHigh then (
				twistSpringHigh = twistSpringLow
				UpdateD6Param "twistSpringHigh"       (twistSpringHigh as string)
			)
			UpdateD6Param "twistSpringLow"        (twistSpringLow as string) 
		)
		on twist_spring_high changed state  do (
			if twistSpringLow > twistSpringHigh then (
				twistSpringLow = twistSpringHigh
				UpdateD6Param "twistSpringLow"       (twistSpringLow as string)
			)
			UpdateD6Param "twistSpringHigh"       (twistSpringHigh as string) 
		)
		on twist_damp_low    changed state  do (
			if twistDampingLow > twistDampingHigh then (
				twistDampingHigh = twistDampingLow
				UpdateD6Param "twistDampingHigh"      (twistDampingHigh as string)
			)
			UpdateD6Param "twistDampingLow"       (twistDampingLow as string) 
		)
		on twist_damp_high   changed state  do (
			if twistDampingLow > twistDampingHigh then (
				twistDampingLow = twistDampingHigh
				UpdateD6Param "twistDampingLow"      (twistDampingLow as string)
			)
			UpdateD6Param "twistDampingHigh"      (twistDampingHigh as string) 
		)
		
		on px_panel_d6_swingtwist open do 
		(
			KeepValidSwing1Value()
			KeepValidSwing2Value()
			updateSwing1EnableState()
			updateSwing2EnableState()
			updateTwistEnableState()
			
		)
	)

	rollout px_panel_spring "Spring" rolledUp:false  category:4
	(
		group nvpxText.UI_GUID6_SPRING_GROUPP
		(
		label         lbl_spp01       "Springiness"         align:#left  across:2
		spinner       posSpring_ui    ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label         lbl_spp02       "Damping"            align:#left  across:2
		spinner       posDamping_ui   ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		)
		
		group nvpxText.UI_GUID6_SPRING_GROUPS
		(
		label         lbl_sps01        "Springiness"         align:#left  across:2
		spinner       swingSpring_ui   ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label         lbl_sps02        "Damping"            align:#left  across:2
		spinner       swingDamping_ui  ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		)
		
		group nvpxText.UI_GUID6_SPRING_GROUPT
		(
		label         lbl_spt01        "Springiness"         align:#left  across:2
		spinner       twistSpring_ui   ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		label         lbl_spt02        "Damping"            align:#left  across:2
		spinner       twistDamping_ui  ""                   align:#right range:[0, PxMaxValue,0.01] type:#float width:60 
		)
		
		on px_panel_spring open do
		(
			px_panel_spring.title = nvpxText.UI_GUID6_SPRING_TITLE
		
			lbl_spp01.text = nvpxText.UI_GUID6_SPRING_LB_SPRGNS
			lbl_sps01.text = nvpxText.UI_GUID6_SPRING_LB_SPRGNS
			lbl_spt01.text = nvpxText.UI_GUID6_SPRING_LB_SPRGNS
			
			lbl_spp02.text = nvpxText.UI_GUID6_TRANS_LB_DAMP
			lbl_sps02.text = nvpxText.UI_GUID6_TRANS_LB_DAMP
			lbl_spt02.text = nvpxText.UI_GUID6_TRANS_LB_DAMP
		)
		
		on posSpring_ui    changed val do (UpdateD6Param "posSpring"    (posSpring as string); )
		on posDamping_ui   changed val do (UpdateD6Param "posDamping"   (posDamping as string))
		on swingSpring_ui  changed val do (UpdateD6Param "swingSpring"  (swingSpring as string))
		on swingDamping_ui changed val do (UpdateD6Param "swingDamping" (swingDamping as string))
		on twistSpring_ui  changed val do (UpdateD6Param "twistSpring"  (twistSpring as string))
		on twistDamping_ui changed val do (UpdateD6Param "twistDamping" (twistDamping as string))
	)	
	
	rollout px_panel_d6advanced "Advanced" category:5
	(
		button    moveToParent  "Move to Parent's Pivot" width:120
		button    moveToChild   "Move to Child's Pivot"  width:120
		
		label     lbl_h1		   "Display Size"  align:#left  across:2
		spinner   helpersize_ui       "" range: [0.001,1000,0.001] type:#worldunits align:#right width:60
		
		checkbox  collision_ui     "Parent/Child Collision" checked:false
		checkbox  gearing_ui       "Parent Turns Child"     checked:false
		label     gearratio_lb     "Gear Ratio"             align:#right across:2
		spinner   gearratio_ui     ""                       align:#right type:#float range:[-PxMaxValue, PxMaxValue, 1] width:60

		checkbox      useProj_ui    "Use Projection"    align:#left
		radiobuttons  projmode_ui   ""                  labels:#(nvpxText.UI_GUID6_ADV_RB_LB1, nvpxText.UI_GUID6_ADV_RB_LB2)  width:120 columns:1 align:#right
		label         projdist_lb   "Distance"          align:#right across:2    width:50
		spinner       projdist_ui   ""                  align:#right type:#worldunits width:60
		label         projangle_lb  "Angle"             align:#right across:2    width:50
		spinner       projangle_ui  ""                  align:#right type:#float width:60

		on px_panel_d6advanced open do
		(
			px_panel_d6advanced.title = nvpxText.UI_GUID6_ADV_TITLE

			moveToParent.text = nvpxText.UI_GUID6_ADV_BTN_TOPARENT
			moveToChild.text = nvpxText.UI_GUID6_ADV_BTN_TOCHILD
			lbl_h1.text = nvpxText.UI_GUID6_ADV_LB_DISPSIZE
			collision_ui.text = nvpxText.UI_GUID6_ADV_CB_COLLISION
			gearing_ui.text = nvpxText.UI_GUID6_ADV_CB_GEARING
			gearratio_lb.text = nvpxText.UI_GUID6_ADV_LB_GEARRATIO
			useProj_ui.text =  nvpxText.UI_GUID6_ADV_CB_USEPROJ
			projdist_lb.text = nvpxText.UI_GUID6_ADV_LB_DIST 
			projangle_lb.text = nvpxText.UI_GUID6_ADV_LB_ANGLE
		)
		
		on moveToParent pressed do
		(
			if body0 != undefined then try(pxCurrentNode.transform = body0.transform) catch()
		)
		
		on moveToChild pressed do
		(
			if body1 != undefined then try(pxCurrentNode.pos = body1.pos) catch()
		)
		
		on helpersize_ui changed val do
		(
			--delegate.boxsize = [val*10.2,val*10.2,val*10.2];
		)
		
		fn updateEnableGearState =
		(
			local state = gearing_ui.checked
			gearratio_lb.enabled = state
			gearratio_ui.enabled = state
		)
		
		fn updateEnableProjectionState =
		(
			local state = useProj_ui.checked
			projmode_ui.enabled = state
			projdist_lb.enabled = state
			projdist_ui.enabled = state
			projangle_lb.enabled = state and (projectionMode == 2)
			projangle_ui.enabled = projangle_lb.enabled
		)

		-- SDK requires the following rule to make a valid D6 joint
		fn KeepValidGearing =
		(
			if gearing and twistMode == 1 then 
			(
				twistMode = PX_DOF_LIMITED
				px_panel_d6_swingtwist.updateTwistEnableState()
			)
		)
		
		on gearing_ui   changed value do 
		(
			KeepValidGearing()
			updateEnableGearState();
			UpdateD6Param "gearing"            (gearing as string)
		)
		on useProj_ui   changed value do (updateEnableProjectionState();  UpdateD6Param "useProjection"      (useProjection as string))

		on collision_ui changed value do (UpdateD6Param "collision"             (collision as string))
		on gearratio_ui changed value do (UpdateD6Param "gearRatio"             (gearRatio as string))
		on projmode_ui  changed value do (updateEnableProjectionState();        UpdateD6Param "projectionMode"        (projectionMode as string))
		on projdist_ui  changed value do (UpdateD6Param "projectionDist"        (projectionDist as string))
		on projangle_ui changed value do (UpdateD6Param "projectionAngle"       (projectionAngle as string))
		
		on px_panel_d6advanced open do
		(
			KeepValidGearing()
			updateEnableGearState()
			updateEnableProjectionState()
		)
	)
	
	tool create
	(
		on mousepoint click do
		(
			case click of
			(
				1: 
				(
					nodeTM.translation = worldpoint;
				)

				2:  
				(
					helpersize = abs(gridDist.y);    
					if helpersize>1000 then helpersize = 1000; 
					if helpersize < 0.01 then helpersize = 0.01;
					#stop;
				)
			)
		)
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBu+GggIAhwmeJ+Z9OMvmuOlKL0EDQbodQ9
-- aOXZ4wr/pIrZzCNgGM3HQwtBO1Qh8IeScri95r9uMphV1XCMgXdvKt3+S1x72I4O
-- O8r7LHtwy3zK9p7dPVa3jZGqzzPkcMiwYef2/v6Tf8VupmxM6WrJkXdNHZr6GfxR
-- 01vc7FQmxNw42Zc4rlswlf1WkVnJ1FMe/9VV7mOdK9kZxtwfNm2YUatKT4tXYYWt
-- Ca74PDTgTClhtYoLRASxV7+n3+BabJhQwXpzP9pB7AOXpv4wrj7ed6f8UkPZbvdC
-- YElbOgQmfzy0/L9XbdM0dF8FoXXSSKOPF4+wS6fG7KuZZwvOCECB
-- -----END-SIGNATURE-----