
-- some common method, it does not depend on the other script files

function PxGrabRotations n =
(
	-- we might consider adding more slidertime samples later when our algo is more intelligent
	local quatlist = #()  
	for k in n.rotation.controller.keys do
	(
		slidertime = k.time
		append quatlist n.controller.rotation
	)
	slidertime = animationRange.start
	quatlist
)

function PxGrabPositions n =
(
	-- we might consider adding more slidertime samples later when our algo is more intelligent
	local poslist = #()  
	for k in n.position.controller.keys do
	(
		slidertime = k.time
		append poslist n.controller.position
	)
	slidertime = animationRange.start
	poslist
)

function PxCalcJointLimits n =
(
	quatlist = PxGrabRotations n
	if(quatlist.count <2) then
	(
		if PHYSX_AUTODESK_VER!=undefined then format "MassFX Warning: not enough keys to extract any useful info!\n" else
			format "PhysX Warning: not enough keys to extract any useful info!\n"
		[0,-45,45]; 
	)
	else
	(
		local r = quatlist[2] / quatlist[1]
		axis = r.axis
		cp  = cross r.axis [0,0,1] 
		cpb = cross r.axis [0,1,0] 
		if(length(cpb)>length(cp)) then
		(
			cp = cpb
		)
		nrml = normalize ( cp )
		
		slidertime = animationRange.start;
		--axis = getpoint3prop n "pmljointaxis" 
		--nrml = getpoint3prop n "pmljointnrml"
		--format "axis = %, normal = %\n" axis nrml
		na = nrml
		nloc = nrml * (conjugate(quatlist[1]) as Matrix3) 
		local limithigh=0
		local limitlow=0
		local theta=0;
		local q
		for q in quatlist do
		(
			nb = nloc *(q as Matrix3) 
			dp = dot na nb 
			if(dp> 1.0) then dp =  1.0 ;
			if(dp<-1.0) then dp = -1.0 ;
			delta = acos(dp)
			cp = cross na nb ;
			if((dot axis cp) <0) then
			(
				delta = -delta;
			)
			theta = theta + delta
			if(theta > limithigh) then 
			(
				limithigh = theta
			)
			if(theta < limitlow) then 
			(
				limitlow = theta
			)
			na = nb;
		)
		
		--format "axis = %, normal = %, limitlow = %, limithigh = %\n" axis nrml limitlow limithigh
		slidertime = animationRange.start;
		if(limithigh-limitlow > 315) then
		(
			[0,limitlow,limithigh]
		)
		else [1,limitlow,limithigh]
	)
)

-- Sorted set of items, supports union and intersection operations
struct SortedArray_Struct
(
	itemArray = #(),
	
	fn DefaultComparator a b =
	(
		if a > b then 1
		else if a < b then -1
		else 0
	),
	comparator = DefaultComparator,	
	
	fn FindIndex item findExisting:true =
	(	-- Binary search.  Returns index where item should be inserted, or existing item if findExisting==true
		local len = itemArray.count
		local lo = 1, hi = len, cur = 1, exists = false
		while lo<=hi do
		(
			cur = (lo + ((hi-lo)/2))
			local res = Comparator item itemArray[cur]
			if res==0 then ( exists = true; lo=(hi+1) ) -- force loop to break
			else if res<0 then hi=(cur-1)
		else if res>0 then lo=cur=(cur+1)
		)
		if (findExisting) and (not exists) then 0
		else cur
	),
	fn AddItem item = 
	(
		local index = FindIndex item findExisting:false
		insertItem item itemArray index
	),
	fn SetUnion itemArrayInput =
	(
		if (isKindOf itemArrayInput SortedArray_Struct) then itemArrayInput = itemArrayInput.itemArray
		for item in itemArrayInput do AddItem item
	),
	fn SetIntersection itemArrayInput =
	(
		b = #{} -- BitArray, all values initially false
		if (isKindOf itemArrayInput SortedArray_Struct) then itemArrayInput = itemArrayInput.itemArray
		for item in itemArrayInput do
		(
			local index = FindIndex item findExisting:false
			if (itemArray[index]==item) then b[index] = true
		)
		for index = itemArray.count to 1 by -1 do
		(
			if not b[index] then deleteItem itemArray index
		)
	),

	fn Init itemArrayInput comparator:undefined =
	(
		itemArray = #()
		if (comparator!=undefined) then this.comparator = comparator
		SetUnion itemArrayInput
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA3MGGlFKOiC8DNbyV8exQoYTj2WxB+BPID
-- 8q8P5RfOrhGS6g9y9Wza6YiRfxNuOP8xwHb5OKE2mzGMveIyU3fvg5R1hovixOb4
-- 0juLREkilXQKetxHj5mojPexoi/4XhYHJLoY8+wy2b0rxTyoTdW5pMpE2KUv1tY6
-- datMK3i9KnwZFGKP/vH/Np1Qe5W86Ev/GRmrMdgqlcxfi+cyOi2JH8ZrLXZMjQ30
-- kcNEGtwnNM0N00tVVwqzC0iqXSCEbFvJXXerbl+k4yyUyhC4iSl6HbNnc/BhoKtS
-- 6JTh3uDqeWB0nUGzPnE1GNE+Ixep4fCfLnw+zHvOwCF1Vf2776yE
-- -----END-SIGNATURE-----