-- need it as a global otherwiser garbage collector will delete its reference...
global px_tab_multiedit  -- Forward declaration

-- there is some trouble in multiple-Edit tab with max versions earlier than 2011
global PxAtLeastMax2011 = ((MaxVersion())[1] > PX_MAXVERSION_2010)
global PxTabIndexWorld = 0
global PxTabIndexTool = 1
global PxTabIndexMultiEdit = 2
global PxTabIndexDisplay = 3
global PxGetPhysXPanelTab  -- Forward declaration


-- this call will create the px_panel_debugVisualizer rollout (cf px_visualizer.ms)
debugVisualizerAutoUI()

-- the following generates the rollout for px_panel_debugVisualizerClothing, US6256
fn PxGeneratePhysXClothingDebugVisualizerRollout = 
(
	local DebugSDKName = #("Collision Shapes", "Collision Axes")
	local DebugSDKParam = #("Collision Shapes", "Collision Axes")
	local DebugApexName = #("Cloth Mesh", "Cloth Collisions", "Cloth Self Collisions", "Cloth Attachment", "Cloth Hard Stretch", "Clothing Skinned", "Clothing Backstop Offset", "Clothing Max Dist Out", "Clothing Max Dist In", "Clothing Skin Map", "Clothing Normals", "Clothing Tangents")
	local DebugApexParam = #("Cloth Mesh", "Cloth Collisions", "Cloth Self Collisions", "Cloth Attachment", "Cloth Hard Stretch", "Clothing Skinned Positions", "Clothing Sphere Collision", "Clothing Max Dist Out", "Clothing Max Dist In", "Clothing Skin Map", "Clothing Normals", "Clothing Tangents")
	
	local rolloutStr = "rollout px_panel_debugVisualizerClothing \"PhysX Clothing Visualizer\" rolledUp:true \n"
	rolloutStr +="(\n"

	-- checkboxes
	for i = 1 to DebugSDKName.count do
	(
		rolloutStr += "checkbox cbSDK_" + (i as string) + " \"" + DebugSDKName[i] + "\"" + " align:#left \n"
	)
	for i = 1 to DebugApexName.count do
	(
		rolloutStr += "checkbox cbApex_" + (i as string) + " \"" + DebugApexName[i] + "\"" + " align:#left \n"
	)

	-- on checked events	
	for i = 1 to DebugSDKName.count do
	(
		rolloutStr +=
			"on cbSDK_" + (i as string) + " changed value do
			 (
				nvpx.VisualizerSetPhysXParam (\"" + DebugSDKParam[i] + "\") value
			 )
			"
	)
	for i = 1 to DebugApexName.count do
	(
		rolloutStr +=
			"on cbApex_" + (i as string) + " changed value do
			(
				nvpx.VisualizerSetApexParam (\"" + DebugApexParam[i] + "\") value
			)
			"
	)
	
	-- load values function
	rolloutStr += "fn loadValues = \n"
	rolloutStr += "(\n"
	for i = 1 to DebugSDKName.count do
	(
		rolloutStr += "  cbSDK_" + (i as string) + ".checked = ((nvpx.VisualizerGetPhysXParam (\"" + DebugSDKParam[i] + "\")) == 1) \n"
	)
	for i = 1 to DebugApexName.count do
	(
		rolloutStr += "  cbApex_" + (i as string) + ".checked = ((nvpx.VisualizerGetApexParam (\"" + DebugApexParam[i] + "\")) == 1) \n"
	)
	rolloutStr += ")\n\n"
	
	-- on open event
	rolloutStr +=
		"fn IsVisible =
		 (
			(PHYSX_AUTODESK_VER==undefined) and
				((PxGetPhysXPanelTab()) == PxTabIndexDisplay)
		 )
		 on px_panel_debugVisualizerClothing open do
		 (
			local rolloutName = nvpx.GetPluginCompanyName() + \" Clothing Visualizer\"
			px_panel_debugVisualizerClothing.title = rolloutName
			loadValues()
		 )
		 "
	
	rolloutStr +=")\n"
)

fn debugVisualizerClothingAutoUI = 
(
	local rolloutStr = PxGeneratePhysXClothingDebugVisualizerRollout()
	execute rolloutStr
)

-- NOTE: Rollout always created here, but only added to the panel if PHYSX_AUTODESK_VER==undefined
debugVisualizerClothingAutoUI()

fn PxGenerateApexClothingDebugVisualizerRollout =
(
	-- set up apex name in sdk order
	local DebugApexName = #("Clothing Skinned Positions", "Clothing Backstop", "Clothing Max Dist Out", "Clothing Max Dist In", "Clothing All Skin Map",
										 "Clothing Bad Skin Map", "Clothing Skin Map", "Clothing Physics Wireframe", "Clothing Physics Solid", "Clothing Skeleton", 
										 "Clothing Bone Frames", "Clothing Bone Names",  "Clothing Velocities", "Clothing Graphical Bones", "Clothing Physical Bones", 	
										 "Clothing Backstop Umbrellas", "Clothing Collision Volumes", "Clothing Stretching VPhases", "Clothing Stretching HPhases", 
										 "Clothing Bending Phases", "Clothing Shearing Phases", "Clothing ZeroStretch Phases", "Clothing SemiImplicit Phases", 
										 "Clothing Gaussseidel Phases",	"Clothing Virtual Particles", "Clothing Stiffness Scaling"
										)
	local DebugApexParam = #("Clothing Skinned Positions", "Clothing Backstop", "Clothing Max Dist Out", "Clothing Max Dist In", "Clothing All Skin Map",
										 "Clothing Bad Skin Map", "Clothing Skin Map", "Clothing Physics Wireframe", "Clothing Physics Solid", "Clothing Skeleton", 
										 "Clothing Bone Frames", "Clothing Bone Names",  "Clothing Velocities", "Clothing Graphical Bones", "Clothing Physical Bones", 	
										 "Clothing Backstop Umbrellas", "Clothing Collision Volumes", "Clothing Stretching VPhases", "Clothing Stretching HPhases", 
										 "Clothing Bending Phases", "Clothing Shearing Phases", "Clothing ZeroStretch Phases", "Clothing SemiImplicit Phases", 
										 "Clothing Gaussseidel Phases",	"Clothing Virtual Particles", "Clothing Stiffness Scaling"
										)
										
	local rolloutStr = "rollout px_panel_debugVisualizerApexClothing \"APEX Clothing Visualizer\" rolledUp:true \n"
	rolloutStr +="(\n"
										
	for i = 1 to DebugApexName.count do
	(
		rolloutStr += "checkbox cbApex_" + (i as string) + " \"" + DebugApexName[i] + "\"" + " align:#left \n"
	)
	
	for i = 1 to DebugApexName.count do
	(
		rolloutStr +=
			"on cbApex_" + (i as string) + " changed value do
			 (
				nvpx.VisualizerSetApexParam (\"" + DebugApexParam[i] + "\") value
			 )
			 "
	)
	
	-- load values function
	rolloutStr += "fn loadValues = \n"
	rolloutStr += "(\n"
	
	for i = 1 to DebugApexName.count do
	(
		rolloutStr += "  cbApex_" + (i as string) + ".checked = ((nvpx.VisualizerGetApexParam (\"" + DebugApexParam[i] + "\")) == 1) \n"
	)
	rolloutStr += ")\n\n"
	
		-- on open event
	rolloutStr +=
		"fn IsVisible =
		 (
			(PHYSX_AUTODESK_VER==undefined) and
				((PxGetPhysXPanelTab()) == PxTabIndexDisply)
		 )
		 on px_panel_debugVisualizerApexClothing open do
		 (
			local rolloutName = nvpx.GetPluginCompanyName() + \" Clothing Visualizer\"
			px_panel_debugVisualizerApexClothing.title = rolloutName
			loadValues()
		 )
		 "
	
	rolloutStr +=")\n"
)

fn debugVisualizerApexClothingAutoUI = 
(
	local rolloutStr = PxGenerateApexClothingDebugVisualizerRollout()
	execute rolloutStr
)

-- NOTE: Rollout always created here, but only added to the panel if PHYSX_AUTODESK_VER==undefined
debugVisualizerApexClothingAutoUI()


rollout px_panel_globalParameters "Scene Settings" rolledUp:false
(
	fn gravity_filter_fn obj = (classof obj == gravity)

	groupBox		grp_Environment "Environment" width:170 height:15 across:1 align:#center
	checkbox		cb_useGround	"Use Ground Collisions"	align:#left offset:[-5, 3] checked:true tooltip:nvpxText.UI_PANEL_TT_USEGROUND
	label				lb_groundHeight "Ground Height" offset:[13, 0] align:#left across:2 tooltip:nvpxText.UI_PANEL_TT_GROUNDHEIGHT
	spinner			sp_groundHeight "" align:#right width:65 range:[-PxMaxValue, PxMaxValue, 0.0] type:#worldunits tooltip:nvpxText.UI_PANEL_TT_GROUNDHEIGHT 
	label				lb_globalGravity "Global Gravity" align:#left across:1 offset:[0,4]
	radiobuttons	rb_globalGravityDirectional	align:#left labels:#(nvpxText.physXPanelGravitySettings) 
	label				lb_direction		"Axis"	offset:[18, 0]	   align:#left across:2 tooltip:nvpxText.toolsDlgGravityDirectionTooltip
	radiobuttons	rb_direction		labels:#("X", "Y", "Z") offset:[-5, 0] columns:3
	label				lb_gravity  		"Acceleration"     align:#right offset:[2, 0] across:2  tooltip:nvpxText.toolsDlgGravityAccelerationTooltip
	spinner			sp_amount			""		       align:#right width:65 range:[-PxMaxValue, PxMaxValue, -9.81*PxMeterToSystemUnit] scale:0.01 type:#worldunits tooltip:nvpxText.UI_PANEL_TT_ACC
	radiobuttons	rb_globalGravityForce	labels:#(nvpxText.physXPanelGravityForce) align:#left 
	pickButton	pb_pickGravity		"Pick Gravity"	align:#center width:100 offset:[0, 0] filter:gravity_filter_fn autodisplay:true message:nvpxText.physXPanelGravityForceMsg tooltip:nvpxText.physXPanelGravityForceMsg 
	radiobuttons	rb_globalGravityNone	align:#left labels:#(nvpxText.physXPanelGravityNone)  
	
	groupBox		grp_rigidBodies "Rigid Bodies" width:170 height:15 across:1 align:#center offset:[0,5]
	-- for subSteps, since tick is the smallest time unit in Max, there is no way to make a sub step to be smaller than a tick.
	-- then subSteps is 0 to (ticksPerFrame - 1).
	label				lb_substeps		"Acceleration" align:#left offset:[2, 3] across:2
	spinner			sp_substeps		"" align:#right offset:[0, 3] width:65 type:#integer range:[0, ticksPerFrame-1, 1] tooltip:nvpxText.UI_PANEL_TT_SUBSTEP
	label				lb_solverIteration	"SolverIter" align:#left offset:[2, 0] across:2
	spinner			sp_solveriteration	"" align:#right width:65 type:#integer range:[1, 255, 1] tooltip:nvpxText.UI_PANEL_TT_SI
	checkbox		cb_enableCCD		"Use High Velocity Collisions" align:#left offset:[0,4] checked:false tooltip:nvpxText.UI_PANEL_TT_ENABLECCD
	checkbox		cb_adaptiveforce	"Use Adaptive Force" align:#left checked:true tooltip:nvpxText.UI_PANEL_TT_USEADAPTIVEFORCE
	checkbox		cb_generateShapePerElem "Generate Shape Per Element" align:#left checked:false
	
	fn updateGravityValue = 
	(
		px_sdk_gravityx = 0
		px_sdk_gravityy = 0
		px_sdk_gravityz = 0
		if nvpx.gravityMode == #directional then
		(
			case rb_direction.state of
			(
				1:	px_sdk_gravityx = sp_amount.value
				2:	px_sdk_gravityy = sp_amount.value
				3:	px_sdk_gravityz = sp_amount.value
			)
		)
		else if (nvpx.gravityMode == #object) and (nvpx.gravityObject != undefined) then
		(
			local gravityDir = nvpx.gravityObject.strength*nvpx.gravityObject.transform.row3
			px_sdk_gravityx = gravityDir.x
			px_sdk_gravityy = gravityDir.y
			px_sdk_gravityz = gravityDir.z
		)
	)
	
	fn loadValues = 
	(
		cb_useGround.checked = physXpaneldata.useGroundPlane
		cb_adaptiveforce.checked = physXpaneldata.useAdaptiveForce
		sp_groundHeight.value = physXpaneldata.groundHeight
		rb_direction.state = physXpaneldata.gravityDirection
		sp_amount.value = physXpaneldata.gravity
		
		if (nvpx.gravityMode == #none) then (
			rb_globalGravityNone.state = 1
			rb_globalGravityDirectional.state = 0
			rb_globalGravityForce.state = 0
		)
		else if (nvpx.gravityMode == #directional) then (
			rb_globalGravityNone.state = 0
			rb_globalGravityDirectional.state = 1
			rb_globalGravityForce.state = 0
		)
		else if (nvpx.gravityMode == #object) then (
			rb_globalGravityNone.state = 0
			rb_globalGravityDirectional.state = 0
			rb_globalGravityForce.state = 1
		)
		rb_direction.enabled = (nvpx.gravityMode == #directional)
		sp_amount.enabled = (nvpx.gravityMode == #directional)
		pb_pickGravity.enabled = (nvpx.gravityMode == #object)
		if (nvpx.gravityObject != undefined) then 
			pb_pickGravity.text = nvpx.gravityObject.name
		else
			pb_pickGravity.text = nvpxText.physXPanelPickGravity
		updateGravityValue()
		
		sp_solveriteration.value = physXpaneldata.solverIteration
		sp_subSteps.value = physXpaneldata.subSteps
		cb_enableCCD.checked = physXpaneldata.enableCCD
		cb_generateShapePerElem.checked = physXpaneldata.shapePerElement
	)
	
	fn saveValues = 
	(
		updateGravityValue()
		PxSaveGlobalParams()
		PxUpdateGravity()
	)

	fn useGroundChanged =
	(
		gPxUseGround = physXpaneldata.useGroundPlane
		gPxGroundHeight = physXpaneldata.GroundHeight
		--PxStopSimulation()
		PxSaveGlobalParams()
		PxUpdateGroundPlane()
	)
	
	fn useAdaptiveForceChanged = 
	(
		nvpx.useAdaptiveForce = physXpaneldata.useAdaptiveForce
	)
	
	on cb_useGround changed value do
	(
		undo "PhysX Tools useGroundPlane edit" on
		(
			PxSetProperty physXpaneldata #useGroundPlane value
		)
		
		useGroundChanged()
	)
	
	on cb_adaptiveforce changed value do
	(
		undo "PhysX Tools useAdaptiveForce edit" on
		(
			PxSetProperty physXpaneldata #useAdaptiveForce value
		)
		
		useAdaptiveForceChanged()
	)
	
	on sp_GroundHeight changed value do
	(
		undo "PhysX Tools ground height edit" on
		(
			PxSetProperty physXpaneldata #groundHeight value
		) 
		
		useGroundChanged()
	)
	
	fn enableGravityChanged =
	(
		px_sdk_enable_gravity = physXpaneldata.enableGravity
		PxUpdateGravity()
	)
	
	on rb_globalGravityNone changed value do
	(
		undo label:nvpxText.physXPanelUndoGravity on
		(
			if (rb_globalGravityNone.state == 1) then (
				PxSetProperty nvpx #gravityMode #none
				PxSetProperty physXpaneldata #enableGravity false
				rb_globalGravityDirectional.state = 0
				rb_globalGravityForce.state = 0
				updateGravityValue()
				enableGravityChanged()
			)
		)
	)

	on rb_globalGravityDirectional changed value do
	(
		undo label:nvpxText.physXPanelUndoGravity on
		(
			if (rb_globalGravityDirectional.state == 1) then (
				PxSetProperty nvpx #gravityMode #directional
				PxSetProperty physXpaneldata #enableGravity true
				rb_globalGravityForce.state = 0
				rb_globalGravityNone.state = 0
				updateGravityValue()
				enableGravityChanged()
			)
		)
	)

	on rb_globalGravityForce changed value do
	(
		undo label:nvpxText.physXPanelUndoGravity on
		(
			if (rb_globalGravityForce.state == 1) then (
				PxSetProperty nvpx #gravityMode #object
				PxSetProperty physXpaneldata #enableGravity true
				rb_globalGravityDirectional.state = 0
				rb_globalGravityNone.state = 0
				updateGravityValue()
				enableGravityChanged()
			)
		)
	)
		
	on pb_pickGravity picked obj do
	(
		undo label:nvpxText.physXPanelUndoGravity on
		(
			PxSetProperty nvpx #gravityObject obj
			if (rb_globalGravityNone.state == 2) then (
				updateGravityValue()
				enableGravityChanged()
			)
		)
	)
	
	on rb_direction changed state do
	(
		undo "PhysX Tools gravity edit" on
		(
			PxSetProperty physXpaneldata #gravityDirection state
			px_sdk_gravityDirection = state
		)
		
		saveValues()
	)
	
	on sp_amount changed val do
	(	
		undo "PhysX Tools gravity edit" on
		(
			PxSetProperty physXpaneldata #gravity val
		)

		saveValues()
	)
	
	fn enableCCDChanged = 
	(
		px_sdk_continuous_cd = physXpaneldata.enableCCD
		PxUpdatePhysXParameters()
		PxSaveGlobalParams()
		
		-- dis/enable current object's checkbox
		if selection.count > 0 do
		(
			nvpx.UpdateCCDCtrlState(selection[1])
		)
	)
	
	on cb_enableCCD changed val do
	(
		undo "PhysX Tools Use High Vel Collisions" on
		(
			PxSetProperty physXpaneldata #enableCCD val
		)
		enableCCDChanged()
	)
	
	fn shapePerElementChanged = 
	(
		gPxGenerateShapePerElement = physXpaneldata.shapePerElement
		PxUpdatePhysXParameters()
		PxSaveGlobalParams()
		nvpx.SetShapePerElement gPxGenerateShapePerElement
	)
	
	on cb_generateShapePerElem changed val do
	(
		undo "PhysX Tools enable shape per element" on
		(
			PxSetProperty physXpaneldata #shapePerElement val
		)
		shapePerElementChanged()
	)
	
	fn solverIterationChanged =
	(
		px_rb_solveritertions = physXpaneldata.solverIteration
		px_rb_solveritertions = nvpx.setSolverIterations(px_rb_solveritertions)
		PxSaveGlobalParams()
	)
	
	on sp_solveriteration changed val do
	(
		undo "PhysX Tools solverIteration edit" on
		(
			PxSetProperty physXpaneldata #solverIteration val
		)
		
		solverIterationChanged()
	)
	
	fn subStepsChanged = 
	(
		px_sdk_sub_sim_steps = nvpx.SetSimulationSubSteps physXpaneldata.subSteps
		PxSaveGlobalParams()		
	)
	
	on sp_subSteps changed val do
	(
		undo "PhysX Tools subSteps edit" on
		(
			PxSetProperty physXpaneldata #subSteps val
		)
		
		subStepsChanged()
	)

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexWorld
	)
	
	on px_panel_globalParameters open do
	(
		loadValues()
		
		-- set strings to controls
		px_panel_globalParameters.title = nvpxText.UI_PANEL_SETTINGS_TITLE
		
		grp_environment.text = nvpxText.UI_PANEL_LB_ENVIRONMENT
		cb_useGround.text = nvpxText.UI_PANEL_BT_USEGROUND
		lb_groundHeight.text = nvpxText.UI_PANEL_LB_GROUND_HEIGHT
		lb_globalGravity.text = nvpxText.toolsDlgGlobalGravity
		lb_direction.text = nvpxText.toolsDlgGravityDirection
		lb_gravity.text = nvpxText.toolsDlgGravityAcceleration
		pb_pickGravity.text = nvpxText.physXPanelPickGravity
		--rb_globalGravityNone.labels = nvpxText.toolsDlgGravityNone
		
		grp_rigidBodies.text = nvpxText.UI_PANEL_RB_TITLE
		lb_substeps.text = nvpxText.UI_PANEL_LB_SUBSTEP
		lb_solveriteration.text = nvpxText.UI_PANEL_LB_SI
		cb_enableCCD.text = nvpxText.UI_PANEL_CB_ENABLECCD1
		cb_adaptiveforce.text = nvpxText.UI_PANEL_BT_USEADAPTIVEFORCE
		cb_generateShapePerElem.text = nvpxText.UI_PANEL_BT_GENERATESHAPEPERELEM
	
		grp_environment.height = 20 + (rb_globalGravityNone.pos.y - grp_environment.pos.y)
		grp_rigidBodies.height = 20 + (cb_generateShapePerElem.pos.y - grp_rigidBodies.pos.y)
		px_panel_globalParameters.height += 8
	)
	
	on px_panel_globalParameters close do
	(
		saveValues()
	)

	on px_panel_globalParameters help do (HelpSystem.ShowProductHelp 15010) --id_massfx_tools_world
)

rollout px_panel_advancedSettings "Advanced Settings" rolledUp: true
(
	group "Sleep Settings"
	(
		-- we have to use some tricky to align these controls and labels
		radiobuttons	rb_sleepThresholds	labels:#(nvpxText.UI_PANEL_RB_AUTO, nvpxText.UI_PANEL_RB_MANUAL) align:#left columns:2 tooltips:#(nvpxText.UI_PANEL_TT_AUTOSPEED, nvpxText.UI_PANEL_TT_MANUALSPEED)
		label			lb_sleep_energy			"Sleep Energy"		align:#left across:2
		spinner        sp_sleep_energy	align:#right type:#worldunits  width:65 range:[0, PxMaxValue, 5] tooltip:nvpxText.UI_PANEL_TT_SLEEP_ENERGY
	)
	
	group "High Velocity Collisions"
	(
		-- we have to use some tricky to align these controls and labels
		radiobuttons rb_CCDMinSpeed labels:#(nvpxText.UI_PANEL_RB_AUTO, nvpxText.UI_PANEL_RB_MANUAL) align:#left columns:2 tooltips:#(nvpxText.UI_PANEL_TT_AUTOCCD, nvpxText.UI_PANEL_TT_MANUALCCD)
		label			lb_CCDThreshold	"Min Speed"		align:#left across:2
		spinner		sp_CCDThreshold	align:#right type:#worldunits  width:65 range:[-PxMaxValue, pxMaxValue, 5] tooltip:nvpxText.UI_PANEL_TT_ENTER_MINCCD
	)
	
	group "Bounce Settings"
	(
		-- we have to use some tricky to align these controls and labels
		radiobuttons rb_BounceMinSpeed labels:#(nvpxText.UI_PANEL_RB_AUTO, nvpxText.UI_PANEL_RB_MANUAL) align:#left columns:2 tooltips:#(nvpxText.UI_PANEL_TT_AUTOBOUNCE, nvpxText.UI_PANEL_TT_MANUALBOUNCE)
		label			lb_BounceMinSpeedThreshold	"Min Speed"		align:#left across:2
		spinner		sp_BounceMinSpeedThreshold	align:#right type:#worldunits  width:65 range:[0, pxMaxValue, 5] tooltip:nvpxText.UI_PANEL_TT_ENTER_MINB
	)
	
	GroupBox grp_contactShell "Contact Shell" width:170 height:15 across:1 align:#center
	label lbl_contact_distance "Contact Distance" align:#left across:2
	spinner spn_contact_distance "" align:#right width:65 type:#worldunits range:[-1000,1000,1]
	label lbl_contact_restDepth "Rest Depth" align:#left across:2
	spinner spn_contact_restDepth "" align:#right width:65 type:#worldunits range:[0,1000,1]
	
	fn contactShellRestDepthChanged =
	(
		px_sdk_skinwidth = physXpaneldata.skinWidth
		PxUpdatePhysXParameters()
		PxSaveGlobalParams()
	)
	
	fn contactShellDistanceChanged =
	(
		px_sdk_contactDistance = physXpaneldata.contactShellContactDistance
		spn_contact_restDepth.value = physXpaneldata.skinWidth -- the value is changed in c++
		PxUpdatePhysXParameters()
	)
	
	fn contactShellLegacyChanged =
	(
		--PxUpdatePhysXParameters()
	)

	on spn_contact_distance changed val do
	(
		undo "PhysX Tools contact shell contactDistance" on
		(
			physXpaneldata.contactShellContactDistance =  val
		)
		
		contactShellDistanceChanged()
	)
	
	on spn_contact_restDepth changed val do
	(
		undo "PhysX Tools contact shell restDepth" on
		(
			physXpaneldata.skinWidth =  val
		)
		
		contactShellRestDepthChanged()
	)

	fn loadValues = 
	( 
		-- US7668 - Expose skin width for Rigid Body
		-- local usingSDK2 = (nvpx.GetPhysXSDKVersionMajor() == 2)
		spn_contact_distance.value = physXpaneldata.contactShellContactDistance
		spn_contact_restDepth.value = physXpaneldata.skinWidth

		rb_sleepThresholds.state = physXpaneldata.sleepThresholdsAutomatic
		sp_sleep_energy.value = physXpaneldata.sleepEnergy
		
		rb_CCDMinSpeed.state = physXpaneldata.ccdMinSpeedAutomatic
		sp_CCDThreshold.value = physXpaneldata.ccdMinSpeedThreshold
		
		rb_BounceMinSpeed.state = physXpaneldata.bounceMinSpeedAutomatic
		sp_BounceMinSpeedThreshold.value = physXpaneldata.bounceMinSpeedThreshold
		
		-- update UI state
		if rb_sleepThresholds.state == 1 then
		(
			sp_sleep_energy.enabled = false
		)
		else
		(
			sp_sleep_energy.enabled = true
		)
		
		if rb_CCDMinSpeed.state == 1 then
		(
			sp_CCDThreshold.enabled = false
		)
		else
		(
			sp_CCDThreshold.enabled = true
		)
		
		if rb_BounceMinSpeed.state== 1 then
		(
			sp_BounceMinSpeedThreshold.enabled	= false
		)
		else
		(
			sp_BounceMinSpeedThreshold.enabled	= true
		)
	)
	
	fn saveValues =
	(
		PxSaveGlobalParams()
	)
	
	fn sleepThresholdAutomaticChanged = 
	(
		undo off
		(
			gPxSleepThresholdsAutomatic = physXpaneldata.sleepThresholdsAutomatic
			-- heuristic algorithm from Maya
			if gPxSleepThresholdsAutomatic == 1 then
			(
				
				sp_sleep_energy.value = 0.05 * PxMeterToSystemUnit
				
				physXpaneldata.sleepEnergy = sp_sleep_energy.value
				px_sdk_sleep_energy = physXpaneldata.sleepEnergy
				
				sp_sleep_energy.enabled = false
			)
			else
			(
				sp_sleep_energy.enabled = true
			)
			PxUpdatePhysXParameters()
			PxSaveGlobalParams()
		)
	)
	
	on rb_sleepThresholds changed val do
	(
		undo "PhysX Tools sleepThresholdsAutomatic" on
		(
			PxSetProperty physXpaneldata #sleepThresholdsAutomatic val
		)
		sleepThresholdAutomaticChanged()
	)
	
	fn CCDMinSpeedAutomaticChanged =
	(
		undo off
		(
			gPxCCDMinSpeedAutomatic = physXpaneldata.ccdMinSpeedAutomatic
			-- heuristic alogrithm suggested by Lou Rohan & Mike Skolones
			if gPxCCDMinSpeedAutomatic == 1 then
			(
				sp_CCDThreshold.value = 0.05 * PxMeterToSystemUnit -- 5.0f / frameRate
				physXpaneldata.ccdMinSpeedThreshold = sp_CCDThreshold.value
				px_sdk_ccd_motion_threshold = physXpaneldata.ccdMinSpeedThreshold
				sp_CCDThreshold.enabled = false
			)
			else
			(
				sp_CCDThreshold.enabled = true
			)
			PxUpdatePhysXParameters()
			PxSaveGlobalParams()
			PxSetCCDMotionThreshold(px_sdk_ccd_motion_threshold)
		)
	)
	
	on rb_CCDMinSpeed changed val do
	(
		undo "PhysX Tools CCDMinSpeedAutomatic" on
		(
			PxSetProperty physXpaneldata #ccdMinSpeedAutomatic val
		)
		CCDMinSpeedAutomaticChanged()
	)
	
	fn CCDThresholdChanged = 
	(
		px_sdk_ccd_motion_threshold = physXpaneldata.ccdMinSpeedThreshold
		--PxUpdatePhysXParameters()
		PxSaveGlobalParams()
		PxSetCCDMotionThreshold(px_sdk_ccd_motion_threshold)
	)
	
	on sp_CCDThreshold changed val do
	(
		undo "PhysX Tools High Vel Collisions Min Speed edit" on
		(
			PxSetProperty physXpaneldata #ccdMinSpeedThreshold val
		)
		
		CCDThresholdChanged()	
	)

	fn BounceMinSpeedAutomaticChanged =
	(
		undo off
		(
			gPxBounceMinSpeedAutomatic = physXpaneldata.bounceMinSpeedAutomatic
			-- heuristic alogrithm for Maya
			if gPxBounceMinSpeedAutomatic == 1 then
			(
				sp_BounceMinSpeedThreshold.value = 0.05 * PxMeterToSystemUnit
				physXpaneldata.bounceMinSpeedThreshold = sp_BounceMinSpeedThreshold.value
				px_sdk_bouncethresh = -physXpaneldata.bounceMinSpeedThreshold
				
				sp_BounceMinSpeedThreshold.enabled = false
			)
			else
			(
				sp_BounceMinSpeedThreshold.enabled = true
			)
			PxUpdatePhysXParameters()
			PxSaveGlobalParams()
		)
	)
	
	on rb_BounceMinSpeed changed val do
	(
		undo "PhysX Tools BounceMinSpeedAutomatic" on
		(
			PxSetProperty physXpaneldata #bounceMinSpeedAutomatic val
		)
		
		BounceMinSpeedAutomaticChanged()
	)
	
	fn BounceMinSpeedThresholdChanged =
	(
		px_sdk_bouncethresh = -physXpaneldata.bounceMinSpeedThreshold
		PxUpdatePhysXParameters()
		PxSaveGlobalParams()
	)
	
	on sp_BounceMinSpeedThreshold changed val do
	(
		undo "PhysX Tools BounceMinSpeedThreshold edit" on
		(
			PxSetProperty physXpaneldata #bounceMinSpeedThreshold val
		)
		
		BounceMinSpeedThresholdChanged()
	)
	
	fn sleepEnergyChanged =
	(
		px_sdk_sleep_energy = physXpaneldata.sleepEnergy
		PxUpdatePhysXParameters()
		PxSaveGlobalParams()
	)
	
	on sp_sleep_energy changed val do
	(
		undo "PhysX Tools sleep energy edit" on
		(
			PxSetProperty physXpaneldata #sleepEnergy val
		)
		
		sleepEnergyChanged()
	)

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexWorld
	)
	
	on px_panel_advancedSettings open do 
	(
		loadValues()
		
		-- set strings to controls
		px_panel_advancedSettings.title = nvpxText.UI_PANEL_ADV_TITLE
		px_panel_advancedSettings.controls[1].text = nvpxText.UI_PANEL_GROUP_SLEEPSET
		px_panel_advancedSettings.controls[6].text = nvpxText.UI_PANEL_GROUP_CCD
		px_panel_advancedSettings.controls[11].text = nvpxText.UI_PANEL_GROUP_BOUNCE
		lb_sleep_energy.text = nvpxText.UI_PANEL_LB_SLEEP_ENERGY
		lb_CCDThreshold.text = nvpxText.UI_PANEL_LB_MINSPEED
		lb_BounceMinSpeedThreshold.text = nvpxText.UI_PANEL_LB_MINSPEED
		grp_contactshell.text = nvpxText.panelMultiAdvancedContactShell
		lbl_contact_distance.text = nvpxText.panelMultiAdvancedContactShellContactDistance
		lbl_contact_restDepth.text = nvpxText.panelMultiAdvancedContactShellRestDepth
		
		grp_contactShell.height = 20 + (spn_contact_restDepth.pos.y - grp_contactShell.pos.y)
		
		px_panel_advancedSettings.height += 8
	)
	
	on px_panel_advancedSettings close do
	(
		saveValues()
	)

	on px_panel_advancedSettings help do (HelpSystem.ShowProductHelp 15010) --id_massfx_tools_world
)

rollout px_panel_simulation "Simulation Settings" rolledUp:true
(
	group "Playback"
	(
		label lb_on_last_frame "On Last Frame" align:#left
		radiobuttons rb_simOnLast labels:#(nvpxText.UI_PANEL_RB_CONTINUE, nvpxText.UI_PANEL_RB_STOP, nvpxText.UI_PANEL_RB_LOOP) offset:[5,0] columns:1 tooltips:#(nvpxText.UI_PANEL_TT_CONTINUE, nvpxText.UI_PANEL_TT_STOP, nvpxText.UI_PANEL_TT_LOOP)
		radiobuttons rb_loopAnim  labels:#(nvpxText.UI_PANEL_RB_LOOPRESET, nvpxText.UI_PANEL_RB_CONTINUE) columns:1 offset:[10, 0] enabled:false tooltips:#(nvpxText.UI_PANEL_TT_LOOPRESET, nvpxText.UI_PANEL_TT_CONTINUE)
	)
		
	fn loadValues =
	(
		--cb_useFirst.state = physXpaneldata.useFirst
	
		rb_simOnLast.state = physXpaneldata.onLastFrame
		rb_loopAnim.state  = physXpaneldata.loopAnimation
		
		if physXpaneldata.onLastFrame == PX_LASTFRAME_LOOP then
		(
			rb_loopAnim.enabled = true
		)
		else
		(
			rb_loopAnim.enabled = false
		)
	)
	
	fn useFirstChanged =
	(
		--gPxUseFirstFrame = physXpaneldata.useFirst
		gPxUseFirstFrame = true
	)
	
	fn onLastChanged =
	(
		gPxOnLastFrame = physXpaneldata.onLastFrame
		
		if gPxOnLastFrame == PX_LASTFRAME_LOOP then
		(
			rb_loopAnim.enabled = true
		)
		else
		(
			rb_loopAnim.enabled = false
		)
	)
	
	on rb_simOnLast changed value do
	(
		undo "PhysX Tools onLastFrame edit" on
		(
			PxSetProperty physXpaneldata #onLastFrame value
		)
		
		onLastChanged()
		
		-- interact with previewer
		if (PHYSX_AUTODESK_VER == undefined) do
		(
			global gViewerClock
			if (gViewerClock.Enabled == true) then
				nvpx.UpdateViewerPlayback()
		)
	)
	
	fn loopAnimChanged =
	(
		gPxLoopAnimation = 	physXpaneldata.loopAnimation
	)
	
	on rb_loopAnim changed value do
	(
		undo "PhysX Tools loopAnimation edit" on
		(
			PxSetProperty physXpaneldata #loopAnimation value
		)
		
		loopAnimChanged()
		
		-- interact with previewer
		if (PHYSX_AUTODESK_VER == undefined) do
		(
			global gViewerClock
			if (gViewerClock.Enabled == true) then
				nvpx.UpdateViewerPlayback()
		)
	)
	
	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexTool
	)

	on px_panel_simulation open do 
	(
		loadValues()
		
		-- set strings to controls
		px_panel_simulation.title = nvpxText.UI_PANEL_SIM_TITLE
		px_panel_simulation.controls[1].text = nvpxText.UI_PANEL_GROUP_PLAYBACK
		lb_on_last_frame.text = nvpxText.UI_PANEL_LB_ONLAST
	)
	
	--on px_panel_simulation close do saveValues()
	
	--on bt_useCurrent pressed do PxForceCreatePhysXScene()

	on px_panel_simulation help do (HelpSystem.ShowProductHelp 15010) --id_massfx_tools_world
)

-- use string to generate px_panel_engine because we want to hide some controls
global PxStringRolloutPanelEngine = "
rollout px_panel_engine \"Engine\" rolledUp:true
(
	group \"Options\"
	(
"

if PxSDK3Loaded do 
(
	PxStringRolloutPanelEngine +="
			label           lbl_SDK_switch       \"Use PhysX Engine\" align:#center tooltip:nvpxText.UI_PANEL_TT_SWITCH_SDK
			radiobuttons	rb_SDK_switch        labels:#(\"2.x\", \"3.x\") align:#center columns:2  tooltip:nvpxText.UI_PANEL_TT_SWITCH_SDK
	"
)

PxStringRolloutPanelEngine +="
		checkbox		cb_useMultiThread	\"Use Multithreading\"	align:#left  checked:true tooltip:nvpxText.UI_PANEL_TT_MT
		checkbox		cb_useHardwareScene	\"Hardware Acceleration\"	align:#left  checked:true tooltip:nvpxText.UI_PANEL_TT_HWACC
	)
	
	group \"Version\"
	(
		button bt_versionButton \"Version\"
	)
	
	on rb_SDK_switch changed state do
	(
		-- state: 1 is SDK 2.x, 2 is SDK 3.x
		case rb_SDK_switch.state of
		(
		1: PxSwitchSDK 2 false   -- false is not-silent
		2: PxSwitchSDK 3 false
		)
	)

	fn loadValues =
	(
		if PxSDK3Loaded do
		(
			rb_SDK_switch.enabled = PxSDK3Loaded
			rb_SDK_switch.state = if nvpx.GetPhysXSDKVersionMajor() == 2 then 1 else 2  -- state: 1 is SDK 2.x, 2 is SDK 3.x
		)

		cb_useMultiThread.checked = physXpaneldata.useMultiThread
		cb_useMultiThread.enabled = nvpx.SupportMultiThread()
		
		cb_useHardwareScene.enabled = nvpx.SupportHardwareScene()
		cb_useHardwareScene.checked = physXpaneldata.useHardwareScene
	)
	
	fn useMultiThreadChanged =
	(
		gPxUseMultiThread = physXpaneldata.useMultiThread
		PxSaveGlobalParams()
		PxUseMultiThread(gPxUseMultiThread)
	)

	fn useHardwareSceneChanged =
	(
		gPxUseHardwareScene = physXpaneldata.useHardwareScene
		PxSaveGlobalParams()
		PxUseHardwareScene(gPxUseHardwareScene)
	)
	
	on bt_versionButton pressed do
	(
		nvpx.ShowAboutDialog()
	)
	
	on cb_useMultiThread changed value do
	(
		undo \"PhysX Tools useMultiThread edit\" on
		(
			PxSetProperty physXpaneldata #useMultiThread value
		)
		
		useMultiThreadChanged()
	)
	
	on cb_useHardwareScene changed value do
	(
		undo \"PhysX Tools useHardwareScene edit\" on
		(
			PxSetProperty physXpaneldata #useHardwareScene value
		)
		
		useHardwareSceneChanged()
	)

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexWorld
	)
	
	on px_panel_engine open do 
	(
		loadValues()

		-- set controls' titles
		px_panel_engine.title = nvpxText.UI_PANEL_ENTINE_TITLE
		local optionGroupControlIndex = 1
		px_panel_engine.controls[optionGroupControlIndex].text = nvpxText.UI_PANEL_GROUP_OPTIONS
		local versionGroupControlIndex = if PxSDK3Loaded then 7 else 5
		px_panel_engine.controls[versionGroupControlIndex].text = nvpxText.UI_PANEL_GROUP_VERSION
		cb_useMultiThread.caption = nvpxText.UI_PANEL_CB_MT
		cb_useMultiThread.tooltip = nvpxText.UI_PANEL_TT_MT
		if PxSDK3Loaded do lbl_SDK_switch.caption = nvpxText.UI_PANEL_LBL_SWITCH_SDK
		cb_useHardwareScene.caption = nvpxText.UI_PANEL_CB_HWACC
		cb_useHardwareScene.tooltip = nvpxText.UI_PANEL_TT_HWACC
		bt_versionButton.caption = nvpxText.UI_PANEL_BT_ABOUT + \" \" + nvpx.GetPluginCompanyName() + \"...\"
	)

	on px_panel_engine help do (HelpSystem.ShowProductHelp 15010) --id_massfx_tools_world
)
"

execute PxStringRolloutPanelEngine

rollout px_panel_tools_simulation "Simulation" rolledUp:false
(
	group "Playback"
	(
		button bt_reset "Reset" width:32 height:32 align:#left across:4 iconName:"MassFX/ResetSimulation"
		button bt_play "Start" width:32 height:32 iconName:"MassFX/StartSimulation"
		button bt_PNA "PNA" width:32 height:32 iconName:"MassFX/StartSimulationWithoutAnimation"
		button bt_step "Step" width:32 height:32 iconName:"MassFX/AdvanceSimulationOneFrame"
	)
	
	on bt_reset pressed do
	(
		PxStopSimulation()
	)
	
	on bt_play pressed do
	(
		nvpx.SetAnimationState(true)
		PxRunSimulation()
		
		global gSimClock
		state = false
		if gSimClock != undefined then state =gSimClock.Enabled
		nvpx.SetButtonCheck 1003 (state and nvpx.GetAnimationState())
	)
	
	on bt_PNA pressed do
	(
		nvpx.SetAnimationState(false)
		PxRunSimulation()
		
		global gSimClock
		state = false
		if gSimClock != undefined then state = gSimClock.Enabled
		nvpx.SetButtonCheck 1003 (state)
	)
	
	on bt_step pressed do
	(
		PxStepSimulation()
	)
	
	group "Simulation Baking"
	(
		button bt_bake_all "Bake All" align:#center width:120
		button bt_bake_selected "Bake Selected" align:#center width:120
		button bt_unbake_all "Unbake All" align:#center width:120
		button bt_unbake_selected "Unbake Selected" align:#center width:120
	)
	
	on bt_bake_all pressed do
	(
		undo "PhysX Tools bake all" on
		(
			pxBakeAll false
		)
	)
	
	on bt_bake_selected pressed do
	(
		undo "PhysX Tools bake selected" on
		(
			pxBakeSelection false
		)
	)
	
	on bt_unbake_all pressed do
	(
		undo "PhysX Tools unbake all" on
		(
			pxBakeAll true
		)
	)
	
	on bt_unbake_selected pressed do
	(
		undo "PhysX Tools unbake selected" on
		(
			pxBakeSelection true
		)
	)
	
	group "Capture Tranforms"
	(
		button bt_capture_transforms "Capture Selected" width:120
	)
	
	on bt_capture_transforms pressed do
	(
		PxCaptureTransform(true)
	)

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexTool
	)
	
	on px_panel_tools_simulation open do
	(
		-- set strings to controls
		px_panel_tools_simulation.title = nvpxText.UI_PANEL_SIMULATION_TITLE
		px_panel_tools_simulation.controls[1].text = nvpxText.UI_PANEL_GROUP_PLAYBACK
		px_panel_tools_simulation.controls[7].text = nvpxText.UI_PANEL_GROUP_SIMBAKING
		px_panel_tools_simulation.controls[13].text = nvpxText.UI_PANEL_GROUP_MODELING
		bt_reset.text = nvpxText.UI_PANEL_BT_RESET
		bt_play.text = nvpxText.UI_PANEL_BT_PLAY
		bt_PNA.text = nvpxText.UI_PANEL_BT_PNA
		bt_step.text = nvpxText.UI_PANEL_BT_STEP
		if ((MaxVersion())[1] > PX_MAXVERSION_2010) do
		(
			bt_reset.tooltip = nvpxText.UI_PANEL_BT_RESET_TOOLTIP
			bt_play.tooltip = nvpxText.UI_PANEL_BT_PLAY_TOOLTIP
			bt_PNA.tooltip = nvpxText.UI_PANEL_BT_PNA_TOOLTIP
			bt_step.tooltip = nvpxText.UI_PANEL_BT_STEP_TOOLTIP
		)
		bt_bake_all.text = nvpxText.UI_PANEL_BT_BAKEALL
		bt_bake_selected.text = nvpxText.UI_PANEL_BT_BAKESEL
		bt_unbake_all.text = nvpxText.UI_PANEL_BT_UNBAKEALL
		bt_unbake_selected.text = nvpxText.UI_PANEL_UNBAKESEL
		bt_capture_transforms.text = nvpxText.UI_PANEL_BT_CAPTRANS
	)

	on px_panel_tools_simulation help do (HelpSystem.ShowProductHelp 15011) --id_massfx_tools_tools
)

rollout px_panel_tools_utilities "Utilities" rolledUp:false
(
	group "Mass FX Scene"
	(
		button bt_explore_scene "Explore Scene" width: 120
		button bt_validate_scene "Validate Scene" width: 120
		button bt_export_scene "Export Scene" width: 120
	)
	
	on bt_validate_scene pressed do
	(
		nvpx.ShowValidateScene(false)
	)
	
	on bt_export_scene pressed do
	(
		global PxExportPxProj_Prompting
		PxExportPxProj_Prompting(false)
	)
	
	on bt_explore_scene pressed do
	(
		macros.run "PhysX" "OpenDynamicsExplorer"
	)

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexTool
	)
	
	on px_panel_tools_utilities open do
	(
		-- set strings to controls
		px_panel_tools_utilities.title = nvpxText.UI_PANEL_UTILITY_TITLE
		px_panel_tools_utilities.controls[1].text = nvpx.GetPluginCompanyName() + " " + nvpxText.UI_PANEL_GROUP_PHYSCENE
		bt_explore_scene.text = nvpxText.UI_PANEL_BT_EXPLORE
		bt_validate_scene.text = nvpxText.UI_PANEL_BT_VALID
		bt_export_scene.text = nvpxText.UI_PANEL_BT_EXPORT
	)

	on px_panel_tools_utilities help do (HelpSystem.ShowProductHelp 15011) --id_massfx_tools_tools
)

rollout px_panel_tools_destruction "Destruction Tools" rolledUp:false
(
	group "Tools"
	(
		button bt_radialdamage "Radial Damage" width:32 align:#center height:32 across:2 iconName:"MassFX/RadialDamage"
		button bt_hammer "Hammer" width:32 height:32 iconName:"MassFX/Hammer"
		
	)
	
	group "Properties"
	(
		spinner        sp_damage           "Damage"            align:#right type:#integer range:[0.0, PxMaxValue, 1.0] tooltip:nvpxText.UI_PANEL_DESTRUCTION_DAMAGE
		spinner        sp_radius           "Radius"            align:#right type:#integer range:[0.0, PxMaxValue, 1.0] tooltip:nvpxText.UI_PANEL_DESTRUCTION_RADIUS
		spinner        sp_momentum           "Momentum"          align:#right type:#integer range:[0.0, PxMaxValue, 1.0] tooltip:nvpxText.UI_PANEL_DESTRUCTION_MOMENTUM
	)
		
	fn loadValues = 
	(
		sp_damage.value = physXpaneldata.destructionDamage
		sp_radius.value = physXpaneldata.destructionRadius
		sp_momentum.value = physXpaneldata.destructionMomentum
	)

	fn saveValues = 
	(
		physXpaneldata.destructionRadius = sp_radius.value
		physXpaneldata.destructionMomentum = sp_momentum.value
		physXpaneldata.destructionDamage = sp_damage.value
		PxSaveGlobalParams()
	)	
	
	fn damageChanged =
	(
		nvpx.UpdateDamageForces sp_damage.value sp_momentum.value sp_radius.value
	)
	
	on sp_damage changed value do
	(
		sp_damage.value = value
		damageChanged()
	)

	on sp_radius changed value do
	(
		sp_radius.value = value
		damageChanged()
	)

	on sp_momentum changed value do
	(
		sp_momentum.value = value
		damageChanged()
	)
	
	on bt_hammer pressed do
	(
		nvpx.ToggleHammer()
	)
	
	on bt_radialdamage pressed do
	(
		nvpx.ToggleBomb()
	)
	
	fn IsVisible =
	(
		(PHYSX_AUTODESK_VER==undefined) and
			((PxGetPhysXPanelTab()) == PxTabIndexTool)
	)

	on px_panel_tools_destruction open do
	(
		-- set strings to controls
		px_panel_tools_destruction.title = nvpxText.UI_PANEL_DESTRUCTION_TITLE
		loadValues()
	)

	on px_panel_tools_destruction close do
	(
		saveValues()
	)

	on px_panel_tools_destruction help do (HelpSystem.ShowProductHelp 15011) --id_massfx_tools_tools
)


rollout px_panel_rigidBodyDisplay "Rigid Bodies" rolledUp:false
(
	-- the tooltips are not very useful.  @todo: remove them or update them
	checkbox		cb_displayPhysicalMeshes	"Display Physical Meshes"	align:#left  checked:true tooltip:"Display Physical Meshes"
	checkbox		cb_selectedObjectsOnly		"Selected Objects Only"		align:#left  offset:[10, 0] checked:true tooltip:"Selected Objects Only"

	fn loadValues = 
	(
		local meshViz = physXpaneldata.physicalMeshes
		cb_displayPhysicalMeshes.checked = (meshViz != 3)
		cb_selectedObjectsOnly.checked = (meshViz == 1)
		cb_selectedObjectsOnly.enabled = cb_displayPhysicalMeshes.checked
	)

	fn saveValues = 
	(
		local int meshViz
		if (not cb_displayPhysicalMeshes.checked) then meshViz = 3 else (
			if cb_selectedObjectsOnly.checked then meshViz = 1 else meshViz = 2
		)
		nvpx.SetPMVisibleForRigidBodies meshViz
	)

	fn meshChanged =
	(
		nvpx.SetPMVisibleForRigidBodies physXpaneldata.physicalMeshes
	)

	on cb_displayPhysicalMeshes changed value do
	(
		cb_selectedObjectsOnly.enabled = value
		undo "PhysX Tools physicalMeshes edit" on
		(
			local int meshViz
			if (not value) then meshViz = 3 else (
				if cb_selectedObjectsOnly.checked then meshViz = 1 else meshViz = 2
			)
			PxSetProperty physXpaneldata #physicalMeshes meshViz
		)
		meshChanged()
	)

	on cb_selectedObjectsOnly changed value do
	(
		undo "PhysX Tools physicalMeshes edit" on
		(
			PxSetProperty physXpaneldata #physicalMeshes (if (value) then 1 else 2)
		)
		meshChanged()
	)

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexDisplay
	)

	on px_panel_rigidBodyDisplay open do
	(
		loadValues()
		
		px_panel_rigidBodyDisplay.title = nvpxText.UI_PANEL_VISUALIZE_ROLLOUT_RIGID_BODIES
		cb_displayPhysicalMeshes.text = nvpxText.UI_PANEL_VISUALIZE_DISPLAY_PHYSICAL_MESHES
		cb_selectedObjectsOnly.text = nvpxText.UI_PANEL_VISUALIZE_SELECTED_OBJECTS_ONLY
	)
	
	on px_panel_rigidBodyDisplay close do
	(
		saveValues()
	)

	on px_panel_rigidBodyDisplay help do (HelpSystem.ShowProductHelp 15013) --id_massfx_tools_display
)

rollout px_physXPanel "PhysX Tools" width:195
(
	dotNetControl  	tabCtrl "System.Windows.Forms.TabControl" align:#left height:30 width:195 pos:[3,5]
	dotNetControl  	tabPgWorld "System.Windows.Forms.TabPage"
	dotNetControl  	tabPgDisplay "System.Windows.Forms.TabPage"
	dotNetControl	tabPgTools "System.Windows.Forms.TabPage"
	dotNetControl	tabPgMultiEdit "System.Windows.Forms.TabPage"
	subRollout 		theSubRollout 	width:190 height:710 pos:[5,45]
	
	local imgLst	= dotNetObject "System.Windows.Forms.ImageList"
	local Img1		= dotNetClass "System.Drawing.Image"
	local Img2		= dotNetClass "System.Drawing.Image"
	local Img3		= dotNetClass "System.Drawing.Image"
	local Img4		= dotNetClass "System.Drawing.Image"

	local tabRollouts =
	#(
		px_panel_globalParameters,
		px_panel_advancedSettings,
		px_panel_engine,
		px_panel_tools_simulation,
		px_panel_simulation,
		px_panel_tools_utilities,
		px_panel_tools_destruction,
		px_panel_rigidBodyDisplay,
		px_panel_debugVisualizer,
		px_panel_debugVisualizerClothing,
		px_panel_debugVisualizerApexClothing
	)
	local rolloutInfoList = undefined  -- Objects of type MultiEdit_RolloutInfo_struct, for each rollout above

	-- Create rollout configuration data or load from ini file
	fn GetRolloutInfoList =
	(
		if (rolloutInfoList == undefined) then 
		(
			-- create a list of RolloutInfo objects
			rolloutInfoList = for r in tabRollouts collect (PxRolloutInfo_struct rolloutVal:r)
			
			-- load the state data from ini file, for each entry
			PxLoadRolloutInfoList rolloutInfoList
		)
		rolloutInfoList  -- return value
	)
	

	fn initImgList =
	(
		imgLst.imageSize = dotNetObject "System.Drawing.Size" 24 24
		
		--Set white as transparent color
		--imgLst.TransparentColor = imgLst.TransparentColor.FromArgb 255 255 255 255
		
		colorman.resolveIconFolder ("PhysXGlobal_24i.bmp") &iconDir1
		colorman.resolveIconFolder ("PhysXTools_24i.bmp") &iconDir2
		colorman.resolveIconFolder ("PhysXEdit_24i.bmp") &iconDir3
		colorman.resolveIconFolder ("PhysXDisplay_24i.bmp") &iconDir4
		
		imgLst.images.add (img1.fromFile iconDir1)
		imgLst.images.add (img2.fromFile iconDir2)
		imgLst.images.add (img3.fromFile iconDir3)
		imgLst.images.add (img4.fromFile iconDir4)		
	)
	
	fn initPgWorld =
	(
		-- Set the tab title to "World"
		-- the tab-control of Max 2010 does not display Chinese Charactor right
		tabPgWorld.TooltipText = if (MaxVersion())[1] == PX_MAXVERSION_2010 then "World" else nvpxText.toolsDlgPageWorld
		tabPgWorld.ImageIndex = 0
	)
	
	fn initPgTools =
	(
		-- Set the tab title to "Tools"
		-- the tab-control of Max 2010 does not display Chinese Charactor right
		tabPgTools.TooltipText = if (MaxVersion())[1] == PX_MAXVERSION_2010 then "Tools" else nvpxText.toolsDlgPageTools
		tabPgTools.ImageIndex = 1
	)

	fn initPgEdit =
	(
		-- Set the tab title to "Multi-Edit"
		-- the tab-control of Max 2010 does not display Chinese Charactor right
		tabPgMultiEdit.TooltipText = if (MaxVersion())[1] == PX_MAXVERSION_2010 then "MultiEdit" else nvpxText.toolsDlgPageEdit
		tabPgMultiEdit.ImageIndex = 2
	)

	fn initPgDisplay =
	(
		-- Set the tab title to "Display"
		-- the tab-control of Max 2010 does not display Chinese Charactor right
		tabPgDisplay.TooltipText = if (MaxVersion())[1] == PX_MAXVERSION_2010 then "Display" else nvpxText.toolsDlgPageDisplay
		tabPgDisplay.ImageIndex = 3
	)

	fn initTabs =
	(
		local TSizeMode = dotNetClass "System.Windows.Forms.TabSizeMode"

		px_tab_multiedit.OnOpen tabPgMultiEdit PxTabIndexMultiEdit  -- Initialize Multi-Edit as tab #2

		-- TO DO: Convert other tabs to object-oriented style

		initImgList()
		initPgWorld()
		initPgTools()
		initPgEdit()
		initPgDisplay()
		
		tabCtrl.name = "Dotnet Tab"
		
		tabCtrl.SizeMode = TSizeMode.Fixed
		tabCtrl.ItemSize = dotNetObject "System.Drawing.Size" 40 27
		tabCtrl.Controls.Add tabPgWorld
		tabCtrl.Controls.Add tabPgTools
		tabCtrl.Controls.Add tabPgMultiEdit
		tabCtrl.Controls.Add tabPgDisplay
		
		tabCtrl.SelectedIndex = 0  -- no tab is displayed initially
		tabCtrl.TabIndex = 1
		tabCtrl.ImageList = imgLst
		tabCtrl.ShowToolTips = true
	)
	
	-- Adds and removes rollouts for current tab, expanded or collapsed according to RolloutInfo configuration
	fn refreshPage = 
	(		
		px_tab_multiedit.OnSwitchTabs tabCtrl theSubRollout

		local rolloutInfoList = GetRolloutInfoList()
		PxUpdateRolloutInfoList rolloutInfoList
		
		for rolloutInfoVal in rolloutInfoList do
		(
			local rolloutVal = rolloutInfoVal.rolloutVal
			if (rolloutVal.IsVisible()) then  -- rollout should be displayed ...
			(
				if not rolloutVal.isDisplayed then -- ... but not currently displayed, add it
					addSubRollout theSubRollout rolloutVal rolledUp:(rolloutInfoVal.rolloutRolledUp)
			)
			else  -- rollout should not be displayed ...
			(
				if rolloutVal.isDisplayed then  -- ... but is currently displayed, remove it
					removeSubRollout theSubRollout rolloutVal
			)
		)
	)
	
	fn setCurrentPage nbTab =
	(
		--format "setCurrentPage %!\n" nbTab
		tabCtrl.SelectedIndex = (nbTab-1)
		refreshPage()
		nvpx.SetButtonCheck 1009 true
	)

	fn getCurrentPage =
	(
		--format "getStartPage!\n"
		tabCtrl.SelectedIndex + 1
	)
	
	on tabCtrl Click arg do
	(
		--format "Selected page is %!\n" tabCtrl.SelectedIndex
		refreshPage()
	)
	
	on px_physXPanel open do
	(
		PxLoadRolloutInfoList (GetRolloutInfoList())  -- load rollout state information from ini file
		
		--format "Init Tab control!\n"
		theSubRollout.height = px_physXPanel.height - 50
		initTabs()
		
		nx = nvpx.GetVirtualScreenX()
		ny = nvpx.GetVirtualScreenY()
		
		pos = GetDialogPos px_physXPanel
		needMove = false
		
		if pos.x <= -px_physXPanel.width or pos.x >= nx do
		(
			pos.x = 100
			needMove = true
		)
		if pos.y <= -px_physXPanel.height or pos.y >= ny do
		(
			pos.y = 100
			needMove = true
		)
		
		if needMove == true do (SetDialogPos px_physXPanel pos)
		
		-- set strings to controls
		px_physXPanel.title = nvpx.GetPluginCompanyName() + " " + nvpxText.UI_PANEL_TITLE
		
		-- make sure the button is depressed even if opened by toggle manager
		nvpx.SetButtonCheck 1009 true
	)
	
	on px_physXPanel resized nNewSize do
	(
		--px_physXPanel.height = nNewSize.y - 30
		theSubRollout.height = nNewSize.y - 50
	)
	
	fn SavePos =
	(
		iniFile = PxGetIniFilename()
		pos = GetDialogPos px_physXPanel
		setINISetting iniFile "ToolsPanel" "PosX" (pos.x as string)
		setINISetting iniFile "ToolsPanel" "PosY" (pos.y as string)
		setINISetting iniFile "DialogExportOptions" "Height" (px_physXPanel.height as string)
	)
	
	fn LoadPos =
	(
		iniFile = PxGetIniFilename()
		hasInit = hasINISetting iniFile "ToolsPanel"
		if hasInit then
		(
			posx = (GetINISetting iniFile "ToolsPanel" "PosX") as float
			posy = (GetINISetting iniFile "ToolsPanel" "PosY") as float
			height = (GetINISetting iniFile "DialogExportOptions" "Height") as float
			pos = [posx, posy, height]
		)
		else
		(
			pos = [100, 100, 400]
		)
	)
	
	on px_physXPanel close do
	(
		PxSaveRolloutInfoList (GetRolloutInfoList())  -- save rollout state information to ini file
			
		SavePos()

		px_tab_multiedit.OnClose()
		
		-- Update the physX toolbar (depress the physX Panel button #1009)
		nvpx.SetButtonCheck 1009 false
	)

	on px_physXPanel help do
	(
		case (tabCtrl.SelectedIndex) of
		(
			0:
			(
				HelpSystem.ShowProductHelp 15010
			)
			1:
			(
				HelpSystem.ShowProductHelp 15011
			)

			2:
			(
				HelpSystem.ShowProductHelp 15012
			)

			3:
			(
				HelpSystem.ShowProductHelp 15013
			)
		)
	)

) -- end rollout px_physXPanel

fn PxPanelUndo =
(
	t = callbacks.notificationParam()
	
	px_tab_multiedit.OnUndo()

	-- TO DO: Convert other tabs to object-oriented style


	if t == "PhysX Tools enableGravity edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.enableGravityChanged()
	)
	
	else if t == "PhysX Tools gravity edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.enableGravityChanged()
		px_panel_globalParameters.saveValues()
	)
	
	else if t == "PhysX Tools sleep energy edit" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.sleepEnergyChanged()
	)
	
	else if t == "PhysX Tools contact shell LegacyMode" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.contactShellLegacyChanged()
	)

	else if t == "PhysX Tools contact shell contactDistance" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.contactShellDistanceChanged()
	)
	
	else if t == "PhysX Tools contact shell restDepth" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.contactShellRestDepthChanged()
	)
	
	else if t == "PhysX Tools enable shape per element" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.shapePerElementChanged()
	)
	
	else if t == "PhysX Tools solverIteration edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.solverIterationChanged()
	)

	else if t == "PhysX Tools subSteps edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.subStepsChanged()
	)
	--US2946
	else if  t == "PhysX Tools Use High Vel Collisions" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.enableCCDChanged()
	)
	
	else if t == "PhysX Tools sleepThresholdsAutomatic" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.sleepThresholdAutomaticChanged()
	)
	
	else if t == "PhysX Tools CCDMinSpeedAutomatic" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.CCDMinSpeedAutomaticChanged()
	)
	
	else if t == "PhysX Tools High Vel Collisions Min Speed edit" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.CCDThresholdChanged()
	)
	
	else if t == "PhysX Tools BounceMinSpeedAutomatic" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.BounceMinSpeedAutomaticChanged()
	)
	
	else if t == "PhysX Tools BounceMinSpeedThreshold edit" then
	(
		px_panel_advancedSettings.loadValues()
		px_panel_advancedSettings.BounceMinSpeedThresholdChanged()
	)
	
	else if t == "PhysX Tools useFirst edit" then
	(
		px_panel_simulation.loadValues()
		px_panel_simulation.useFirstChanged()
	)
	
	else if t == "PhysX Tools useGroundPlane edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.useGroundChanged()
	)
	
	else if t == "PhysX Tools useAdaptiveForce edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.useAdaptiveForceChanged()
	)
	
	else if t == "PhysX Tools ground height edit" then
	(
		px_panel_globalParameters.loadValues()
		px_panel_globalParameters.useGroundChanged()
	)
	
	else if t == "PhysX Tools useMultiThread edit" then
	(
		px_panel_engine.loadValues()
		px_panel_engine.useMultiThreadChanged()
	)
	
	else if t == "PhysX Tools useHardwareScene edit" then
	(
		px_panel_engine.loadValues()
		px_panel_engine.useHardwareSceneChanged()
	)
	
	else if t == "PhysX Tools loopAnimation edit" then
	(
		px_panel_simulation.loadValues()
		px_panel_simulation.onLastChanged()
	)
	else if t == "PhysX Tools onLastFrame edit" then
	(
		px_panel_simulation.loadValues()
		px_panel_simulation.loopAnimChanged()
	)
	else if t == "PhysX Tools physicalMeshes edit" then
	(
		px_panel_rigidBodyDisplay.loadValues()
		px_panel_rigidBodyDisplay.meshChanged()
	)
	else if t == "PhysX Visualizer Enable edit" then
	(
		px_panel_debugVisualizer.optionsChanged()
	)
	else if t == "PhysX Visualizer Scale edit" then
	(
		px_panel_debugVisualizer.optionsChanged()
	)
	else pxDebugVisualizerUndo()
)

fn PxPanelClose =
(
	if px_physXPanel.open then
	(
		cui.UnRegisterDialogBar px_physXPanel
		DestroyDialog  px_physXPanel
	)
)

fn PxGetPhysXPanelTab =
(
	px_physXPanel.tabCtrl.SelectedIndex  -- return value
)

fn PxRefreshPhysXToolPanel =
(
	if px_panel_globalParameters.open do
		px_panel_globalParameters.loadValues()
	if px_panel_advancedSettings.open do
		px_panel_advancedSettings.loadValues()
	if px_panel_simulation.open do
		px_panel_simulation.loadValues()
	if px_panel_engine.open do
		px_panel_engine.loadValues()
	if px_panel_rigidBodyDisplay.open do
		px_panel_rigidBodyDisplay.loadValues()
	if px_panel_debugVisualizer.open do
		px_panel_debugVisualizer.loadValues()
	if px_panel_debugVisualizerClothing.open do
		px_panel_debugVisualizerClothing.loadValues()
	if px_panel_debugVisualizerApexClothing.open do
		px_panel_debugVisualizerApexClothing.loadValues()
)

fn PxSetPhysXPanelInterfaceFromGlobalParams =
(
	physXpaneldata.enableGravity = px_sdk_enable_gravity
	physXpaneldata.gravityDirection = px_sdk_gravityDirection
	physXpaneldata.gravity = case physXpaneldata.gravityDirection of
	( 
		1: px_sdk_gravityx
		2: px_sdk_gravityy
		3: px_sdk_gravityz
	)
	
	physXpaneldata.sleepEnergy = px_sdk_sleep_energy

	-- should save contact distance before skin width	
	physXpaneldata.contactShellContactDistance = px_sdk_contactDistance
	physXpaneldata.skinWidth = px_sdk_skinwidth
	physXpaneldata.solverIteration = px_rb_solveritertions
	physXpaneldata.subSteps = px_sdk_sub_sim_steps
	--physXpaneldata.useFirst = gPxUseFirstFrame
	physXpaneldata.useFirst = true
	physXpaneldata.useGroundPlane = gPxUseGround
	physXpaneldata.groundHeight = gPxGroundHeight
	physXpaneldata.onLastFrame = gPxOnLastFrame
	physXpaneldata.loopAnimation = gPxLoopAnimation
	physXpaneldata.physicalMeshes = nvpx.GetPMVisibleForRigidBodies()
	
	physXpaneldata.useMultiThread = gPxUseMultiThread
	physXpaneldata.useHardwareScene = gPxUseHardwareScene
	
	--US2946
	physXpaneldata.enableCCD = px_sdk_continuous_cd
	physXpaneldata.sleepThresholdsAutomatic = gPxSleepThresholdsAutomatic
	physXpaneldata.ccdMinSpeedAutomatic = gPxCCDMinSpeedAutomatic
	physXpaneldata.bounceMinSpeedAutomatic = gPxBounceMinSpeedAutomatic
	physXpaneldata.ccdMinSpeedThreshold = px_sdk_ccd_motion_threshold

 	--US 6220
 	physXpaneldata.shapePerElement = gPxGenerateShapePerElement

	-- Destruction
	physXpaneldata.destructionDamage = gpxDestructionDamage
	physXpaneldata.destructionRadius = gpxDestructionRadius
	physXpaneldata.destructionMomentum = gpxDestructionMomentum

	-- load system unit information
	physXpaneldata.unitType = px_plugin_unittype
	physXpaneldata.unitScale= px_plugin_unitscale

	-- version information 
	physXpaneldata.pluginPropertyVersion = px_plugin_version

	-- physics sdk part
	
	physXpaneldata.sleepEnergy = px_sdk_sleep_energy
	physXpaneldata.bounceMinSpeedThreshold = -px_sdk_bouncethresh
	physXpaneldata.dynamicFrictionScale = px_sdk_dynamicfrictionscaling
	physXpaneldata.staticFrictionScale = px_sdk_staticfrictionscaling

	physXpaneldata.maxAngleVelocity = px_sdk_maxangvel

	physXpaneldata.ccdEpsilon = px_sdk_ccd_epsilon
		
	-- unit change part
	physXpaneldata.geometryScale = gPxGeometryScale

	PxRefreshPhysXToolPanel()
)

fn PxSetGlobalParamsFromPhysXPanelInterface =
(
	px_sdk_enable_gravity = physXpaneldata.enableGravity
	
	px_sdk_gravityx = 0
	px_sdk_gravityy = 0
	px_sdk_gravityz = 0
	if nvpx.gravityMode == #directional then
	(
		case physXpaneldata.gravityDirection of
		( 
			1: px_sdk_gravityx = physXpaneldata.gravity
			2: px_sdk_gravityy = physXpaneldata.gravity
			3: px_sdk_gravityz = physXpaneldata.gravity
		)
	)
	else if (nvpx.gravityMode == #object) and (nvpx.gravityObject != undefined) then
	(
		local gravityDir = nvpx.gravityObject.strength*nvpx.gravityObject.transform.row3
		px_sdk_gravityx = gravityDir.x
		px_sdk_gravityy = gravityDir.y
		px_sdk_gravityz = gravityDir.z
	)
	
	px_sdk_sleep_energy = physXpaneldata.sleepEnergy
	
	px_sdk_skinwidth = physXpaneldata.skinWidth
	px_sdk_contactDistance = physXpaneldata.contactShellContactDistance
	px_rb_solveritertions = physXpaneldata.solverIteration
	px_sdk_sub_sim_steps = physXpaneldata.subSteps
	--gPxUseFirstFrame = physXpaneldata.useFirst
	gPxUseFirstFrame = true
	gPxUseGround = physXpaneldata.useGroundPlane
	gPxGroundHeight = physXpaneldata.groundHeight
	gPxOnLastFrame = physXpaneldata.onLastFrame
	gPxLoopAnimation = physXpaneldata.loopAnimation
	nvpx.SetPMVisibleForRigidBodies physXpaneldata.physicalMeshes
	nvpx.SetApexShowStatSimulatedVerts physXpaneldata.apexStats

	gPxUseMultiThread = physXpaneldata.useMultiThread
	gPxUseHardwareScene = physXpaneldata.useHardwareScene
	
	--US2946
	px_sdk_continuous_cd = physXpaneldata.enableCCD
	gPxSleepThresholdsAutomatic = physXpaneldata.sleepThresholdsAutomatic
	gPxCCDMinSpeedAutomatic = physXpaneldata.ccdMinSpeedAutomatic
	gPxBounceMinSpeedAutomatic = physXpaneldata.bounceMinSpeedAutomatic
	px_sdk_ccd_motion_threshold = physXpaneldata.ccdMinSpeedThreshold

	--US 6220
	gPxGenerateShapePerElement = physXpaneldata.shapePerElement

	-- Destruction	
	gpxDestructionDamage = physXpaneldata.destructionDamage
	gpxDestructionRadius = physXpaneldata.destructionRadius
	gpxDestructionMomentum = physXpaneldata.destructionMomentum
)

callbacks.removeScripts id:#PhysXToolPanel
callbacks.addScript #sceneUndo  "PxPanelUndo()" id:#PhysXToolPanel
callbacks.addScript #sceneRedo  "PxPanelUndo()" id:#PhysXToolPanel
callbacks.addScript #systemPostReset  "PxPanelClose()" id:#PhysXToolPanel -- max close all windows on a reset, do the same

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBcn5OYIqCyC1HAM9cqnlRclNVMp9tOU+KJ
-- VG91egeuKS81nF3/IYMxYZdOmxSyYW2LBCm76dMl5EsAsaT9W5oJMUiv+ljfCCqD
-- 3Lcfr4XH5rn9yykj0FG2PNffxpUk7qJSCZxj8zrIZlmyDl2iiijVw8+zaR2zhQUn
-- 51ssYkH8fQWhbBSUk4pZVbFre2xAMCKrNhBg54l6jNebGRDu/6So+BNGusKHLCSO
-- C+5nmyme2E3PlyL5ypvTT+xFw6IZb54eB7lRfH0HntBwJ2B6zLT2Fo9ywI730Xyy
-- SK1cj0V9ZjIHaNsSd4wxOLVOQZwRIiZf87bDyoKWdmLee4l88oyg
-- -----END-SIGNATURE-----